/* gnome-db-result-set.h
 *
 * Copyright (C) 2003 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_RESULT_SET_H_
#define __GNOME_DB_RESULT_SET_H_

#include <glib-object.h>
#include "gnome-db-decl.h"
#include "gnome-db-base.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_RESULT_SET          (gnome_db_result_set_get_type())
#define GNOME_DB_RESULT_SET(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_result_set_get_type(), GnomeDbResultSet)
#define GNOME_DB_RESULT_SET_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_result_set_get_type (), GnomeDbResultSetClass)
#define IS_GNOME_DB_RESULT_SET(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_result_set_get_type ())



/* error reporting */
extern GQuark gnome_db_result_set_error_quark (void);
#define GNOME_DB_RESULT_SET_ERROR gnome_db_result_set_error_quark ()

enum
{
	ERROR1
};

/* struct for the object's data */
struct _GnomeDbResultSet
{
	GnomeDbBase              object;
	GnomeDbResultSetPrivate *priv;
};

/* struct for the object's class */
struct _GnomeDbResultSetClass
{
	GnomeDbBaseClass             class;
};

GType           gnome_db_result_set_get_type           (void);

GObject        *gnome_db_result_set_new                (GnomeDbQuery *query, GnomeDbTarget *modif_target);

gboolean        gnome_db_result_set_check_model        (GnomeDbResultSet *rs, gint nbcols, ...);
gboolean        gnome_db_result_set_check_data_model   (GdaDataModel *model, gint nbcols, ...);

gchar          *gnome_db_result_set_get_row_as_string  (GdaDataModel *model, GnomeDbQuery *query, gint row, gchar *sep);

/* deprecated functions */
#define gnome_db_result_set_get_nbtuples(x)          gda_data_model_get_n_columns (GDA_DATA_MODEL (x))
#define gnome_db_result_set_get_nbcols(x)            gda_data_model_get_n_columns (GDA_DATA_MODEL (x))
#define gnome_db_result_set_get_gdavalue(x,row,col)  gda_data_model_get_value_at (GDA_DATA_MODEL (x), (col), (row))
#define gnome_db_result_set_get_col_name(x,col)      gda_data_model_get_column_title (GDA_DATA_MODEL (x), (col))
#define gnome_db_result_set_set_col_name(x,col,name) gda_data_model_set_column_title (GDA_DATA_MODEL (x), (col), (name))
#define gnome_db_result_set_get_data_model(x)        GDA_DATA_MODEL (x)

/* internal use only */
gint    gnome_db_result_set_find_column_ext          (GnomeDbResultSet *rs, GnomeDbDataSetNode *node, gint col);


G_END_DECLS

#endif
