typedef	GtkWidget *(*GDoDemoFunc) (GtkWidget *do_widget);

typedef struct _Demo Demo;

struct _Demo 
{
  gchar *title;
  gchar *filename;
  GDoDemoFunc func;
  Demo *children;
};

GtkWidget *do_form (GtkWidget *do_widget);
GtkWidget *do_form_rw (GtkWidget *do_widget);
GtkWidget *do_form_pict (GtkWidget *do_widget);
GtkWidget *do_grid (GtkWidget *do_widget);
GtkWidget *do_grid_rw (GtkWidget *do_widget);
GtkWidget *do_grid_pict (GtkWidget *do_widget);
GtkWidget *do_linked_grid_form (GtkWidget *do_widget);
GtkWidget *do_linked_model_param (GtkWidget *do_widget);
GtkWidget *do_console (GtkWidget *do_widget);
GtkWidget *do_selector (GtkWidget *do_widget);
GtkWidget *do_ddl_queries (GtkWidget *do_widget);
GtkWidget *do_graph (GtkWidget *do_widget);

Demo child0[] = {
  { "Read-only form", "form.c", do_form, NULL },
  { "Read-write form", "form_rw.c", do_form_rw, NULL },
  { "Using the picture plugin", "form_pict.c", do_form_pict, NULL },
  { NULL } 
};

Demo child1[] = {
  { "Read-only grid", "grid.c", do_grid, NULL },
  { "Read-write grid", "grid_rw.c", do_grid_rw, NULL },
  { "Using the picture plugin", "grid_pict.c", do_grid_pict, NULL },
  { NULL } 
};

Demo child2[] = {
  { "Same data", "linked_grid_form.c", do_linked_grid_form, NULL },
  { "Data model with parameters", "linked_model_param.c", do_linked_model_param, NULL },
  { NULL } 
};

Demo gnomedb_demos[] = {
  { "DDL queries", "ddl_queries.c", do_ddl_queries, NULL }, 
  { "Data widgets linking", NULL, NULL, child2 }, 
  { "Dictionary browser", "selector.c", do_selector, NULL }, 
  { "Forms", NULL, NULL, child0 }, 
  { "Graph", "graph.c", do_graph, NULL }, 
  { "Grids", NULL, NULL, child1 }, 
  { "Sql console", "console.c", do_console, NULL },
  { NULL } 
};
