
#include <libgnomeuimm/about.h>
#include <libgnomeuimm/private/about_p.h>

// -*- C++ -*-

/* $Id: about.ccg,v 1.6 2002/01/19 04:26:33 daniel Exp $ */

/* about.cc
 *
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomeui/gnome-about.h>

namespace Gnome
{

namespace UI
{

About::About(const Glib::ustring& name,
             const Glib::ustring& version,
             const Glib::ustring& copyright,
             const Glib::ArrayHandle<Glib::ustring>& authors,
             const Glib::ArrayHandle<Glib::ustring>& documenters,
             const Glib::ustring& comments,
             const Glib::ustring& translator_credits)
:
  Dialog(GTK_DIALOG(g_object_new(get_type(), (char*)0)))
{
  gnome_about_construct(gobj(),
                        name.c_str(),
                        version.c_str(),
                        copyright.c_str(),
                        comments.c_str(),
                        const_cast<const char**>(authors.data()),
                        const_cast<const char**>(documenters.data()),
                        translator_credits.c_str(),
			0);

  //Prevent automatic gobj destruction upon dialog close.
  //It's not suitable for C++.
  //close_hides();
}


About::About(const Glib::ustring& name,
             const Glib::ustring& version,
             const Glib::ustring& copyright,
             const Glib::ArrayHandle<Glib::ustring>& authors,
             const Glib::ArrayHandle<Glib::ustring>& documenters,
             const Glib::ustring& comments,
             const Glib::ustring& translator_credits,
             const Glib::RefPtr<Gdk::Pixbuf>& logo)
:
  Dialog(GTK_DIALOG(g_object_new(get_type(), (char*)0)))
{
  gnome_about_construct(gobj(),
                        name.c_str(),
                        version.c_str(),
                        copyright.c_str(),
                        comments.c_str(),
                        const_cast<const char**>(authors.data()),
                        const_cast<const char**>(documenters.data()),
                        translator_credits.c_str(),
                        Glib::unwrap(logo));

  //Prevent automatic gobj destruction upon dialog close.
  //It's not suitable for C++.
  //close_hides();
}

} /* namespace UI */
} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::UI::About* wrap(GnomeAbout* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::About *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType About_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_about_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void About_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* About_Class::wrap_new(GObject* o)
{
  return manage(new About((GnomeAbout*)(o)));
}


/* The implementation: */

About::About(GnomeAbout* castitem)
: Gtk::Dialog((GtkDialog*)(castitem))
{}

About::~About()
{
  destroy_();
}

About::CppClassType About::about_class_; //Initialize static member.

GType About::get_type()
{
  return about_class_.get_type();
}

GType About::get_base_type()
{
  return gnome_about_get_type();
}


Glib::PropertyProxy<Glib::ustring> About::property_name()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "name");
}

Glib::PropertyProxy<Glib::ustring> About::property_version()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "version");
}

Glib::PropertyProxy<Glib::ustring> About::property_copyright()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "copyright");
}

Glib::PropertyProxy<Glib::ustring> About::property_comments()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "comments");
}

Glib::PropertyProxy<Glib::ustring> About::property_translator_credits()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "translator_credits");
}


} // namespace UI

} // namespace Gnome

