
#include <libgnomeuimm/druid-page-edge.h>
#include <libgnomeuimm/private/druid-page-edge_p.h>

/* $Id: druid-page-edge.ccg,v 1.1 2002/04/27 20:24:50 murrayc Exp $ */


/* druid-page-edge.ccg
 *
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomeui/gnometypebuiltins.h>


namespace Gnome
{

namespace UI
{

DruidPageEdge::DruidPageEdge(EdgePosition position, bool antialiased)
  : DruidPage(GNOME_DRUID_PAGE(g_object_new(get_type(),0)))
{
  gnome_druid_page_edge_construct(gobj(), (GnomeEdgePosition)position, (gboolean)antialiased, 0, 0, 0, 0, 0);
}

DruidPageEdge::DruidPageEdge(EdgePosition position, const Glib::ustring& title, const Glib::ustring& text, bool antialiased = true)
  : DruidPage(GNOME_DRUID_PAGE(g_object_new(get_type(),0)))
{
  gnome_druid_page_edge_construct(gobj(), (GnomeEdgePosition)position, (gboolean)antialiased, title.c_str(), text.c_str(), 0, 0, 0);
}


DruidPageEdge::DruidPageEdge(EdgePosition position, const Glib::ustring& title, const Glib::ustring& text,
                         const Glib::RefPtr<Gdk::Pixbuf>& logo, const Glib::RefPtr<Gdk::Pixbuf>& watermark, const Glib::RefPtr<Gdk::Pixbuf>& top_watermark,
                         bool antialiased = true)
  : DruidPage(GNOME_DRUID_PAGE(g_object_new(get_type(),0)))
{
  gnome_druid_page_edge_construct(gobj(), (GnomeEdgePosition)position, (gboolean)antialiased, title.c_str(), text.c_str(), logo->gobj(), watermark->gobj(), top_watermark->gobj());
}


} /* namespace UI */
} /* namespace Gnome */


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gnome::UI::EdgePosition>::value_type()
{
  return gnome_edge_position_get_type();
}


namespace Glib
{

Gnome::UI::DruidPageEdge* wrap(GnomeDruidPageEdge* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::DruidPageEdge *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType DruidPageEdge_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_druid_page_edge_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void DruidPageEdge_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* DruidPageEdge_Class::wrap_new(GObject* o)
{
  return manage(new DruidPageEdge((GnomeDruidPageEdge*)(o)));
}


/* The implementation: */

DruidPageEdge::DruidPageEdge(GnomeDruidPageEdge* castitem)
: DruidPage((GnomeDruidPage*)(castitem))
{}

DruidPageEdge::~DruidPageEdge()
{
  destroy_();
}

DruidPageEdge::CppClassType DruidPageEdge::druidpageedge_class_; //Initialize static member.

GType DruidPageEdge::get_type()
{
  return druidpageedge_class_.get_type();
}

GType DruidPageEdge::get_base_type()
{
  return gnome_druid_page_edge_get_type();
}

void DruidPageEdge::set_bg_color(const Gdk::Color& color)
{
  gnome_druid_page_edge_set_bg_color(gobj(), const_cast<GdkColor*>(color.gobj()));
}

void DruidPageEdge::set_textbox_color(const Gdk::Color& color)
{
  gnome_druid_page_edge_set_textbox_color(gobj(), const_cast<GdkColor*>(color.gobj()));
}

void DruidPageEdge::set_logo_bg_color(const Gdk::Color& color)
{
  gnome_druid_page_edge_set_logo_bg_color(gobj(), const_cast<GdkColor*>(color.gobj()));
}

void DruidPageEdge::set_title_color(const Gdk::Color& color)
{
  gnome_druid_page_edge_set_title_color(gobj(), const_cast<GdkColor*>(color.gobj()));
}

void DruidPageEdge::set_text_color(const Gdk::Color& color)
{
  gnome_druid_page_edge_set_text_color(gobj(), const_cast<GdkColor*>(color.gobj()));
}

void DruidPageEdge::set_text(const Glib::ustring& text)
{
  gnome_druid_page_edge_set_text(gobj(), text.c_str());
}

void DruidPageEdge::set_title(const Glib::ustring& title)
{
  gnome_druid_page_edge_set_title(gobj(), title.c_str());
}

void DruidPageEdge::set_logo(const Glib::RefPtr<Gdk::Pixbuf>& logo_image)
{
  gnome_druid_page_edge_set_logo(gobj(), (logo_image)->gobj());
}

void DruidPageEdge::set_watermark(const Glib::RefPtr<Gdk::Pixbuf>& watermark)
{
  gnome_druid_page_edge_set_watermark(gobj(), (watermark)->gobj());
}

void DruidPageEdge::set_top_watermark(const Glib::RefPtr<Gdk::Pixbuf>& top_watermark)
{
  gnome_druid_page_edge_set_top_watermark(gobj(), (top_watermark)->gobj());
}


} // namespace UI

} // namespace Gnome

