
#include <libgnomeuimm/icon-list.h>
#include <libgnomeuimm/private/icon-list_p.h>

// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in
/* $Id: icon-list.ccg,v 1.13 2002/02/26 18:47:49 murrayc Exp $ */

/* icon-list.cc
 *
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/adjustment.h>
#include <libgnomecanvasmm/group.h>

namespace Gnome
{

namespace UI
{

namespace IconList_Helpers
{

GList*& SelectionList::glist() const
{
  //We need to store it so that we can return a reference:
  glist_ = gnome_icon_list_get_selection((GnomeIconList*)gparent_);
  return glist_;
}

SelectionList::iterator SelectionList::insert(iterator position, element_type& e)
{
  //TODO:
  g_warning("IconList_Helpers::SelectionList::insert(): Not implemented.");
  return SelectionList::iterator();
}

SelectionList::iterator SelectionList::erase(iterator position)
{
  if ( !position.node || (position == end()) )
    return end();

  iterator next = position;
  next++;

  gnome_icon_list_remove((GnomeIconList*)gparent_, *(*position)); //Deref the iter to get the int*, then deref the int* to get the int.
  return next;
}

void SelectionList::remove(const_reference child)
{
  gnome_icon_list_remove((GnomeIconList*)gparent_, *child);
}


} /* IconList_Helpers */

IconList::IconList(guint icon_width, bool is_editable)
  : Gnome::Canvas::Canvas(GNOME_CANVAS(g_object_new(get_type(),0)))
{
  gnome_icon_list_construct(gobj(), icon_width, 0, (is_editable ? GNOME_ICON_LIST_IS_EDITABLE : 0));
}

IconList::SelectionList& IconList::selection()
{
  selection_proxy_ = SelectionList(gobj());
  return selection_proxy_;
}

const IconList::SelectionList& IconList::selection() const
{
  selection_proxy_ = SelectionList(const_cast<GnomeIconList*>(gobj()));
  return selection_proxy_;
}


// Commented out until further explaination. What is this
// adjustment_widget ?
//
// IconList::IconList(GnomeIconList *castitem)
//    : Canvas(GNOME_CANVAS(castitem))
//  {
//    g_assert(adjustment_widget);

//    gnome_icon_list_construct(gobj(),castitem->pad13,
//  			    adjustment_widget->gobj(),
//  			    castitem->pad14);
//  }


} /* namespace UI */
} /* namespace Gnome */


namespace
{


void IconList_signal_select_icon_callback(GnomeIconList*, gint p0,GdkEvent* p1,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot2<void,int,GdkEvent*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
,p1, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo IconList_signal_select_icon_info =
{
  "select_icon",
  (GCallback) &IconList_signal_select_icon_callback,
  (GCallback) &IconList_signal_select_icon_callback
};


void IconList_signal_unselect_icon_callback(GnomeIconList*, gint p0,GdkEvent* p1,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot2<void,int,GdkEvent*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
,p1, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo IconList_signal_unselect_icon_info =
{
  "unselect_icon",
  (GCallback) &IconList_signal_unselect_icon_callback,
  (GCallback) &IconList_signal_unselect_icon_callback
};


void IconList_signal_focus_icon_callback(GnomeIconList*, gint p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<void,int> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo IconList_signal_focus_icon_info =
{
  "focus_icon",
  (GCallback) &IconList_signal_focus_icon_callback,
  (GCallback) &IconList_signal_focus_icon_callback
};


gboolean IconList_signal_text_changed_callback(GnomeIconList*, gint p0,const gchar* p1,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot2<bool,int,const char*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (p0
,p1
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean IconList_signal_text_changed_notify_callback(GnomeIconList*, gint p0,const gchar* p1,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot2<void,int,const char*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
,p1
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo IconList_signal_text_changed_info =
{
  "text_changed",
  (GCallback) &IconList_signal_text_changed_callback,
  (GCallback) &IconList_signal_text_changed_notify_callback
};


void IconList_signal_move_cursor_callback(GnomeIconList*, GtkDirectionType p0,gboolean p1,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot2<void,Gtk::DirectionType,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((Gtk::DirectionType)(p0))
,p1
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo IconList_signal_move_cursor_info =
{
  "move_cursor",
  (GCallback) &IconList_signal_move_cursor_callback,
  (GCallback) &IconList_signal_move_cursor_callback
};


const Glib::SignalProxyInfo IconList_signal_toggle_cursor_selection_info =
{
  "toggle_cursor_selection",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gnome::UI::IconList* wrap(GnomeIconList* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::IconList *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType IconList_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_icon_list_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void IconList_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->select_icon = &select_icon_callback;
  klass->unselect_icon = &unselect_icon_callback;
  klass->focus_icon = &focus_icon_callback;
  klass->text_changed = &text_changed_callback;
  klass->move_cursor = &move_cursor_callback;
  klass->toggle_cursor_selection = &toggle_cursor_selection_callback;
}


void IconList_Class::select_icon_callback(GnomeIconList* self, gint p0, GdkEvent* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_select_icon(p0
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->select_icon)
      (*base->select_icon)(self, p0, p1);
  }
}

void IconList_Class::unselect_icon_callback(GnomeIconList* self, gint p0, GdkEvent* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_unselect_icon(p0
, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->unselect_icon)
      (*base->unselect_icon)(self, p0, p1);
  }
}

void IconList_Class::focus_icon_callback(GnomeIconList* self, gint p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_focus_icon(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->focus_icon)
      (*base->focus_icon)(self, p0);
  }
}

gboolean IconList_Class::text_changed_callback(GnomeIconList* self, gint p0, const gchar* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_text_changed(p0
, p1
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->text_changed)
      (*base->text_changed)(self, p0, p1);
  }

  typedef gboolean RType;
  return RType();
}

void IconList_Class::move_cursor_callback(GnomeIconList* self, GtkDirectionType p0, gboolean p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_move_cursor(((Gtk::DirectionType)(p0))
, p1
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->move_cursor)
      (*base->move_cursor)(self, p0, p1);
  }
}

void IconList_Class::toggle_cursor_selection_callback(GnomeIconList* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_toggle_cursor_selection();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->toggle_cursor_selection)
      (*base->toggle_cursor_selection)(self);
  }
}


Glib::ObjectBase* IconList_Class::wrap_new(GObject* o)
{
  return manage(new IconList((GnomeIconList*)(o)));
}


/* The implementation: */

IconList::IconList(GnomeIconList* castitem)
: Gnome::Canvas::Canvas((GnomeCanvas*)(castitem))
{}

IconList::~IconList()
{
  destroy_();
}

IconList::CppClassType IconList::iconlist_class_; //Initialize static member.

GType IconList::get_type()
{
  return iconlist_class_.get_type();
}

GType IconList::get_base_type()
{
  return gnome_icon_list_get_type();
}


namespace IconList_Helpers
{

SelectionList::SelectionList()
{}

SelectionList::SelectionList(GnomeIconList* gparent)
: type_base((GObject*)gparent)
{}

SelectionList::SelectionList(const SelectionList& src)
{
  operator=(src);
}

SelectionList& SelectionList::operator=(const SelectionList& src)
{
  gparent_ = src.gparent_;
  return *this;
}


void SelectionList::erase(iterator start, iterator stop)
{
  type_base::erase(start, stop);
}

GnomeIconList* SelectionList::gparent()
{
  return (GnomeIconList*)type_base::gparent();
}

const GnomeIconList* SelectionList::gparent() const
{
  return (GnomeIconList*)type_base::gparent();
}

SelectionList::value_type SelectionList::operator[](size_type l) const
{
  return type_base::operator[](l);
}

} /* namespace IconList_Helpers */

void IconList::set_hadjustment(Gtk::Adjustment& hadj)
{
  gnome_icon_list_set_hadjustment(gobj(), (hadj).gobj());
}

void IconList::set_vadjustment(Gtk::Adjustment& vadj)
{
  gnome_icon_list_set_vadjustment(gobj(), (vadj).gobj());
}

void IconList::freeze()
{
  gnome_icon_list_freeze(gobj());
}

void IconList::thaw()
{
  gnome_icon_list_thaw(gobj());
}

void IconList::insert(int pos, const Glib::ustring& icon_filename, const Glib::ustring& text)
{
  gnome_icon_list_insert(gobj(), pos, icon_filename.c_str(), text.c_str());
}

void IconList::insert(int idx, const Glib::RefPtr<Gdk::Pixbuf>& im, const Glib::ustring& icon_filename, const Glib::ustring& text)
{
  gnome_icon_list_insert_pixbuf(gobj(), idx, (im)->gobj(), icon_filename.c_str(), text.c_str());
}

int IconList::append(const Glib::ustring& icon_filename, const Glib::ustring& text)
{
  return gnome_icon_list_append(gobj(), icon_filename.c_str(), text.c_str());
}

int IconList::append(const Glib::RefPtr<Gdk::Pixbuf>& im, const Glib::ustring& icon_filename, const Glib::ustring& text)
{
  return gnome_icon_list_append_pixbuf(gobj(), (im)->gobj(), icon_filename.c_str(), text.c_str());
}

void IconList::clear()
{
  gnome_icon_list_clear(gobj());
}

void IconList::remove(int pos)
{
  gnome_icon_list_remove(gobj(), pos);
}

guint IconList::get_num_icons() const
{
  return gnome_icon_list_get_num_icons(const_cast<GnomeIconList*>(gobj()));
}

Gtk::SelectionMode IconList::get_selection_mode() const
{
  return ((Gtk::SelectionMode)(gnome_icon_list_get_selection_mode(const_cast<GnomeIconList*>(gobj()))));
}

void IconList::set_selection_mode(Gtk::SelectionMode mode)
{
  gnome_icon_list_set_selection_mode(gobj(), ((GtkSelectionMode)(mode)));
}

void IconList::select_icon(int idx)
{
  gnome_icon_list_select_icon(gobj(), idx);
}

void IconList::unselect_icon(int idx)
{
  gnome_icon_list_unselect_icon(gobj(), idx);
}

int IconList::unselect_all()
{
  return gnome_icon_list_unselect_all(gobj());
}

void IconList::focus_icon(gint idx)
{
  gnome_icon_list_focus_icon(gobj(), idx);
}

void IconList::set_icon_width(int w)
{
  gnome_icon_list_set_icon_width(gobj(), w);
}

void IconList::set_row_spacing(int spacing)
{
  gnome_icon_list_set_row_spacing(gobj(), spacing);
}

void IconList::set_col_spacing(int spacing)
{
  gnome_icon_list_set_col_spacing(gobj(), spacing);
}

void IconList::set_text_spacing(int spacing)
{
  gnome_icon_list_set_text_spacing(gobj(), spacing);
}

void IconList::set_icon_border(int spacing)
{
  gnome_icon_list_set_icon_border(gobj(), spacing);
}

void IconList::set_separators(const Glib::ustring& sep)
{
  gnome_icon_list_set_separators(gobj(), sep.c_str());
}

Glib::ustring IconList::get_icon_filename(int idx)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_icon_list_get_icon_filename(gobj(), idx));
}

int IconList::find_icon_from_filename(const Glib::ustring& filename)
{
  return gnome_icon_list_find_icon_from_filename(gobj(), filename.c_str());
}

void IconList::set_icon_data(int pos, gpointer data)
{
  gnome_icon_list_set_icon_data(gobj(), pos, data);
}

int IconList::find_icon_from_data(gpointer data)
{
  return gnome_icon_list_find_icon_from_data(gobj(), data);
}

gpointer IconList::get_icon_data(int pos)
{
  return gnome_icon_list_get_icon_data(gobj(), pos);
}

void IconList::moveto(int pos, double yalign)
{
  gnome_icon_list_moveto(gobj(), pos, yalign);
}

Gtk::Visibility IconList::icon_is_visible(int pos)
{
  return ((Gtk::Visibility)(gnome_icon_list_icon_is_visible(gobj(), pos)));
}

int IconList::get_icon_at(int x, int y)
{
  return gnome_icon_list_get_icon_at(gobj(), x, y);
}

int IconList::get_items_per_line()
{
  return gnome_icon_list_get_items_per_line(gobj());
}

IconTextItem* IconList::get_icon_text_item(int idx)
{
  return Glib::wrap(gnome_icon_list_get_icon_text_item(gobj(), idx));
}

Gnome::Canvas::Pixbuf* IconList::get_icon_pixbuf_item(int idx)
{
  return Glib::wrap(gnome_icon_list_get_icon_pixbuf_item(gobj(), idx));
}


Glib::SignalProxy2<void,int,GdkEvent*> IconList::signal_select_icon()
{
  return Glib::SignalProxy2<void,int,GdkEvent*>(this, &IconList_signal_select_icon_info);
}

Glib::SignalProxy2<void,int,GdkEvent*> IconList::signal_unselect_icon()
{
  return Glib::SignalProxy2<void,int,GdkEvent*>(this, &IconList_signal_unselect_icon_info);
}

Glib::SignalProxy1<void,int> IconList::signal_focus_icon()
{
  return Glib::SignalProxy1<void,int>(this, &IconList_signal_focus_icon_info);
}

Glib::SignalProxy2<bool,int,const char*> IconList::signal_text_changed()
{
  return Glib::SignalProxy2<bool,int,const char*>(this, &IconList_signal_text_changed_info);
}

Glib::SignalProxy2<void,Gtk::DirectionType,bool> IconList::signal_move_cursor()
{
  return Glib::SignalProxy2<void,Gtk::DirectionType,bool>(this, &IconList_signal_move_cursor_info);
}

Glib::SignalProxy0<void> IconList::signal_toggle_cursor_selection()
{
  return Glib::SignalProxy0<void>(this, &IconList_signal_toggle_cursor_selection_info);
}


void Gnome::UI::IconList::on_select_icon(int num, GdkEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->select_icon)
    (*base->select_icon)(gobj(),num,event);
}

void Gnome::UI::IconList::on_unselect_icon(int num, GdkEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->unselect_icon)
    (*base->unselect_icon)(gobj(),num,event);
}

void Gnome::UI::IconList::on_focus_icon(int num)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->focus_icon)
    (*base->focus_icon)(gobj(),num);
}

bool Gnome::UI::IconList::on_text_changed(int num, const char* new_text)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->text_changed)
    return (*base->text_changed)(gobj(),num,new_text);

  typedef bool RType;
  return RType();
}

void Gnome::UI::IconList::on_move_cursor(Gtk::DirectionType dir, bool clear_selection)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->move_cursor)
    (*base->move_cursor)(gobj(),((GtkDirectionType)(dir)),static_cast<int>(clear_selection));
}

void Gnome::UI::IconList::on_toggle_cursor_selection()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->toggle_cursor_selection)
    (*base->toggle_cursor_selection)(gobj());
}


} // namespace UI

} // namespace Gnome

