
#include <libgnomeuimm/pixmap-entry.h>
#include <libgnomeuimm/private/pixmap-entry_p.h>

/* $Id: pixmap-entry.ccg,v 1.7 2002/01/03 12:28:01 murrayc Exp $ */


/* pixmap-entry.ccg
 * 
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomeui/gnome-pixmap-entry.h>

namespace Gnome
{

namespace UI
{

PixmapEntry::PixmapEntry(const Glib::ustring& history_id,
				     const Glib::ustring& browse_dialog_title,
				     bool do_preview)
  : Gtk::VBox(GTK_VBOX(g_object_new(get_type(),0)))  
{
  gnome_pixmap_entry_construct(gobj(), 
			       history_id.c_str(),
			       browse_dialog_title.c_str(),
			       do_preview);
}

} /* namespace UI */
} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::UI::PixmapEntry* wrap(GnomePixmapEntry* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::PixmapEntry *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType PixmapEntry_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_pixmap_entry_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void PixmapEntry_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* PixmapEntry_Class::wrap_new(GObject* o)
{
  return manage(new PixmapEntry((GnomePixmapEntry*)(o)));
}


/* The implementation: */

PixmapEntry::PixmapEntry(GnomePixmapEntry* castitem)
: Gtk::VBox((GtkVBox*)(castitem))
{}

PixmapEntry::~PixmapEntry()
{
  destroy_();
}

PixmapEntry::CppClassType PixmapEntry::pixmapentry_class_; //Initialize static member.

GType PixmapEntry::get_type()
{
  return pixmapentry_class_.get_type();
}

GType PixmapEntry::get_base_type()
{
  return gnome_pixmap_entry_get_type();
}

PixmapEntry::PixmapEntry()
: Gtk::VBox((GtkVBox*)(g_object_new(get_type(), (char*)0)))
{}

void PixmapEntry::set_pixmap_subdir(const Glib::ustring& subdir)
{
  gnome_pixmap_entry_set_pixmap_subdir(gobj(), subdir.c_str());
}

Gtk::ScrolledWindow* PixmapEntry::get_scrolled_window()
{
  return Glib::wrap((GtkScrolledWindow*)gnome_pixmap_entry_scrolled_window(gobj()));
}

Gtk::Widget* PixmapEntry::get_preview_widget()
{
  return Glib::wrap(gnome_pixmap_entry_preview_widget(gobj()));
}

void PixmapEntry::set_preview(bool do_preview)
{
  gnome_pixmap_entry_set_preview(gobj(), static_cast<int>(do_preview));
}

void PixmapEntry::set_preview_size(gint preview_w, gint preview_h)
{
  gnome_pixmap_entry_set_preview_size(gobj(), preview_w, preview_h);
}

Glib::ustring PixmapEntry::get_filename() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_pixmap_entry_get_filename(const_cast<GnomePixmapEntry*>(gobj())));
}


} // namespace UI

} // namespace Gnome

