/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-26 07:00:55 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <glib.h>
#include <glib-object.h>
#ifdef __cplusplus
extern "C" 
{
#endif

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_set_pixbuf
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1pixbuf (JNIEnv *env, jclass cls, 
        jint value, jint obj) 
    {
        g_value_set_pointer ((GValue*)value, &obj);
    }

    /*
     */
    JNIEXPORT jint JNICALL Java_org_gnu_glib_Value_g_1value_1get_1pixbuf (JNIEnv *env, jclass 
        cls, jint value) 
    {
        GValue *value_g = (GValue *)value;
        {
            gpointer pointer_g = (gpointer) (g_value_get_pointer (value_g));
            return (jint) pointer_g;
        }
	}
    
    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_set_java_object
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1java_1object (JNIEnv *env, jclass cls, 
        jint value, jobject obj) 
    {
		gpointer ptr =  (*env)->NewGlobalRef(env, obj);
        GValue *value_g = (GValue *)value;
        {
            g_value_set_pointer (value_g, ptr);
        }
    }

    /*
     */
    JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1get_1java_1object (JNIEnv *env, jclass 
        cls, jint value) 
    {
        GValue *value_g = (GValue *)value;
        {
            gpointer pointer_g = (gpointer) (g_value_get_pointer (value_g));
            return (jobject) pointer_g;
        }
    }
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_init
     * Signature: (I)V
     */
    JNIEXPORT jint JNICALL Java_org_gnu_glib_Value_g_1value_1init (JNIEnv *env, jclass cls, 
        jint type) 
    {
        GValue *value_g = (GValue *) g_malloc(sizeof(GValue));
		value_g->g_type = 0;
        value_g = g_value_init (value_g,(GType*)type);
        return (jint)value_g;
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_copy
     * Signature: (I[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1copy (JNIEnv *env, jclass cls, jint 
        srcValue, jintArray destValue) 
    {
        GValue *srcValue_g = (GValue *)srcValue;
        gint *destValue_g_g = (gint *) (*env)->GetIntArrayElements (env, destValue, NULL);
        GValue *destValue_g = (GValue *)destValue_g_g;
        {
            g_value_copy (srcValue_g, destValue_g);
            (*env)->ReleaseIntArrayElements (env, destValue, (jint*)destValue_g_g, 0);
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_reset
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_glib_Value_g_1value_1reset (JNIEnv *env, jclass cls, jint 
        value) 
    {
        GValue *value_g = (GValue *)value;
        {
            return (jint)g_value_reset (value_g);
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_unset
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1unset (JNIEnv *env, jclass cls, jint 
        value) 
    {
        GValue *value_g = (GValue *)value;
        {
            g_value_unset (value_g);
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_set_char
     * Signature: (IB)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1char (JNIEnv *env, jclass cls, 
        jint value, jbyte vChar) 
    {
        GValue *value_g = (GValue *)value;
        gchar vChar_g = (gchar) vChar;
        {
            g_value_set_char (value_g, vChar_g);
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_get_char
     * Signature: (I)B
     */
    JNIEXPORT jbyte JNICALL Java_org_gnu_glib_Value_g_1value_1get_1char (JNIEnv *env, jclass cls, 
        jint value) 
    {
        GValue *value_g = (GValue *)value;
        {
            jbyte result_j = (jbyte) (g_value_get_char (value_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_set_boolean
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1boolean (JNIEnv *env, jclass cls, 
        jint value, jboolean vBoolean) 
    {
        GValue *value_g = (GValue *)value;
        gboolean vBoolean_g = (gboolean) vBoolean;
        {
            g_value_set_boolean (value_g, vBoolean_g);
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_get_boolean
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_glib_Value_g_1value_1get_1boolean (JNIEnv *env, jclass 
        cls, jint value) 
    {
        GValue *value_g = (GValue *)value;
        {
            jboolean result_j = (jboolean) (g_value_get_boolean (value_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_set_int
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1int (JNIEnv *env, jclass cls, 
        jint value, jint vInt) 
    {
        GValue *value_g = (GValue *)value;
        gint32 vInt_g = (gint32) vInt;
        {
            g_value_set_int (value_g, vInt_g);
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_get_int
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_glib_Value_g_1value_1get_1int (JNIEnv *env, jclass cls, 
        jint value) 
    {
        GValue *value_g = (GValue *)value;
        {
            jint result_j = (jint) (g_value_get_int (value_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_set_long
     * Signature: (IJ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1long (JNIEnv *env, jclass cls, 
        jint value, jlong vLong) 
    {
        GValue *value_g = (GValue *)value;
        glong vLong_g = (glong) vLong;
        {
            g_value_set_long (value_g, vLong_g);
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_get_long
     * Signature: (I)J
     */
    JNIEXPORT jlong JNICALL Java_org_gnu_glib_Value_g_1value_1get_1long (JNIEnv *env, jclass cls, 
        jint value) 
    {
        GValue *value_g = (GValue *)value;
        {
            jlong result_j = (jlong) (g_value_get_long (value_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_set_float
     * Signature: (ID)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1float (JNIEnv *env, jclass cls, 
        jint value, jdouble vFloat) 
    {
        GValue *value_g = (GValue *)value;
        gdouble vFloat_g = (gdouble) vFloat;
        {
            g_value_set_float (value_g, vFloat_g);
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_get_float
     * Signature: (I)D
     */
    JNIEXPORT jdouble JNICALL Java_org_gnu_glib_Value_g_1value_1get_1float (JNIEnv *env, jclass 
        cls, jint value) 
    {
        GValue *value_g = (GValue *)value;
        {
            jdouble result_j = (jdouble) (g_value_get_float (value_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_set_double
     * Signature: (ID)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1double (JNIEnv *env, jclass cls, 
        jint value, jdouble vDouble) 
    {
        GValue *value_g = (GValue *)value;
        gdouble vDouble_g = (gdouble) vDouble;
        {
            g_value_set_double (value_g, vDouble_g);
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_get_double
     * Signature: (I)D
     */
    JNIEXPORT jdouble JNICALL Java_org_gnu_glib_Value_g_1value_1get_1double (JNIEnv *env, jclass 
        cls, jint value) 
    {
        GValue *value_g = (GValue *)value;
        {
            jdouble result_j = (jdouble) (g_value_get_double (value_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_set_string
     * Signature: (Ijava.lang.String)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1string (JNIEnv *env, jclass cls, 
        jint value, jstring vString) 
    {
        GValue *value_g = (GValue *)value;
        const gchar* vString_g = (*env)->GetStringUTFChars(env, vString, 0);
        g_value_set_string (value_g, vString_g);
        (*env)->ReleaseStringUTFChars(env, vString, vString_g);
    }

    /*
     * Class:     org.gnu.glib.Value
     * Method:    g_value_get_string
     * Signature: (I)java.lang.String
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_glib_Value_g_1value_1get_1string (JNIEnv *env, jclass 
        cls, jint value) 
    {
        GValue *value_g = (GValue *)value;
        {
            const gchar *result_g = g_value_get_string ((const GValue*)value_g);
            jstring result = (*env)->NewStringUTF(env, result_g);
            return result;
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
