/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * Represents a block in which data can be stored in a {@link TreeModel} (such
 * as {@link ListStore} or {@link TreeStore}). In Gtk, these are called columns
 * and are referenced by integers. We have renamed them to DataBlocks to avoid
 * confusion with {@link TreeViewColumn}s and created these objects to use
 * rather than integers. This allows type checking and should make programs more
 * maintainable. This is an abstract class - there is an implementation of it
 * for each type of data accepted by the two tree models.
 *
 * @see ListStore
 * @see TreeStore
 *
 * @author Mark Howard &lt;mh@debian.org&gt;
 */
public abstract class DataBlock {

	protected Type type = null;
	protected int column = -1;

	/**
	 * Returns the column number of this dataBlock used internally by Gtk.
	 */
	public int getColumn(){
		if (column >= 0)
			return column;
		else
			throw new RuntimeException("The column field has not been set - this DataBlock has not yet been passed to a TreeModel");
	}

	/**
	 * Sets the integer column number
	 */
	void setColumn(int column){
		this.column = column;
	}

	/**
	 * Returns the glib Type of data contained in this column. This can only be
	 * called once. (it is only needed once - in the constructor of the
	 * listStore/TreeStore)
	 */
	public Type getType(){
		if (type != null){
			Type t = type;
			type = null;
			return t;
		}else
			throw new RuntimeException("The type either hasn't been set, or has already been requested and destroyed");
	}

}
