/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * Drag and Drop Support
     ****************************************/
	
	JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1drag_1dest_1set( JNIEnv *env, jclass cls, jint widget, jint flags, jintArray targets, jint actions)
	{
		gint *targets_g_g = (gint *) (*env)->GetIntArrayElements( env, targets, NULL );	
		GtkTargetEntry **targets_g = (GtkTargetEntry **) targets_g_g;	
		GtkWidget *widget_g = (GtkWidget *) widget; 
		GtkDestDefaults flags_g = (GtkDestDefaults) flags;
		GdkDragAction actions_g = (GdkDragAction) actions;
		int targets_n = (int) (*env)->GetArrayLength( env, targets );
		
		GtkTargetEntry *targets_arr = g_new( GtkTargetEntry, targets_n );
		int i = 0;
		for( i = 0; i < targets_n; i++){
			targets_arr[i] = * targets_g[i];
		}
		
		gtk_drag_dest_set ( widget_g,
							flags_g,
							targets_arr,
							targets_n,
							actions_g );
	}
	
	JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1drag_1source_1set( JNIEnv *env, jclass cls, jint widget, jint start_button_mask, jintArray targets, jint actions)
	{
		gint *targets_g_g = (gint *) (*env)->GetIntArrayElements( env, targets, NULL );	
		GtkTargetEntry **targets_g = (GtkTargetEntry **) targets_g_g;	
		
		int targets_n = (int) (*env)->GetArrayLength( env, targets );
		GtkTargetEntry *targets_arr = g_new( GtkTargetEntry, targets_n );
		int i = 0;
		for( i = 0; i < targets_n; i++){
			targets_arr[i] = * targets_g[i];
		}
		//printf("\n%d\n", targets_n );
		gtk_drag_source_set( (GtkWidget *) widget,
							(GdkModifierType) start_button_mask,
							targets_arr,
							targets_n,
							(GdkDragAction) actions );
	}
	
	JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1drag_1dest_1unset( JNIEnv *env, jclass cls, jint widget )
	{
		gtk_drag_dest_unset( (GtkWidget *) widget );
	}
	JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1drag_1source_1unset( JNIEnv *env, jclass cls, jint widget )
	{
		gtk_drag_source_unset( (GtkWidget *) widget );
	}

	JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1sensitive( JNIEnv *env, jclass cls, jint widget )
	{
		return (jboolean) (GTK_WIDGET_SENSITIVE((GtkWidget *)widget));
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1type (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gtk_widget_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_ref
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1ref (JNIEnv *env, jclass cls, jint 
        widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_ref (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_unref
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1unref (JNIEnv *env, jclass cls, 
        jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_unref (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_destroy
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1destroy (JNIEnv *env, jclass cls, 
        jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_destroy (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_destroyed
     * Signature: (I[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1destroyed (JNIEnv *env, jclass cls, 
        jint widget, jintArray widgetPointer) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint *widgetPointer_g_g = (gint *) (*env)->GetIntArrayElements (env, widgetPointer, NULL);
        GtkWidget **widgetPointer_g = (GtkWidget **)widgetPointer_g_g;
        {
            gtk_widget_destroyed (widget_g, widgetPointer_g);
            (*env)->ReleaseIntArrayElements (env, widgetPointer, (jint*)widgetPointer_g_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_unparent
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1unparent (JNIEnv *env, jclass cls, 
        jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_unparent (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_show
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1show (JNIEnv *env, jclass cls, jint 
        widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_show (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_show_now
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1show_1now (JNIEnv *env, jclass cls, 
        jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_show_now (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_hide
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1hide (JNIEnv *env, jclass cls, jint 
        widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_hide (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_show_all
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1show_1all (JNIEnv *env, jclass cls, 
        jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_show_all (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_hide_all
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1hide_1all (JNIEnv *env, jclass cls, 
        jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_hide_all (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_map
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1map (JNIEnv *env, jclass cls, jint 
        widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_map (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_unmap
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1unmap (JNIEnv *env, jclass cls, 
        jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_unmap (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_realize
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1realize (JNIEnv *env, jclass cls, 
        jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_realize (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_unrealize
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1unrealize (JNIEnv *env, jclass cls, 
        jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_unrealize (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_queue_draw
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1queue_1draw (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_queue_draw (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_queue_draw_area
     * Signature: (IIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1queue_1draw_1area (JNIEnv *env, 
        jclass cls, jint widget, jint x, jint y, jint width, jint height) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint32 x_g = (gint32) x;
        gint32 y_g = (gint32) y;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            gtk_widget_queue_draw_area (widget_g, x_g, y_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_queue_resize
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1queue_1resize (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_queue_resize (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_size_request
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1size_1request (JNIEnv *env, jclass 
        cls, jint widget, jint requisition) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkRequisition *requisition_g = (GtkRequisition *)requisition;
        {
            gtk_widget_size_request (widget_g, requisition_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_size_allocate
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1size_1allocate (JNIEnv *env, jclass 
        cls, jint widget, jint allocation) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkAllocation *allocation_g = (GtkAllocation *)allocation;
        {
            gtk_widget_size_allocate (widget_g, allocation_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_child_requisition
     * Signature: (I[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1child_1requisition (JNIEnv 
        *env, jclass cls, jint widget, jintArray requisition) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint *requisition_g_g = (gint *) (*env)->GetIntArrayElements (env, requisition, NULL);
        GtkRequisition *requisition_g = (GtkRequisition *)requisition_g_g;
        {
            gtk_widget_get_child_requisition (widget_g, requisition_g);
            (*env)->ReleaseIntArrayElements (env, requisition, (jint*)requisition_g_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_add_accelerator
     * Signature: (I[BIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1add_1accelerator (JNIEnv *env, 
        jclass cls, jint widget, jstring accelSignal, jint accelGroup, jint accelKey, jint 
        accelMods, jint accelFlags) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkAccelGroup *accelGroup_g = (GtkAccelGroup *)accelGroup;
        guint32 accelKey_g = (guint32) accelKey;
        guint32 accelMods_g = (guint32) accelMods;
        GtkAccelFlags accelFlags_g = (GtkAccelFlags) accelFlags;
        const gchar* accelSignal_g = (*env)->GetStringUTFChars(env, accelSignal, NULL);
		gtk_widget_add_accelerator (widget_g, accelSignal_g, accelGroup_g, accelKey_g, 
			accelMods_g, accelFlags_g);
		(*env)->ReleaseStringUTFChars(env, accelSignal, accelSignal_g);
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_remove_accelerator
     * Signature: (IIII)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1remove_1accelerator (JNIEnv 
        *env, jclass cls, jint widget, jint accelGroup, jint accelKey, jint accelMods) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkAccelGroup *accelGroup_g = (GtkAccelGroup *)accelGroup;
        guint32 accelKey_g = (guint32) accelKey;
        guint32 accelMods_g = (guint32) accelMods;
        {
            jboolean result_j = (jboolean) (gtk_widget_remove_accelerator (widget_g, accelGroup_g, 
                    accelKey_g, accelMods_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_accel_path
     * Signature: (I[BI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1accel_1path (JNIEnv *env, 
        jclass cls, jint widget, jstring accelPath, jint accelGroup) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkAccelGroup *accelGroup_g = (GtkAccelGroup *)accelGroup;
        const gchar* accelPath_g = (*env)->GetStringUTFChars(env, accelPath, NULL);
		gtk_widget_set_accel_path (widget_g, accelPath_g, accelGroup_g);
		(*env)->ReleaseStringUTFChars( env, accelPath, accelPath_g );
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_list_accel_closures
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1list_1accel_1closures (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_list_accel_closures (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_mnemonic_activate
     * Signature: (IZ)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1mnemonic_1activate (JNIEnv 
        *env, jclass cls, jint widget, jboolean groupCycling) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gboolean groupCycling_g = (gboolean) groupCycling;
        {
            jboolean result_j = (jboolean) (gtk_widget_mnemonic_activate (widget_g, groupCycling_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_event
     * Signature: (II)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1event (JNIEnv *env, jclass cls, 
        jint widget, jint event) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GdkEvent *event_g = (GdkEvent *)event;
        {
            jboolean result_j = (jboolean) (gtk_widget_event (widget_g, event_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_send_expose
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1send_1expose (JNIEnv *env, jclass 
        cls, jint widget, jint event) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GdkEvent *event_g = (GdkEvent *)event;
        {
            jint result_j = (jint) (gtk_widget_send_expose (widget_g, event_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_activate
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1activate (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            jboolean result_j = (jboolean) (gtk_widget_activate (widget_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_scroll_adjustments
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1scroll_1adjustments (JNIEnv 
        *env, jclass cls, jint widget, jint hadj, jint vadj) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkAdjustment *hadj_g = (GtkAdjustment *)hadj;
        GtkAdjustment *vadj_g = (GtkAdjustment *)vadj;
        {
            gtk_widget_set_scroll_adjustments (widget_g, hadj_g, vadj_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_reparent
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1reparent (JNIEnv *env, jclass cls, 
        jint widget, jint newParent) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkWidget *newParent_g = (GtkWidget *)newParent;
        {
            gtk_widget_reparent (widget_g, newParent_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_intersect
     * Signature: (II[Lint ;)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1intersect (JNIEnv *env, jclass 
        cls, jint widget, jint area, jintArray intersection) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GdkRectangle *area_g = (GdkRectangle *)area;
        gint *intersection_g_g = (gint *) (*env)->GetIntArrayElements (env, intersection, NULL);
        GdkRectangle *intersection_g = (GdkRectangle *)intersection_g_g;
        {
            jboolean result_j = (jboolean) (gtk_widget_intersect (widget_g, area_g, intersection_g));
            (*env)->ReleaseIntArrayElements (env, intersection, (jint*)intersection_g_g, 0);
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_region_intersect
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1region_1intersect (JNIEnv *env, 
        jclass cls, jint widget, jint region) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GdkRegion *region_g = (GdkRegion *)region;
        {
            return (jint)gtk_widget_region_intersect (widget_g, region_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_freeze_child_notify
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1freeze_1child_1notify (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_freeze_child_notify (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_child_notify
     * Signature: (Ijava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1child_1notify (JNIEnv *env, jclass 
        cls, jint widget, jstring childProperty) 
    {
        gchar* childProperty_g = (gchar*)(*env)->GetStringUTFChars(env, childProperty, 0);
        gtk_widget_child_notify ((GtkWidget*)widget, childProperty_g);
        if (childProperty) (*env)->ReleaseStringUTFChars(env, childProperty, childProperty_g);
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_thaw_child_notify
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1thaw_1child_1notify (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_thaw_child_notify (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_is_focus
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1is_1focus (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            jboolean result_j = (jboolean) (gtk_widget_is_focus (widget_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_grab_focus
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1grab_1focus (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_grab_focus (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_grab_default
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1grab_1default (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
		GTK_WIDGET_SET_FLAGS (widget_g, GTK_CAN_DEFAULT);
        {
            gtk_widget_grab_default (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_name
     * Signature: (I[B)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1name (JNIEnv *env, jclass cls, 
        jint widget, jstring name) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        const gchar* name_g = (*env)->GetStringUTFChars(env, name, NULL);
		gtk_widget_set_name (widget_g, name_g);
		(*env)->ReleaseStringUTFChars(env, name, name_g);
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_name
     * Signature: (I)[B
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1name (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
		return (*env)->NewStringUTF( env, (gchar*)gtk_widget_get_name (widget_g));
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_state
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1state (JNIEnv *env, jclass 
        cls, jint widget, jint state) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkStateType state_g = (GtkStateType) state;
        {
            gtk_widget_set_state (widget_g, state_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_sensitive
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1sensitive (JNIEnv *env, jclass 
        cls, jint widget, jboolean sensitive) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gboolean sensitive_g = (gboolean) sensitive;
        {
            gtk_widget_set_sensitive (widget_g, sensitive_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_app_paintable
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1app_1paintable (JNIEnv *env, 
        jclass cls, jint widget, jboolean appPaintable) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gboolean appPaintable_g = (gboolean) appPaintable;
        {
            gtk_widget_set_app_paintable (widget_g, appPaintable_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_double_buffered
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1double_1buffered (JNIEnv *env, 
        jclass cls, jint widget, jboolean doubleBuffered) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gboolean doubleBuffered_g = (gboolean) doubleBuffered;
        {
            gtk_widget_set_double_buffered (widget_g, doubleBuffered_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_redraw_on_allocate
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1redraw_1on_1allocate (JNIEnv 
        *env, jclass cls, jint widget, jboolean redrawOnAllocate) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gboolean redrawOnAllocate_g = (gboolean) redrawOnAllocate;
        {
            gtk_widget_set_redraw_on_allocate (widget_g, redrawOnAllocate_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_parent
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1parent (JNIEnv *env, jclass 
        cls, jint widget, jint parent) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkWidget *parent_g = (GtkWidget *)parent;
        {
            gtk_widget_set_parent (widget_g, parent_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_parent_window
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1parent_1window (JNIEnv *env, 
        jclass cls, jint widget, jint parent) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GdkWindow *parent_g = (GdkWindow *)parent;
        {
            gtk_widget_set_parent_window (widget_g, parent_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_child_visible
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1child_1visible (JNIEnv *env, 
        jclass cls, jint widget, jboolean isVisible) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gboolean isVisible_g = (gboolean) isVisible;
        {
            gtk_widget_set_child_visible (widget_g, isVisible_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_child_visible
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1child_1visible (JNIEnv 
        *env, jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            jboolean result_j = (jboolean) (gtk_widget_get_child_visible (widget_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_parent
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1parent (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_parent (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_parent_window
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1parent_1window (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_parent_window (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_child_focus
     * Signature: (II)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1child_1focus (JNIEnv *env, 
        jclass cls, jint widget, jint direction) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkDirectionType direction_g = (GtkDirectionType) direction;
        {
            jboolean result_j = (jboolean) (gtk_widget_child_focus (widget_g, direction_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_size_request
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1size_1request (JNIEnv *env, 
        jclass cls, jint widget, jint width, jint height) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            gtk_widget_set_size_request (widget_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_size_request
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1size_1request (JNIEnv *env, 
        jclass cls, jint widget, jintArray width, jintArray height) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint *width_g = (gint *) (*env)->GetIntArrayElements (env, width, NULL);
        gint *height_g = (gint *) (*env)->GetIntArrayElements (env, height, NULL);
        {
            gtk_widget_get_size_request (widget_g, width_g, height_g);
            (*env)->ReleaseIntArrayElements (env, width, (jint *) width_g, 0);
            (*env)->ReleaseIntArrayElements (env, height, (jint *) height_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_events
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1events (JNIEnv *env, jclass 
        cls, jint widget, jint events) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint32 events_g = (gint32) events;
        {
            gtk_widget_set_events (widget_g, events_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_add_events
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1add_1events (JNIEnv *env, jclass 
        cls, jint widget, jint events) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint32 events_g = (gint32) events;
        {
            gtk_widget_add_events (widget_g, events_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_extension_events
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1extension_1events (JNIEnv 
        *env, jclass cls, jint widget, jint mode) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GdkExtensionMode mode_g = (GdkExtensionMode) mode;
        {
            gtk_widget_set_extension_events (widget_g, mode_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_extension_events
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1extension_1events (JNIEnv 
        *env, jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            jint result_j = (jint) (gtk_widget_get_extension_events (widget_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_toplevel
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1toplevel (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_toplevel (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_ancestor
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1ancestor (JNIEnv *env, jclass 
        cls, jint widget, jint widgetType) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GType widgetType_g = (GType)&widgetType;
        {
            return (jint)gtk_widget_get_ancestor (widget_g, widgetType_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_colormap
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1colormap (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_colormap (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_visual
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1visual (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_visual (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_settings
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1settings (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_settings (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_accessible
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1accessible (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_accessible (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_colormap
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1colormap (JNIEnv *env, jclass 
        cls, jint widget, jint cmap) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GdkColormap *cmap_g = (GdkColormap *)cmap;
        {
            gtk_widget_set_colormap (widget_g, cmap_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_events
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1events (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            jint result_j = (jint) (gtk_widget_get_events (widget_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_pointer
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1pointer (JNIEnv *env, jclass 
        cls, jint widget, jintArray x, jintArray y) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint *x_g = (gint *) (*env)->GetIntArrayElements (env, x, NULL);
        gint *y_g = (gint *) (*env)->GetIntArrayElements (env, y, NULL);
        {
            gtk_widget_get_pointer (widget_g, x_g, y_g);
            (*env)->ReleaseIntArrayElements (env, x, (jint *) x_g, 0);
            (*env)->ReleaseIntArrayElements (env, y, (jint *) y_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_is_ancestor
     * Signature: (II)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1is_1ancestor (JNIEnv *env, 
        jclass cls, jint widget, jint ancestor) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkWidget *ancestor_g = (GtkWidget *)ancestor;
        {
            jboolean result_j = (jboolean) (gtk_widget_is_ancestor (widget_g, ancestor_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_translate_coordinates
     * Signature: (IIII[Lint ;[Lint ;)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1translate_1coordinates (JNIEnv 
        *env, jclass cls, jint srcWidget, jint destWidget, jint srcX, jint srcY, jintArray destX, 
        jintArray destY) 
    {
        GtkWidget *srcWidget_g = (GtkWidget *)srcWidget;
        GtkWidget *destWidget_g = (GtkWidget *)destWidget;
        gint32 srcX_g = (gint32) srcX;
        gint32 srcY_g = (gint32) srcY;
        gint *destX_g = (gint *) (*env)->GetIntArrayElements (env, destX, NULL);
        gint *destY_g = (gint *) (*env)->GetIntArrayElements (env, destY, NULL);
        {
            jboolean result_j = (jboolean) (gtk_widget_translate_coordinates (srcWidget_g, 
                    destWidget_g, srcX_g, srcY_g, destX_g, destY_g));
            (*env)->ReleaseIntArrayElements (env, destX, (jint *) destX_g, 0);
            (*env)->ReleaseIntArrayElements (env, destY, (jint *) destY_g, 0);
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_hide_on_delete
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1hide_1on_1delete (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            jboolean result_j = (jboolean) (gtk_widget_hide_on_delete (widget_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_style
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1style (JNIEnv *env, jclass 
        cls, jint widget, jint style) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkStyle *style_g = (GtkStyle *)style;
        {
            gtk_widget_set_style (widget_g, style_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_ensure_style
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1ensure_1style (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_ensure_style (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_style
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1style (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_style (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_modify_style
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1modify_1style (JNIEnv *env, jclass 
        cls, jint widget, jint style) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkRcStyle *style_g = (GtkRcStyle *)style;
        {
            gtk_widget_modify_style (widget_g, style_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_modifier_style
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1modifier_1style (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_modifier_style (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_modify_fg
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1modify_1fg (JNIEnv *env, jclass 
        cls, jint widget, jint state, jint color) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkStateType state_g = (GtkStateType) state;
        GdkColor *color_g = (GdkColor *)color;
        {
            gtk_widget_modify_fg (widget_g, state_g, color_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_modify_bg
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1modify_1bg (JNIEnv *env, jclass 
        cls, jint widget, jint state, jint color) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkStateType state_g = (GtkStateType) state;
        GdkColor *color_g = (GdkColor *)color;
        {
            gtk_widget_modify_bg (widget_g, state_g, color_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_modify_text
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1modify_1text (JNIEnv *env, jclass 
        cls, jint widget, jint state, jint color) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkStateType state_g = (GtkStateType) state;
        GdkColor *color_g = (GdkColor *)color;
        {
            gtk_widget_modify_text (widget_g, state_g, color_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_modify_base
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1modify_1base (JNIEnv *env, jclass 
        cls, jint widget, jint state, jint color) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkStateType state_g = (GtkStateType) state;
        GdkColor *color_g = (GdkColor *)color;
        {
            gtk_widget_modify_base (widget_g, state_g, color_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_modify_font
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1modify_1font (JNIEnv *env, jclass 
        cls, jint widget, jint fontDesc) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        PangoFontDescription *fontDesc_g = (PangoFontDescription *)fontDesc;
        {
            gtk_widget_modify_font (widget_g, fontDesc_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_create_pango_context
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1create_1pango_1context (JNIEnv 
        *env, jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_create_pango_context (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_pango_context
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1pango_1context (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_widget_get_pango_context (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_create_pango_layout
     * Signature: (I[B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1create_1pango_1layout (JNIEnv *env, 
        jclass cls, jint widget, jstring text) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        const gchar* text_g = (*env)->GetStringUTFChars(env, text, NULL);
        jint retval = (jint)gtk_widget_create_pango_layout (widget_g, text_g);
		(*env)->ReleaseStringUTFChars(env, text, text_g);
		return retval;
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_render_icon
     * Signature: (I[BI[B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1render_1icon (JNIEnv *env, jclass 
        cls, jint widget, jstring stockID, jint size, jstring detail) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkIconSize size_g = (GtkIconSize) size;
        const gchar* stockID_g = (*env)->GetStringUTFChars(env, stockID, NULL);
        const gchar* detail_g = (*env)->GetStringUTFChars(env, detail, NULL);
		jint retval = (jint)gtk_widget_render_icon (widget_g, stockID_g, size_g, detail_g);
		(*env)->ReleaseStringUTFChars( env, stockID, stockID_g );
		(*env)->ReleaseStringUTFChars( env, detail, detail_g );
		return retval;
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_composite_name
     * Signature: (I[B)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1composite_1name (JNIEnv *env, 
        jclass cls, jint widget, jstring name) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        const gchar* name_g = (*env)->GetStringUTFChars(env, name, NULL);
		gtk_widget_set_composite_name (widget_g, name_g);
		(*env)->ReleaseStringUTFChars( env, name, name_g);
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_composite_name
     * Signature: (I)[B
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1composite_1name (JNIEnv 
        *env, jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
		 return (*env)->NewStringUTF( env, gtk_widget_get_composite_name (widget_g)) ;
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_reset_rc_styles
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1reset_1rc_1styles (JNIEnv *env, 
        jclass cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_widget_reset_rc_styles (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_push_colormap
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1push_1colormap (JNIEnv *env, jclass 
        cls, jint cmap) 
    {
        GdkColormap *cmap_g = (GdkColormap *)cmap;
        {
            gtk_widget_push_colormap (cmap_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_pop_colormap
     * Signature: ()V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1pop_1colormap (JNIEnv *env, jclass 
        cls) 
    {
        {
            gtk_widget_pop_colormap ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_push_composite_child
     * Signature: ()V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1push_1composite_1child (JNIEnv 
        *env, jclass cls) 
    {
        {
            gtk_widget_push_composite_child ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_pop_composite_child
     * Signature: ()V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1pop_1composite_1child (JNIEnv *env, 
        jclass cls) 
    {
        {
            gtk_widget_pop_composite_child ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_style_get_property
     * Signature: (I[BI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1style_1get_1property (JNIEnv *env, 
        jclass cls, jint widget, jstring propertyName, jint value) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GValue *value_g = (GValue *)value;
        const gchar* propertyName_g = (*env)->GetStringUTFChars(env, propertyName, NULL);
		gtk_widget_style_get_property (widget_g, propertyName_g, value_g);
		(*env)->ReleaseStringUTFChars(env, propertyName, propertyName_g );
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_default_colormap
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1default_1colormap (JNIEnv 
        *env, jclass cls, jint cmap) 
    {
        GdkColormap *cmap_g = (GdkColormap *)cmap;
        {
            gtk_widget_set_default_colormap (cmap_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_default_colormap
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1default_1colormap (JNIEnv 
        *env, jclass cls) 
    {
        {
            return (jint)gtk_widget_get_default_colormap ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_default_visual
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1default_1visual (JNIEnv *env, 
        jclass cls) 
    {
        {
            return (jint)gtk_widget_get_default_visual ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_default_style
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1default_1style (JNIEnv *env, 
        jclass cls) 
    {
        {
            return (jint)gtk_widget_get_default_style ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_direction
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1direction (JNIEnv *env, jclass 
        cls, jint widget, jint dir) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GtkTextDirection dir_g = (GtkTextDirection) dir;
        {
            gtk_widget_set_direction (widget_g, dir_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_direction
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1direction (JNIEnv *env, jclass 
        cls, jint widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            jint result_j = (jint) (gtk_widget_get_direction (widget_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_set_default_direction
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1set_1default_1direction (JNIEnv 
        *env, jclass cls, jint dir) 
    {
        GtkTextDirection dir_g = (GtkTextDirection) dir;
        {
            gtk_widget_set_default_direction (dir_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_get_default_direction
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1default_1direction (JNIEnv 
        *env, jclass cls) 
    {
        {
            jint result_j = (jint) (gtk_widget_get_default_direction ());
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_shape_combine_mask
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1shape_1combine_1mask (JNIEnv *env, 
        jclass cls, jint widget, jint shapeMask, jint offsetX, jint offsetY) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        GdkBitmap *shapeMask_g = (GdkBitmap *)shapeMask;
        gint32 offsetX_g = (gint32) offsetX;
        gint32 offsetY_g = (gint32) offsetY;
        {
            gtk_widget_shape_combine_mask (widget_g, shapeMask_g, offsetX_g, offsetY_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_path
     * Signature: (I[Lint ;[java/lang/String;[Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1path (JNIEnv *env, jclass cls, jint 
        widget, jintArray pathLength, jobjectArray path, jobjectArray pathReversed) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint *pathLength_g = (gint *) (*env)->GetIntArrayElements (env, pathLength, NULL);
        gchar **path_g = getStringArray(env, path);
        gchar **pathReversed_g = getStringArray(env, pathReversed);
        gtk_widget_path (widget_g, pathLength_g, path_g, pathReversed_g);
        (*env)->ReleaseIntArrayElements (env, pathLength, (jint *) pathLength_g, 0);
        freeStringArray(env, path, path_g);
        freeStringArray(env, pathReversed, pathReversed_g);
    }

    /*
     * Class:     org.gnu.gtk.Widget
     * Method:    gtk_widget_class_path
     * Signature: (I[Lint ;[Ljava/lang/String;[Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1class_1path (JNIEnv *env, jclass 
        cls, jint widget, jintArray pathLength, jobjectArray path, jobjectArray pathReversed) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        gint *pathLength_g = (gint *) (*env)->GetIntArrayElements (env, pathLength, NULL);
        gchar **path_g = getStringArray(env, path);
        gchar **pathReversed_g = getStringArray(env, pathReversed);
        gtk_widget_class_path (widget_g, pathLength_g, path_g, pathReversed_g);
        (*env)->ReleaseIntArrayElements (env, pathLength, (jint *) pathLength_g, 0);
        freeStringArray(env, path, path_g);
        freeStringArray(env, pathReversed, pathReversed_g);
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/

/*
 * Class:     org_gnu_gtk_Widget
 * Method:    gtk_widget_can_activate_accel
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1can_1activate_1accel
  (JNIEnv *env, jclass cls, jint widget, jint signalId)
{
	return (jboolean)gtk_widget_can_activate_accel((GtkWidget*)widget, (gint)signalId);
}
                                                                                
/*
 * Class:     org_gnu_gtk_Widget
 * Method:    gtk_widget_get_screen
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1screen
  (JNIEnv *env, jclass cls, jint widget)
{
	return (jint)gtk_widget_get_screen((GtkWidget*)widget);
}
                                                                                
/*
 * Class:     org_gnu_gtk_Widget
 * Method:    gtk_widget_has_screen
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1has_1screen
  (JNIEnv *env, jclass cls, jint widget)
{
	return (jboolean)gtk_widget_has_screen((GtkWidget*)widget);
}
                                                                                
/*
 * Class:     org_gnu_gtk_Widget
 * Method:    gtk_widget_get_display
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1display
  (JNIEnv *env, jclass cls, jint widget)
{
	return (jint)gtk_widget_get_display((GtkWidget*)widget);
}
                                                                                
/*
 * Class:     org_gnu_gtk_Widget
 * Method:    gtk_widget_get_root_window
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Widget_gtk_1widget_1get_1root_1window
  (JNIEnv *env, jclass cls, jint widget)
{
	return (jint)gtk_widget_get_root_window((GtkWidget*)widget);
}
                                                                                
#ifdef __cplusplus
}

#endif
