/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-25 10:04:26 EDT
 */

package org.gnu.glib;

/**
 * This object represents a doubly-linked list in the GLib system.
 * This should only be used internally.  This type should be converted
 * into one of the Java container types prior to being passed to
 * the application layer.  Objects of this type should be freed by
 * calling thre free() method.  The <strong>data</strong> parameter that
 * is being passed into many of the methods is the handle of a java-gnome
 * object.
 */
public class List extends Boxed {
	
	/**
	 * Construct a List object
	 */
	public List() {
		handle = List.g_list_alloc();
	}
	
	/**
	*	Contruct a List object using a given handle.
	*	This constructor is used by the libraries internally
	*	to construct the object with the handle returned by a native method.
	*/
	public List(int handle){
		this.handle = handle;
	}
	
	/**
	 * Release the resources associated with this object.
	 */
	public void free() {
		List.g_list_free(handle);
	}
	
	/**
	 * Append an element to the end of the list.
	 * 
	 * @param data The handle of the object that is being added
	 * to the List.
	 */	
	public void append(int data) {
		handle = List.g_list_append(handle, data);
	}
	
	/**
	 * Prepend an element to the end of the list.
	 * 
	 * @param data The handle of the object that is being
	 * added to the List.
	 */
	public void prepend(int data) {
		handle = List.g_list_prepend(handle, data);
	}
	
	/**
	 * Insert an element at a specified location in the List.
	 * 
	 * @param data The handle of the object that is being added
	 * to the List.
	 * @param position The position to perform the insertion.
	 */
	public void insert(int data, int position) {
		handle = List.g_list_insert(handle, data, position);
	}
	
	/**
	 * Remove the first instance of an element from the List.
	 * 
	 * @param data The item to remove from the list.  If two
	 * items contain the same data only the first will be 
	 * removed.
	 */
	public void remove(int data) {
		handle = List.g_list_remove(handle, data);
	}
	
	/**
	 * Remove all instances of an element from the List.
	 * 
	 * @param data The item to remove from the List.  This
	 * method will remove all instances of the object pointed
	 * to by data.
	 */
	public void removeAllInstances(int data) {
		handle = List.g_list_remove_all(handle, data);
	}

	/**
	 * Return the number of elements contained in the List.
	 * 
	 * @return The number of elements in the List.
	 */
	public int length() {
		return List.g_list_length(handle);
	}
	
	/**
	 * Return the first element from the List.  This method
	 * will also reposition the current list item to the 
	 * beginning of the list.
	 * 
	 * @return The first element from the List.
	 */
	public int first() {
		handle = List.g_list_first(handle);
		return List.getData(handle);
	}
	
	/**
	 * Return the last element from the List.  This method
	 * will also reposition the current list item to the
	 * end of the list.
	 * 
	 * @return The last element from the List.
	 */
	public int last() {
		handle = List.g_list_last(handle);
		return List.getData(handle);
	}
	
	/**
	 * Return the next element in the List.  This method
	 * will also move the current list item forward one
	 * element.
	 * 
	 * @return The next element from the List.
	 */
	public int next() {
		handle = List.g_list_next(handle);
		return List.getData(handle);
	}
	
	/**
	 * Return the previous element in the List.  This method
	 * will also move the current list item backward one
	 * element.
	 * 
	 * @return The previous element from the List.
	 */
	public int previous() {
		handle = List.g_list_previous(handle);
		return List.getData(handle);
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
    native static final protected int getData (int obj);
	native static final protected int g_list_append(int list, int data);
	native static final protected int g_list_prepend(int list, int data);
	native static final protected int g_list_insert(int list, int data, int position);
	native static final protected int g_list_remove(int list, int data);
	native static final protected int g_list_remove_all(int list, int data);
	native static final protected void g_list_free(int list);
	native static final protected int g_list_alloc();
	native static final protected int g_list_length(int list);
	native static final protected int g_list_first(int list);
	native static final protected int g_list_last(int list);
	native static final protected int g_list_previous(int list);
	native static final protected int g_list_next(int list);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
