/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * This is the listener interface for receiving life cycle
 * realted events for a Widget. 
 * <p>
 * An example of using this class to manage the life cycle events of an
 * application would be as follows:
 * <pre>
 * public class MyExample {
 * 
 *     public static void main( String[] argv ) {
 *         Gtk.init( argv );
 *         MyExample example = new MyExample();
 *         Gtk.main();
 *     }
 * 
 *     public MyExample() {
 *         Window window = new Window( WindowType.TOPLEVEL );
 *         window.setTitle( "AboutDialogExample" );
 * 	   window.addListener( new Life() );
 *         window.showAll();
 *     }
 * <strong>
 *     protected class Life implements LifeCycleListener {
 *         public void lifeCycleEvent(LifeCycleEvent event) {}
 *         public boolean lifeCycleQuery(LifeCycleEvent event) {
 *             if (event.isOfType(LifeCycleEvent.Type.DESTROY) || 
 *                 event.isOfType(LifeCycleEvent.Type.DELETE)) {
 *                 Gtk.mainQuit();
 *             }
 *             return false;
 *         }
 *     }
 * </strong>
 * }
 * 
 * </pre>
 *
 * @see LifeCycleEvent
 */
public interface LifeCycleListener {

	/**
	 * This method is for all void-returning LifeCycleEvents (ie 
         * everything not of type {@link LifeCycleEvent.Type#DESTROY} or 
         * {@link LifeCycleEvent.Type#DELETE}.
         * <p>
	 * TODO: document this properly.
	 */
	void lifeCycleEvent( LifeCycleEvent event );

	/**
	 * This method is for the delete and destroy events.
         * <p>
	 * TODO: document this properly.
	 */
	boolean lifeCycleQuery( LifeCycleEvent event );
	
}
