/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * HButtonBox is a container designed to display a collection of buttons
 * horizontally.
 * <p>
 * The main methods for manipulating this object are part of the super class
 * ButtonBox
 * 
 * @see ButtonBox
 * @see VButtonBox
 */
public class HButtonBox extends ButtonBox {

    /**
     * Construct a new HButtonBox
     */
    public HButtonBox() {
        super(gtk_hbutton_box_new());
    }

    /**
     * Construct a new HButtonBox from a handle to a native resource.
     */
    public HButtonBox(Handle handle) {
        super(handle);
    }

    /**
     * Construct a new HButtonBox from a handle to a native resource.
     */
    public static HButtonBox getHButtonBox(Handle handle) {
        if (handle == null)
            return null;

        HButtonBox obj = (HButtonBox) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new HButtonBox(handle);

        return obj;
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gtk_hbutton_box_get_type());
    }

    native static final protected int gtk_hbutton_box_get_type();

    native static final protected Handle gtk_hbutton_box_new();

    /*
     * Deprectated functions. native static final private int
     * gtk_hbutton_box_get_spacing_default(); native static final private int
     * gtk_hbutton_box_get_layout_default(); native static final private void
     * gtk_hbutton_box_set_spacing_default(int spacing); native static final
     * private void gtk_hbutton_box_set_layout_default(int layout);
     */
}
