#include "sw-collections-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_collections_iface_object_info;

struct _SwCollectionsIfaceClass {
    GTypeInterface parent_class;
    sw_collections_iface_get_list_impl get_list;
    sw_collections_iface_get_details_impl get_details;
    sw_collections_iface_create_impl create;
    sw_collections_iface_get_creatable_types_impl get_creatable_types;
};

static void sw_collections_iface_base_init (gpointer klass);

GType
sw_collections_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwCollectionsIfaceClass),
        sw_collections_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwCollectionsIface", &info, 0);
    }

  return type;
}

/**
 * sw_collections_iface_get_list_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetList on interface com.meego.libsocialweb.Collections.
 */
static void
sw_collections_iface_get_list (SwCollectionsIface *self,
    DBusGMethodInvocation *context)
{
  sw_collections_iface_get_list_impl impl = (SW_COLLECTIONS_IFACE_GET_CLASS (self)->get_list);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_collections_iface_implement_get_list:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetList D-Bus method
 *
 * Register an implementation for the GetList method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_collections_iface_implement_get_list (SwCollectionsIfaceClass *klass, sw_collections_iface_get_list_impl impl)
{
  klass->get_list = impl;
}

/**
 * sw_collections_iface_get_details_impl:
 * @self: The object implementing this interface
 * @in_collection_id: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetDetails on interface com.meego.libsocialweb.Collections.
 */
static void
sw_collections_iface_get_details (SwCollectionsIface *self,
    const gchar *in_collection_id,
    DBusGMethodInvocation *context)
{
  sw_collections_iface_get_details_impl impl = (SW_COLLECTIONS_IFACE_GET_CLASS (self)->get_details);

  if (impl != NULL)
    {
      (impl) (self,
        in_collection_id,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_collections_iface_implement_get_details:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetDetails D-Bus method
 *
 * Register an implementation for the GetDetails method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_collections_iface_implement_get_details (SwCollectionsIfaceClass *klass, sw_collections_iface_get_details_impl impl)
{
  klass->get_details = impl;
}

/**
 * sw_collections_iface_create_impl:
 * @self: The object implementing this interface
 * @in_collection_name: const gchar * (FIXME, generate documentation)
 * @in_supported_types: guint  (FIXME, generate documentation)
 * @in_collection_parent: const gchar * (FIXME, generate documentation)
 * @in_extra_parameters: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Create on interface com.meego.libsocialweb.Collections.
 */
static void
sw_collections_iface_create (SwCollectionsIface *self,
    const gchar *in_collection_name,
    guint in_supported_types,
    const gchar *in_collection_parent,
    GHashTable *in_extra_parameters,
    DBusGMethodInvocation *context)
{
  sw_collections_iface_create_impl impl = (SW_COLLECTIONS_IFACE_GET_CLASS (self)->create);

  if (impl != NULL)
    {
      (impl) (self,
        in_collection_name,
        in_supported_types,
        in_collection_parent,
        in_extra_parameters,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_collections_iface_implement_create:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Create D-Bus method
 *
 * Register an implementation for the Create method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_collections_iface_implement_create (SwCollectionsIfaceClass *klass, sw_collections_iface_create_impl impl)
{
  klass->create = impl;
}

/**
 * sw_collections_iface_get_creatable_types_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetCreatableTypes on interface com.meego.libsocialweb.Collections.
 */
static void
sw_collections_iface_get_creatable_types (SwCollectionsIface *self,
    DBusGMethodInvocation *context)
{
  sw_collections_iface_get_creatable_types_impl impl = (SW_COLLECTIONS_IFACE_GET_CLASS (self)->get_creatable_types);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_collections_iface_implement_get_creatable_types:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetCreatableTypes D-Bus method
 *
 * Register an implementation for the GetCreatableTypes method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_collections_iface_implement_get_creatable_types (SwCollectionsIfaceClass *klass, sw_collections_iface_get_creatable_types_impl impl)
{
  klass->get_creatable_types = impl;
}

static inline void
sw_collections_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_collections_iface_get_type (),
      &_sw_collections_iface_object_info);

}
static void
sw_collections_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_collections_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_collections_iface_methods[] = {
  { (GCallback) sw_collections_iface_get_list, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) sw_collections_iface_get_details, sw_marshal_VOID__STRING_POINTER, 82 },
  { (GCallback) sw_collections_iface_create, sw_marshal_VOID__STRING_UINT_STRING_BOXED_POINTER, 187 },
  { (GCallback) sw_collections_iface_get_creatable_types, g_cclosure_marshal_VOID__POINTER, 341 },
};

static const DBusGObjectInfo _sw_collections_iface_object_info = {
  0,
  _sw_collections_iface_methods,
  4,
"com.meego.libsocialweb.Collections\0GetList\0A\0collection_list\0O\0F\0N\0a(sssuia{ss})\0\0com.meego.libsocialweb.Collections\0GetDetails\0A\0collection_id\0I\0s\0collection_details\0O\0F\0N\0(sssuia{ss})\0\0com.meego.libsocialweb.Collections\0Create\0A\0collection_id\0O\0F\0N\0s\0collection_name\0I\0s\0supported_types\0I\0u\0collection_parent\0I\0s\0extra_parameters\0I\0a{ss}\0\0com.meego.libsocialweb.Collections\0GetCreatableTypes\0A\0media_types_list\0O\0F\0N\0au\0\0\0",
"\0\0",
"\0\0",
};


