'''
Defines abstract classes representing the interfaces that must be implemented
by an input device for LSR. All input devices derive from the base class in 
L{AEInput}. Devices that serve double duty as sources of input for LSR as well 
as the rest of the operating system derive from the L{SystemInput} subclass.

Concrete classes implementing the methods of L{AEInput} that ship with LSR are 
not located in this package. Rather, they are stored in the Devices folder and
referenced by the L{UIRegistrar} when they need to be loaded.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''

from Base import AEInput
from SystemInput import SystemInput
from GestureList import GestureList
from Gesture import Gesture
from Error import *
from Constants import *
import Constants

def getDefaults():
  '''
  Suggests the default L{AEOutput}s events to be monitored.
  
  @return: Names of defaults to monitor
  @rtype: list of string
  '''
  return Constants.default_types
  
def getNames():
  '''
  Gets the names of all the L{AEOutput} command types.
  
  @return: List of all known L{AEOutput} command names
  @rtype: list of string
  '''
  names = Constants.all_types
  names.sort()
  return names