/* query-editor-fields.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __QUERY_EDITOR_FIELDS__
#define __QUERY_EDITOR_FIELDS__

#include <gnome.h>
#include "query.h"

G_BEGIN_DECLS


/*
 *
 * the QueryEditorFields Widget
 *
 */

#define QUERY_EDITOR_FIELDS_TYPE          (query_editor_fields_get_type())
#define QUERY_EDITOR_FIELDS(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, query_editor_fields_get_type(), QueryEditorFields)
#define QUERY_EDITOR_FIELDS_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, query_editor_fields_get_type (), QueryEditorFieldsClass)
#define IS_QUERY_EDITOR_FIELDS(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, query_editor_fields_get_type ())


typedef struct _QueryEditorFields QueryEditorFields;
typedef struct _QueryEditorFieldsClass QueryEditorFieldsClass;
typedef struct _QueryEditorFieldsPrivate QueryEditorFieldsPrivate;
typedef enum {
	QEF_EXPR      = 1 << 0,
	QEF_COND      = 1 << 1,
	QEF_PARAM     = 1 << 2,
	QEF_NOTNAMED  = 1 << 3,
	QEF_LAST
} QueryEditorFieldsShowType;


/* struct for the object's data */
struct _QueryEditorFields
{
	GtkVBox                   object;

	QueryEditorFieldsPrivate *priv;
};

/* struct for the object's class */
struct _QueryEditorFieldsClass
{
	GtkVBoxClass parent_class;
};

/* 
 * generic widget's methods 
 */
guint      query_editor_fields_get_type  (void);
GtkWidget *query_editor_fields_new       (Query *q);

/*
 * Getting information
 */
Query     *query_editor_fields_get_query (QueryEditorFields *qef);





/*
 *
 * the QueryEditorExpr Widget
 *
 */

#define QUERY_EDITOR_EXPR_TYPE          (query_editor_expr_get_type())
#define QUERY_EDITOR_EXPR(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, query_editor_expr_get_type(), QueryEditorExpr)
#define QUERY_EDITOR_EXPR_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, query_editor_expr_get_type (), QueryEditorExprClass)
#define IS_QUERY_EDITOR_EXPR(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, query_editor_expr_get_type ())


typedef struct _QueryEditorExpr QueryEditorExpr;
typedef struct _QueryEditorExprClass QueryEditorExprClass;
typedef struct _QueryEditorExprPrivate QueryEditorExprPrivate;


/* struct for the object's data */
struct _QueryEditorExpr
{
	GtkVBox                 object;

	QueryEditorFields      *qef;
	QueryField             *orig_qf;
	QueryField             *top_qf;

	QueryEditorExprPrivate *priv;
};

/* struct for the object's class */
struct _QueryEditorExprClass
{
	GtkVBoxClass       parent_class;

	void (*status)    (QueryEditorExpr * qee, gboolean active);
};

/* 
 * generic widget's functions 
 */
guint      query_editor_expr_get_type     (void);

/* Calling with qf=NULL is for the creation of a new QueryField */
GtkWidget *query_editor_expr_new          (QueryEditorFields * qef, QueryField *qf);

/* Calling this function removes the possibility to use the widget anymore */
GSList    *query_editor_expr_fetch_fields (QueryEditorExpr * qee);

G_END_DECLS

#endif
