/*
 *
 * mtm-selector-list.c :
 *
 * Copyright (C) 2000-2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Chema Celorio
 * 	    Richard Hestilow
 *
 */

#include <config.h>
#include <gnome.h>
#include <string.h>

#include <mtm/mtm-theme.h>
#include "mtm-selector.h"
#include "mtm-control-list.h"

static void
mtm_control_list_selection_changed (GtkMenuItem *item, gpointer data)
{
	MtmSelector *selector = MTM_SELECTOR (data);
	MtmTheme *theme;

	g_return_if_fail (MTM_IS_SELECTOR (data));

	theme = gtk_object_get_data (GTK_OBJECT (item), "theme");
	mtm_selector_select_theme (selector, theme);
}
	

static void
mtm_control_list_files_changed (MtmSelector *selector, GtkOptionMenu *option)
{
	MtmTheme *theme;
	GList *themes;
	GList *list;
	GtkMenu *menu;
	GtkWidget *item;
	gchar *name;

	g_return_if_fail (MTM_IS_SELECTOR (selector));
	g_return_if_fail (GTK_IS_OPTION_MENU (option));

	themes = mtm_selector_get_themes (selector);
	list = g_list_copy (themes);

	list = g_list_sort (list, mtm_theme_compare);
	
	menu = GTK_MENU (gtk_menu_new ());
	
	for (; list != NULL; list = list->next) {
		theme = list->data;
		g_return_if_fail (MTM_IS_THEME (theme));

		name = mtm_theme_dup_name (theme);
		item = gtk_menu_item_new_with_label (name);
		gtk_object_set_data (GTK_OBJECT (item), "theme", theme);
		gtk_signal_connect (GTK_OBJECT (item), "activate",
				    mtm_control_list_selection_changed,
				    selector);
		gtk_menu_append (menu, GTK_WIDGET (item));
		g_free (name);
	}
	gtk_option_menu_set_menu (option, GTK_WIDGET (menu));

	g_list_free (list);
}

GtkWidget *
mtm_control_list_new (MtmSelector *selector)
{
	GtkWidget *option;

	option = gtk_option_menu_new ();

	gtk_signal_connect (GTK_OBJECT (selector), "files_changed",
					mtm_control_list_files_changed, option);
	gtk_object_set_data (GTK_OBJECT (option), "selector", selector);
	
	return option;
}

void
mtm_control_list_select_default (GtkWidget *clist)
{
	GList *l;
	GtkWidget *menu;
	int i = 0;
	gchar *current;
	MtmSelector *selector;
	
	g_return_if_fail (GTK_IS_OPTION_MENU (clist));
	
	current = gnome_config_get_string ("/metatheme_selector_capplet/current/filename");
	selector = gtk_object_get_data (GTK_OBJECT (clist), "selector");
	
	menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (clist));
	
	for (l = GTK_MENU_SHELL (menu)->children; l != NULL; l = l->next)
	{
		MtmTheme *theme = MTM_THEME (gtk_object_get_data (GTK_OBJECT (l->data), "theme"));
		
		if (!current)
		{
			gtk_option_menu_set_history (GTK_OPTION_MENU (clist), 0);
			mtm_selector_select_theme (selector, theme);
			break;
		}	
		
		if (!strcmp (theme->filename, current))
		{
			gtk_option_menu_set_history (GTK_OPTION_MENU (clist), i);
			mtm_selector_select_theme (selector, theme);
		}

		i++;
	}
}
