/* -*- Mode: C; tab-width: 8; c-basic-offset: 8; indent-tabs-mode: nil -*- */

#include <gtk/gtk.h>

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <libgnome/libgnome.h>

GtkWidget *plug;

static gboolean
data_in (GIOChannel *source, GIOCondition condition, gpointer data)
{
        gchar buf[2];
        guint bytes_read;

        if (condition & (G_IO_ERR | G_IO_HUP)) {
                gtk_main_quit ();
        }

        g_io_channel_read (source, buf, 2, &bytes_read);

        if (!bytes_read) {
                gtk_main_quit ();
        }

        if (gtk_rc_reparse_all ()) {
                gtk_widget_reset_rc_styles (plug);
        }

        return (TRUE);
}

static void
setup_widgets (GtkWidget *plug)
{
        GtkWidget *table;
        GtkWidget *hbox;
        GtkWidget *widget;
        GtkWidget *menu;
	GtkWidget *menubar;
	GtkWidget *scrolled_window;
	GSList *group;

        gchar *titles[2];
        gchar *row1[2];
        gchar *row2[2];
        gchar *row3[2];
        gchar *row4[2];
        gchar *row5[2];
        gchar *row6[2];

        titles [0] = _("One");
        titles [1] = _("Two");

        row1 [0]   = _("Eenie");
        row1 [1]   = _("Meenie");

        row2 [0]   = _("Mynie");
        row2 [1]   = _("Mynie");

        row3 [0]   = _("Catcha");
        row3 [1]   = _("Tiger");

        row4 [0]   = _("By Its");
        row4 [1]   = _("Toe");

        row5 [0]   = _("If It");
        row5 [1]   = _("Hollers");

        row6 [0]   = _("Let It");
        row6 [1]   = _("Go");

	/* I should strip this of raster-code */
	table = gtk_table_new (5, 3, FALSE);
	widget = gtk_label_new (_("Selected themes from above will be tested by previewing here."));
	gtk_label_set_justify (GTK_LABEL (widget), GTK_JUSTIFY_LEFT);
	gtk_table_attach (GTK_TABLE (table), widget, 0, 3, 0, 1, 0, 0, 4, 4);

	/* column one */
	widget = gtk_button_new_with_label (_("Sample Button"));
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 2, 3, GTK_EXPAND | GTK_FILL, 0, 4, 4);
	widget = gtk_check_button_new_with_label (_("Sample Check Button"));
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 3, 4, GTK_EXPAND | GTK_FILL, 0, 4, 0);
	widget = gtk_entry_new_with_max_length (50);
	gtk_entry_set_text (GTK_ENTRY (widget), _("Sample Text Entry Field"));
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 4, 5, GTK_EXPAND | GTK_FILL, 0, 4, 4);

	/* column two */

	menubar = gtk_menu_bar_new();
	gtk_table_attach (GTK_TABLE (table), menubar, 1, 2, 2, 3, 0, 0, 4, 4);

	widget = gtk_menu_item_new_with_label(_("Submenu"));
	gtk_widget_show(widget);
	gtk_menu_bar_append(GTK_MENU_BAR(menubar), widget);
	gtk_widget_show(menubar);

	menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(widget), menu);
	widget = gtk_menu_item_new_with_label(_("Item 1"));
	gtk_widget_show(widget);
	gtk_menu_append(GTK_MENU(menu), widget);
	widget = gtk_menu_item_new_with_label(_("Another item"));
	gtk_widget_show(widget);
	gtk_widget_set_usize (widget, 70, -1);
	gtk_menu_append(GTK_MENU(menu), widget);
	
	widget = gtk_radio_button_new_with_label (NULL, _("Radio Button 1"));
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON (widget));
	gtk_table_attach (GTK_TABLE (table), hbox, 1, 2, 3, 4, GTK_EXPAND | GTK_FILL, 0, 0, 0);

	widget = gtk_radio_button_new_with_label (group, _("Radio Button 2"));
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON (widget));
	gtk_table_attach (GTK_TABLE (table), hbox, 1, 2, 4, 5, GTK_EXPAND | GTK_FILL, 0, 0, 0);

	/* column three */
	scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolled_window), 
				 GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

	gtk_table_attach (GTK_TABLE (table), scrolled_window, 2, 3, 2, 5, GTK_EXPAND | GTK_FILL, 0, 4, 0);

	widget = gtk_clist_new_with_titles (2, titles);
	gtk_clist_set_column_width (GTK_CLIST(widget), 0, 45);
	gtk_clist_set_column_width (GTK_CLIST(widget), 1, 45);
	gtk_clist_append (GTK_CLIST(widget), row1);
	gtk_clist_append (GTK_CLIST(widget), row2);
	gtk_clist_append (GTK_CLIST(widget), row3);
	gtk_clist_append (GTK_CLIST(widget), row4);
	gtk_widget_set_usize (widget, 160, -1);
	gtk_container_add (GTK_CONTAINER (scrolled_window), widget);

	gtk_widget_show_all (table);

        gtk_container_add (GTK_CONTAINER (plug), table);
}

int
main (int argc, char **argv)
{
        guint32 socket_id;

        gchar **gtkrc_files;
        gchar **new_gtkrc_files;
        guint gtkrc_count;
        guint new_gtkrc_count;
        gchar *home_dir;
        guint i;

        GIOChannel *channel;

        unsetenv ("GTK_RC_FILES");

        gtkrc_files = gtk_rc_get_default_files ();

        gtkrc_count = 0;
        while (gtkrc_files[gtkrc_count]) {
                gtkrc_count++;
        }

        new_gtkrc_files = g_new (gchar *, gtkrc_count + 2);

        home_dir = g_get_home_dir ();
        new_gtkrc_count = 0;

        for (i = 0; i < gtkrc_count; i++) {
                if (strncmp (gtkrc_files[i], home_dir, strlen (home_dir))) {
                        new_gtkrc_files[new_gtkrc_count++] =
                                g_strdup (gtkrc_files[i]);
                }
        }

        new_gtkrc_files[new_gtkrc_count++] = g_strdup (argv[2]);
        new_gtkrc_files[new_gtkrc_count] = NULL;

        gtk_rc_set_default_files (new_gtkrc_files);
        g_strfreev (new_gtkrc_files);

        gtk_set_locale ();
        gtk_init (&argc, &argv);

	sleep (1);
	socket_id = strtol (argv[1], NULL, 16);

        plug = gtk_plug_new (socket_id);
        gtk_widget_show (plug);

        setup_widgets (plug);

        fcntl (atoi (argv[3]), F_SETFL, O_NONBLOCK);

        channel = g_io_channel_unix_new (atoi (argv[3]));

        g_io_add_watch (channel, G_IO_IN | G_IO_PRI | G_IO_ERR | G_IO_HUP,
                        (GIOFunc) data_in, NULL);

        gtk_main ();

        unlink (argv[2]);

	exit (0);
}
