/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

#ifndef __MLVIEW_SETTINGS_BUILDER_H__
#  define __MLVIEW_SETTINGS_BUILDER_H__

#  ifdef __cplusplus
extern "C" {
#  endif
       /*__cplusplus*/

#  include "mlview-app-context.h"
#  include "mlview-settings-management.h"

#  define MLVIEW_TYPE_SETTINGS_BUILDER (mlview_settings_builder_get_type ())
#  define MLVIEW_SETTINGS_BUILDER(widget) (GTK_CHECK_CAST ((widget), MLVIEW_TYPE_SETTINGS_BUILDER, MlViewSettingsBuilder))
#  define MLVIEW_SETTINGS_BUILDER_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), MLVIEW_TYPE_SETTTINGS_DIALOG, MlViewEditorClass))
#  define MLVIEW_IS_SETTINGS_BUILDER(widget) (GTK_CHECK_TYPE ((widget), MLVIEW_TYPE_SETTINGS_BUILDER))
#  define MLVIEW_IS_SETTINGS_BUILDER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), MLVIEW_TYPE_SETTINGS_BUILDER))

        typedef struct _MlViewSettingsBuilderPrivate
         MlViewSettingsBuilderPrivate;
        typedef struct _MlViewSettingsBuilder
         MlViewSettingsBuilder;
        typedef struct _MlViewSettingsBuilderClass
         MlViewSettingsBuilderClass;

        struct _MlViewSettingsBuilder {
                GtkObject parent_object;
                MlViewSettingsBuilderPrivate *private;
        };

        struct _MlViewSettingsBuilderClass {
                GtkDialogClass parent_class;
        };

        gint mlview_settings_builder_get_type (void);
         MlViewSettingsBuilder
                * mlview_settings_builder_new (MlViewAppContext *
                                               a_context);
        void mlview_settings_builder_build_settings
                (MlViewSettingsBuilder * a_settings_builder);
         MlViewSettingsManager
                * mlview_settings_builder_get_settings_manager
                (MlViewSettingsBuilder * a_settings_builder);
        void mlview_settings_builder_destroy (GtkObject *
                                              a_object);

#  ifdef __cpluscplus
}
#  endif
       /*__cpluscplus*/
#endif
