/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file copyright information.
 */

/**
 *@file
 *The place where MlView application is launched.
 *Here the command line is parsed, and mlview high level classes
 *are instanciated.
 *
 */

#include <stdio.h>
#include <libxml/parser.h>
#include <libxml/catalog.h>
#include "config.h"
#include "mlview-app.h"


/**
 *MlView main entry point.
 */
int
main (int argc, char **argv)
{
        GnomeProgram *mlview_program = NULL;
        GnomeApp *mlview_application = NULL;

        gchar **args = NULL;
        poptContext popt_context = NULL;
        GValue popt_context_value = { 0, };
        gboolean show_version = FALSE,
                show_info = FALSE;
        struct poptOption cmd_options_table[] = {
                {
                 "version",
                 'v',
                 POPT_ARG_NONE,
                 &show_version,
                 0,
                 N_
                 ("Prints The version of gnome-mlview you are using"),
                 NULL},
                {
                 "about",
                 'a',
                 POPT_ARG_NONE,
                 &show_info,
                 0,
                 N_
                 ("Prints some information about gnome-mlview"),
                 NULL},
                {0}
        };
        /*init underlaying facilities */
        mlview_utils_init ();

        /*init gnome */
        mlview_program = gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                                             argc, argv,
                                             GNOME_PARAM_POPT_TABLE, cmd_options_table,
                                             GNOME_PARAM_APP_DATADIR, DATADIR, 
                                             GNOME_PARAM_NONE);
        
        gnome_program_parse_args (mlview_program);

        g_value_init (&popt_context_value, G_TYPE_POINTER);
        g_object_get_property (G_OBJECT (mlview_program), GNOME_PARAM_POPT_CONTEXT,
                               &popt_context_value);
        popt_context = g_value_peek_pointer (&popt_context_value);
        g_value_unset (&popt_context_value);

        /*Then, parse the non option command arguments */
        args = (gchar **) poptGetArgs (popt_context);

        if (show_version == TRUE) {
                g_print ("%s\n", VERSION);
                poptFreeContext (popt_context);
                return 0;
        }

        if (show_info == TRUE) {
                g_print ("%s\n", _("No usefull info yest"));
                poptFreeContext (popt_context);
                return 0;
        }

        /*instanciate an mlview application */
        mlview_application = mlview_app_new (PACKAGE);

        if (args) {
                /*
                 *they are some argument on the comment line. Treat them 
                 *like files to open
                 */
                MlViewEditor *mlview_editor =
                        mlview_app_get_editor
                        (mlview_application);

                if (mlview_editor) {
                        int i;

                        for (i = 0; args[i] != NULL; i++) {
                                mlview_editor_load_xml_file
                                        (mlview_editor,
                                         (gchar *) args[i]);
                        }
                }
        }

        poptFreeContext (popt_context);

        gtk_main ();

        mlview_utils_cleanup ();

        return 0;
}
