/*Class for communicating with the rz program*/

#ifndef __SRC_RZWRAPPER_H__
#define __SRC_RZWRAPPER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "src/SerialConnection.h"

G_BEGIN_DECLS


#define MOSERIAL_TYPE_RZWRAPPER (moserial_rzwrapper_get_type ())
#define MOSERIAL_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper))
#define MOSERIAL_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))
#define MOSERIAL_IS_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_IS_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_RZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))

typedef struct _moserialRzwrapper moserialRzwrapper;
typedef struct _moserialRzwrapperClass moserialRzwrapperClass;
typedef struct _moserialRzwrapperPrivate moserialRzwrapperPrivate;

#define MOSERIAL_RZWRAPPER_TYPE_PROTOCOL (moserial_rzwrapper_protocol_get_type ())

struct _moserialRzwrapper {
	GObject parent_instance;
	moserialRzwrapperPrivate * priv;
	moserialSerialConnection* sc;
	gboolean running;
};

struct _moserialRzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_NULL
} moserialRzwrapperProtocol;


GType moserial_rzwrapper_protocol_get_type (void);
moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* p, const char* filename);
moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* p, const char* filename);
void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte);
void moserial_rzwrapper_flush (moserialRzwrapper* self);
void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o);
moserialRzwrapperProtocol moserial_rzwrapper_get_protocol (moserialRzwrapper* self);
const char* moserial_rzwrapper_get_path (moserialRzwrapper* self);
const char* moserial_rzwrapper_get_filename (moserialRzwrapper* self);
GType moserial_rzwrapper_get_type (void);


G_END_DECLS

#endif
