
#include <src/InputParser.h>
#include <glib/gi18n-lib.h>




static char* string_replace (const char* self, const char* old, const char* replacement);
static glong string_get_length (const char* self);
enum  {
	INPUT_PARSER_DUMMY_PROPERTY
};
static gchar input_parser_xtoi (gunichar c);
static gpointer input_parser_parent_class = NULL;



static char* string_replace (const char* self, const char* old, const char* replacement) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	inner_error = NULL;
	{
		char* _tmp0;
		GRegex* _tmp1;
		GRegex* regex;
		char* _tmp2;
		char* _tmp3;
		_tmp0 = NULL;
		_tmp1 = NULL;
		regex = (_tmp1 = g_regex_new (_tmp0 = g_regex_escape_string (old, -1), 0, 0, &inner_error), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
		if (inner_error != NULL) {
			if (inner_error->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			goto __finally11;
		}
		_tmp2 = g_regex_replace_literal (regex, self, (glong) (-1), 0, replacement, 0, &inner_error);
		if (inner_error != NULL) {
			(regex == NULL) ? NULL : (regex = (g_regex_unref (regex), NULL));
			if (inner_error->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			goto __finally11;
		}
		_tmp3 = NULL;
		return (_tmp3 = _tmp2, (regex == NULL) ? NULL : (regex = (g_regex_unref (regex), NULL)), _tmp3);
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_assert_not_reached ();
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally11:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
}


static glong string_get_length (const char* self) {
	g_return_val_if_fail (self != NULL, 0L);
	return g_utf8_strlen (self, -1);
}


GQuark hex_parse_error_quark (void) {
	return g_quark_from_static_string ("hex_parse_error-quark");
}


/* We need this due to some strange Vala bug stopping us using string.replace in two different classes 
   should look into it and possibly file a bug */
char* input_parser_statusReplace (const char* oldString) {
	g_return_val_if_fail (oldString != NULL, NULL);
	return string_replace (oldString, "\\r", "\\n");
}


guchar* input_parser_parseHex (const char* s, int* result_length1, GError** error) {
	GError * inner_error;
	glong len;
	guchar* _tmp0;
	gint r_size;
	gint r_length1;
	guchar* r;
	guchar* _tmp1;
	g_return_val_if_fail (s != NULL, NULL);
	inner_error = NULL;
	len = string_get_length (s);
	_tmp0 = NULL;
	r = (_tmp0 = g_new0 (guchar, (len + 1) / 2), r_length1 = (len + 1) / 2, r_size = r_length1, _tmp0);
	{
		gint x;
		x = 0;
		for (; x < ((len + 1) / 2); x++) {
			gunichar c;
			gint i;
			gint temp;
			c = 0U;
			i = 0;
			temp = 0;
			c = g_utf8_get_char (s);
			if (len > 1) {
				i = input_parser_xtoi (c) * 16;
				if (i < 0) {
					inner_error = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _ ("Invalid Input"));
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						r = (g_free (r), NULL);
						return NULL;
					}
				}
				s = g_utf8_next_char (s);
				c = g_utf8_get_char (s);
				temp = (gint) input_parser_xtoi (c);
				if (temp < 0) {
					inner_error = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _ ("Invalid Input"));
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						r = (g_free (r), NULL);
						return NULL;
					}
				}
				i = i + temp;
			} else {
				i = (gint) input_parser_xtoi (c);
				if (i < 0) {
					inner_error = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _ ("Invalid Input"));
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						r = (g_free (r), NULL);
						return NULL;
					}
				}
			}
			s = g_utf8_next_char (s);
			r[x] = (guchar) i;
		}
	}
	_tmp1 = NULL;
	return (_tmp1 = r, *result_length1 = r_length1, _tmp1);
}


/* There should be bindings to something in vala that can do this but there dosen't seem to be yet 2009-01-31*/
static gchar input_parser_xtoi (gunichar c) {
	gchar i;
	i = (gchar) (-1);
	switch (c) {
		case '0':
		{
			i = (gchar) 0;
			break;
		}
		case '1':
		{
			i = (gchar) 1;
			break;
		}
		case '2':
		{
			i = (gchar) 2;
			break;
		}
		case '3':
		{
			i = (gchar) 3;
			break;
		}
		case '4':
		{
			i = (gchar) 4;
			break;
		}
		case '5':
		{
			i = (gchar) 5;
			break;
		}
		case '6':
		{
			i = (gchar) 6;
			break;
		}
		case '7':
		{
			i = (gchar) 7;
			break;
		}
		case '8':
		{
			i = (gchar) 8;
			break;
		}
		case '9':
		{
			i = (gchar) 9;
			break;
		}
		case 'a':
		{
			i = (gchar) 10;
			break;
		}
		case 'b':
		{
			i = (gchar) 11;
			break;
		}
		case 'c':
		{
			i = (gchar) 12;
			break;
		}
		case 'd':
		{
			i = (gchar) 13;
			break;
		}
		case 'e':
		{
			i = (gchar) 14;
			break;
		}
		case 'f':
		{
			i = (gchar) 15;
			break;
		}
		case 'A':
		{
			i = (gchar) 10;
			break;
		}
		case 'B':
		{
			i = (gchar) 11;
			break;
		}
		case 'C':
		{
			i = (gchar) 12;
			break;
		}
		case 'D':
		{
			i = (gchar) 13;
			break;
		}
		case 'E':
		{
			i = (gchar) 14;
			break;
		}
		case 'F':
		{
			i = (gchar) 15;
			break;
		}
	}
	return i;
}


InputParser* input_parser_construct (GType object_type) {
	InputParser * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


InputParser* input_parser_new (void) {
	return input_parser_construct (TYPE_INPUT_PARSER);
}


static void input_parser_class_init (InputParserClass * klass) {
	input_parser_parent_class = g_type_class_peek_parent (klass);
}


static void input_parser_instance_init (InputParser * self) {
}


GType input_parser_get_type (void) {
	static GType input_parser_type_id = 0;
	if (input_parser_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (InputParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputParser), 0, (GInstanceInitFunc) input_parser_instance_init, NULL };
		input_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "InputParser", &g_define_type_info, 0);
	}
	return input_parser_type_id;
}




