
#include <src/Preferences.h>
#include <gconf/gconf-client.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include "src/MoUtils.h"




struct _PreferencesPrivate {
	gboolean _useSystemMonospaceFont;
	char* _font;
	char* _fontColor;
	char* _backgroundColor;
	char* _highlightColor;
	gboolean _recordLaunch;
	gboolean _enableTimeout;
	gint _timeout;
};

#define PREFERENCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES, PreferencesPrivate))
enum  {
	PREFERENCES_DUMMY_PROPERTY,
	PREFERENCES_USE_SYSTEM_MONOSPACE_FONT,
	PREFERENCES_FONT,
	PREFERENCES_FONT_COLOR,
	PREFERENCES_BACKGROUND_COLOR,
	PREFERENCES_HIGHLIGHT_COLOR,
	PREFERENCES_RECORD_LAUNCH,
	PREFERENCES_ENABLE_TIMEOUT,
	PREFERENCES_TIMEOUT
};
gboolean preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT = TRUE;
char* preferences_DEFAULT_FONT = NULL;
char* preferences_DEFAULT_FONT_COLOR = NULL;
char* preferences_DEFAULT_BACKGROUND_COLOR = NULL;
char* preferences_DEFAULT_HIGHLIGHT_COLOR = NULL;
gboolean preferences_DEFAULT_RECORD_LAUNCH = TRUE;
static void preferences_set_useSystemMonospaceFont (Preferences* self, gboolean value);
static void preferences_set_font (Preferences* self, const char* value);
static void preferences_set_fontColor (Preferences* self, const char* value);
static void preferences_set_backgroundColor (Preferences* self, const char* value);
static void preferences_set_highlightColor (Preferences* self, const char* value);
static void preferences_set_recordLaunch (Preferences* self, gboolean value);
static void preferences_set_enableTimeout (Preferences* self, gboolean value);
static void preferences_set_timeout (Preferences* self, gint value);
static GObject * preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer preferences_parent_class = NULL;
static void preferences_finalize (GObject* obj);



Preferences* preferences_construct (GType object_type, gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout) {
	GParameter * __params;
	GParameter * __params_it;
	Preferences * self;
	__params = g_new0 (GParameter, 8);
	__params_it = __params;
	__params_it->name = "useSystemMonospaceFont";
	g_value_init (&__params_it->value, G_TYPE_BOOLEAN);
	g_value_set_boolean (&__params_it->value, useSystemMonospaceFont);
	__params_it++;
	__params_it->name = "font";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, font);
	__params_it++;
	__params_it->name = "recordLaunch";
	g_value_init (&__params_it->value, G_TYPE_BOOLEAN);
	g_value_set_boolean (&__params_it->value, recordLaunch);
	__params_it++;
	__params_it->name = "fontColor";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, fontColor);
	__params_it++;
	__params_it->name = "backgroundColor";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, backgroundColor);
	__params_it++;
	__params_it->name = "highlightColor";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, highlightColor);
	__params_it++;
	__params_it->name = "enableTimeout";
	g_value_init (&__params_it->value, G_TYPE_BOOLEAN);
	g_value_set_boolean (&__params_it->value, enableTimeout);
	__params_it++;
	__params_it->name = "timeout";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, timeout);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


Preferences* preferences_new (gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout) {
	return preferences_construct (TYPE_PREFERENCES, useSystemMonospaceFont, font, fontColor, backgroundColor, highlightColor, recordLaunch, enableTimeout, timeout);
}


char* preferences_getSystemDefaultMonospaceFont (void) {
	GError * inner_error;
	char* value;
	GConfClient* _tmp0;
	GConfClient* gc;
	char* _tmp5;
	inner_error = NULL;
	value = g_strdup ("");
	_tmp0 = NULL;
	gc = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	{
		const char* _tmp1;
		char* _tmp3;
		const char* _tmp2;
		_tmp1 = gconf_client_get_string (gc, "/desktop/gnome/interface/monospace_font_name", &inner_error);
		if (inner_error != NULL) {
			goto __catch21_g_error;
			goto __finally21;
		}
		_tmp3 = NULL;
		_tmp2 = NULL;
		value = (_tmp3 = (_tmp2 = _tmp1, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), value = (g_free (value), NULL), _tmp3);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp4;
			g_warning (_ ("Unable to retrieve gconf key: %s"), e->message);
			_tmp4 = NULL;
			value = (_tmp4 = g_strdup ("Monospace 10"), value = (g_free (value), NULL), _tmp4);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally21:
	if (inner_error != NULL) {
		value = (g_free (value), NULL);
		(gc == NULL) ? NULL : (gc = (g_object_unref (gc), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
	_tmp5 = NULL;
	return (_tmp5 = value, (gc == NULL) ? NULL : (gc = (g_object_unref (gc), NULL)), _tmp5);
}


GdkColor preferences_getGdkColor (const char* color) {
	GdkColor c = {0};
	gdk_color_parse (color, &c);
	return c;
}


void preferences_toString (Preferences* self) {
	g_return_if_fail (self != NULL);
	fprintf (stdout, "useSystemMonospaceFont: ");
	if (self->priv->_useSystemMonospaceFont) {
		fprintf (stdout, "true\n");
	} else {
		fprintf (stdout, "false\n");
	}
	fprintf (stdout, "font: %s\n", self->priv->_font);
	fprintf (stdout, "fontColor: %s\n", self->priv->_fontColor);
	fprintf (stdout, "backgroundColor: %s\n", self->priv->_backgroundColor);
	fprintf (stdout, "highlightColor: %s\n", self->priv->_highlightColor);
	fprintf (stdout, "recordLaunch: ");
	if (self->priv->_recordLaunch) {
		fprintf (stdout, "true\n");
	} else {
		fprintf (stdout, "false\n");
	}
}


void preferences_saveToProfile (Preferences* self, Profile* profile) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	g_key_file_set_boolean (profile->keyFile, "preferences", "use_system_monospace_font", self->priv->_useSystemMonospaceFont);
	g_key_file_set_string (profile->keyFile, "preferences", "font", self->priv->_font);
	g_key_file_set_string (profile->keyFile, "preferences", "font_color", self->priv->_fontColor);
	g_key_file_set_string (profile->keyFile, "preferences", "background_color", self->priv->_backgroundColor);
	g_key_file_set_string (profile->keyFile, "preferences", "highlight_color", self->priv->_highlightColor);
	g_key_file_set_boolean (profile->keyFile, "preferences", "record_launch", self->priv->_recordLaunch);
	g_key_file_set_boolean (profile->keyFile, "preferences", "enable_timeout", self->priv->_enableTimeout);
	g_key_file_set_integer (profile->keyFile, "preferences", "timeout", self->priv->_timeout);
}


Preferences* preferences_loadFromProfile (Profile* profile) {
	gboolean useSystemMonospaceFont;
	char* font;
	char* fontColor;
	char* backgroundColor;
	char* highlightColor;
	gboolean recordLaunch;
	gboolean enableTimeout;
	gint timeout;
	char* _tmp0;
	char* _tmp1;
	char* _tmp2;
	char* _tmp3;
	Preferences* _tmp4;
	g_return_val_if_fail (profile != NULL, NULL);
	useSystemMonospaceFont = FALSE;
	font = NULL;
	fontColor = NULL;
	backgroundColor = NULL;
	highlightColor = NULL;
	recordLaunch = FALSE;
	enableTimeout = FALSE;
	timeout = 0;
	useSystemMonospaceFont = mo_utils_getKeyBoolean (profile, "preferences", "use_system_monospace_font", preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT);
	_tmp0 = NULL;
	font = (_tmp0 = mo_utils_getKeyString (profile, "preferences", "font"), font = (g_free (font), NULL), _tmp0);
	_tmp1 = NULL;
	fontColor = (_tmp1 = mo_utils_getKeyString (profile, "preferences", "font_color"), fontColor = (g_free (fontColor), NULL), _tmp1);
	_tmp2 = NULL;
	backgroundColor = (_tmp2 = mo_utils_getKeyString (profile, "preferences", "background_color"), backgroundColor = (g_free (backgroundColor), NULL), _tmp2);
	_tmp3 = NULL;
	highlightColor = (_tmp3 = mo_utils_getKeyString (profile, "preferences", "highlight_color"), highlightColor = (g_free (highlightColor), NULL), _tmp3);
	recordLaunch = mo_utils_getKeyBoolean (profile, "preferences", "record_launch", TRUE);
	enableTimeout = mo_utils_getKeyBoolean (profile, "preferences", "enable_timeout", FALSE);
	timeout = mo_utils_getKeyInteger (profile, "preferences", "timeout", 30);
	_tmp4 = NULL;
	return (_tmp4 = preferences_new (useSystemMonospaceFont, font, fontColor, backgroundColor, highlightColor, recordLaunch, enableTimeout, timeout), font = (g_free (font), NULL), fontColor = (g_free (fontColor), NULL), backgroundColor = (g_free (backgroundColor), NULL), highlightColor = (g_free (highlightColor), NULL), _tmp4);
}


gboolean preferences_get_useSystemMonospaceFont (Preferences* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_useSystemMonospaceFont;
}


static void preferences_set_useSystemMonospaceFont (Preferences* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_useSystemMonospaceFont = value;
	g_object_notify ((GObject *) self, "useSystemMonospaceFont");
}


const char* preferences_get_font (Preferences* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_font;
}


static void preferences_set_font (Preferences* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_font = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_font = (g_free (self->priv->_font), NULL), _tmp2);
	g_object_notify ((GObject *) self, "font");
}


const char* preferences_get_fontColor (Preferences* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_fontColor;
}


static void preferences_set_fontColor (Preferences* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_fontColor = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_fontColor = (g_free (self->priv->_fontColor), NULL), _tmp2);
	g_object_notify ((GObject *) self, "fontColor");
}


const char* preferences_get_backgroundColor (Preferences* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_backgroundColor;
}


static void preferences_set_backgroundColor (Preferences* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_backgroundColor = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_backgroundColor = (g_free (self->priv->_backgroundColor), NULL), _tmp2);
	g_object_notify ((GObject *) self, "backgroundColor");
}


const char* preferences_get_highlightColor (Preferences* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_highlightColor;
}


static void preferences_set_highlightColor (Preferences* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_highlightColor = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_highlightColor = (g_free (self->priv->_highlightColor), NULL), _tmp2);
	g_object_notify ((GObject *) self, "highlightColor");
}


gboolean preferences_get_recordLaunch (Preferences* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_recordLaunch;
}


static void preferences_set_recordLaunch (Preferences* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_recordLaunch = value;
	g_object_notify ((GObject *) self, "recordLaunch");
}


gboolean preferences_get_enableTimeout (Preferences* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_enableTimeout;
}


static void preferences_set_enableTimeout (Preferences* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_enableTimeout = value;
	g_object_notify ((GObject *) self, "enableTimeout");
}


gint preferences_get_timeout (Preferences* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_timeout;
}


static void preferences_set_timeout (Preferences* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_timeout = value;
	g_object_notify ((GObject *) self, "timeout");
}


static GObject * preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	PreferencesClass * klass;
	GObjectClass * parent_class;
	Preferences * self;
	klass = PREFERENCES_CLASS (g_type_class_peek (TYPE_PREFERENCES));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = PREFERENCES (obj);
	{
		if (self->priv->_font == NULL) {
			preferences_set_font (self, preferences_DEFAULT_FONT);
		}
		if (self->priv->_fontColor == NULL) {
			preferences_set_fontColor (self, preferences_DEFAULT_FONT_COLOR);
		}
		if (self->priv->_backgroundColor == NULL) {
			preferences_set_backgroundColor (self, preferences_DEFAULT_BACKGROUND_COLOR);
		}
		if (self->priv->_highlightColor == NULL) {
			preferences_set_highlightColor (self, preferences_DEFAULT_HIGHLIGHT_COLOR);
		}
	}
	return obj;
}


static void preferences_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Preferences * self;
	gpointer boxed;
	self = PREFERENCES (object);
	switch (property_id) {
		case PREFERENCES_USE_SYSTEM_MONOSPACE_FONT:
		g_value_set_boolean (value, preferences_get_useSystemMonospaceFont (self));
		break;
		case PREFERENCES_FONT:
		g_value_set_string (value, preferences_get_font (self));
		break;
		case PREFERENCES_FONT_COLOR:
		g_value_set_string (value, preferences_get_fontColor (self));
		break;
		case PREFERENCES_BACKGROUND_COLOR:
		g_value_set_string (value, preferences_get_backgroundColor (self));
		break;
		case PREFERENCES_HIGHLIGHT_COLOR:
		g_value_set_string (value, preferences_get_highlightColor (self));
		break;
		case PREFERENCES_RECORD_LAUNCH:
		g_value_set_boolean (value, preferences_get_recordLaunch (self));
		break;
		case PREFERENCES_ENABLE_TIMEOUT:
		g_value_set_boolean (value, preferences_get_enableTimeout (self));
		break;
		case PREFERENCES_TIMEOUT:
		g_value_set_int (value, preferences_get_timeout (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void preferences_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Preferences * self;
	self = PREFERENCES (object);
	switch (property_id) {
		case PREFERENCES_USE_SYSTEM_MONOSPACE_FONT:
		preferences_set_useSystemMonospaceFont (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_FONT:
		preferences_set_font (self, g_value_get_string (value));
		break;
		case PREFERENCES_FONT_COLOR:
		preferences_set_fontColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_BACKGROUND_COLOR:
		preferences_set_backgroundColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_HIGHLIGHT_COLOR:
		preferences_set_highlightColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_RECORD_LAUNCH:
		preferences_set_recordLaunch (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_ENABLE_TIMEOUT:
		preferences_set_enableTimeout (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_TIMEOUT:
		preferences_set_timeout (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void preferences_class_init (PreferencesClass * klass) {
	preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesPrivate));
	G_OBJECT_CLASS (klass)->get_property = preferences_get_property;
	G_OBJECT_CLASS (klass)->set_property = preferences_set_property;
	G_OBJECT_CLASS (klass)->constructor = preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = preferences_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_USE_SYSTEM_MONOSPACE_FONT, g_param_spec_boolean ("useSystemMonospaceFont", "useSystemMonospaceFont", "useSystemMonospaceFont", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_FONT, g_param_spec_string ("font", "font", "font", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_FONT_COLOR, g_param_spec_string ("fontColor", "fontColor", "fontColor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_BACKGROUND_COLOR, g_param_spec_string ("backgroundColor", "backgroundColor", "backgroundColor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_HIGHLIGHT_COLOR, g_param_spec_string ("highlightColor", "highlightColor", "highlightColor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_RECORD_LAUNCH, g_param_spec_boolean ("recordLaunch", "recordLaunch", "recordLaunch", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_ENABLE_TIMEOUT, g_param_spec_boolean ("enableTimeout", "enableTimeout", "enableTimeout", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_TIMEOUT, g_param_spec_int ("timeout", "timeout", "timeout", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	preferences_DEFAULT_FONT = g_strdup ("Monospace 10");
	preferences_DEFAULT_FONT_COLOR = g_strdup ("black");
	preferences_DEFAULT_BACKGROUND_COLOR = g_strdup ("white");
	preferences_DEFAULT_HIGHLIGHT_COLOR = g_strdup ("#2020ff");
}


static void preferences_instance_init (Preferences * self) {
	self->priv = PREFERENCES_GET_PRIVATE (self);
}


static void preferences_finalize (GObject* obj) {
	Preferences * self;
	self = PREFERENCES (obj);
	self->priv->_font = (g_free (self->priv->_font), NULL);
	self->priv->_fontColor = (g_free (self->priv->_fontColor), NULL);
	self->priv->_backgroundColor = (g_free (self->priv->_backgroundColor), NULL);
	self->priv->_highlightColor = (g_free (self->priv->_highlightColor), NULL);
	G_OBJECT_CLASS (preferences_parent_class)->finalize (obj);
}


GType preferences_get_type (void) {
	static GType preferences_type_id = 0;
	if (preferences_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Preferences), 0, (GInstanceInitFunc) preferences_instance_init, NULL };
		preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "Preferences", &g_define_type_info, 0);
	}
	return preferences_type_id;
}




