
#ifndef __SRC_MOUTILS_H__
#define __SRC_MOUTILS_H__

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "src/Profile.h"

G_BEGIN_DECLS


#define TYPE_MO_UTILS (mo_utils_get_type ())
#define MO_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MO_UTILS, MoUtils))
#define MO_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MO_UTILS, MoUtilsClass))
#define IS_MO_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MO_UTILS))
#define IS_MO_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MO_UTILS))
#define MO_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MO_UTILS, MoUtilsClass))

typedef struct _MoUtils MoUtils;
typedef struct _MoUtilsClass MoUtilsClass;
typedef struct _MoUtilsPrivate MoUtilsPrivate;

struct _MoUtils {
	GObject parent_instance;
	MoUtilsPrivate * priv;
};

struct _MoUtilsClass {
	GObjectClass parent_class;
};


GFile* mo_utils_newFile (const char* path);
gboolean mo_utils_fileExists (const char* path);
gint64 mo_utils_fileSize (const char* path);
char* mo_utils_getParentFolder (const char* path);
char* mo_utils_getKeyString (Profile* profile, const char* group, const char* key);
gint mo_utils_getKeyInteger (Profile* profile, const char* group, const char* key, gint default_val);
gboolean mo_utils_getKeyBoolean (Profile* profile, const char* group, const char* key, gboolean default_val);
char* mo_utils_getLastMessage (const char* messages);
MoUtils* mo_utils_construct (GType object_type);
MoUtils* mo_utils_new (void);
GType mo_utils_get_type (void);


G_END_DECLS

#endif
