
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <glib/gi18n-lib.h>


#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
typedef struct _moserialSerialConnectionPrivate moserialSerialConnectionPrivate;

#define MOSERIAL_SERIAL_CONNECTION_TYPE_LINE_END (moserial_serial_connection_line_end_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

struct _moserialSerialConnection {
	GObject parent_instance;
	moserialSerialConnectionPrivate * priv;
	gulong tx;
	gulong rx;
	gulong nonprintable;
	gboolean forced_hex_view;
	gboolean lastRxCharWasCR;
	char* echoReference;
	char* echoCompare;
};

struct _moserialSerialConnectionClass {
	GObjectClass parent_class;
};

struct _moserialSerialConnectionPrivate {
	gboolean connected;
	struct termios newtio;
	struct termios restoretio;
	gint m_fd;
	GIOChannel* IOChannelFd;
	gint flags;
	guint* sourceId;
	gboolean localEcho;
};

typedef enum  {
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CR,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_LF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE
} moserialSerialConnectionLineEnd;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_serial_connection_parent_class = NULL;

GType moserial_serial_connection_get_type (void);
#define MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionPrivate))
enum  {
	MOSERIAL_SERIAL_CONNECTION_DUMMY_PROPERTY
};
GType moserial_serial_connection_line_end_get_type (void);
GType settings_access_mode_get_type (void);
GType settings_get_type (void);
SettingsAccessMode settings_get_accessMode (Settings* self);
const char* settings_get_device (Settings* self);
static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings);
static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition);
static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static guint* _uint_dup (guint* self);
gboolean settings_get_localEcho (Settings* self);
gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size);
char* moserial_serial_connection_getLineEnd (moserialSerialConnection* self, gint e);
void moserial_serial_connection_doDisconnect (moserialSerialConnection* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
GType settings_parity_get_type (void);
SettingsParity settings_get_parity (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_handshake_get_type (void);
SettingsHandshake settings_get_handshake (Settings* self);
char* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self);
moserialSerialConnection* moserial_serial_connection_new (void);
moserialSerialConnection* moserial_serial_connection_construct (GType object_type);
static void moserial_serial_connection_finalize (GObject* obj);


static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


GType moserial_serial_connection_line_end_get_type (void) {
	static GType moserial_serial_connection_line_end_type_id = 0;
	if (G_UNLIKELY (moserial_serial_connection_line_end_type_id == 0)) {
		static const GEnumValue values[] = {{MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF", "crlf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_CR, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CR", "cr"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_LF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_LF", "lf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB, "MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB", "tab"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC, "MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC", "esc"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE, "MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE", "none"}, {0, NULL, NULL}};
		moserial_serial_connection_line_end_type_id = g_enum_register_static ("moserialSerialConnectionLineEnd", values);
	}
	return moserial_serial_connection_line_end_type_id;
}


static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	return moserial_serial_connection_readBytes (self, source, condition);
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings) {
	gboolean result;
	gint n;
	GIOChannel* _tmp0_;
	guint* _tmp3_;
	guint* _tmp2_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	if (settings_get_accessMode (settings) == SETTINGS_ACCESS_MODE_READWRITE) {
		self->priv->flags = O_RDWR;
	} else {
		if (settings_get_accessMode (settings) == SETTINGS_ACCESS_MODE_READONLY) {
			self->priv->flags = O_RDONLY;
		} else {
			self->priv->flags = O_WRONLY;
		}
	}
	self->priv->m_fd = open (settings_get_device (settings), (self->priv->flags | O_NDELAY) | O_NONBLOCK, 0);
	if (self->priv->m_fd < 0) {
		self->priv->m_fd = -1;
		/* TODO display error in gui*/
		result = FALSE;
		return result;
	}
	tcflush (self->priv->m_fd, TCIOFLUSH);
	n = fcntl (self->priv->m_fd, F_GETFL);
	fcntl (self->priv->m_fd, F_SETFL, (gulong) (n & (~O_NDELAY)));
	tcgetattr (self->priv->m_fd, &self->priv->restoretio);
	moserial_serial_connection_applySettings (self, settings);
	tcsetattr (self->priv->m_fd, TCSANOW, &self->priv->newtio);
	self->priv->connected = TRUE;
	_tmp0_ = NULL;
	self->priv->IOChannelFd = (_tmp0_ = g_io_channel_unix_new (self->priv->m_fd), (self->priv->IOChannelFd == NULL) ? NULL : (self->priv->IOChannelFd = (g_io_channel_unref (self->priv->IOChannelFd), NULL)), _tmp0_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	self->priv->sourceId = (_tmp3_ = (_tmp2_ = (_tmp1_ = g_io_add_watch (self->priv->IOChannelFd, G_IO_IN, _moserial_serial_connection_readBytes_gio_func, self), &_tmp1_), (_tmp2_ == NULL) ? NULL : _uint_dup (_tmp2_)), (self->priv->sourceId == NULL) ? NULL : (self->priv->sourceId = (g_free (self->priv->sourceId), NULL)), _tmp3_);
	self->priv->localEcho = settings_get_localEcho (settings);
	result = TRUE;
	return result;
}


void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte) {
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		guchar* _tmp0_;
		gint b_size;
		gint b_length1;
		guchar* b;
		gsize x;
		_tmp0_ = NULL;
		b = (_tmp0_ = g_new0 (guchar, 1), b_length1 = 1, b_size = b_length1, _tmp0_);
		b[0] = byte;
		x = (gsize) write (self->priv->m_fd, b, (gsize) 1);
		/*POSIX.Termios.drain(m_fd);*/
		self->tx = self->tx + x;
		b = (g_free (b), NULL);
	}
}


void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size) {
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		gsize x;
		x = (gsize) write (self->priv->m_fd, bytes, size);
		tcdrain (self->priv->m_fd);
		self->tx = self->tx + x;
	}
}


char* moserial_serial_connection_getLineEnd (moserialSerialConnection* self, gint e) {
	char* result;
	char* s;
	g_return_val_if_fail (self != NULL, NULL);
	s = NULL;
	switch (e) {
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_CR:
		{
			{
				char* _tmp0_;
				_tmp0_ = NULL;
				s = (_tmp0_ = g_strdup ("\r"), s = (g_free (s), NULL), _tmp0_);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_LF:
		{
			{
				char* _tmp1_;
				_tmp1_ = NULL;
				s = (_tmp1_ = g_strdup ("\n"), s = (g_free (s), NULL), _tmp1_);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF:
		{
			{
				char* _tmp2_;
				_tmp2_ = NULL;
				s = (_tmp2_ = g_strdup ("\r\n"), s = (g_free (s), NULL), _tmp2_);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB:
		{
			{
				char* _tmp3_;
				_tmp3_ = NULL;
				s = (_tmp3_ = g_strdup ("\t"), s = (g_free (s), NULL), _tmp3_);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC:
		{
			{
				char* _tmp4_;
				_tmp4_ = NULL;
				s = (_tmp4_ = g_strdup ("\x1b"), s = (g_free (s), NULL), _tmp4_);
				break;
			}
		}
		default:
		{
			{
				char* _tmp5_;
				_tmp5_ = NULL;
				s = (_tmp5_ = g_strdup (""), s = (g_free (s), NULL), _tmp5_);
				break;
			}
		}
	}
	result = s;
	return result;
}


void moserial_serial_connection_doDisconnect (moserialSerialConnection* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->connected) {
		guint* _tmp0_;
		GIOChannel* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		g_source_remove (*self->priv->sourceId);
		_tmp0_ = NULL;
		self->priv->sourceId = (_tmp0_ = NULL, (self->priv->sourceId == NULL) ? NULL : (self->priv->sourceId = (g_free (self->priv->sourceId), NULL)), _tmp0_);
		{
			g_io_channel_shutdown (self->priv->IOChannelFd, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch6_g_io_channel_error;
				}
				goto __finally6;
			}
		}
		goto __finally6;
		__catch6_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("SerialConnection.vala:116: %s", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally6:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = NULL;
		self->priv->IOChannelFd = (_tmp1_ = NULL, (self->priv->IOChannelFd == NULL) ? NULL : (self->priv->IOChannelFd = (g_io_channel_unref (self->priv->IOChannelFd), NULL)), _tmp1_);
		self->priv->connected = FALSE;
		self->forced_hex_view = FALSE;
		self->lastRxCharWasCR = FALSE;
		self->tx = self->rx = self->nonprintable = (gulong) 0;
		_tmp2_ = NULL;
		self->echoReference = (_tmp2_ = g_strdup (""), self->echoReference = (g_free (self->echoReference), NULL), _tmp2_);
		_tmp3_ = NULL;
		self->echoCompare = (_tmp3_ = g_strdup (""), self->echoCompare = (g_free (self->echoCompare), NULL), _tmp3_);
		tcsetattr (self->priv->m_fd, TCSANOW, &self->priv->newtio);
		close (self->priv->m_fd);
	}
}


static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition) {
	gboolean result;
	guchar* _tmp0_;
	gint m_buf_size;
	gint m_buf_length1;
	guchar* m_buf;
	gint bytesRead;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = NULL;
	m_buf = (_tmp0_ = g_new0 (guchar, 1000), m_buf_length1 = 1000, m_buf_size = m_buf_length1, _tmp0_);
	bytesRead = (gint) read (self->priv->m_fd, m_buf, (gsize) 1000);
	self->rx = self->rx + ((gulong) bytesRead);
	if (bytesRead < 0) {
		result = FALSE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	}
	g_signal_emit_by_name (self, "new-data", m_buf, m_buf_length1, bytesRead);
	if (self->priv->localEcho) {
		moserial_serial_connection_sendBytes (self, (gchar*) m_buf, m_buf_length1, (gsize) bytesRead);
	}
	result = self->priv->connected;
	m_buf = (g_free (m_buf), NULL);
	return result;
}


static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings) {
	guint baudRate;
	gint dataBits;
	gboolean _tmp0_;
	gboolean _tmp2_;
	gint mcs;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	/*BaudRate*/
	baudRate = (guint) 0;
	switch (settings_get_baudRate (settings)) {
		case 300:
		{
			baudRate = B300;
			break;
		}
		case 600:
		{
			baudRate = B600;
			break;
		}
		case 1200:
		{
			baudRate = B1200;
			break;
		}
		case 2400:
		{
			baudRate = B2400;
			break;
		}
		case 4800:
		{
			baudRate = B4800;
			break;
		}
		case 9600:
		{
			baudRate = B9600;
			break;
		}
		case 19200:
		{
			baudRate = B19200;
			break;
		}
		case 38400:
		{
			baudRate = B38400;
			break;
		}
		case 57600:
		{
			baudRate = B57600;
			break;
		}
		case 115200:
		{
			baudRate = B115200;
			break;
		}
		case 230400:
		{
			baudRate = B230400;
			break;
		}
		case 460800:
		{
			baudRate = B460800;
			break;
		}
		case 576000:
		{
			baudRate = B576000;
			break;
		}
		case 921600:
		{
			baudRate = B921600;
			break;
		}
		case 1000000:
		{
			baudRate = B1000000;
			break;
		}
		case 2000000:
		{
			baudRate = B2000000;
			break;
		}
	}
	cfsetospeed (&self->priv->newtio, baudRate);
	cfsetispeed (&self->priv->newtio, baudRate);
	/*DataBits*/
	dataBits = 0;
	dataBits = settings_get_dataBits (settings);
	_tmp0_ = FALSE;
	if (settings_get_dataBits (settings) == 7) {
		gboolean _tmp1_;
		_tmp1_ = FALSE;
		if (settings_get_parity (settings) == SETTINGS_PARITY_MARK) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = settings_get_parity (settings) == SETTINGS_PARITY_SPACE;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	/* We generate mark and space parity*/
	if (_tmp0_) {
		dataBits = 8;
	}
	switch (dataBits) {
		case 5:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS5;
			break;
		}
		case 6:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS6;
			break;
		}
		case 7:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS7;
			break;
		}
		default:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS8;
			break;
		}
	}
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (CLOCAL | CREAD);
	/*Parity*/
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~(PARENB | PARODD));
	if (settings_get_parity (settings) == SETTINGS_PARITY_EVEN) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | PARENB;
	} else {
		if (settings_get_parity (settings) == SETTINGS_PARITY_ODD) {
			self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (PARENB | PARODD);
		}
	}
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CRTSCTS);
	/*Stop Bits*/
	if (settings_get_stopBits (settings) == 2) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | CSTOPB;
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CSTOPB);
	}
	/*Input Settings*/
	self->priv->newtio.c_iflag = IGNBRK;
	_tmp2_ = FALSE;
	if (settings_get_handshake (settings) == SETTINGS_HANDSHAKE_SOFTWARE) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = settings_get_handshake (settings) == SETTINGS_HANDSHAKE_BOTH;
	}
	/*Handshake*/
	if (_tmp2_) {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag | (IXON | IXOFF);
	} else {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag & (~((IXON | IXOFF) | IXANY));
	}
	self->priv->newtio.c_lflag = (guint) 0;
	self->priv->newtio.c_oflag = (guint) 0;
	self->priv->newtio.c_cc[VTIME] = (guchar) 1;
	self->priv->newtio.c_cc[VMIN] = (guchar) 1;
	/*Some other port settings from minicom.
	newtio.c_iflag &= ~(IGNBRK | IGNCR | INLCR | ICRNL | IUCLC | IXANY | IXON | IXOFF | INPCK | ISTRIP);
	newtio.c_iflag &= ~(POSIX.InputMode.IGNBRK | POSIX.InputMode.IGNCR | POSIX.InputMode.INLCR | POSIX.InputMode.ICRNL | POSIX.InputMode.IXANY | POSIX.InputMode.IXON | POSIX.InputMode.IXOFF | POSIX.InputMode.INPCK | POSIX.InputMode.ISTRIP);
	newtio.c_iflag |= (POSIX.InputMode.BRKINT | POSIX.InputMode.IGNPAR);
	newtio.c_oflag &= ~POSIX.OutputMode.OPOST;
	newtio.c_lflag &= ~(XCASE|ECHONL|NOFLSH);*/
	self->priv->newtio.c_lflag = self->priv->newtio.c_lflag & (~(ECHONL | NOFLSH));
	/*newtio.c_lflag &= ~(POSIX.LocalMode.ICANON | POSIX.LocalMode.ISIG | POSIX.LocalMode.ECHO);
	newtio.c_cflag |= CREAD;
	newtio.c_cc[VTIME] = 5;*/
	mcs = 0;
	ioctl (self->priv->m_fd, TIOCMGET, &mcs);
	mcs = mcs | TIOCM_RTS;
	ioctl (self->priv->m_fd, TIOCMSET, &mcs);
	_tmp3_ = FALSE;
	if (settings_get_handshake (settings) == SETTINGS_HANDSHAKE_HARDWARE) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = settings_get_handshake (settings) == SETTINGS_HANDSHAKE_BOTH;
	}
	if (_tmp3_) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | CRTSCTS;
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CRTSCTS);
	}
}


char* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self) {
	char* result;
	char* r;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	if (self->nonprintable > 0) {
		char* _tmp0_;
		_tmp0_ = NULL;
		r = (_tmp0_ = g_strdup_printf (_ ("TX: %lu, RX: %lu (%lu unprintable)"), self->tx, self->rx, self->nonprintable), r = (g_free (r), NULL), _tmp0_);
	} else {
		char* _tmp1_;
		_tmp1_ = NULL;
		r = (_tmp1_ = g_strdup_printf (_ ("TX: %lu, RX: %lu"), self->tx, self->rx), r = (g_free (r), NULL), _tmp1_);
	}
	result = r;
	return result;
}


moserialSerialConnection* moserial_serial_connection_construct (GType object_type) {
	moserialSerialConnection * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


moserialSerialConnection* moserial_serial_connection_new (void) {
	return moserial_serial_connection_construct (MOSERIAL_TYPE_SERIAL_CONNECTION);
}


static void moserial_serial_connection_class_init (moserialSerialConnectionClass * klass) {
	moserial_serial_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSerialConnectionPrivate));
	G_OBJECT_CLASS (klass)->finalize = moserial_serial_connection_finalize;
	g_signal_new ("new_data", MOSERIAL_TYPE_SERIAL_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_INT, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_INT);
}


static void moserial_serial_connection_instance_init (moserialSerialConnection * self) {
	self->priv = MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE (self);
	self->tx = (gulong) 0;
	self->rx = (gulong) 0;
	self->nonprintable = (gulong) 0;
	self->forced_hex_view = FALSE;
	self->lastRxCharWasCR = FALSE;
	self->echoReference = g_strdup ("");
	self->echoCompare = g_strdup ("");
	self->priv->m_fd = -1;
	self->priv->flags = 0;
}


static void moserial_serial_connection_finalize (GObject* obj) {
	moserialSerialConnection * self;
	self = MOSERIAL_SERIAL_CONNECTION (obj);
	self->echoReference = (g_free (self->echoReference), NULL);
	self->echoCompare = (g_free (self->echoCompare), NULL);
	(self->priv->IOChannelFd == NULL) ? NULL : (self->priv->IOChannelFd = (g_io_channel_unref (self->priv->IOChannelFd), NULL));
	(self->priv->sourceId == NULL) ? NULL : (self->priv->sourceId = (g_free (self->priv->sourceId), NULL));
	G_OBJECT_CLASS (moserial_serial_connection_parent_class)->finalize (obj);
}


GType moserial_serial_connection_get_type (void) {
	static GType moserial_serial_connection_type_id = 0;
	if (moserial_serial_connection_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSerialConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_serial_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSerialConnection), 0, (GInstanceInitFunc) moserial_serial_connection_instance_init, NULL };
		moserial_serial_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSerialConnection", &g_define_type_info, 0);
	}
	return moserial_serial_connection_type_id;
}



static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}



