/* Profile.c generated by valac 0.12.0, the Vala compiler
 * generated from Profile.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


static gpointer profile_parent_class = NULL;

GType profile_get_type (void) G_GNUC_CONST;
enum  {
	PROFILE_DUMMY_PROPERTY
};
void profile_saveWindowSize (Profile* self, gint w, gint h);
void profile_saveWindowPanedPosition (Profile* self, gint pos);
gint profile_getWindowPanedPosition (Profile* self);
gint profile_getWindowWidth (Profile* self);
gint profile_getWindowHeight (Profile* self);
gboolean profile_load (Profile* self, const gchar* filename, GtkWindow* window);
void profile_toString (Profile* self);
void profile_save (Profile* self, const gchar* filename, GtkWindow* window);
Profile* profile_new (void);
Profile* profile_construct (GType object_type);
static GObject * profile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void profile_finalize (GObject* obj);


void profile_saveWindowSize (Profile* self, gint w, gint h) {
	g_return_if_fail (self != NULL);
	if (w > 0) {
		g_key_file_set_integer (self->keyFile, "window", "width", w);
	}
	if (h > 0) {
		g_key_file_set_integer (self->keyFile, "window", "height", h);
	}
}


void profile_saveWindowPanedPosition (Profile* self, gint pos) {
	g_return_if_fail (self != NULL);
	g_key_file_set_integer (self->keyFile, "window", "paned_pos", pos);
}


gint profile_getWindowPanedPosition (Profile* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_key_file_get_integer (self->keyFile, "window", "paned_pos", &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch23_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = _tmp1_;
	return result;
	goto __finally23;
	__catch23_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally23:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


gint profile_getWindowWidth (Profile* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_key_file_get_integer (self->keyFile, "window", "width", &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch24_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = _tmp1_;
	return result;
	goto __finally24;
	__catch24_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally24:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


gint profile_getWindowHeight (Profile* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_key_file_get_integer (self->keyFile, "window", "height", &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch25_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = _tmp1_;
	return result;
	goto __finally25;
	__catch25_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally25:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


gboolean profile_load (Profile* self, const gchar* filename, GtkWindow* window) {
	gboolean result = FALSE;
	gchar* f = NULL;
	gboolean default_profile;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	default_profile = FALSE;
	if (filename == NULL) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		default_profile = TRUE;
		_tmp0_ = g_get_user_config_dir ();
		_tmp1_ = g_strdup_printf ("%s/moserial.conf", _tmp0_);
		_g_free0 (f);
		f = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (filename);
		_g_free0 (f);
		f = _tmp2_;
	}
	g_key_file_load_from_file (self->keyFile, f, G_KEY_FILE_NONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch26_g_key_file_error;
		}
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch26_g_file_error;
		}
		_g_free0 (f);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_free0 (f);
	return result;
	goto __finally26;
	__catch26_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		result = TRUE;
		_g_error_free0 (e);
		_g_free0 (f);
		return result;
	}
	goto __finally26;
	__catch26_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (!default_profile) {
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			GtkMessageDialog* _tmp6_ = NULL;
			GtkMessageDialog* _tmp7_;
			GtkMessageDialog* errorDialog;
			_tmp3_ = _ ("Error: Could not open file");
			_tmp4_ = g_strdup_printf ("%s: %s\n%s", _tmp3_, filename, e->message);
			_tmp5_ = _tmp4_;
			_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new (window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp5_);
			_tmp7_ = g_object_ref_sink (_tmp6_);
			_g_free0 (_tmp5_);
			errorDialog = _tmp7_;
			gtk_dialog_run ((GtkDialog*) errorDialog);
			gtk_widget_destroy ((GtkWidget*) errorDialog);
			_g_object_unref0 (errorDialog);
		}
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (f);
		return result;
	}
	__finally26:
	_g_free0 (f);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


void profile_toString (Profile* self) {
	gsize s = 0UL;
	gsize _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = g_key_file_to_data (self->keyFile, &_tmp0_, NULL);
	s = _tmp0_;
	_tmp2_ = _tmp1_;
	fprintf (stdout, "%s\n", _tmp2_);
	_g_free0 (_tmp2_);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = -1;
	_tmp0_ = strlen (self);
	res_length1 = (gint) _tmp0_;
	_tmp1_ = res;
	*result_length1 = res_length1;
	result = _tmp1_;
	return result;
}


void profile_save (Profile* self, const gchar* filename, GtkWindow* window) {
	GFile* file = NULL;
	GFileOutputStream* fos = NULL;
	gchar* f = NULL;
	gboolean default_profile;
	GFile* _tmp3_ = NULL;
	gsize s = 0UL;
	gchar* data = NULL;
	GFileOutputStream* _tmp4_ = NULL;
	GFileOutputStream* _tmp5_;
	gsize _tmp6_;
	gchar* _tmp7_ = NULL;
	guint8* _tmp8_ = NULL;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	default_profile = FALSE;
	if (filename == NULL) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		default_profile = TRUE;
		_tmp0_ = g_get_user_config_dir ();
		_tmp1_ = g_strdup_printf ("%s/moserial.conf", _tmp0_);
		_g_free0 (f);
		f = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (filename);
		_g_free0 (f);
		f = _tmp2_;
	}
	_tmp3_ = g_file_new_for_path (f);
	_g_object_unref0 (file);
	file = _tmp3_;
	_tmp4_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		goto __catch27_g_error;
	}
	_g_object_unref0 (fos);
	fos = _tmp5_;
	_tmp7_ = g_key_file_to_data (self->keyFile, &_tmp6_, NULL);
	s = _tmp6_;
	_g_free0 (data);
	data = _tmp7_;
	_tmp8_ = string_get_data (data, &_tmp9_);
	g_output_stream_write ((GOutputStream*) fos, _tmp8_, (gsize) _tmp9_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		goto __catch27_g_error;
	}
	_g_free0 (data);
	goto __finally27;
	__catch27_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "profile.save error: %s\n", e->message);
		if (!default_profile) {
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			GtkMessageDialog* _tmp13_ = NULL;
			GtkMessageDialog* _tmp14_;
			GtkMessageDialog* errorDialog;
			_tmp10_ = _ ("Error: Could not open file");
			_tmp11_ = g_strdup_printf ("%s: %s\n%s", _tmp10_, filename, e->message);
			_tmp12_ = _tmp11_;
			_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new (window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp12_);
			_tmp14_ = g_object_ref_sink (_tmp13_);
			_g_free0 (_tmp12_);
			errorDialog = _tmp14_;
			gtk_dialog_run ((GtkDialog*) errorDialog);
			gtk_widget_destroy ((GtkWidget*) errorDialog);
			_g_object_unref0 (errorDialog);
		}
		_g_error_free0 (e);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_free0 (f);
		_g_object_unref0 (fos);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (f);
	_g_object_unref0 (fos);
	_g_object_unref0 (file);
}


Profile* profile_construct (GType object_type) {
	Profile * self = NULL;
	self = (Profile*) g_object_new (object_type, NULL);
	return self;
}


Profile* profile_new (void) {
	return profile_construct (TYPE_PROFILE);
}


static GObject * profile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Profile * self;
	GKeyFile* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (profile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = PROFILE (obj);
	_tmp0_ = g_key_file_new ();
	_g_key_file_free0 (self->keyFile);
	self->keyFile = _tmp0_;
	return obj;
}


static void profile_class_init (ProfileClass * klass) {
	profile_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = profile_constructor;
	G_OBJECT_CLASS (klass)->finalize = profile_finalize;
}


static void profile_instance_init (Profile * self) {
}


static void profile_finalize (GObject* obj) {
	Profile * self;
	self = PROFILE (obj);
	_g_key_file_free0 (self->keyFile);
	G_OBJECT_CLASS (profile_parent_class)->finalize (obj);
}


GType profile_get_type (void) {
	static volatile gsize profile_type_id__volatile = 0;
	if (g_once_init_enter (&profile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Profile), 0, (GInstanceInitFunc) profile_instance_init, NULL };
		GType profile_type_id;
		profile_type_id = g_type_register_static (G_TYPE_OBJECT, "Profile", &g_define_type_info, 0);
		g_once_init_leave (&profile_type_id__volatile, profile_type_id);
	}
	return profile_type_id__volatile;
}



