/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Pan - A Newsreader for X
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __FILTER_SCORE_H__
#define __FILTER_SCORE_H__

#include <pan/filters/filter.h>

#define FILTER_SCORE(a) ((FilterScore*)(a))
extern const gchar * FILTER_SCORE_CLASS_ID;

typedef struct _FilterScore FilterScore;

struct _FilterScore
{
	/* Parent */
	Filter parent;

	/* Fields */
	gint16 minimum_score;
};

/***
****  PUBLIC
***/

Filter*      filter_score_new           (void);

void         filter_score_set_score     (FilterScore        * filter,
                                         gint16               minimum_score);

#endif
