// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 4 -*-

/*
 *  PaperBox - dialog-entry.cc
 *
 *  Copyright (C) 2007 Marko Anastasov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "dialog-entry.hh"
#include "paths.hh"

namespace paperbox {

    DialogEntry::DialogEntry(GtkDialog* cobject,
                             const Glib::RefPtr<Gnome::Glade::Xml>& glade)
        :
        Gtk::Dialog(cobject),
        glade_(glade),
        label_instructions_(0)
    {
        glade_->get_widget("entry_tags", entry_tags_);
        g_assert(entry_tags_);
    }

    DialogEntry::~DialogEntry()
    {
    }

    DialogEntry*
    DialogEntry::create()
    {
        Glib::RefPtr<Gnome::Glade::Xml> glade_xml =
            Gnome::Glade::Xml::create(glade_dialog_entry);

        DialogEntry* p = 0;
        glade_xml->get_widget_derived("dialog_entry", p);
        return p;
    }

    void
    DialogEntry::set_instructions(const Glib::ustring& msg)
    {
        if (! label_instructions_) {
            glade_->get_widget("label_instructions", label_instructions_);
            g_assert(label_instructions_);
        }

        label_instructions_->set_text(msg);
    }

    int
    DialogEntry::run(Glib::ustring& text)
    {
        int response = Gtk::Dialog::run();
        text = entry_tags_->get_text();
        return response;
    }

} // namespace paperbox
