///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "imagemeta.h"
#include "document/imageframe.h"
#include "propbase.h"
#include "postscriptviewent.h"
#include "widget/filesel.h"
#include "widget/wmisc.h"
#include <gtkmm/label.h>

Pagent* ImageMeta::load(const xmlpp::Element& node, Group* parent,
			const FileContext &context)
{
  return new ImageFrame(parent, node, context);
}

Viewent::Ref ImageMeta::create_viewent(View& view, Pagent& node) {
  Viewent::Ref result(new PostscriptViewent
		      (view, &dynamic_cast<ImageFrame&>(node)));
  result->reference();
  return result;
}

// Properties for a EPS image, as represented by ImageFrame.
// Currently just displays the filename.  It should be able to change the file
// name and possibly display some of the header info from the EPS (title,
// created by, etc).
class PropImage : public GenericProp<ImageFrame> {
public:
  PropImage()
    : GenericProp<ImageFrame>("_EPS"),
     e_fname("Associated File")
    {
      Gtk::Box *line = manage(new Gtk::HBox(false, double_space));
      Gtk::Label *label = manage(new Gtk::Label("_Filename:", 0.0, 0.5, true));
      label->set_mnemonic_widget(e_fname);
      line->pack_start(*label, Gtk::PACK_SHRINK);
      line->pack_start(e_fname);
      pack_start(*line, Gtk::PACK_SHRINK);
      set_sensitive(false);
      update();
    }
  
  void update() {
    if(object) {
      e_fname.entry.set_text(object->get_association());
    } else {
      e_fname.entry.set_text("");
    }
  }
  void apply() {
    if(object)
      object->set_association(e_fname.entry.get_text());
  }
private:
  FileEntry e_fname;
};

PropBase* ImageMeta::getProp() {
  return new PropImage;
}
