/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Quick Lounge Applet
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef FILE_UTILS_H
#define FILE_UTILS_H

#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#include <libgnomevfs/gnome-vfs-uri.h>
#include <libgnomevfs/gnome-vfs-result.h>
#include <libgnomevfs/gnome-vfs-file-size.h>
#include <libgnomevfs/gnome-vfs-async-ops.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>
#include "typedefs.h"

#define SPECIAL_DIR(x) (! strcmp (x, "..") || ! strcmp (x, "."))

typedef struct _PathListData PathListData;

typedef void (*PathListDoneFunc) (PathListData *dld, gpointer data);

struct _PathListData {
	GnomeVFSURI *uri;
	GnomeVFSResult result;
	GList *files;               /* gchar* items. */
	GList *dirs;                /* gchar* items. */
	PathListDoneFunc done_func;
	gpointer data;
};


typedef struct {
	GnomeVFSAsyncHandle *vfs_handle;
	PathListData *pli_data;
} PathListHandle;


PathListData *      path_list_data_new           ();

void                path_list_data_free          (PathListData *dli);

void                path_list_handle_free        (PathListHandle *handle);

gboolean            path_is_file                 (const gchar *s);

gboolean            path_is_dir                  (const gchar *s);

gboolean            dir_is_empty                 (const gchar *s);

GnomeVFSFileSize    get_file_size                (const gchar *s);

time_t              get_file_mtime               (const gchar *s);

time_t              get_file_ctime               (const gchar *s);

void                set_file_mtime               (const gchar *s,
						  time_t       mtime);

gboolean            file_copy                    (const gchar *from, 
						  const gchar *to);

gboolean            file_move                    (const gchar *from, 
						  const gchar *to);

gint                file_in_path                 (const gchar *name);

gboolean            ensure_dir_exists            (const gchar *a_path,
						  mode_t mode);

gboolean            file_is_hidden               (const gchar *name);

G_CONST_RETURN gchar * file_name_from_path       (const gchar *path);

gchar *             remove_level_from_path       (const gchar *path);

gchar *             remove_extension_from_path   (const gchar *path);

gchar *             remove_ending_separator      (const gchar *path);


/* Return TRUE on success, it is up to you to free
 * the lists with path_list_free()
 */
gboolean            path_list_new                (const gchar *path, 
						  GList **files, 
						  GList **dirs);

void                path_list_free               (GList *list);

PathListHandle *    path_list_async_new          (const gchar *uri, 
						  PathListDoneFunc f,
						  gpointer  data);

void                path_list_async_interrupt    (PathListHandle *handle);

gboolean            file_is_image                (const gchar *name,
						  gboolean fast_file_type);

gboolean            file_extension_is            (const char *filename, 
						  const char *ext);

long                checksum_simple              (const gchar *path);

GList *             dir_list_filter_and_sort     (GList *dir_list, 
						  gboolean names_only,
						  gboolean show_dot_files);

gchar*              shell_escape                 (const gchar *filename);

gchar *             application_get_command      (const GnomeVFSMimeApplication *app);

char *              get_path_relative_to_dir     (const char *filename, 
						  const char *destdir);

char *              remove_special_dirs_from_path (const char *path);
     
char *              get_unique_desktop_file (const char *base_dir);

gboolean            is_desktop_file (const char *uri);

GList *             get_file_list_from_url_list (char *url_list);


#define errno_to_string() (gnome_vfs_result_to_string (gnome_vfs_result_from_errno ()))


#endif /* FILE_UTILS_H */
