/*
 * rarian-omf.cpp
 * This file is part of Rarian
 *
 * Copyright (C) 2006 - Don scorgie
 *
 * Rarian is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rarian is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Rarian; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>

#include <../util/tinyxml.h>

#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#include "rarian-omf.h"

static char *lang;
static char *sk_series;
static char *new_series;
static char *type;

static bool am_parsing = false;

enum ElemType {
    REG_NAME,
    REG_URI,
    REG_DESC,
    REG_LANG,
    REG_SERIES,
    REG_TYPE,
    REG_CATEGORIES
};

void
get_attribute (TiXmlElement *elem, ElemType e, RrnReg *reg)
{
    TiXmlAttribute* pAttrib=elem->FirstAttribute();
    if (e == REG_URI && strcmp (pAttrib->Value(), "")) {
        reg->uri = strdup (pAttrib->Value());
    } else if (e == REG_URI && !strcmp(pAttrib->Value(), "")){
        reg->uri = strdup ("");
    } else if (e == REG_LANG) {
      if (strcmp (pAttrib->Value(), "")) {
        reg->lang = strdup (pAttrib->Value());
      }
    } else if (e == REG_SERIES) {
      if (strcmp (pAttrib->Value(), "")) {
	reg->identifier = (char *) malloc (sizeof(char) * (strlen(pAttrib->Value()) + 18));
	sprintf (reg->identifier, "org.scrollkeeper.%s", pAttrib->Value());
        }
    } else if (e == REG_TYPE && strcmp (pAttrib->Value(), "")) {
        if (!type) {
            reg->type = strdup (pAttrib->Value());
        }
    } else if (e == REG_TYPE && !strcmp (pAttrib->Value(), "")) {
        /* Do nothing */
    } else if (e == REG_CATEGORIES && strcmp (pAttrib->Value(), "")) {
      char *categories;
      categories = strdup (pAttrib->Value());
      
      /* OMF files can only have 1 category. */
      reg->categories = (char **) malloc (sizeof(char *) * 2);
      reg->categories[0] = categories;
      reg->categories[1] = NULL;
    } else if (e == REG_CATEGORIES && !strcmp (pAttrib->Value(), "")) {
		/* Do Nothing */
    } else {
      /* Ignore unknown elements */
    }
}

void
get_text (TiXmlNode* pElement, ElemType e, RrnReg *reg)
{

    if (!pElement) {
        if (e == REG_NAME) {
            reg->name = strdup (" ");
        } else {
            reg->comment = strdup (" ");
        }
        return;
    }
    if (e == REG_NAME) {
        reg->name = strdup (pElement->Value());
    } else if (e == REG_DESC ) {
        reg->comment = strdup (pElement->Value());
    }

}

int
process_node (TiXmlNode *pParent, RrnReg *reg)
{
    TiXmlNode* pChild;
	TiXmlText* pText;
	int t = pParent->Type();
	int num;
	ElemType e;


	switch ( t )
	{
	case TiXmlNode::DOCUMENT:
		break;

	case TiXmlNode::ELEMENT:
	   if (!strcmp (pParent->Value(), "omf")) {
	       am_parsing = true;
	   } else if (!am_parsing) {
	       return 1;
	   }
	   if (!strcmp (pParent->Value(), "title")) {
	       e = REG_NAME;
	       get_text (pParent->FirstChild(), e, reg);
	   } else if (!strcmp (pParent->Value(), "description")) {
	       e = REG_DESC;
	       get_text (pParent->FirstChild(), e, reg);
	   } else if (!strcmp (pParent->Value(), "identifier")) {
	       e = REG_URI;
	       get_attribute (pParent->ToElement(), e, reg);
	   } else if (!strcmp (pParent->Value(), "language")) {
	       e = REG_LANG;
	       get_attribute (pParent->ToElement(), e, reg);
	   } else if (!strcmp (pParent->Value(), "relation")) {
	       e = REG_SERIES;
	       get_attribute (pParent->ToElement(), e, reg);
	   } else if (!strcmp (pParent->Value(), "format")) {
	       e = REG_TYPE;
	       get_attribute (pParent->ToElement(), e, reg);
	   } else if (!strcmp (pParent->Value(), "subject")) {
	   	   e = REG_CATEGORIES;
	   	   get_attribute (pParent->ToElement(), e, reg);
	   }
	   break;
	default:
    	break;
    }

	for ( pChild = pParent->FirstChild(); pChild != 0; pChild = pChild->NextSibling())
	{
	  int ret;
	  ret = process_node ( pChild, reg);
	  if (ret != 0)
	    return ret;
	}
	return 0;
}

RrnReg *
rrn_omf_parse_file (char *path)
{
    bool loadok;
    RrnReg *reg;
    TiXmlDocument doc (path);

    reg = rrn_reg_new ();

    loadok = doc.LoadFile(TIXML_ENCODING_UTF8);

    if (!loadok) {
        fprintf (stderr, "ERROR: Cannot parse %s.  Is it valid?\n", path);
	rrn_reg_free (reg);
	return NULL;
    }

    TiXmlNode *pParent = doc.FirstChildElement();

    if (process_node (pParent, reg) != 0) {
      rrn_reg_free (reg);
      return NULL;
    }

    if (!reg->identifier) {
      reg->identifier = (char *) malloc (sizeof(char) * 35);
      sprintf (reg->identifier, "org.scrollkeeper.unknown%d", rand());
    }

    return reg;
}
