/* rygel-media-export-item.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-media-export-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <gst/tag/tag.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__gst_mini_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gst_mini_object_unref0_ (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const gchar* mime, guint64 size, guint64 mtime);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime);
static void _gst_mini_object_unref0_ (gpointer var);
static void _g_list_free__gst_mini_object_unref0_ (GList* self);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info, const gchar* mime, guint64 size, guint64 mtime);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* title;
	RygelMediaItem* item = NULL;
	gboolean _tmp1_;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = g_file_get_basename (file);
	title = _tmp0_;
	_tmp1_ = g_str_has_prefix (mime, "video/");
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		RygelVideoItem* _tmp4_ = NULL;
		_tmp2_ = rygel_media_export_media_cache_get_id (file);
		_tmp3_ = _tmp2_;
		_tmp4_ = rygel_video_item_new (_tmp3_, parent, title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp4_;
		_g_free0 (_tmp3_);
	} else {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_prefix (mime, "image/");
		if (_tmp5_) {
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			RygelPhotoItem* _tmp8_ = NULL;
			_tmp6_ = rygel_media_export_media_cache_get_id (file);
			_tmp7_ = _tmp6_;
			_tmp8_ = rygel_photo_item_new (_tmp7_, parent, title, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp8_;
			_g_free0 (_tmp7_);
		} else {
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			RygelMusicItem* _tmp11_ = NULL;
			_tmp9_ = rygel_media_export_media_cache_get_id (file);
			_tmp10_ = _tmp9_;
			_tmp11_ = rygel_music_item_new (_tmp10_, parent, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp11_;
			_g_free0 (_tmp10_);
		}
	}
	_tmp12_ = g_strdup (mime);
	_g_free0 (item->mime_type);
	item->mime_type = _tmp12_;
	rygel_media_item_set_size (item, (gint64) size);
	((RygelMediaObject*) item)->modified = mtime;
	_tmp13_ = g_file_get_uri (file);
	_tmp14_ = _tmp13_;
	rygel_media_item_add_uri (item, _tmp14_);
	_g_free0 (_tmp14_);
	result = item;
	_g_free0 (title);
	return result;
}


static void _gst_mini_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL));
}


static void _g_list_free__gst_mini_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gst_mini_object_unref0_, NULL);
	g_list_free (self);
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item = NULL;
	gchar* _tmp0_ = NULL;
	gchar* id;
	GList* audio_streams = NULL;
	GList* video_streams = NULL;
	GstDiscovererInfo* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GstDiscovererInfo* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = rygel_media_export_media_cache_get_id (file);
	id = _tmp0_;
	_tmp1_ = gupnp_dlna_information_get_info (dlna_info);
	_tmp2_ = gst_discoverer_info_get_audio_streams (_tmp1_);
	__g_list_free__gst_mini_object_unref0_0 (audio_streams);
	audio_streams = _tmp2_;
	_tmp3_ = gupnp_dlna_information_get_info (dlna_info);
	_tmp4_ = gst_discoverer_info_get_video_streams (_tmp3_);
	__g_list_free__gst_mini_object_unref0_0 (video_streams);
	video_streams = _tmp4_;
	if (audio_streams == NULL) {
		gboolean _tmp6_;
		_tmp6_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) video_streams->data);
		_tmp5_ = _tmp6_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		RygelPhotoItem* _tmp7_ = NULL;
		RygelMediaItem* _tmp8_;
		RygelMediaItem* _tmp9_ = NULL;
		_tmp7_ = rygel_photo_item_new (id, parent, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp7_;
		_tmp8_ = item;
		_tmp9_ = rygel_media_export_item_factory_fill_photo_item (RYGEL_IS_PHOTO_ITEM (_tmp8_) ? ((RygelPhotoItem*) _tmp8_) : NULL, file, dlna_info, (GstDiscovererVideoInfo*) video_streams->data, mime, size, mtime);
		result = _tmp9_;
		__g_list_free__gst_mini_object_unref0_0 (video_streams);
		__g_list_free__gst_mini_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	} else {
		gboolean _tmp10_ = FALSE;
		if (audio_streams != NULL) {
			_tmp10_ = video_streams != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			RygelVideoItem* _tmp11_ = NULL;
			RygelMediaItem* _tmp12_;
			RygelMediaItem* _tmp13_ = NULL;
			_tmp11_ = rygel_video_item_new (id, parent, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp11_;
			_tmp12_ = item;
			_tmp13_ = rygel_media_export_item_factory_fill_video_item (RYGEL_IS_VIDEO_ITEM (_tmp12_) ? ((RygelVideoItem*) _tmp12_) : NULL, file, dlna_info, (GstDiscovererVideoInfo*) video_streams->data, (GstDiscovererAudioInfo*) audio_streams->data, mime, size, mtime);
			result = _tmp13_;
			__g_list_free__gst_mini_object_unref0_0 (video_streams);
			__g_list_free__gst_mini_object_unref0_0 (audio_streams);
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			if (audio_streams != NULL) {
				RygelMusicItem* _tmp14_ = NULL;
				RygelMediaItem* _tmp15_;
				RygelMediaItem* _tmp16_ = NULL;
				_tmp14_ = rygel_music_item_new (id, parent, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp14_;
				_tmp15_ = item;
				_tmp16_ = rygel_media_export_item_factory_fill_music_item (RYGEL_IS_MUSIC_ITEM (_tmp15_) ? ((RygelMusicItem*) _tmp15_) : NULL, file, dlna_info, (GstDiscovererAudioInfo*) audio_streams->data, mime, size, mtime);
				result = _tmp16_;
				__g_list_free__gst_mini_object_unref0_0 (video_streams);
				__g_list_free__gst_mini_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			} else {
				result = NULL;
				__g_list_free__gst_mini_object_unref0_0 (video_streams);
				__g_list_free__gst_mini_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	__g_list_free__gst_mini_object_unref0_0 (video_streams);
	__g_list_free__gst_mini_object_unref0_0 (audio_streams);
	_g_free0 (id);
	_g_object_unref0 (item);
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info) {
	GstDiscovererInfo* _tmp0_ = NULL;
	GstClockTime _tmp1_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (dlna_info != NULL);
	_tmp0_ = gupnp_dlna_information_get_info (dlna_info);
	_tmp1_ = gst_discoverer_info_get_duration (_tmp0_);
	if (_tmp1_ > 0) {
		GstDiscovererInfo* _tmp2_ = NULL;
		GstClockTime _tmp3_;
		_tmp2_ = gupnp_dlna_information_get_info (dlna_info);
		_tmp3_ = gst_discoverer_info_get_duration (_tmp2_);
		item->duration = (glong) (_tmp3_ / GST_SECOND);
	} else {
		item->duration = (glong) (-1);
	}
	if (audio_info != NULL) {
		GstTagList* _tmp4_ = NULL;
		guint _tmp7_;
		guint _tmp8_;
		_tmp4_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) audio_info);
		if (_tmp4_ != NULL) {
			guint tmp = 0U;
			GstTagList* _tmp5_ = NULL;
			guint _tmp6_;
			_tmp5_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) audio_info);
			gst_tag_list_get_uint (_tmp5_, GST_TAG_BITRATE, &_tmp6_);
			tmp = _tmp6_;
			item->bitrate = ((gint) tmp) / 8;
		}
		_tmp7_ = gst_discoverer_audio_info_get_channels (audio_info);
		item->channels = (gint) _tmp7_;
		_tmp8_ = gst_discoverer_audio_info_get_sample_rate (audio_info);
		item->sample_freq = (gint) _tmp8_;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelVideoItem* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	RygelMediaItem* _tmp4_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = item;
	rygel_media_export_item_factory_fill_audio_item (RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL, dlna_info, audio_info);
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) item, file, dlna_info, mime, size, mtime);
	_tmp1_ = gst_discoverer_video_info_get_width (video_info);
	rygel_visual_item_set_width ((RygelVisualItem*) item, (gint) _tmp1_);
	_tmp2_ = gst_discoverer_video_info_get_height (video_info);
	rygel_visual_item_set_height ((RygelVisualItem*) item, (gint) _tmp2_);
	_tmp3_ = gst_discoverer_video_info_get_depth (video_info);
	rygel_visual_item_set_color_depth ((RygelVisualItem*) item, (gint) _tmp3_);
	_tmp4_ = _g_object_ref0 ((RygelMediaItem*) item);
	result = _tmp4_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	RygelMediaItem* _tmp3_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) item, file, dlna_info, mime, size, mtime);
	_tmp0_ = gst_discoverer_video_info_get_width (video_info);
	rygel_visual_item_set_width ((RygelVisualItem*) item, (gint) _tmp0_);
	_tmp1_ = gst_discoverer_video_info_get_height (video_info);
	rygel_visual_item_set_height ((RygelVisualItem*) item, (gint) _tmp1_);
	_tmp2_ = gst_discoverer_video_info_get_depth (video_info);
	rygel_visual_item_set_color_depth ((RygelVisualItem*) item, (gint) _tmp2_);
	_tmp3_ = _g_object_ref0 ((RygelMediaItem*) item);
	result = _tmp3_;
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelMusicItem* _tmp0_;
	RygelMediaItem* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = item;
	rygel_media_export_item_factory_fill_audio_item (RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL, dlna_info, audio_info);
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) item, file, dlna_info, mime, size, mtime);
	if (audio_info != NULL) {
		GstTagList* _tmp1_ = NULL;
		GstDiscovererInfo* _tmp10_ = NULL;
		GstTagList* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GstDiscovererInfo* _tmp13_ = NULL;
		GstTagList* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GstDiscovererInfo* _tmp16_ = NULL;
		GstTagList* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		guint tmp = 0U;
		GstDiscovererInfo* _tmp19_ = NULL;
		GstTagList* _tmp20_ = NULL;
		guint _tmp21_;
		_tmp1_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) audio_info);
		if (_tmp1_ != NULL) {
			GstBuffer* buffer = NULL;
			GstTagList* _tmp2_ = NULL;
			GstBuffer* _tmp3_ = NULL;
			_tmp2_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) audio_info);
			gst_tag_list_get_buffer (_tmp2_, GST_TAG_IMAGE, &_tmp3_);
			buffer = _tmp3_;
			if (buffer != NULL) {
				const GstStructure* _tmp4_ = NULL;
				GstStructure* _tmp5_;
				GstStructure* structure;
				gint image_type = 0;
				gint _tmp6_;
				_tmp4_ = gst_caps_get_structure (buffer->caps, (guint) 0);
				_tmp5_ = _gst_structure_copy0 (_tmp4_);
				structure = _tmp5_;
				gst_structure_get_enum (structure, "image-type", GST_TYPE_TAG_IMAGE_TYPE, &_tmp6_);
				image_type = _tmp6_;
				switch (image_type) {
					case GST_TAG_IMAGE_TYPE_UNDEFINED:
					case GST_TAG_IMAGE_TYPE_FRONT_COVER:
					{
						RygelMediaArtStore* _tmp7_ = NULL;
						RygelMediaArtStore* store;
						GFile* _tmp8_ = NULL;
						GFile* thumb;
						RygelMediaExportJPEGWriter* _tmp9_ = NULL;
						RygelMediaExportJPEGWriter* writer;
						_tmp7_ = rygel_media_art_store_get_default ();
						store = _tmp7_;
						_tmp8_ = rygel_media_art_store_get_media_art_file (store, "album", item, TRUE);
						thumb = _tmp8_;
						_tmp9_ = rygel_media_export_jpeg_writer_new (&_inner_error_);
						writer = _tmp9_;
						if (_inner_error_ != NULL) {
							goto __catch54_g_error;
						}
						rygel_media_export_jpeg_writer_write (writer, buffer, thumb);
						_g_object_unref0 (writer);
						goto __finally54;
						__catch54_g_error:
						{
							GError * _error_;
							_error_ = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (_error_);
						}
						__finally54:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (thumb);
							_g_object_unref0 (store);
							_gst_structure_free0 (structure);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_object_unref0 (thumb);
						_g_object_unref0 (store);
						break;
					}
					default:
					{
						break;
					}
				}
				_gst_structure_free0 (structure);
			}
		}
		_tmp10_ = gupnp_dlna_information_get_info (dlna_info);
		_tmp11_ = gst_discoverer_info_get_tags (_tmp10_);
		gst_tag_list_get_string (_tmp11_, GST_TAG_ARTIST, &_tmp12_);
		_g_free0 (item->artist);
		item->artist = _tmp12_;
		_tmp13_ = gupnp_dlna_information_get_info (dlna_info);
		_tmp14_ = gst_discoverer_info_get_tags (_tmp13_);
		gst_tag_list_get_string (_tmp14_, GST_TAG_ALBUM, &_tmp15_);
		_g_free0 (item->album);
		item->album = _tmp15_;
		_tmp16_ = gupnp_dlna_information_get_info (dlna_info);
		_tmp17_ = gst_discoverer_info_get_tags (_tmp16_);
		gst_tag_list_get_string (_tmp17_, GST_TAG_GENRE, &_tmp18_);
		_g_free0 (item->genre);
		item->genre = _tmp18_;
		_tmp19_ = gupnp_dlna_information_get_info (dlna_info);
		_tmp20_ = gst_discoverer_info_get_tags (_tmp19_);
		gst_tag_list_get_uint (_tmp20_, GST_TAG_TRACK_NUMBER, &_tmp21_);
		tmp = _tmp21_;
		item->track_number = (gint) tmp;
	}
	_tmp22_ = _g_object_ref0 ((RygelMediaItem*) item);
	result = _tmp22_;
	return result;
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime) {
	gchar* title;
	gboolean _tmp0_ = FALSE;
	GstDiscovererInfo* _tmp1_ = NULL;
	GstTagList* _tmp2_ = NULL;
	GstDiscovererInfo* _tmp8_ = NULL;
	GstTagList* _tmp9_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (dlna_info != NULL);
	g_return_if_fail (mime != NULL);
	title = NULL;
	_tmp1_ = gupnp_dlna_information_get_info (dlna_info);
	_tmp2_ = gst_discoverer_info_get_tags (_tmp1_);
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GstDiscovererInfo* _tmp3_ = NULL;
		GstTagList* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_;
		_tmp3_ = gupnp_dlna_information_get_info (dlna_info);
		_tmp4_ = gst_discoverer_info_get_tags (_tmp3_);
		_tmp6_ = gst_tag_list_get_string (_tmp4_, GST_TAG_TITLE, &_tmp5_);
		_g_free0 (title);
		title = _tmp5_;
		_tmp0_ = !_tmp6_;
	}
	if (_tmp0_) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = g_file_get_basename (file);
		_g_free0 (title);
		title = _tmp7_;
	}
	rygel_media_object_set_title ((RygelMediaObject*) item, title);
	_tmp8_ = gupnp_dlna_information_get_info (dlna_info);
	_tmp9_ = gst_discoverer_info_get_tags (_tmp8_);
	if (_tmp9_ != NULL) {
		GDate* date = NULL;
		GstDiscovererInfo* _tmp10_ = NULL;
		GstTagList* _tmp11_ = NULL;
		GDate* _tmp12_ = NULL;
		gboolean _tmp13_;
		_tmp10_ = gupnp_dlna_information_get_info (dlna_info);
		_tmp11_ = gst_discoverer_info_get_tags (_tmp10_);
		_tmp13_ = gst_tag_list_get_date (_tmp11_, GST_TAG_DATE, &_tmp12_);
		_g_free0 (date);
		date = _tmp12_;
		if (_tmp13_) {
			gchar* _tmp14_ = NULL;
			gchar* datestr;
			gint datestr_length1;
			gint _datestr_size_;
			gchar* _tmp15_;
			_tmp14_ = g_new0 (gchar, 30);
			datestr = _tmp14_;
			datestr_length1 = 30;
			_datestr_size_ = 30;
			g_date_strftime (datestr, datestr_length1, "%F", date);
			_tmp15_ = g_strdup ((const gchar*) datestr);
			_g_free0 (item->date);
			item->date = _tmp15_;
			datestr = (g_free (datestr), NULL);
		}
		_g_free0 (date);
	}
	if (item->date == NULL) {
		GTimeVal _tmp16_ = {0};
		GTimeVal tv;
		gchar* _tmp17_ = NULL;
		_tmp16_.tv_sec = (glong) mtime;
		_tmp16_.tv_usec = (glong) 0;
		tv = _tmp16_;
		_tmp17_ = g_time_val_to_iso8601 (&tv);
		_g_free0 (item->date);
		item->date = _tmp17_;
	}
	rygel_media_item_set_size (item, (gint64) size);
	((RygelMediaObject*) item)->modified = (guint64) ((gint64) mtime);
	_tmp18_ = gupnp_dlna_information_get_name (dlna_info);
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp19_ = gupnp_dlna_information_get_name (dlna_info);
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (item->dlna_profile);
		item->dlna_profile = _tmp20_;
		_tmp21_ = gupnp_dlna_information_get_mime (dlna_info);
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (item->mime_type);
		item->mime_type = _tmp22_;
	} else {
		gchar* _tmp23_;
		_tmp23_ = g_strdup (mime);
		_g_free0 (item->mime_type);
		item->mime_type = _tmp23_;
	}
	_tmp24_ = g_file_get_uri (file);
	_tmp25_ = _tmp24_;
	rygel_media_item_add_uri (item, _tmp25_);
	_g_free0 (_tmp25_);
	_g_free0 (title);
}



