/*
 * Scaffold text plugin
 *
 * Contains all text based plugins:
 *  - insert date and time
 *  - insert GPL header (C and C++)
 *  - insert file
 *  - delete BOF, EOF, BOL, EOL
 *  - replace tabs with spaces
 */

#include <config.h>

#include <bonobo-activation/bonobo-activation.h>
#include <gtk/gtk.h>
#include <libbonobo.h>
#include <libbonoboui.h>
#include <libscaffold/libscaffold.h>

#include "text-insert.h"
#include "text-delete.h"
#include "text-replace.h"

#define PLUGIN_NAME			"scaffold-text-plugin"
#define PLUGIN_XML			"scaffold-text-plugin.xml"


typedef struct {
	ScaffoldTool parent;
} TextTool;

typedef struct {
	ScaffoldToolClass parent;
} TextToolClass;

/*
 * Define the verbs in this plugin
 */
static BonoboUIVerb verbs[] = {
	BONOBO_UI_UNSAFE_VERB("TextInsertDateTime", text_insert_date),
	BONOBO_UI_UNSAFE_VERB("TextInsertGplC", text_insert_gpl_c),
	BONOBO_UI_UNSAFE_VERB("TextInsertGplCpp", text_insert_gpl_cpp),
	BONOBO_UI_UNSAFE_VERB("TextInsertFile", text_insert_file),
	BONOBO_UI_UNSAFE_VERB("TextDeleteBOF", text_delete_to_bof),
	BONOBO_UI_UNSAFE_VERB("TextDeleteEOF", text_delete_to_eof),
	BONOBO_UI_UNSAFE_VERB("TextDeleteBOL", text_delete_to_bol),
	BONOBO_UI_UNSAFE_VERB("TextDeleteEOL", text_delete_to_eol),
	BONOBO_UI_UNSAFE_VERB("TextReplaceTabs", text_replace_tab_spaces),
	BONOBO_UI_VERB_END
};

static void
shell_set (ScaffoldTool *tool)
{
	scaffold_tool_merge_ui (tool,
			      "scaffold-text-tool",
			      SCAFFOLD_DATADIR,
			      "scaffold-text-plugin.xml",
			      verbs, tool);
}

static void
dispose (GObject *obj)
{
	scaffold_tool_unmerge_ui (SCAFFOLD_TOOL (obj));
}

static void
text_tool_instance_init (GObject *object)
{
}

static void
text_tool_class_init (GObjectClass *klass)
{
	ScaffoldToolClass *tool_class = SCAFFOLD_TOOL_CLASS (klass);
	
	tool_class->shell_set = shell_set;
	klass->dispose = dispose;
}

SCAFFOLD_TOOL_BOILERPLATE (TextTool, text_tool);

SCAFFOLD_SIMPLE_PLUGIN (TextTool, text_tool);
