/* valaccodeenum.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodeenum.h"
#include <ccode/valaccodeenum.h>

struct _ValaCCodeEnumPrivate {
	char* _name;
	GList* values;
};
#define VALA_CCODE_ENUM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ENUM, ValaCCodeEnumPrivate))
enum  {
	VALA_CCODE_ENUM_DUMMY_PROPERTY,
	VALA_CCODE_ENUM_NAME,
};
static void vala_ccode_enum_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_enum_parent_class = NULL;
static void vala_ccode_enum_dispose (GObject * obj);


ValaCCodeEnum* vala_ccode_enum_new (const char* n)
{
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, n), __params_it++);
	ValaCCodeEnum * self = g_object_newv (VALA_TYPE_CCODE_ENUM, __params_it - __params, __params);
	return self;
}


/**
 * Adds the specified value to this enum.
 *
 * @param name  enum value name
 * @param value optional numerical value
 */
void vala_ccode_enum_add_value (ValaCCodeEnum* self, const char* name, const char* value)
{
	g_return_if_fail (VALA_IS_CCODE_ENUM (self));
	g_return_if_fail (name != NULL);
	if (value == NULL) {
		self->priv->values = g_list_append (self->priv->values, g_strdup (name));
	} else {
		self->priv->values = g_list_append (self->priv->values, g_strdup_printf ("%s = %s", name, value));
	}
}


static void vala_ccode_enum_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeEnum * self = VALA_CCODE_ENUM (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if (vala_ccode_enum_get_name (self) != NULL) {
		vala_ccode_writer_write_string (writer, "typedef ");
	}
	vala_ccode_writer_write_string (writer, "enum ");
	vala_ccode_writer_write_begin_block (writer);
	{
		GList* __temp0 = NULL;
		__temp0 = self->priv->values;
		GList* value_it;
		for (value_it = __temp0; value_it != NULL; value_it = value_it->next) {
			char* value = value_it->data;
			{
				vala_ccode_writer_write_indent (writer);
				vala_ccode_writer_write_string (writer, value);
				vala_ccode_writer_write_string (writer, ",");
				vala_ccode_writer_write_newline (writer);
			}
		}
	}
	vala_ccode_writer_write_end_block (writer);
	if (vala_ccode_enum_get_name (self) != NULL) {
		vala_ccode_writer_write_string (writer, " ");
		vala_ccode_writer_write_string (writer, vala_ccode_enum_get_name (self));
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


char* vala_ccode_enum_get_name (ValaCCodeEnum* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_ENUM (self), NULL);
	return self->priv->_name;
}


void vala_ccode_enum_set_name (ValaCCodeEnum* self, const char* value)
{
	g_return_if_fail (VALA_IS_CCODE_ENUM (self));
	char* __temp3 = NULL;
	const char* __temp2 = NULL;
	self->priv->_name = (__temp3 = (__temp2 = value, (__temp2 == NULL ? NULL : g_strdup (__temp2))), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp3);
}


static void vala_ccode_enum_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeEnum * self = VALA_CCODE_ENUM (object);
	switch (property_id) {
		case VALA_CCODE_ENUM_NAME:
		g_value_set_string (value, vala_ccode_enum_get_name (self));
		break;
	}
}


static void vala_ccode_enum_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeEnum * self = VALA_CCODE_ENUM (object);
	switch (property_id) {
		case VALA_CCODE_ENUM_NAME:
		vala_ccode_enum_set_name (self, g_value_get_string (value));
		break;
	}
}


static void vala_ccode_enum_class_init (ValaCCodeEnumClass * klass)
{
	vala_ccode_enum_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeEnumPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_enum_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_enum_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_enum_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_enum_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ENUM_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_enum_init (ValaCCodeEnum * self)
{
	self->priv = VALA_CCODE_ENUM_GET_PRIVATE (self);
}


static void vala_ccode_enum_dispose (GObject * obj)
{
	ValaCCodeEnum * self = VALA_CCODE_ENUM (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->values == NULL ? NULL : (self->priv->values = (g_list_foreach (self->priv->values, (GFunc) g_free, NULL), g_list_free (self->priv->values), NULL)));
	ValaCCodeEnumClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CCODE_ENUM_CLASS (g_type_class_peek (VALA_TYPE_CCODE_ENUM));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_enum_get_type ()
{
	static GType vala_ccode_enum_type_id = 0;
	if (G_UNLIKELY (vala_ccode_enum_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeEnumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_enum_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeEnum), 0, (GInstanceInitFunc) vala_ccode_enum_init };
		vala_ccode_enum_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeEnum", &g_define_type_info, 0);
	}
	return vala_ccode_enum_type_id;
}




