/* valaconstant.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaconstant.h"
#include <vala/valatypereference.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valaconstant.h>
#include <vala/valacodevisitor.h>
#include <vala/valasymbol.h>
#include <vala/valadatatype.h>
#include <vala/valanamespace.h>

struct _ValaConstantPrivate {
	char* _name;
	ValaTypeReference* _type_reference;
	ValaExpression* _initializer;
	char* cname;
	gboolean lock_used;
};
#define VALA_CONSTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CONSTANT, ValaConstantPrivate))
enum  {
	VALA_CONSTANT_DUMMY_PROPERTY,
	VALA_CONSTANT_NAME,
	VALA_CONSTANT_TYPE_REFERENCE,
	VALA_CONSTANT_INITIALIZER
};
static void vala_constant_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_constant_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_constant_real_get_lock_used (ValaLockable* base);
static void vala_constant_real_set_lock_used (ValaLockable* base, gboolean used);
static gpointer vala_constant_parent_class = NULL;
static ValaLockableIface* vala_constant_vala_lockable_parent_iface = NULL;
static void vala_constant_dispose (GObject * obj);


/**
 * Creates a new constant.
 *
 * @param name   constant name
 * @param type   constant type
 * @param init   constant value
 * @param source reference to source code
 * @return       newly created constant
 */
ValaConstant* vala_constant_new (const char* _name, ValaTypeReference* type, ValaExpression* init, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaConstant * self;
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	g_return_val_if_fail (init == NULL || VALA_IS_EXPRESSION (init), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 4);
	__params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, type), __params_it++);
	(__params_it->name = "initializer", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, init), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_CONSTANT, __params_it - __params, __params);
	return self;
}


static void vala_constant_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaConstant * self;
	self = VALA_CONSTANT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_member (visitor, VALA_MEMBER (self));
	vala_code_visitor_visit_constant (visitor, self);
}


static void vala_constant_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaConstant * self;
	self = VALA_CONSTANT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_constant_get_type_reference (self)), visitor);
	if (vala_constant_get_initializer (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_constant_get_initializer (self)), visitor);
	}
}


/**
 * Returns the name of this constant as it is used in C code.
 *
 * @return the name to be used in C code
 */
char* vala_constant_get_cname (ValaConstant* self)
{
	const char* __temp9;
	g_return_val_if_fail (VALA_IS_CONSTANT (self), NULL);
	if (self->priv->cname == NULL) {
		if (VALA_IS_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (self)))))) {
			ValaDataType* __temp0;
			ValaDataType* t;
			char* __temp3;
			char* __temp2;
			char* __temp1;
			__temp0 = NULL;
			t = (__temp0 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (self))))), (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
			__temp3 = NULL;
			__temp2 = NULL;
			__temp1 = NULL;
			self->priv->cname = (__temp3 = g_strdup_printf ("%s%s", (__temp2 = g_utf8_strup ((__temp1 = vala_data_type_get_lower_case_cprefix (t)), -1)), vala_constant_get_name (self)), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp3);
			(__temp2 = (g_free (__temp2), NULL));
			(__temp1 = (g_free (__temp1), NULL));
			(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
		} else {
			ValaNamespace* __temp4;
			ValaNamespace* ns;
			__temp4 = NULL;
			ns = (__temp4 = VALA_NAMESPACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (self))))), (__temp4 == NULL ? NULL : g_object_ref (__temp4)));
			if (ns == NULL) {
				char* __temp5;
				/* global constant*/
				__temp5 = NULL;
				self->priv->cname = (__temp5 = g_strdup (vala_constant_get_name (self)), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp5);
			} else {
				char* __temp8;
				char* __temp7;
				char* __temp6;
				__temp8 = NULL;
				__temp7 = NULL;
				__temp6 = NULL;
				self->priv->cname = (__temp8 = g_strdup_printf ("%s%s", (__temp7 = g_utf8_strup ((__temp6 = vala_namespace_get_lower_case_cprefix (ns)), -1)), vala_constant_get_name (self)), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp8);
				(__temp7 = (g_free (__temp7), NULL));
				(__temp6 = (g_free (__temp6), NULL));
			}
			(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
		}
	}
	__temp9 = NULL;
	return (__temp9 = self->priv->cname, (__temp9 == NULL ? NULL : g_strdup (__temp9)));
}


static gboolean vala_constant_real_get_lock_used (ValaLockable* base)
{
	ValaConstant * self;
	self = VALA_CONSTANT (base);
	return self->priv->lock_used;
}


static void vala_constant_real_set_lock_used (ValaLockable* base, gboolean used)
{
	ValaConstant * self;
	self = VALA_CONSTANT (base);
	self->priv->lock_used = used;
}


char* vala_constant_get_name (ValaConstant* self)
{
	g_return_val_if_fail (VALA_IS_CONSTANT (self), NULL);
	return self->priv->_name;
}


void vala_constant_set_name (ValaConstant* self, const char* value)
{
	char* __temp13;
	g_return_if_fail (VALA_IS_CONSTANT (self));
	__temp13 = NULL;
	self->priv->_name = (__temp13 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp13);
}


ValaTypeReference* vala_constant_get_type_reference (ValaConstant* self)
{
	g_return_val_if_fail (VALA_IS_CONSTANT (self), NULL);
	return self->priv->_type_reference;
}


void vala_constant_set_type_reference (ValaConstant* self, ValaTypeReference* value)
{
	ValaTypeReference* __temp15;
	g_return_if_fail (VALA_IS_CONSTANT (self));
	__temp15 = NULL;
	self->priv->_type_reference = (__temp15 = g_object_ref (value), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), __temp15);
}


ValaExpression* vala_constant_get_initializer (ValaConstant* self)
{
	g_return_val_if_fail (VALA_IS_CONSTANT (self), NULL);
	return self->priv->_initializer;
}


void vala_constant_set_initializer (ValaConstant* self, ValaExpression* value)
{
	ValaExpression* __temp18;
	ValaExpression* __temp17;
	g_return_if_fail (VALA_IS_CONSTANT (self));
	__temp18 = NULL;
	__temp17 = NULL;
	self->priv->_initializer = (__temp18 = (__temp17 = value, (__temp17 == NULL ? NULL : g_object_ref (__temp17))), (self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL))), __temp18);
}


static void vala_constant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaConstant * self;
	self = VALA_CONSTANT (object);
	switch (property_id) {
		case VALA_CONSTANT_NAME:
		g_value_set_string (value, vala_constant_get_name (self));
		break;
		case VALA_CONSTANT_TYPE_REFERENCE:
		g_value_set_object (value, vala_constant_get_type_reference (self));
		break;
		case VALA_CONSTANT_INITIALIZER:
		g_value_set_object (value, vala_constant_get_initializer (self));
		break;
	}
}


static void vala_constant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaConstant * self;
	self = VALA_CONSTANT (object);
	switch (property_id) {
		case VALA_CONSTANT_NAME:
		vala_constant_set_name (self, g_value_get_string (value));
		break;
		case VALA_CONSTANT_TYPE_REFERENCE:
		vala_constant_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_CONSTANT_INITIALIZER:
		vala_constant_set_initializer (self, g_value_get_object (value));
		break;
	}
}


static void vala_constant_class_init (ValaConstantClass * klass)
{
	vala_constant_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaConstantPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_constant_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_constant_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_constant_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_constant_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_constant_real_accept_children;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CONSTANT_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CONSTANT_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CONSTANT_INITIALIZER, g_param_spec_object ("initializer", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_constant_vala_lockable_interface_init (ValaLockableIface * iface)
{
	vala_constant_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_constant_real_get_lock_used;
	iface->set_lock_used = vala_constant_real_set_lock_used;
}


static void vala_constant_init (ValaConstant * self)
{
	self->priv = VALA_CONSTANT_GET_PRIVATE (self);
	self->priv->lock_used = FALSE;
}


static void vala_constant_dispose (GObject * obj)
{
	ValaConstant * self;
	ValaConstantClass * klass;
	GObjectClass * parent_class;
	self = VALA_CONSTANT (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL)));
	(self->priv->cname = (g_free (self->priv->cname), NULL));
	klass = VALA_CONSTANT_CLASS (g_type_class_peek (VALA_TYPE_CONSTANT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_constant_get_type ()
{
	static GType vala_constant_type_id = 0;
	if (G_UNLIKELY (vala_constant_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaConstantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_constant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConstant), 0, (GInstanceInitFunc) vala_constant_init };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_constant_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_constant_type_id = g_type_register_static (VALA_TYPE_MEMBER, "ValaConstant", &g_define_type_info, 0);
		g_type_add_interface_static (vala_constant_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	}
	return vala_constant_type_id;
}




