/* valafield.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAFIELD_H__
#define __VALAFIELD_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valamember.h>
#include <vala/valainvokable.h>
#include <vala/valalockable.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaFieldPrivate ValaFieldPrivate;

/**
 * Represents a type or namespace field.
 */
struct _ValaField {
	ValaMember parent;
	ValaFieldPrivate * priv;
	ValaMemberAccessibility access;
};
struct _ValaFieldClass {
	ValaMemberClass parent;
};

ValaField* vala_field_new (const char* name, ValaTypeReference* type_reference, ValaExpression* initializer, ValaSourceReference* source_reference);
char* vala_field_get_cname (ValaField* self);
void vala_field_process_attributes (ValaField* self);
ValaTypeReference* vala_field_get_type_reference (ValaField* self);
void vala_field_set_type_reference (ValaField* self, ValaTypeReference* value);
ValaExpression* vala_field_get_initializer (ValaField* self);
void vala_field_set_initializer (ValaField* self, ValaExpression* value);
gboolean vala_field_get_instance (ValaField* self);
void vala_field_set_instance (ValaField* self, gboolean value);
gboolean vala_field_get_no_array_length (ValaField* self);
void vala_field_set_no_array_length (ValaField* self, gboolean value);
GType vala_field_get_type (void);

G_END_DECLS

#endif
