/* valaccodenewline.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODENEWLINE_H__
#define __CCODE_VALACCODENEWLINE_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_NEWLINE (vala_ccode_newline_get_type ())
#define VALA_CCODE_NEWLINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NEWLINE, ValaCCodeNewline))
#define VALA_CCODE_NEWLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NEWLINE, ValaCCodeNewlineClass))
#define VALA_IS_CCODE_NEWLINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NEWLINE))
#define VALA_IS_CCODE_NEWLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NEWLINE))
#define VALA_CCODE_NEWLINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NEWLINE, ValaCCodeNewlineClass))

typedef struct _ValaCCodeNewline ValaCCodeNewline;
typedef struct _ValaCCodeNewlineClass ValaCCodeNewlineClass;
typedef struct _ValaCCodeNewlinePrivate ValaCCodeNewlinePrivate;

/**
 * Represents a line break in the C code.
 */
struct _ValaCCodeNewline {
	ValaCCodeNode parent_instance;
	ValaCCodeNewlinePrivate * priv;
};
struct _ValaCCodeNewlineClass {
	ValaCCodeNodeClass parent_class;
};

ValaCCodeNewline* vala_ccode_newline_new (void);
GType vala_ccode_newline_get_type (void);

G_END_DECLS

#endif
