/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <version.h>


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ValaVAPIGen {
	GObject parent_instance;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GObjectClass parent_class;
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};


static gpointer vala_vapi_gen_parent_class = NULL;
static gchar* vala_vapi_gen_directory;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gchar** vala_vapi_gen_sources;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages;
static gchar** vala_vapi_gen_packages = NULL;
static gchar* vala_vapi_gen_metadata_filename;
static gchar* vala_vapi_gen_metadata_filename = NULL;

GType vala_vapi_gen_get_type (void) G_GNUC_CONST;
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
enum  {
	VALA_VAPI_GEN_DUMMY_PROPERTY
};
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static gint vala_vapi_gen_main (gchar** args, int args_length1);
ValaVAPIGen* vala_vapi_gen_new (void);
ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[10] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"metadata", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_metadata_filename, "Metadata filename", "FILE"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static gint vala_vapi_gen_quit (ValaVAPIGen* self) {
	gint result = 0;
	ValaReport* _tmp0_ = NULL;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_get_report (self->priv->context);
	_tmp1_ = vala_report_get_errors (_tmp0_);
	if (_tmp1_ == 0) {
		if (!vala_vapi_gen_quiet_mode) {
			ValaReport* _tmp2_ = NULL;
			gint _tmp3_;
			_tmp2_ = vala_code_context_get_report (self->priv->context);
			_tmp3_ = vala_report_get_warnings (_tmp2_);
			fprintf (stdout, "Generation succeeded - %d warning(s)\n", _tmp3_);
		}
		result = 0;
		return result;
	} else {
		if (!vala_vapi_gen_quiet_mode) {
			ValaReport* _tmp4_ = NULL;
			gint _tmp5_;
			ValaReport* _tmp6_ = NULL;
			gint _tmp7_;
			_tmp4_ = vala_code_context_get_report (self->priv->context);
			_tmp5_ = vala_report_get_errors (_tmp4_);
			_tmp6_ = vala_code_context_get_report (self->priv->context);
			_tmp7_ = vala_report_get_warnings (_tmp6_);
			fprintf (stdout, "Generation failed: %d error(s), %d warning(s)\n", _tmp5_, _tmp7_);
		}
		result = 1;
		return result;
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static gint vala_vapi_gen_run (ValaVAPIGen* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	ValaReport* _tmp8_ = NULL;
	gint _tmp9_;
	ValaReport* _tmp18_ = NULL;
	gint _tmp19_;
	ValaReport* _tmp21_ = NULL;
	gint _tmp22_;
	ValaReport* _tmp26_ = NULL;
	gint _tmp27_;
	gchar** _tmp35_;
	ValaReport* _tmp36_ = NULL;
	gint _tmp37_;
	ValaParser* _tmp39_ = NULL;
	ValaParser* parser;
	ValaReport* _tmp40_ = NULL;
	gint _tmp41_;
	ValaGirParser* _tmp43_ = NULL;
	ValaGirParser* girparser;
	ValaReport* _tmp44_ = NULL;
	gint _tmp45_;
	ValaGIdlParser* _tmp47_ = NULL;
	ValaGIdlParser* gidlparser;
	ValaReport* _tmp48_ = NULL;
	gint _tmp49_;
	ValaSymbolResolver* _tmp51_ = NULL;
	ValaSymbolResolver* resolver;
	ValaReport* _tmp52_ = NULL;
	gint _tmp53_;
	ValaSemanticAnalyzer* _tmp55_ = NULL;
	ValaSemanticAnalyzer* analyzer;
	ValaReport* _tmp56_ = NULL;
	gint _tmp57_;
	gboolean _tmp59_ = FALSE;
	gint _tmp78_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_tmp1_ = _tmp0_;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
	_tmp2_ = (_tmp3_ = vala_vapi_gen_vapi_directories, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup1 (_tmp3_, _vala_array_length (vala_vapi_gen_vapi_directories)));
	_tmp4_ = _tmp2_;
	self->priv->context->vapi_directories = (_vala_array_free (self->priv->context->vapi_directories, self->priv->context->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->context->vapi_directories_length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	self->priv->context->vapi_directories = _tmp4_;
	_tmp5_ = (_tmp6_ = vala_vapi_gen_gir_directories, (_tmp6_ == NULL) ? ((gpointer) _tmp6_) : _vala_array_dup2 (_tmp6_, _vala_array_length (vala_vapi_gen_gir_directories)));
	_tmp7_ = _tmp5_;
	self->priv->context->gir_directories = (_vala_array_free (self->priv->context->gir_directories, self->priv->context->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->context->gir_directories_length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	self->priv->context->gir_directories = _tmp7_;
	vala_code_context_push (self->priv->context);
	vala_code_context_add_external_package (self->priv->context, "glib-2.0");
	vala_code_context_add_external_package (self->priv->context, "gobject-2.0");
	_tmp8_ = vala_code_context_get_report (self->priv->context);
	_tmp9_ = vala_report_get_errors (_tmp8_);
	if (_tmp9_ > 0) {
		gint _tmp10_;
		_tmp10_ = vala_vapi_gen_quit (self);
		result = _tmp10_;
		return result;
	}
	{
		gchar** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			gchar* _tmp11_;
			gchar* source;
			_tmp11_ = g_strdup (source_collection[source_it]);
			source = _tmp11_;
			{
				gboolean _tmp12_;
				glong _tmp13_;
				glong _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* depsfile;
				_tmp12_ = g_str_has_suffix (source, ".gi");
				if (!_tmp12_) {
					_g_free0 (source);
					continue;
				}
				_tmp13_ = strlen (source);
				_tmp14_ = strlen ("gi");
				_tmp15_ = string_substring (source, (glong) 0, _tmp13_ - _tmp14_);
				_tmp16_ = _tmp15_;
				depsfile = (_tmp17_ = g_strconcat (_tmp16_, "deps", NULL), _g_free0 (_tmp16_), _tmp17_);
				vala_code_context_add_packages_from_file (self->priv->context, depsfile);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp18_ = vala_code_context_get_report (self->priv->context);
	_tmp19_ = vala_report_get_errors (_tmp18_);
	if (_tmp19_ > 0) {
		gint _tmp20_;
		_tmp20_ = vala_vapi_gen_quit (self);
		result = _tmp20_;
		return result;
	}
	if (vala_vapi_gen_library != NULL) {
		gchar* depsfile;
		depsfile = g_strconcat (vala_vapi_gen_library, ".deps", NULL);
		vala_code_context_add_packages_from_file (self->priv->context, depsfile);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp21_ = vala_code_context_get_report (self->priv->context);
	_tmp22_ = vala_report_get_errors (_tmp21_);
	if (_tmp22_ > 0) {
		gint _tmp23_;
		_tmp23_ = vala_vapi_gen_quit (self);
		result = _tmp23_;
		return result;
	}
	if (vala_vapi_gen_packages != NULL) {
		gchar** _tmp25_;
		{
			gchar** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = vala_vapi_gen_packages;
			package_collection_length1 = _vala_array_length (vala_vapi_gen_packages);
			for (package_it = 0; package_it < _vala_array_length (vala_vapi_gen_packages); package_it = package_it + 1) {
				gchar* _tmp24_;
				gchar* package;
				_tmp24_ = g_strdup (package_collection[package_it]);
				package = _tmp24_;
				{
					vala_code_context_add_external_package (self->priv->context, package);
					_g_free0 (package);
				}
			}
		}
		_tmp25_ = NULL;
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = _tmp25_;
	}
	_tmp26_ = vala_code_context_get_report (self->priv->context);
	_tmp27_ = vala_report_get_errors (_tmp26_);
	if (_tmp27_ > 0) {
		gint _tmp28_;
		_tmp28_ = vala_vapi_gen_quit (self);
		result = _tmp28_;
		return result;
	}
	{
		gchar** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			gchar* _tmp29_;
			gchar* source;
			_tmp29_ = g_strdup (source_collection[source_it]);
			source = _tmp29_;
			{
				gboolean _tmp30_;
				_tmp30_ = g_file_test (source, G_FILE_TEST_EXISTS);
				if (_tmp30_) {
					ValaSourceFile* _tmp31_ = NULL;
					ValaSourceFile* _tmp32_;
					_tmp31_ = vala_source_file_new (self->priv->context, VALA_SOURCE_FILE_TYPE_PACKAGE, source, NULL);
					_tmp32_ = _tmp31_;
					vala_code_context_add_source_file (self->priv->context, _tmp32_);
					_vala_source_file_unref0 (_tmp32_);
				} else {
					gchar* _tmp33_ = NULL;
					gchar* _tmp34_;
					_tmp33_ = g_strdup_printf ("%s not found", source);
					_tmp34_ = _tmp33_;
					vala_report_error (NULL, _tmp34_);
					_g_free0 (_tmp34_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp35_ = NULL;
	vala_vapi_gen_sources = (_vala_array_free (vala_vapi_gen_sources, _vala_array_length (vala_vapi_gen_sources), (GDestroyNotify) g_free), NULL);
	vala_vapi_gen_sources = _tmp35_;
	_tmp36_ = vala_code_context_get_report (self->priv->context);
	_tmp37_ = vala_report_get_errors (_tmp36_);
	if (_tmp37_ > 0) {
		gint _tmp38_;
		_tmp38_ = vala_vapi_gen_quit (self);
		result = _tmp38_;
		return result;
	}
	_tmp39_ = vala_parser_new ();
	parser = _tmp39_;
	vala_parser_parse (parser, self->priv->context);
	_tmp40_ = vala_code_context_get_report (self->priv->context);
	_tmp41_ = vala_report_get_errors (_tmp40_);
	if (_tmp41_ > 0) {
		gint _tmp42_;
		_tmp42_ = vala_vapi_gen_quit (self);
		result = _tmp42_;
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp43_ = vala_gir_parser_new ();
	girparser = _tmp43_;
	if (vala_vapi_gen_metadata_filename != NULL) {
		vala_gir_parser_parse_metadata (girparser, vala_vapi_gen_metadata_filename);
	}
	vala_gir_parser_parse (girparser, self->priv->context);
	_tmp44_ = vala_code_context_get_report (self->priv->context);
	_tmp45_ = vala_report_get_errors (_tmp44_);
	if (_tmp45_ > 0) {
		gint _tmp46_;
		_tmp46_ = vala_vapi_gen_quit (self);
		result = _tmp46_;
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp47_ = vala_gidl_parser_new ();
	gidlparser = _tmp47_;
	vala_gidl_parser_parse (gidlparser, self->priv->context);
	_tmp48_ = vala_code_context_get_report (self->priv->context);
	_tmp49_ = vala_report_get_errors (_tmp48_);
	if (_tmp49_ > 0) {
		gint _tmp50_;
		_tmp50_ = vala_vapi_gen_quit (self);
		result = _tmp50_;
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp51_ = vala_symbol_resolver_new ();
	resolver = _tmp51_;
	vala_symbol_resolver_resolve (resolver, self->priv->context);
	_tmp52_ = vala_code_context_get_report (self->priv->context);
	_tmp53_ = vala_report_get_errors (_tmp52_);
	if (_tmp53_ > 0) {
		gint _tmp54_;
		_tmp54_ = vala_vapi_gen_quit (self);
		result = _tmp54_;
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp55_ = vala_semantic_analyzer_new ();
	analyzer = _tmp55_;
	vala_semantic_analyzer_analyze (analyzer, self->priv->context);
	_tmp56_ = vala_code_context_get_report (self->priv->context);
	_tmp57_ = vala_report_get_errors (_tmp56_);
	if (_tmp57_ > 0) {
		gint _tmp58_;
		_tmp58_ = vala_vapi_gen_quit (self);
		result = _tmp58_;
		_vala_code_visitor_unref0 (analyzer);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (vala_vapi_gen_library == NULL) {
		gint _tmp60_;
		gchar** _tmp61_ = NULL;
		gchar** _tmp62_;
		gint _tmp62__length1;
		_tmp61_ = vala_gir_parser_get_package_names (girparser, &_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp62__length1 = _tmp60_;
		_tmp59_ = _tmp62_ != NULL;
		_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_free), NULL);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		gint _tmp63_;
		gchar** _tmp64_ = NULL;
		gint names_length1;
		gint _names_size_;
		gchar** _tmp65_;
		gchar** names;
		gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp64_ = vala_gir_parser_get_package_names (girparser, &_tmp63_);
		_tmp65_ = _tmp64_;
		names_length1 = _tmp63_;
		_names_size_ = names_length1;
		names = _tmp65_;
		if (names_length1 != 1) {
			gint _tmp66_;
			vala_report_error (NULL, "multiple packages encountered and no library name given");
			_tmp66_ = vala_vapi_gen_quit (self);
			result = _tmp66_;
			names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_visitor_unref0 (analyzer);
			_vala_code_visitor_unref0 (resolver);
			_vala_code_visitor_unref0 (gidlparser);
			_vala_code_visitor_unref0 (girparser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp67_ = g_strdup (names[0]);
		_tmp68_ = _tmp67_;
		_g_free0 (vala_vapi_gen_library);
		vala_vapi_gen_library = _tmp68_;
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	}
	if (vala_vapi_gen_library != NULL) {
		ValaCodeWriter* _tmp74_ = NULL;
		ValaCodeWriter* interface_writer;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_;
		gchar* _tmp77_;
		{
			ValaList* _tmp69_ = NULL;
			ValaList* _file_list;
			gint _tmp70_;
			gint _file_size;
			gint _file_index;
			_tmp69_ = vala_code_context_get_source_files (self->priv->context);
			_file_list = _tmp69_;
			_tmp70_ = vala_collection_get_size ((ValaCollection*) _file_list);
			_file_size = _tmp70_;
			_file_index = -1;
			while (TRUE) {
				gpointer _tmp71_ = NULL;
				ValaSourceFile* file;
				const gchar* _tmp72_ = NULL;
				gboolean _tmp73_;
				_file_index = _file_index + 1;
				if (!(_file_index < _file_size)) {
					break;
				}
				_tmp71_ = vala_list_get (_file_list, _file_index);
				file = (ValaSourceFile*) _tmp71_;
				_tmp72_ = vala_source_file_get_filename (file);
				_tmp73_ = g_str_has_suffix (_tmp72_, ".vapi");
				if (!_tmp73_) {
					vala_source_file_set_file_type (file, VALA_SOURCE_FILE_TYPE_SOURCE);
				}
				_vala_source_file_unref0 (file);
			}
			_vala_iterable_unref0 (_file_list);
		}
		_tmp74_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp74_;
		_tmp75_ = g_strdup_printf ("%s.vapi", vala_vapi_gen_library);
		_tmp76_ = _tmp75_;
		vala_code_writer_write_file (interface_writer, self->priv->context, _tmp76_);
		_g_free0 (_tmp76_);
		_tmp77_ = NULL;
		_g_free0 (vala_vapi_gen_library);
		vala_vapi_gen_library = _tmp77_;
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp78_ = vala_vapi_gen_quit (self);
	result = _tmp78_;
	_vala_code_visitor_unref0 (analyzer);
	_vala_code_visitor_unref0 (resolver);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static gint vala_vapi_gen_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* opt_context;
	ValaVAPIGen* _tmp1_ = NULL;
	ValaVAPIGen* vapigen;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("- Vala API Generator");
	opt_context = _tmp0_;
	g_option_context_set_help_enabled (opt_context, TRUE);
	g_option_context_add_main_entries (opt_context, VALA_VAPI_GEN_options, NULL);
	g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (opt_context);
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch2_g_option_error;
		}
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_g_option_context_free0 (opt_context);
	goto __finally2;
	__catch2_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (vala_vapi_gen_version) {
		fprintf (stdout, "Vala API Generator %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	if (vala_vapi_gen_sources == NULL) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp1_ = vala_vapi_gen_new ();
	vapigen = _tmp1_;
	_tmp2_ = vala_vapi_gen_run (vapigen);
	result = _tmp2_;
	_g_object_unref0 (vapigen);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_vapi_gen_main (argv, argc);
}


ValaVAPIGen* vala_vapi_gen_construct (GType object_type) {
	ValaVAPIGen * self = NULL;
	self = (ValaVAPIGen*) g_object_new (object_type, NULL);
	return self;
}


ValaVAPIGen* vala_vapi_gen_new (void) {
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}


static void vala_vapi_gen_class_init (ValaVAPIGenClass * klass) {
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_vapi_gen_finalize;
}


static void vala_vapi_gen_instance_init (ValaVAPIGen * self) {
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
}


static void vala_vapi_gen_finalize (GObject* obj) {
	ValaVAPIGen * self;
	self = VALA_VAPI_GEN (obj);
	_vala_code_context_unref0 (self->priv->context);
	G_OBJECT_CLASS (vala_vapi_gen_parent_class)->finalize (obj);
}


GType vala_vapi_gen_get_type (void) {
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, NULL };
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaVAPIGen", &g_define_type_info, 0);
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



