/* valaccodearraycreationexpressionbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODEARRAYCREATIONEXPRESSIONBINDING_H__
#define __GOBJECT_VALACCODEARRAYCREATIONEXPRESSIONBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodegenerator.h>
#include <vala/valaarraycreationexpression.h>
#include <gobject/valaccodeexpressionbinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_ARRAY_CREATION_EXPRESSION_BINDING (vala_ccode_array_creation_expression_binding_get_type ())
#define VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_CREATION_EXPRESSION_BINDING, ValaCCodeArrayCreationExpressionBinding))
#define VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_CREATION_EXPRESSION_BINDING, ValaCCodeArrayCreationExpressionBindingClass))
#define VALA_IS_CCODE_ARRAY_CREATION_EXPRESSION_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_CREATION_EXPRESSION_BINDING))
#define VALA_IS_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_CREATION_EXPRESSION_BINDING))
#define VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_CREATION_EXPRESSION_BINDING, ValaCCodeArrayCreationExpressionBindingClass))

typedef struct _ValaCCodeArrayCreationExpressionBinding ValaCCodeArrayCreationExpressionBinding;
typedef struct _ValaCCodeArrayCreationExpressionBindingClass ValaCCodeArrayCreationExpressionBindingClass;
typedef struct _ValaCCodeArrayCreationExpressionBindingPrivate ValaCCodeArrayCreationExpressionBindingPrivate;

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeArrayCreationExpressionBinding {
	ValaCCodeExpressionBinding parent_instance;
	ValaCCodeArrayCreationExpressionBindingPrivate * priv;
};
struct _ValaCCodeArrayCreationExpressionBindingClass {
	ValaCCodeExpressionBindingClass parent_class;
};

ValaCCodeArrayCreationExpressionBinding* vala_ccode_array_creation_expression_binding_new (ValaCodeGenerator* codegen, ValaArrayCreationExpression* array_creation_expression);
ValaArrayCreationExpression* vala_ccode_array_creation_expression_binding_get_array_creation_expression (ValaCCodeArrayCreationExpressionBinding* self);
void vala_ccode_array_creation_expression_binding_set_array_creation_expression (ValaCCodeArrayCreationExpressionBinding* self, ValaArrayCreationExpression* value);
GType vala_ccode_array_creation_expression_binding_get_type (void);


G_END_DECLS

#endif
