/* valaccodebreakstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodebreakstatement.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>




enum  {
	VALA_CCODE_BREAK_STATEMENT_DUMMY_PROPERTY
};
static void vala_ccode_break_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_break_statement_parent_class = NULL;



static void vala_ccode_break_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeBreakStatement * self;
	self = VALA_CCODE_BREAK_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
	vala_ccode_writer_write_string (writer, "break;");
	vala_ccode_writer_write_newline (writer);
}


/**
 * Represents a break statement in the C code.
 */
ValaCCodeBreakStatement* vala_ccode_break_statement_new (void) {
	ValaCCodeBreakStatement * self;
	self = g_object_newv (VALA_TYPE_CCODE_BREAK_STATEMENT, 0, NULL);
	return self;
}


static void vala_ccode_break_statement_class_init (ValaCCodeBreakStatementClass * klass) {
	vala_ccode_break_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_break_statement_real_write;
}


static void vala_ccode_break_statement_init (ValaCCodeBreakStatement * self) {
}


GType vala_ccode_break_statement_get_type (void) {
	static GType vala_ccode_break_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_break_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBreakStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_break_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBreakStatement), 0, (GInstanceInitFunc) vala_ccode_break_statement_init };
		vala_ccode_break_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeBreakStatement", &g_define_type_info, 0);
	}
	return vala_ccode_break_statement_type_id;
}




