/* valasignaltype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valasignaltype.h>




struct _ValaSignalTypePrivate {
	ValaSignal* _signal_symbol;
};
#define VALA_SIGNAL_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SIGNAL_TYPE, ValaSignalTypePrivate))
enum  {
	VALA_SIGNAL_TYPE_DUMMY_PROPERTY,
	VALA_SIGNAL_TYPE_SIGNAL_SYMBOL
};
static gboolean vala_signal_type_real_is_invokable (ValaDataType* base);
static ValaDataType* vala_signal_type_real_get_return_type (ValaDataType* base);
static GeeCollection* vala_signal_type_real_get_parameters (ValaDataType* base);
static ValaDataType* vala_signal_type_real_copy (ValaDataType* base);
static gpointer vala_signal_type_parent_class = NULL;
static void vala_signal_type_dispose (GObject * obj);



ValaSignalType* vala_signal_type_new (ValaSignal* signal_symbol) {
	ValaSignalType * self;
	g_return_val_if_fail (VALA_IS_SIGNAL (signal_symbol), NULL);
	self = g_object_newv (VALA_TYPE_SIGNAL_TYPE, 0, NULL);
	vala_signal_type_set_signal_symbol (self, signal_symbol);
	return self;
}


static gboolean vala_signal_type_real_is_invokable (ValaDataType* base) {
	ValaSignalType * self;
	self = VALA_SIGNAL_TYPE (base);
	return TRUE;
}


static ValaDataType* vala_signal_type_real_get_return_type (ValaDataType* base) {
	ValaSignalType * self;
	ValaDataType* _tmp0;
	self = VALA_SIGNAL_TYPE (base);
	_tmp0 = NULL;
	return (_tmp0 = vala_signal_get_return_type (self->priv->_signal_symbol), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


static GeeCollection* vala_signal_type_real_get_parameters (ValaDataType* base) {
	ValaSignalType * self;
	self = VALA_SIGNAL_TYPE (base);
	return GEE_COLLECTION (vala_signal_get_parameters (self->priv->_signal_symbol));
}


static ValaDataType* vala_signal_type_real_copy (ValaDataType* base) {
	ValaSignalType * self;
	self = VALA_SIGNAL_TYPE (base);
	return VALA_DATA_TYPE (vala_signal_type_new (self->priv->_signal_symbol));
}


ValaSignal* vala_signal_type_get_signal_symbol (ValaSignalType* self) {
	g_return_val_if_fail (VALA_IS_SIGNAL_TYPE (self), NULL);
	return self->priv->_signal_symbol;
}


void vala_signal_type_set_signal_symbol (ValaSignalType* self, ValaSignal* value) {
	ValaSignal* _tmp2;
	ValaSignal* _tmp1;
	g_return_if_fail (VALA_IS_SIGNAL_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_signal_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_signal_symbol == NULL ? NULL : (self->priv->_signal_symbol = (g_object_unref (self->priv->_signal_symbol), NULL))), _tmp2);
}


static void vala_signal_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaSignalType * self;
	self = VALA_SIGNAL_TYPE (object);
	switch (property_id) {
		case VALA_SIGNAL_TYPE_SIGNAL_SYMBOL:
		g_value_set_object (value, vala_signal_type_get_signal_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_signal_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaSignalType * self;
	self = VALA_SIGNAL_TYPE (object);
	switch (property_id) {
		case VALA_SIGNAL_TYPE_SIGNAL_SYMBOL:
		vala_signal_type_set_signal_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_signal_type_class_init (ValaSignalTypeClass * klass) {
	vala_signal_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSignalTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_signal_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_signal_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_signal_type_dispose;
	VALA_DATA_TYPE_CLASS (klass)->is_invokable = vala_signal_type_real_is_invokable;
	VALA_DATA_TYPE_CLASS (klass)->get_return_type = vala_signal_type_real_get_return_type;
	VALA_DATA_TYPE_CLASS (klass)->get_parameters = vala_signal_type_real_get_parameters;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_signal_type_real_copy;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SIGNAL_TYPE_SIGNAL_SYMBOL, g_param_spec_object ("signal-symbol", "signal-symbol", "signal-symbol", VALA_TYPE_SIGNAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_signal_type_init (ValaSignalType * self) {
	self->priv = VALA_SIGNAL_TYPE_GET_PRIVATE (self);
}


static void vala_signal_type_dispose (GObject * obj) {
	ValaSignalType * self;
	self = VALA_SIGNAL_TYPE (obj);
	(self->priv->_signal_symbol == NULL ? NULL : (self->priv->_signal_symbol = (g_object_unref (self->priv->_signal_symbol), NULL)));
	G_OBJECT_CLASS (vala_signal_type_parent_class)->dispose (obj);
}


GType vala_signal_type_get_type (void) {
	static GType vala_signal_type_type_id = 0;
	if (G_UNLIKELY (vala_signal_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSignalTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignalType), 0, (GInstanceInitFunc) vala_signal_type_init };
		vala_signal_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaSignalType", &g_define_type_info, 0);
	}
	return vala_signal_type_type_id;
}




