/* valainterfaceinstancetype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAINTERFACEINSTANCETYPE_H__
#define __VALA_VALAINTERFACEINSTANCETYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valareferencetype.h>
#include <vala/valainterface.h>
#include <vala/valadatatype.h>

G_BEGIN_DECLS


#define VALA_TYPE_INTERFACE_INSTANCE_TYPE (vala_interface_instance_type_get_type ())
#define VALA_INTERFACE_INSTANCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE_INSTANCE_TYPE, ValaInterfaceInstanceType))
#define VALA_INTERFACE_INSTANCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE_INSTANCE_TYPE, ValaInterfaceInstanceTypeClass))
#define VALA_IS_INTERFACE_INSTANCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE_INSTANCE_TYPE))
#define VALA_IS_INTERFACE_INSTANCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE_INSTANCE_TYPE))
#define VALA_INTERFACE_INSTANCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE_INSTANCE_TYPE, ValaInterfaceInstanceTypeClass))

typedef struct _ValaInterfaceInstanceType ValaInterfaceInstanceType;
typedef struct _ValaInterfaceInstanceTypeClass ValaInterfaceInstanceTypeClass;
typedef struct _ValaInterfaceInstanceTypePrivate ValaInterfaceInstanceTypePrivate;

/**
 * An interface type.
 */
struct _ValaInterfaceInstanceType {
	ValaReferenceType parent_instance;
	ValaInterfaceInstanceTypePrivate * priv;
};

struct _ValaInterfaceInstanceTypeClass {
	ValaReferenceTypeClass parent_class;
};


ValaInterfaceInstanceType* vala_interface_instance_type_new (ValaInterface* interface_symbol);
ValaInterface* vala_interface_instance_type_get_interface_symbol (ValaInterfaceInstanceType* self);
void vala_interface_instance_type_set_interface_symbol (ValaInterfaceInstanceType* self, ValaInterface* value);
GType vala_interface_instance_type_get_type (void);


G_END_DECLS

#endif
