/* valaccodedynamicmethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodedynamicmethodbinding.h>
#include <ccode/valaccodefunction.h>
#include <vala/valamethod.h>
#include <vala/valadatatype.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeblock.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <vala/valainvocationexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <vala/valaunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodeunaryexpression.h>
#include <gee/collection.h>
#include <vala/valaformalparameter.h>
#include <vala/valaarraytype.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valavoidtype.h>
#include <vala/valamethodtype.h>
#include <vala/valastruct.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodereturnstatement.h>
#include <gobject/valaccodegenerator.h>




enum  {
	VALA_CCODE_DYNAMIC_METHOD_BINDING_DUMMY_PROPERTY
};
static void vala_ccode_dynamic_method_binding_generate_dbus_method_wrapper (ValaCCodeDynamicMethodBinding* self, ValaCCodeBlock* block);
static ValaCCodeExpression* vala_ccode_dynamic_method_binding_get_dbus_array_type (ValaCCodeDynamicMethodBinding* self, ValaArrayType* array_type);
static gpointer vala_ccode_dynamic_method_binding_parent_class = NULL;



ValaCCodeDynamicMethodBinding* vala_ccode_dynamic_method_binding_new (ValaCCodeGenerator* codegen, ValaDynamicMethod* method) {
	ValaCCodeDynamicMethodBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_DYNAMIC_METHOD (method), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_DYNAMIC_METHOD_BINDING, 0, NULL);
	vala_ccode_method_binding_set_method (VALA_CCODE_METHOD_BINDING (self), VALA_METHOD (method));
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


void vala_ccode_dynamic_method_binding_generate_wrapper (ValaCCodeDynamicMethodBinding* self) {
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* func;
	GeeHashMap* cparam_map;
	char* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* instance_param;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp8;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_METHOD_BINDING (self));
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	func = (_tmp3 = vala_ccode_function_new ((_tmp1 = vala_method_get_cname (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))), (_tmp2 = vala_data_type_get_cname (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), _tmp3);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp4 = NULL;
	_tmp5 = NULL;
	instance_param = (_tmp5 = vala_ccode_formal_parameter_new ("obj", (_tmp4 = vala_data_type_get_cname (vala_dynamic_method_get_dynamic_type (dynamic_method)))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
	gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), FALSE)), instance_param);
	vala_ccode_method_binding_generate_cparameters (VALA_CCODE_METHOD_BINDING (self), vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)), vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), GEE_MAP (cparam_map), func, NULL);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_method_get_dynamic_type (dynamic_method)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_object_type) {
		vala_ccode_dynamic_method_binding_generate_dbus_method_wrapper (self, block);
	} else {
		char* _tmp7;
		char* _tmp6;
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))), (_tmp7 = g_strdup_printf ("dynamic methods are not supported for `%s'", (_tmp6 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_method_get_dynamic_type (dynamic_method)))))));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp6 = (g_free (_tmp6), NULL);
	}
	/* append to C source file*/
	_tmp8 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp8 = vala_ccode_function_copy (func))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
	(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
	(func == NULL ? NULL : (func = (g_object_unref (func), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
}


static void vala_ccode_dynamic_method_binding_generate_dbus_method_wrapper (ValaCCodeDynamicMethodBinding* self, ValaCCodeBlock* block) {
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	ValaInvocationExpression* _tmp1;
	ValaInvocationExpression* expr;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp4;
	gboolean found_out;
	ValaExpression* callback;
	gint callback_index;
	gint arg_index;
	ValaCCodeConstant* _tmp8;
	char* _tmp7;
	ValaCCodeIdentifier* _tmp99;
	ValaCCodeFragment* out_marshalling_fragment;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	expr = (_tmp1 = vala_dynamic_method_get_invocation (dynamic_method), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	_tmp3 = NULL;
	ccall = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("dbus_g_proxy_begin_call")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("obj"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	found_out = FALSE;
	callback = NULL;
	callback_index = -1;
	arg_index = 1;
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
					ValaExpression* _tmp6;
					ValaExpression* _tmp5;
					/* callback*/
					if (callback != NULL) {
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "only one reply callback may be specified in invocation of DBus method");
						vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
						(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
						(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
						(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
						return;
					} else {
						if (found_out) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "out argument and reply callback conflict in invocation of DBus method");
							vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
							return;
						}
					}
					_tmp6 = NULL;
					_tmp5 = NULL;
					callback = (_tmp6 = (_tmp5 = arg, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL))), _tmp6);
					callback_index = arg_index;
				} else {
					if (VALA_IS_UNARY_EXPRESSION (arg) && vala_unary_expression_get_operator ((VALA_UNARY_EXPRESSION (arg))) == VALA_UNARY_OPERATOR_OUT) {
						/* out arg*/
						if (callback != NULL) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "out argument and reply callback conflict in invocation of DBus method");
							vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
							return;
						}
						found_out = TRUE;
					} else {
						/* in arg*/
						if (callback != NULL || found_out) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "in argument must not follow out argument or reply callback in invocation of DBus method");
							vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
							return;
						}
					}
				}
				arg_index++;
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
	}
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ((_tmp7 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (VALA_SYMBOL (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp7 = (g_free (_tmp7), NULL);
	if (callback != NULL) {
		ValaMethod* _tmp9;
		ValaMethod* reply_method;
		char* _tmp11;
		char* _tmp10;
		ValaCCodeFunction* _tmp12;
		ValaCCodeFunction* cb_fun;
		ValaCCodeFormalParameter* _tmp13;
		ValaCCodeFormalParameter* _tmp14;
		ValaCCodeFormalParameter* _tmp15;
		ValaCCodeBlock* _tmp16;
		ValaCCodeDeclaration* cerrdecl;
		ValaCCodeVariableDeclarator* _tmp18;
		ValaCCodeConstant* _tmp17;
		ValaCCodeIdentifier* _tmp19;
		ValaCCodeFunctionCall* _tmp20;
		ValaCCodeFunctionCall* cend_call;
		ValaCCodeIdentifier* _tmp21;
		ValaCCodeIdentifier* _tmp22;
		ValaCCodeUnaryExpression* _tmp24;
		ValaCCodeIdentifier* _tmp23;
		ValaCCodeFunctionCall* creply_call;
		ValaCCodeIdentifier* _tmp25;
		GeeList* _tmp26;
		gint _tmp27;
		gint param_count;
		gint i;
		ValaCCodeIdentifier* _tmp49;
		ValaCCodeExpressionStatement* _tmp50;
		ValaCCodeIdentifier* _tmp51;
		ValaCCodeExpressionStatement* _tmp52;
		ValaCCodeIdentifier* _tmp53;
		ValaCCodeConstant* _tmp55;
		char* _tmp54;
		ValaCCodeConstant* _tmp56;
		_tmp9 = NULL;
		reply_method = (_tmp9 = VALA_METHOD (vala_expression_get_symbol_reference (callback)), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp12 = NULL;
		cb_fun = (_tmp12 = vala_ccode_function_new ((_tmp11 = g_strdup_printf ("_%s_cb", (_tmp10 = vala_method_get_cname (reply_method)))), "void"), (_tmp11 = (g_free (_tmp11), NULL)), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
		vala_ccode_function_set_modifiers (cb_fun, VALA_CCODE_MODIFIERS_STATIC);
		_tmp13 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp13 = vala_ccode_formal_parameter_new ("proxy", "DBusGProxy*")));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp14 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp14 = vala_ccode_formal_parameter_new ("call", "DBusGProxyCall*")));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		_tmp15 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp15 = vala_ccode_formal_parameter_new ("user_data", "void*")));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		_tmp16 = NULL;
		vala_ccode_function_set_block (cb_fun, (_tmp16 = vala_ccode_block_new ()));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		cerrdecl = vala_ccode_declaration_new ("GError*");
		_tmp18 = NULL;
		_tmp17 = NULL;
		vala_ccode_declaration_add_declarator (cerrdecl, VALA_CCODE_DECLARATOR ((_tmp18 = vala_ccode_variable_declarator_new_with_initializer ("error", VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("NULL")))))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
		(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cerrdecl));
		_tmp19 = NULL;
		_tmp20 = NULL;
		cend_call = (_tmp20 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("dbus_g_proxy_end_call")))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), _tmp20);
		_tmp21 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ("proxy"))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		_tmp22 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("call"))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		_tmp24 = NULL;
		_tmp23 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("error")))))));
		(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
		(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
		creply_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (callback))));
		_tmp25 = NULL;
		vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("user_data"))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		_tmp26 = NULL;
		param_count = (_tmp27 = gee_collection_get_size (GEE_COLLECTION ((_tmp26 = vala_method_get_parameters (reply_method)))), (_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL))), _tmp27);
		i = 0;
		{
			GeeList* param_collection;
			int param_it;
			param_collection = vala_method_get_parameters (reply_method);
			for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
				{
					if (((i = i + 1)) == param_count) {
						/* error parameter*/
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						break;
					}
					if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
						ValaArrayType* _tmp28;
						ValaArrayType* array_type;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp29;
						ValaCCodeExpression* _tmp30;
						ValaCCodeUnaryExpression* _tmp32;
						ValaCCodeIdentifier* _tmp31;
						ValaCCodeMemberAccess* _tmp34;
						ValaCCodeIdentifier* _tmp33;
						ValaCCodeMemberAccess* _tmp36;
						ValaCCodeIdentifier* _tmp35;
						_tmp28 = NULL;
						array_type = (_tmp28 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp28 == NULL ? NULL : g_object_ref (_tmp28)));
						cdecl_ = vala_ccode_declaration_new ("GArray*");
						_tmp29 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp29 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
						vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
						_tmp30 = NULL;
						vala_ccode_function_call_add_argument (cend_call, (_tmp30 = vala_ccode_dynamic_method_binding_get_dbus_array_type (self, array_type)));
						(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
						_tmp32 = NULL;
						_tmp31 = NULL;
						vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
						(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
						(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
						_tmp34 = NULL;
						_tmp33 = NULL;
						vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), "data"))));
						(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
						(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
						_tmp36 = NULL;
						_tmp35 = NULL;
						vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), "len"))));
						(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
						(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
						(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					} else {
						char* _tmp37;
						ValaCCodeDeclaration* _tmp38;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp39;
						ValaCCodeUnaryExpression* _tmp44;
						ValaCCodeIdentifier* _tmp43;
						ValaCCodeIdentifier* _tmp45;
						_tmp37 = NULL;
						_tmp38 = NULL;
						cdecl_ = (_tmp38 = vala_ccode_declaration_new ((_tmp37 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)))), (_tmp37 = (g_free (_tmp37), NULL)), _tmp38);
						_tmp39 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp39 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
						vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
						if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
							ValaCCodeIdentifier* _tmp40;
							/* special case string array*/
							_tmp40 = NULL;
							vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("G_TYPE_STRV"))));
							(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
						} else {
							ValaCCodeIdentifier* _tmp42;
							char* _tmp41;
							_tmp42 = NULL;
							_tmp41 = NULL;
							vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_identifier_new ((_tmp41 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))))));
							(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
							_tmp41 = (g_free (_tmp41), NULL);
						}
						_tmp44 = NULL;
						_tmp43 = NULL;
						vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
						(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
						(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
						_tmp45 = NULL;
						vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
						if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
							ValaCCodeIdentifier* _tmp46;
							ValaCCodeFunctionCall* _tmp47;
							ValaCCodeFunctionCall* cstrvlen;
							ValaCCodeIdentifier* _tmp48;
							_tmp46 = NULL;
							_tmp47 = NULL;
							cstrvlen = (_tmp47 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL))), _tmp47);
							_tmp48 = NULL;
							vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
							(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
							vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION (cstrvlen));
							(cstrvlen == NULL ? NULL : (cstrvlen = (g_object_unref (cstrvlen), NULL)));
						}
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		}
		_tmp49 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
		(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
		_tmp50 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp50 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cend_call)))));
		(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
		_tmp51 = NULL;
		vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ("error"))));
		(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
		_tmp52 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp52 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (creply_call)))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (cb_fun));
		_tmp53 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new (vala_ccode_function_get_name (cb_fun)))));
		(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
		_tmp55 = NULL;
		_tmp54 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_constant_new ((_tmp54 = g_strdup_printf ("param%d_target", callback_index))))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
		_tmp54 = (g_free (_tmp54), NULL);
		_tmp56 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_constant_new ("NULL"))));
		(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
		(reply_method == NULL ? NULL : (reply_method = (g_object_unref (reply_method), NULL)));
		(cb_fun == NULL ? NULL : (cb_fun = (g_object_unref (cb_fun), NULL)));
		(cerrdecl == NULL ? NULL : (cerrdecl = (g_object_unref (cerrdecl), NULL)));
		(cend_call == NULL ? NULL : (cend_call = (g_object_unref (cend_call), NULL)));
		(creply_call == NULL ? NULL : (creply_call = (g_object_unref (creply_call), NULL)));
	} else {
		if (found_out || !(VALA_IS_VOID_TYPE (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))) {
			ValaCCodeIdentifier* _tmp57;
			ValaCCodeIdentifier* _tmp58;
			_tmp57 = NULL;
			vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("dbus_g_proxy_call"))));
			(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
			_tmp58 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_identifier_new ("error"))));
			(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
		} else {
			ValaCCodeIdentifier* _tmp59;
			_tmp59 = NULL;
			vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("dbus_g_proxy_call_no_reply"))));
			(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
		}
	}
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)));
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp60;
				gboolean _tmp61;
				if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					/* callback parameter*/
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					continue;
				}
				_tmp60 = NULL;
				if ((_tmp61 = g_str_has_prefix ((_tmp60 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp60 = (g_free (_tmp60), NULL)), _tmp61)) {
					ValaStruct* _tmp62;
					ValaStruct* st;
					ValaCCodeIdentifier* _tmp63;
					ValaCCodeFunctionCall* _tmp64;
					ValaCCodeFunctionCall* array_construct;
					ValaCCodeConstant* _tmp65;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp67;
					char* _tmp66;
					ValaCCodeIdentifier* _tmp68;
					ValaCCodeFunctionCall* _tmp69;
					ValaCCodeFunctionCall* type_call;
					ValaCCodeConstant* _tmp70;
					ValaCCodeConstant* _tmp93;
					ValaCCodeIdentifier* _tmp95;
					char* _tmp94;
					/* struct parameter*/
					_tmp62 = NULL;
					st = (_tmp62 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp62 == NULL ? NULL : g_object_ref (_tmp62)));
					_tmp63 = NULL;
					_tmp64 = NULL;
					array_construct = (_tmp64 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_identifier_new ("g_value_array_new")))), (_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL))), _tmp64);
					_tmp65 = NULL;
					vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_constant_new ("0"))));
					(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
					cdecl_ = vala_ccode_declaration_new ("GValueArray*");
					_tmp67 = NULL;
					_tmp66 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp67 = vala_ccode_variable_declarator_new_with_initializer ((_tmp66 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))), VALA_CCODE_EXPRESSION (array_construct)))));
					(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
					_tmp66 = (g_free (_tmp66), NULL);
					vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
					_tmp68 = NULL;
					_tmp69 = NULL;
					type_call = (_tmp69 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new ("dbus_g_type_get_struct")))), (_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL))), _tmp69);
					_tmp70 = NULL;
					vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_constant_new ("\"GValueArray\""))));
					(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
					{
						GeeList* f_collection;
						int f_it;
						f_collection = vala_struct_get_fields (st);
						for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
							ValaField* f;
							f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
							{
								char* val_name;
								ValaCCodeInitializerList* cvalinit;
								ValaCCodeConstant* _tmp71;
								ValaCCodeDeclaration* cval_decl;
								ValaCCodeVariableDeclarator* _tmp72;
								ValaCCodeIdentifier* _tmp73;
								ValaCCodeUnaryExpression* _tmp74;
								ValaCCodeUnaryExpression* val_ptr;
								ValaCCodeIdentifier* _tmp75;
								ValaCCodeFunctionCall* _tmp76;
								ValaCCodeFunctionCall* cinit_call;
								ValaCCodeIdentifier* _tmp78;
								char* _tmp77;
								ValaCCodeExpressionStatement* _tmp79;
								ValaCCodeIdentifier* _tmp81;
								char* _tmp80;
								ValaCCodeFunctionCall* _tmp82;
								ValaCCodeFunctionCall* cset_call;
								ValaCCodeMemberAccess* _tmp84;
								ValaCCodeIdentifier* _tmp83;
								ValaCCodeExpressionStatement* _tmp85;
								ValaCCodeIdentifier* _tmp86;
								ValaCCodeFunctionCall* _tmp87;
								ValaCCodeFunctionCall* cappend_call;
								ValaCCodeIdentifier* _tmp89;
								char* _tmp88;
								ValaCCodeExpressionStatement* _tmp90;
								ValaCCodeIdentifier* _tmp92;
								char* _tmp91;
								if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
									(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
									continue;
								}
								val_name = g_strdup_printf ("val_%s_%s", vala_symbol_get_name (VALA_SYMBOL (param)), vala_symbol_get_name (VALA_SYMBOL (f)));
								/* 0-initialize struct with struct initializer { 0 }*/
								cvalinit = vala_ccode_initializer_list_new ();
								_tmp71 = NULL;
								vala_ccode_initializer_list_append (cvalinit, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_constant_new ("0"))));
								(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
								cval_decl = vala_ccode_declaration_new ("GValue");
								_tmp72 = NULL;
								vala_ccode_declaration_add_declarator (cval_decl, VALA_CCODE_DECLARATOR ((_tmp72 = vala_ccode_variable_declarator_new_with_initializer (val_name, VALA_CCODE_EXPRESSION (cvalinit)))));
								(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cval_decl));
								_tmp73 = NULL;
								_tmp74 = NULL;
								val_ptr = (_tmp74 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new (val_name)))), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), _tmp74);
								_tmp75 = NULL;
								_tmp76 = NULL;
								cinit_call = (_tmp76 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new ("g_value_init")))), (_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL))), _tmp76);
								vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION (val_ptr));
								_tmp78 = NULL;
								_tmp77 = NULL;
								vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_identifier_new ((_tmp77 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
								(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
								_tmp77 = (g_free (_tmp77), NULL);
								_tmp79 = NULL;
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp79 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit_call)))));
								(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
								_tmp81 = NULL;
								_tmp80 = NULL;
								_tmp82 = NULL;
								cset_call = (_tmp82 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new ((_tmp80 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))), (_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL))), (_tmp80 = (g_free (_tmp80), NULL)), _tmp82);
								vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION (val_ptr));
								_tmp84 = NULL;
								_tmp83 = NULL;
								vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), vala_symbol_get_name (VALA_SYMBOL (f))))));
								(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
								(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
								_tmp85 = NULL;
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp85 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cset_call)))));
								(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
								_tmp86 = NULL;
								_tmp87 = NULL;
								cappend_call = (_tmp87 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new ("g_value_array_append")))), (_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL))), _tmp87);
								_tmp89 = NULL;
								_tmp88 = NULL;
								vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ((_tmp88 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))));
								(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
								_tmp88 = (g_free (_tmp88), NULL);
								vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION (val_ptr));
								_tmp90 = NULL;
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp90 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cappend_call)))));
								(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
								_tmp92 = NULL;
								_tmp91 = NULL;
								vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_identifier_new ((_tmp91 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
								(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
								_tmp91 = (g_free (_tmp91), NULL);
								(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
								val_name = (g_free (val_name), NULL);
								(cvalinit == NULL ? NULL : (cvalinit = (g_object_unref (cvalinit), NULL)));
								(cval_decl == NULL ? NULL : (cval_decl = (g_object_unref (cval_decl), NULL)));
								(val_ptr == NULL ? NULL : (val_ptr = (g_object_unref (val_ptr), NULL)));
								(cinit_call == NULL ? NULL : (cinit_call = (g_object_unref (cinit_call), NULL)));
								(cset_call == NULL ? NULL : (cset_call = (g_object_unref (cset_call), NULL)));
								(cappend_call == NULL ? NULL : (cappend_call = (g_object_unref (cappend_call), NULL)));
							}
						}
						(f_collection == NULL ? NULL : (f_collection = (g_object_unref (f_collection), NULL)));
					}
					_tmp93 = NULL;
					vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_constant_new ("G_TYPE_INVALID"))));
					(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (type_call));
					_tmp95 = NULL;
					_tmp94 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_identifier_new ((_tmp94 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))));
					(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
					_tmp94 = (g_free (_tmp94), NULL);
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					(array_construct == NULL ? NULL : (array_construct = (g_object_unref (array_construct), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					(type_call == NULL ? NULL : (type_call = (g_object_unref (type_call), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp97;
					char* _tmp96;
					ValaCCodeIdentifier* _tmp98;
					_tmp97 = NULL;
					_tmp96 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp97 = vala_ccode_identifier_new ((_tmp96 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))))));
					(_tmp97 == NULL ? NULL : (_tmp97 = (g_object_unref (_tmp97), NULL)));
					_tmp96 = (g_free (_tmp96), NULL);
					_tmp98 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp98 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
					(_tmp98 == NULL ? NULL : (_tmp98 = (g_object_unref (_tmp98), NULL)));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
	}
	_tmp99 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp99 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp99 == NULL ? NULL : (_tmp99 = (g_object_unref (_tmp99), NULL)));
	out_marshalling_fragment = vala_ccode_fragment_new ();
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)));
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp100;
				gboolean _tmp101;
				if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					/* callback parameter*/
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					continue;
				}
				_tmp100 = NULL;
				if ((_tmp101 = g_str_has_prefix ((_tmp100 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp100 = (g_free (_tmp100), NULL)), _tmp101)) {
					ValaStruct* _tmp102;
					ValaStruct* st;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp104;
					char* _tmp103;
					ValaCCodeIdentifier* _tmp105;
					ValaCCodeFunctionCall* _tmp106;
					ValaCCodeFunctionCall* type_call;
					ValaCCodeConstant* _tmp107;
					gint i;
					ValaCCodeConstant* _tmp124;
					ValaCCodeUnaryExpression* _tmp127;
					ValaCCodeIdentifier* _tmp126;
					char* _tmp125;
					/* struct output parameter*/
					_tmp102 = NULL;
					st = (_tmp102 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp102 == NULL ? NULL : g_object_ref (_tmp102)));
					cdecl_ = vala_ccode_declaration_new ("GValueArray*");
					_tmp104 = NULL;
					_tmp103 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp104 = vala_ccode_variable_declarator_new ((_tmp103 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))));
					(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
					_tmp103 = (g_free (_tmp103), NULL);
					vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
					_tmp105 = NULL;
					_tmp106 = NULL;
					type_call = (_tmp106 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_identifier_new ("dbus_g_type_get_struct")))), (_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL))), _tmp106);
					_tmp107 = NULL;
					vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_constant_new ("\"GValueArray\""))));
					(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
					i = 0;
					{
						GeeList* f_collection;
						int f_it;
						f_collection = vala_struct_get_fields (st);
						for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
							ValaField* f;
							f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
							{
								ValaCCodeIdentifier* _tmp109;
								char* _tmp108;
								ValaCCodeFunctionCall* _tmp110;
								ValaCCodeFunctionCall* cget_call;
								ValaCCodeUnaryExpression* _tmp117;
								ValaCCodeElementAccess* _tmp116;
								ValaCCodeConstant* _tmp115;
								char* _tmp114;
								ValaCCodeMemberAccess* _tmp113;
								ValaCCodeIdentifier* _tmp112;
								char* _tmp111;
								ValaCCodeMemberAccess* _tmp119;
								ValaCCodeIdentifier* _tmp118;
								ValaCCodeAssignment* _tmp120;
								ValaCCodeAssignment* assign;
								ValaCCodeExpressionStatement* _tmp121;
								ValaCCodeIdentifier* _tmp123;
								char* _tmp122;
								if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
									(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
									continue;
								}
								_tmp109 = NULL;
								_tmp108 = NULL;
								_tmp110 = NULL;
								cget_call = (_tmp110 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_identifier_new ((_tmp108 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))), (_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL))), (_tmp108 = (g_free (_tmp108), NULL)), _tmp110);
								_tmp117 = NULL;
								_tmp116 = NULL;
								_tmp115 = NULL;
								_tmp114 = NULL;
								_tmp113 = NULL;
								_tmp112 = NULL;
								_tmp111 = NULL;
								vala_ccode_function_call_add_argument (cget_call, VALA_CCODE_EXPRESSION ((_tmp117 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp116 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp113 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp112 = vala_ccode_identifier_new ((_tmp111 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "values"))), VALA_CCODE_EXPRESSION ((_tmp115 = vala_ccode_constant_new ((_tmp114 = g_strdup_printf ("%i", i))))))))))));
								(_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL)));
								(_tmp116 == NULL ? NULL : (_tmp116 = (g_object_unref (_tmp116), NULL)));
								(_tmp115 == NULL ? NULL : (_tmp115 = (g_object_unref (_tmp115), NULL)));
								_tmp114 = (g_free (_tmp114), NULL);
								(_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL)));
								(_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL)));
								_tmp111 = (g_free (_tmp111), NULL);
								_tmp119 = NULL;
								_tmp118 = NULL;
								_tmp120 = NULL;
								assign = (_tmp120 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp119 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp118 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), vala_symbol_get_name (VALA_SYMBOL (f))))), VALA_CCODE_EXPRESSION (cget_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp119 == NULL ? NULL : (_tmp119 = (g_object_unref (_tmp119), NULL))), (_tmp118 == NULL ? NULL : (_tmp118 = (g_object_unref (_tmp118), NULL))), _tmp120);
								_tmp121 = NULL;
								vala_ccode_fragment_append (out_marshalling_fragment, VALA_CCODE_NODE ((_tmp121 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
								(_tmp121 == NULL ? NULL : (_tmp121 = (g_object_unref (_tmp121), NULL)));
								_tmp123 = NULL;
								_tmp122 = NULL;
								vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp123 = vala_ccode_identifier_new ((_tmp122 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
								(_tmp123 == NULL ? NULL : (_tmp123 = (g_object_unref (_tmp123), NULL)));
								_tmp122 = (g_free (_tmp122), NULL);
								i++;
								(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
								(cget_call == NULL ? NULL : (cget_call = (g_object_unref (cget_call), NULL)));
								(assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL)));
							}
						}
						(f_collection == NULL ? NULL : (f_collection = (g_object_unref (f_collection), NULL)));
					}
					_tmp124 = NULL;
					vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_constant_new ("G_TYPE_INVALID"))));
					(_tmp124 == NULL ? NULL : (_tmp124 = (g_object_unref (_tmp124), NULL)));
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (type_call));
					_tmp127 = NULL;
					_tmp126 = NULL;
					_tmp125 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_identifier_new ((_tmp125 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))))))))));
					(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
					(_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL)));
					_tmp125 = (g_free (_tmp125), NULL);
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					(type_call == NULL ? NULL : (type_call = (g_object_unref (type_call), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp129;
					char* _tmp128;
					ValaCCodeUnaryExpression* _tmp131;
					ValaCCodeIdentifier* _tmp130;
					_tmp129 = NULL;
					_tmp128 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_identifier_new ((_tmp128 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))))));
					(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
					_tmp128 = (g_free (_tmp128), NULL);
					_tmp131 = NULL;
					_tmp130 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp131 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp130 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
					(_tmp131 == NULL ? NULL : (_tmp131 = (g_object_unref (_tmp131), NULL)));
					(_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL)));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))) {
		ValaArrayType* _tmp133;
		ValaDataType* _tmp132;
		ValaArrayType* array_type;
		/* synchronous D-Bus method call with reply*/
		_tmp133 = NULL;
		_tmp132 = NULL;
		array_type = (_tmp133 = (_tmp132 = vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), (VALA_IS_ARRAY_TYPE (_tmp132) ? ((ValaArrayType*) (_tmp132)) : NULL)), (_tmp133 == NULL ? NULL : g_object_ref (_tmp133)));
		if (array_type != NULL && vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
			ValaCCodeExpression* _tmp134;
			ValaDataType* garray_type_reference;
			char* _tmp135;
			ValaCCodeDeclaration* _tmp136;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp137;
			ValaCCodeUnaryExpression* _tmp139;
			ValaCCodeIdentifier* _tmp138;
			ValaCCodeIdentifier* _tmp140;
			ValaCCodeExpressionStatement* _tmp141;
			ValaCCodeIdentifier* _tmp142;
			ValaCCodeMemberAccess* _tmp143;
			ValaCCodeMemberAccess* garray_length;
			ValaCCodeIdentifier* _tmp144;
			ValaCCodeUnaryExpression* _tmp145;
			ValaCCodeUnaryExpression* result_length;
			ValaCCodeAssignment* assign;
			ValaCCodeExpressionStatement* _tmp146;
			ValaCCodeReturnStatement* _tmp149;
			ValaCCodeMemberAccess* _tmp148;
			ValaCCodeIdentifier* _tmp147;
			/* non-string arrays (use GArray)*/
			_tmp134 = NULL;
			vala_ccode_function_call_add_argument (ccall, (_tmp134 = vala_ccode_dynamic_method_binding_get_dbus_array_type (self, array_type)));
			(_tmp134 == NULL ? NULL : (_tmp134 = (g_object_unref (_tmp134), NULL)));
			garray_type_reference = vala_ccode_generator_get_data_type_for_symbol (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->garray_type);
			_tmp135 = NULL;
			_tmp136 = NULL;
			cdecl_ = (_tmp136 = vala_ccode_declaration_new ((_tmp135 = vala_data_type_get_cname (garray_type_reference))), (_tmp135 = (g_free (_tmp135), NULL)), _tmp136);
			_tmp137 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp137 = vala_ccode_variable_declarator_new ("result"))));
			(_tmp137 == NULL ? NULL : (_tmp137 = (g_object_unref (_tmp137), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
			_tmp139 = NULL;
			_tmp138 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp139 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp138 = vala_ccode_identifier_new ("result")))))));
			(_tmp139 == NULL ? NULL : (_tmp139 = (g_object_unref (_tmp139), NULL)));
			(_tmp138 == NULL ? NULL : (_tmp138 = (g_object_unref (_tmp138), NULL)));
			_tmp140 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp140 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
			(_tmp140 == NULL ? NULL : (_tmp140 = (g_object_unref (_tmp140), NULL)));
			_tmp141 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp141 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp141 == NULL ? NULL : (_tmp141 = (g_object_unref (_tmp141), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (out_marshalling_fragment));
			/* *result_length1 = result->len;*/
			_tmp142 = NULL;
			_tmp143 = NULL;
			garray_length = (_tmp143 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp142 = vala_ccode_identifier_new ("result"))), "len"), (_tmp142 == NULL ? NULL : (_tmp142 = (g_object_unref (_tmp142), NULL))), _tmp143);
			_tmp144 = NULL;
			_tmp145 = NULL;
			result_length = (_tmp145 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp144 = vala_ccode_identifier_new ("result_length1")))), (_tmp144 == NULL ? NULL : (_tmp144 = (g_object_unref (_tmp144), NULL))), _tmp145);
			assign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (result_length), VALA_CCODE_EXPRESSION (garray_length), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_tmp146 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp146 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
			(_tmp146 == NULL ? NULL : (_tmp146 = (g_object_unref (_tmp146), NULL)));
			/* return result->data;*/
			_tmp149 = NULL;
			_tmp148 = NULL;
			_tmp147 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp149 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp148 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp147 = vala_ccode_identifier_new ("result"))), "data")))))));
			(_tmp149 == NULL ? NULL : (_tmp149 = (g_object_unref (_tmp149), NULL)));
			(_tmp148 == NULL ? NULL : (_tmp148 = (g_object_unref (_tmp148), NULL)));
			(_tmp147 == NULL ? NULL : (_tmp147 = (g_object_unref (_tmp147), NULL)));
			(garray_type_reference == NULL ? NULL : (garray_type_reference = (g_object_unref (garray_type_reference), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(garray_length == NULL ? NULL : (garray_length = (g_object_unref (garray_length), NULL)));
			(result_length == NULL ? NULL : (result_length = (g_object_unref (result_length), NULL)));
			(assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL)));
		} else {
			char* _tmp153;
			ValaCCodeDeclaration* _tmp154;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp155;
			ValaCCodeUnaryExpression* _tmp157;
			ValaCCodeIdentifier* _tmp156;
			ValaCCodeIdentifier* _tmp158;
			ValaCCodeExpressionStatement* _tmp159;
			ValaCCodeReturnStatement* _tmp167;
			ValaCCodeIdentifier* _tmp166;
			/* string arrays or other datatypes*/
			if (VALA_IS_ARRAY_TYPE (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))) {
				ValaCCodeIdentifier* _tmp150;
				/* string arrays*/
				_tmp150 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp150 = vala_ccode_identifier_new ("G_TYPE_STRV"))));
				(_tmp150 == NULL ? NULL : (_tmp150 = (g_object_unref (_tmp150), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp152;
				char* _tmp151;
				/* other types*/
				_tmp152 = NULL;
				_tmp151 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp152 = vala_ccode_identifier_new ((_tmp151 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))))))));
				(_tmp152 == NULL ? NULL : (_tmp152 = (g_object_unref (_tmp152), NULL)));
				_tmp151 = (g_free (_tmp151), NULL);
			}
			_tmp153 = NULL;
			_tmp154 = NULL;
			cdecl_ = (_tmp154 = vala_ccode_declaration_new ((_tmp153 = vala_data_type_get_cname (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))), (_tmp153 = (g_free (_tmp153), NULL)), _tmp154);
			_tmp155 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp155 = vala_ccode_variable_declarator_new ("result"))));
			(_tmp155 == NULL ? NULL : (_tmp155 = (g_object_unref (_tmp155), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
			_tmp157 = NULL;
			_tmp156 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp156 = vala_ccode_identifier_new ("result")))))));
			(_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL)));
			(_tmp156 == NULL ? NULL : (_tmp156 = (g_object_unref (_tmp156), NULL)));
			_tmp158 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
			(_tmp158 == NULL ? NULL : (_tmp158 = (g_object_unref (_tmp158), NULL)));
			_tmp159 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp159 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp159 == NULL ? NULL : (_tmp159 = (g_object_unref (_tmp159), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (out_marshalling_fragment));
			if (array_type != NULL) {
				ValaCCodeIdentifier* _tmp160;
				ValaCCodeFunctionCall* _tmp161;
				ValaCCodeFunctionCall* cstrvlen;
				ValaCCodeIdentifier* _tmp162;
				ValaCCodeIdentifier* _tmp163;
				ValaCCodeUnaryExpression* _tmp164;
				ValaCCodeUnaryExpression* result_length;
				ValaCCodeAssignment* assign;
				ValaCCodeExpressionStatement* _tmp165;
				/* special case string array
				 *result_length1 = g_strv_length (result);*/
				_tmp160 = NULL;
				_tmp161 = NULL;
				cstrvlen = (_tmp161 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp160 == NULL ? NULL : (_tmp160 = (g_object_unref (_tmp160), NULL))), _tmp161);
				_tmp162 = NULL;
				vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp162 = vala_ccode_identifier_new ("result"))));
				(_tmp162 == NULL ? NULL : (_tmp162 = (g_object_unref (_tmp162), NULL)));
				_tmp163 = NULL;
				_tmp164 = NULL;
				result_length = (_tmp164 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp163 = vala_ccode_identifier_new ("result_length1")))), (_tmp163 == NULL ? NULL : (_tmp163 = (g_object_unref (_tmp163), NULL))), _tmp164);
				assign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (result_length), VALA_CCODE_EXPRESSION (cstrvlen), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
				_tmp165 = NULL;
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp165 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
				(_tmp165 == NULL ? NULL : (_tmp165 = (g_object_unref (_tmp165), NULL)));
				(cstrvlen == NULL ? NULL : (cstrvlen = (g_object_unref (cstrvlen), NULL)));
				(result_length == NULL ? NULL : (result_length = (g_object_unref (result_length), NULL)));
				(assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL)));
			}
			_tmp167 = NULL;
			_tmp166 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp167 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp166 = vala_ccode_identifier_new ("result")))))));
			(_tmp167 == NULL ? NULL : (_tmp167 = (g_object_unref (_tmp167), NULL)));
			(_tmp166 == NULL ? NULL : (_tmp166 = (g_object_unref (_tmp166), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp168;
		_tmp168 = NULL;
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp168 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp168 == NULL ? NULL : (_tmp168 = (g_object_unref (_tmp168), NULL)));
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE (out_marshalling_fragment));
	}
	(dynamic_method == NULL ? NULL : (dynamic_method = (g_object_unref (dynamic_method), NULL)));
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
	(out_marshalling_fragment == NULL ? NULL : (out_marshalling_fragment = (g_object_unref (out_marshalling_fragment), NULL)));
}


static ValaCCodeExpression* vala_ccode_dynamic_method_binding_get_dbus_array_type (ValaCCodeDynamicMethodBinding* self, ValaArrayType* array_type) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* carray_type;
	ValaCCodeConstant* _tmp2;
	ValaCCodeIdentifier* _tmp4;
	char* _tmp3;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (array_type), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	carray_type = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("dbus_g_type_get_collection")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("\"GArray\""))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ((_tmp3 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type))))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	return VALA_CCODE_EXPRESSION (carray_type);
}


static void vala_ccode_dynamic_method_binding_class_init (ValaCCodeDynamicMethodBindingClass * klass) {
	vala_ccode_dynamic_method_binding_parent_class = g_type_class_peek_parent (klass);
}


static void vala_ccode_dynamic_method_binding_instance_init (ValaCCodeDynamicMethodBinding * self) {
}


GType vala_ccode_dynamic_method_binding_get_type (void) {
	static GType vala_ccode_dynamic_method_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_dynamic_method_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDynamicMethodBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_dynamic_method_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDynamicMethodBinding), 0, (GInstanceInitFunc) vala_ccode_dynamic_method_binding_instance_init };
		vala_ccode_dynamic_method_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_BINDING, "ValaCCodeDynamicMethodBinding", &g_define_type_info, 0);
	}
	return vala_ccode_dynamic_method_binding_type_id;
}




