/* valagenieparser.vala
 *
 * Copyright (C) 2008  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include <vala/valagenieparser.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <vala/valageniescanner.h>
#include <vala/valasourcelocation.h>
#include <vala/valagenietokentype.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valaparser.h>
#include <vala/valasymbol.h>
#include <vala/valaexpression.h>
#include <vala/valabooleanliteral.h>
#include <vala/valaintegerliteral.h>
#include <vala/valarealliteral.h>
#include <vala/valacharacterliteral.h>
#include <vala/valastringliteral.h>
#include <vala/valanullliteral.h>
#include <vala/valaunresolvedsymbol.h>
#include <vala/valadatatype.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <vala/valaunresolvedtype.h>
#include <vala/valaarraytype.h>
#include <vala/valamemberaccess.h>
#include <vala/valatuple.h>
#include <vala/valaparenthesizedexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valainvocationexpression.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valamemberinitializer.h>
#include <vala/valaelementaccess.h>
#include <vala/valabaseaccess.h>
#include <vala/valapostfixexpression.h>
#include <vala/valacodenode.h>
#include <vala/valainitializerlist.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valasizeofexpression.h>
#include <vala/valatypeofexpression.h>
#include <vala/valaunaryexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valacastexpression.h>
#include <vala/valapointerindirection.h>
#include <vala/valaaddressofexpression.h>
#include <vala/valatypecheck.h>
#include <vala/valaconditionalexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valablock.h>
#include <vala/valaassignment.h>
#include <vala/valastatement.h>
#include <vala/valaemptystatement.h>
#include <vala/valalocalvariable.h>
#include <vala/valadeclarationstatement.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaifstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valaswitchlabel.h>
#include <vala/valabreakstatement.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valacontinuestatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valacatchclause.h>
#include <vala/valatrystatement.h>
#include <vala/valalockstatement.h>
#include <vala/valadeletestatement.h>
#include <vala/valaattribute.h>
#include <vala/valanamedargument.h>
#include <vala/valanamespace.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valaenum.h>
#include <vala/valaerrordomain.h>
#include <vala/valadelegate.h>
#include <vala/valamethod.h>
#include <vala/valamember.h>
#include <vala/valafield.h>
#include <vala/valaconstant.h>
#include <vala/valanamespacereference.h>
#include <vala/valatypeparameter.h>
#include <vala/valacreationmethod.h>
#include <vala/valasignal.h>
#include <vala/valaproperty.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valaformalparameter.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaenumvalue.h>
#include <vala/valaerrorcode.h>


#define VALA_GENIE_PARSER_TYPE_MODIFIER_FLAGS (vala_genie_parser_modifier_flags_get_type ())

#define VALA_GENIE_PARSER_TYPE_RECOVERY_STATE (vala_genie_parser_recovery_state_get_type ())
typedef struct _ValaGenieParserTokenInfo ValaGenieParserTokenInfo;

typedef enum  {
	VALA_GENIE_PARSER_MODIFIER_FLAGS_NONE,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT = 1 << 0,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS = 1 << 1,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN = 1 << 2,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE = 1 << 3,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE = 1 << 4,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC = 1 << 5,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL = 1 << 6,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE = 1 << 7
} ValaGenieParserModifierFlags;

typedef enum  {
	VALA_GENIE_PARSER_RECOVERY_STATE_EOF,
	VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN,
	VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN
} ValaGenieParserRecoveryState;

struct _ValaGenieParserTokenInfo {
	ValaGenieTokenType type;
	ValaSourceLocation begin;
	ValaSourceLocation end;
};



struct _ValaGenieParserPrivate {
	ValaGenieScanner* scanner;
	ValaCodeContext* context;
	ValaGenieParserTokenInfo* tokens;
	gint tokens_length1;
	gint index;
	gint size;
	char* comment;
	char* class_name;
	gboolean current_expr_is_lambda;
};

#define VALA_GENIE_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_GENIE_TYPE_PARSER, ValaGenieParserPrivate))
enum  {
	VALA_GENIE_PARSER_DUMMY_PROPERTY
};
GType vala_genie_parser_modifier_flags_get_type (void);
GType vala_genie_parser_recovery_state_get_type (void);
static void vala_genie_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static inline gboolean vala_genie_parser_next (ValaGenieParser* self);
static inline void vala_genie_parser_prev (ValaGenieParser* self);
static inline ValaGenieTokenType vala_genie_parser_current (ValaGenieParser* self);
static inline gboolean vala_genie_parser_accept (ValaGenieParser* self, ValaGenieTokenType type);
static inline gboolean vala_genie_parser_accept_terminator (ValaGenieParser* self);
static inline gboolean vala_genie_parser_accept_block (ValaGenieParser* self);
static char* vala_genie_parser_get_error (ValaGenieParser* self, const char* msg);
static inline gboolean vala_genie_parser_expect (ValaGenieParser* self, ValaGenieTokenType type, GError** error);
static inline gboolean vala_genie_parser_expect_terminator (ValaGenieParser* self, GError** error);
static inline ValaSourceLocation vala_genie_parser_get_location (ValaGenieParser* self);
static char* vala_genie_parser_get_last_string (ValaGenieParser* self);
static ValaSourceReference* vala_genie_parser_get_src (ValaGenieParser* self, ValaSourceLocation* begin);
static ValaSourceReference* vala_genie_parser_get_src_com (ValaGenieParser* self, ValaSourceLocation* begin);
static ValaSourceReference* vala_genie_parser_get_current_src (ValaGenieParser* self);
static ValaSourceReference* vala_genie_parser_get_last_src (ValaGenieParser* self);
static void vala_genie_parser_rollback (ValaGenieParser* self, ValaSourceLocation* location);
static inline ValaSymbolAccessibility vala_genie_parser_get_access (ValaGenieParser* self, const char* s);
static void vala_genie_parser_skip_identifier (ValaGenieParser* self, GError** error);
static char* vala_genie_parser_parse_identifier (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_literal (ValaGenieParser* self, GError** error);
static void vala_genie_parser_skip_symbol_name (ValaGenieParser* self, GError** error);
static ValaUnresolvedSymbol* vala_genie_parser_parse_symbol_name (ValaGenieParser* self, GError** error);
static void vala_genie_parser_skip_type (ValaGenieParser* self, GError** error);
static ValaDataType* vala_genie_parser_parse_type (ValaGenieParser* self, gboolean owned_by_default, GError** error);
static GeeList* vala_genie_parser_parse_argument_list (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_primary_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_simple_name (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_tuple (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_member_access (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_pointer_member_access (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static GeeList* vala_genie_parser_parse_print_argument_list (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_print_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_assert_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_invocation_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_element_access (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static GeeList* vala_genie_parser_parse_expression_list (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_this_access (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_base_access (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_post_increment_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_post_decrement_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_object_or_array_creation_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_object_creation_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaMemberAccess* member, GError** error);
static ValaExpression* vala_genie_parser_parse_array_creation_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaMemberAccess* member, GError** error);
static GeeList* vala_genie_parser_parse_object_initializer (ValaGenieParser* self, GError** error);
static ValaMemberInitializer* vala_genie_parser_parse_member_initializer (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_sizeof_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_typeof_expression (ValaGenieParser* self, GError** error);
static ValaUnaryOperator vala_genie_parser_get_unary_operator (ValaGenieParser* self, ValaGenieTokenType token_type);
static ValaExpression* vala_genie_parser_parse_unary_expression (ValaGenieParser* self, GError** error);
static ValaBinaryOperator vala_genie_parser_get_binary_operator (ValaGenieParser* self, ValaGenieTokenType token_type);
static ValaExpression* vala_genie_parser_parse_multiplicative_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_additive_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_shift_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_relational_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_equality_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_and_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_exclusive_or_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_inclusive_or_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_in_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_conditional_and_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_conditional_or_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_conditional_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_lambda_expression (ValaGenieParser* self, GError** error);
static ValaAssignmentOperator vala_genie_parser_get_assignment_operator (ValaGenieParser* self, ValaGenieTokenType token_type);
static ValaExpression* vala_genie_parser_parse_expression (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_get_for_statement_type (ValaGenieParser* self, GError** error);
static void vala_genie_parser_parse_statements (ValaGenieParser* self, ValaBlock* block, GError** error);
static gboolean vala_genie_parser_is_expression (ValaGenieParser* self, GError** error);
static ValaBlock* vala_genie_parser_parse_embedded_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_embedded_statement_without_block (ValaGenieParser* self, GError** error);
static ValaBlock* vala_genie_parser_parse_block (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_empty_statement (ValaGenieParser* self, GError** error);
static void vala_genie_parser_add_local_var_variable (ValaGenieParser* self, ValaBlock* block, const char* id, GError** error);
static void vala_genie_parser_parse_local_variable_declarations (ValaGenieParser* self, ValaBlock* block, GError** error);
static ValaLocalVariable* vala_genie_parser_parse_local_variable (ValaGenieParser* self, ValaDataType* variable_type, const char* id, GError** error);
static ValaStatement* vala_genie_parser_parse_expression_statement (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_statement_expression (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_if_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_switch_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_while_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_do_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_for_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_foreach_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_break_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_continue_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_return_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_throw_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_try_statement (ValaGenieParser* self, GError** error);
static void vala_genie_parser_parse_catch_clauses (ValaGenieParser* self, GeeList* catch_clauses, GError** error);
static ValaBlock* vala_genie_parser_parse_finally_clause (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_lock_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_delete_statement (ValaGenieParser* self, GError** error);
static GeeList* vala_genie_parser_parse_attributes (ValaGenieParser* self, GError** error);
static void vala_genie_parser_set_attributes (ValaGenieParser* self, ValaCodeNode* node, GeeList* attributes);
static ValaSymbol* vala_genie_parser_parse_declaration (ValaGenieParser* self, gboolean is_root, GError** error);
static void vala_genie_parser_parse_declarations (ValaGenieParser* self, ValaSymbol* parent, gboolean root, GError** error);
static ValaGenieParserRecoveryState vala_genie_parser_recover (ValaGenieParser* self);
static ValaNamespace* vala_genie_parser_parse_namespace_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static void vala_genie_parser_parse_namespace_member (ValaGenieParser* self, ValaNamespace* ns, GError** error);
static gboolean vala_genie_parser_add_uses_clause (ValaGenieParser* self, GError** error);
static void vala_genie_parser_parse_using_directives (ValaGenieParser* self, GError** error);
static ValaSymbol* vala_genie_parser_parse_class_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static void vala_genie_parser_parse_class_member (ValaGenieParser* self, ValaClass* cl, GError** error);
static ValaConstant* vala_genie_parser_parse_constant_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaField* vala_genie_parser_parse_field_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaInitializerList* vala_genie_parser_parse_initializer (ValaGenieParser* self, GError** error);
static gboolean vala_genie_parser_is_initializer (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_variable_initializer (ValaGenieParser* self, GError** error);
static ValaMethod* vala_genie_parser_parse_main_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaMethod* vala_genie_parser_parse_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaProperty* vala_genie_parser_parse_property_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSignal* vala_genie_parser_parse_signal_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaConstructor* vala_genie_parser_parse_constructor_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaDestructor* vala_genie_parser_parse_destructor_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_struct_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static void vala_genie_parser_parse_struct_member (ValaGenieParser* self, ValaStruct* st, GError** error);
static ValaSymbol* vala_genie_parser_parse_interface_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static void vala_genie_parser_parse_interface_member (ValaGenieParser* self, ValaInterface* iface, GError** error);
static ValaSymbol* vala_genie_parser_parse_enum_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_errordomain_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaGenieParserModifierFlags vala_genie_parser_parse_type_declaration_modifiers (ValaGenieParser* self);
static ValaGenieParserModifierFlags vala_genie_parser_parse_member_declaration_modifiers (ValaGenieParser* self);
static ValaFormalParameter* vala_genie_parser_parse_parameter (ValaGenieParser* self, GError** error);
static ValaCreationMethod* vala_genie_parser_parse_creation_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_delegate_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static GeeList* vala_genie_parser_parse_type_parameter_list (ValaGenieParser* self, GError** error);
static void vala_genie_parser_skip_type_argument_list (ValaGenieParser* self, GError** error);
static GeeList* vala_genie_parser_parse_type_argument_list (ValaGenieParser* self, gboolean maybe_expression, GError** error);
static ValaMemberAccess* vala_genie_parser_parse_member_name (ValaGenieParser* self, GError** error);
static gboolean vala_genie_parser_is_declaration_keyword (ValaGenieParser* self, ValaGenieTokenType type);
static GObject * vala_genie_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_genie_parser_parent_class = NULL;
static void vala_genie_parser_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const gint VALA_GENIE_PARSER_BUFFER_SIZE = 32;



GType vala_genie_parser_modifier_flags_get_type (void) {
	static GType vala_genie_parser_modifier_flags_type_id = 0;
	if (G_UNLIKELY (vala_genie_parser_modifier_flags_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_GENIE_PARSER_MODIFIER_FLAGS_NONE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_NONE", "none"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT, "VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT", "abstract"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS, "VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS", "class"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN, "VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN", "extern"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE", "inline"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE", "override"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC, "VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC", "static"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL, "VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL", "virtual"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE", "private"}, {0, NULL, NULL}};
		vala_genie_parser_modifier_flags_type_id = g_enum_register_static ("ValaGenieParserModifierFlags", values);
	}
	return vala_genie_parser_modifier_flags_type_id;
}



GType vala_genie_parser_recovery_state_get_type (void) {
	static GType vala_genie_parser_recovery_state_type_id = 0;
	if (G_UNLIKELY (vala_genie_parser_recovery_state_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_GENIE_PARSER_RECOVERY_STATE_EOF, "VALA_GENIE_PARSER_RECOVERY_STATE_EOF", "eof"}, {VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN, "VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN", "declaration-begin"}, {VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN, "VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN", "statement-begin"}, {0, NULL, NULL}};
		vala_genie_parser_recovery_state_type_id = g_enum_register_static ("ValaGenieParserRecoveryState", values);
	}
	return vala_genie_parser_recovery_state_type_id;
}


/**
 * Parses all .gs source files in the specified code context and
 * builds a code tree.
 *
 * @param context a code context
 */
void vala_genie_parser_parse (ValaGenieParser* self, ValaCodeContext* context) {
	ValaCodeContext* _tmp1;
	ValaCodeContext* _tmp0;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->context = (_tmp1 = (_tmp0 = context, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), _tmp1);
	vala_code_context_accept (context, VALA_CODE_VISITOR (self));
}


static void vala_genie_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGenieParser * self;
	self = VALA_GENIE_PARSER (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".gs")) {
		vala_genie_parser_parse_file (self, source_file);
	}
}


static inline gboolean vala_genie_parser_next (ValaGenieParser* self) {
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	self->priv->index = (self->priv->index + 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	self->priv->size--;
	if (self->priv->size <= 0) {
		ValaSourceLocation begin = {0};
		ValaSourceLocation end = {0};
		ValaGenieTokenType type;
		type = vala_genie_scanner_read_token (self->priv->scanner, &begin, &end);
		self->priv->tokens[self->priv->index].type = type;
		self->priv->tokens[self->priv->index].begin = begin;
		self->priv->tokens[self->priv->index].end = end;
		self->priv->size = 1;
	}
	return (self->priv->tokens[self->priv->index].type != VALA_GENIE_TOKEN_TYPE_EOF);
}


static inline void vala_genie_parser_prev (ValaGenieParser* self) {
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	self->priv->index = (self->priv->index - 1 + VALA_GENIE_PARSER_BUFFER_SIZE) % VALA_GENIE_PARSER_BUFFER_SIZE;
	self->priv->size++;
	g_assert (self->priv->size <= VALA_GENIE_PARSER_BUFFER_SIZE);
}


static inline ValaGenieTokenType vala_genie_parser_current (ValaGenieParser* self) {
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), 0);
	return self->priv->tokens[self->priv->index].type;
}


static inline gboolean vala_genie_parser_accept (ValaGenieParser* self, ValaGenieTokenType type) {
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	if (vala_genie_parser_current (self) == type) {
		vala_genie_parser_next (self);
		return TRUE;
	}
	return FALSE;
}


static inline gboolean vala_genie_parser_accept_terminator (ValaGenieParser* self) {
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_SEMICOLON || vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_EOL) {
		vala_genie_parser_next (self);
		return TRUE;
	}
	return FALSE;
}


static inline gboolean vala_genie_parser_accept_block (ValaGenieParser* self) {
	gboolean has_term;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	has_term = vala_genie_parser_accept_terminator (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
		vala_genie_parser_prev (self);
		return TRUE;
	}
	if (has_term) {
		vala_genie_parser_prev (self);
	}
	return FALSE;
}


static char* vala_genie_parser_get_error (ValaGenieParser* self, const char* msg) {
	ValaSourceLocation begin;
	char* _tmp1;
	ValaSourceReference* _tmp0;
	const char* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_next (self);
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_report_error ((_tmp0 = vala_genie_parser_get_src (self, &begin)), (_tmp1 = g_strconcat ("syntax error, ", msg, NULL)));
	_tmp1 = (g_free (_tmp1), NULL);
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp2 = NULL;
	return (_tmp2 = msg, (_tmp2 == NULL ? NULL : g_strdup (_tmp2)));
}


static inline gboolean vala_genie_parser_expect (ValaGenieParser* self, ValaGenieTokenType type, GError** error) {
	GError * inner_error;
	ValaGenieTokenType cur;
	ValaGenieTokenType pre;
	char* _tmp2;
	char* _tmp1;
	GError* _tmp3;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	inner_error = NULL;
	if (vala_genie_parser_accept (self, type)) {
		return TRUE;
	}
	cur = vala_genie_parser_current (self);
	pre = self->priv->tokens[self->priv->index - 1].type;
	_tmp2 = NULL;
	_tmp1 = NULL;
	inner_error = (_tmp3 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp2 = vala_genie_parser_get_error (self, (_tmp1 = g_strdup_printf ("expected %s but got %s with previous %s", vala_genie_token_type_to_string (type), vala_genie_token_type_to_string (cur), vala_genie_token_type_to_string (pre)))))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), _tmp3);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return FALSE;
	}
}


static inline gboolean vala_genie_parser_expect_terminator (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaGenieTokenType cur;
	char* _tmp2;
	char* _tmp1;
	GError* _tmp3;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	inner_error = NULL;
	if (vala_genie_parser_accept_terminator (self)) {
		return TRUE;
	}
	cur = vala_genie_parser_current (self);
	_tmp2 = NULL;
	_tmp1 = NULL;
	inner_error = (_tmp3 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp2 = vala_genie_parser_get_error (self, (_tmp1 = g_strdup_printf ("expected line end or semicolon but got %s", vala_genie_token_type_to_string (cur)))))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), _tmp3);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return FALSE;
	}
}


static inline ValaSourceLocation vala_genie_parser_get_location (ValaGenieParser* self) {
	0;
	return self->priv->tokens[self->priv->index].begin;
}


static char* vala_genie_parser_get_last_string (ValaGenieParser* self) {
	gint last_index;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	last_index = (self->priv->index + VALA_GENIE_PARSER_BUFFER_SIZE - 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	return g_strndup ((((const char*) (self->priv->tokens[last_index].begin.pos))), ((gulong) ((self->priv->tokens[last_index].end.pos - self->priv->tokens[last_index].begin.pos))));
}


static ValaSourceReference* vala_genie_parser_get_src (ValaGenieParser* self, ValaSourceLocation* begin) {
	gint last_index;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	last_index = (self->priv->index + VALA_GENIE_PARSER_BUFFER_SIZE - 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	return vala_source_reference_new (vala_genie_scanner_get_source_file (self->priv->scanner), (*begin).line, (*begin).column, self->priv->tokens[last_index].end.line, self->priv->tokens[last_index].end.column);
}


static ValaSourceReference* vala_genie_parser_get_src_com (ValaGenieParser* self, ValaSourceLocation* begin) {
	gint last_index;
	ValaSourceReference* src;
	char* _tmp0;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	last_index = (self->priv->index + VALA_GENIE_PARSER_BUFFER_SIZE - 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	src = vala_source_reference_new_with_comment (vala_genie_scanner_get_source_file (self->priv->scanner), (*begin).line, (*begin).column, self->priv->tokens[last_index].end.line, self->priv->tokens[last_index].end.column, self->priv->comment);
	_tmp0 = NULL;
	self->priv->comment = (_tmp0 = NULL, (self->priv->comment = (g_free (self->priv->comment), NULL)), _tmp0);
	return src;
}


static ValaSourceReference* vala_genie_parser_get_current_src (ValaGenieParser* self) {
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	return vala_source_reference_new (vala_genie_scanner_get_source_file (self->priv->scanner), self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, self->priv->tokens[self->priv->index].end.line, self->priv->tokens[self->priv->index].end.column);
}


static ValaSourceReference* vala_genie_parser_get_last_src (ValaGenieParser* self) {
	gint last_index;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	last_index = (self->priv->index + VALA_GENIE_PARSER_BUFFER_SIZE - 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	return vala_source_reference_new (vala_genie_scanner_get_source_file (self->priv->scanner), self->priv->tokens[last_index].begin.line, self->priv->tokens[last_index].begin.column, self->priv->tokens[last_index].end.line, self->priv->tokens[last_index].end.column);
}


static void vala_genie_parser_rollback (ValaGenieParser* self, ValaSourceLocation* location) {
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	while (self->priv->tokens[self->priv->index].begin.pos != (*location).pos) {
		vala_genie_parser_prev (self);
	}
}


static inline ValaSymbolAccessibility vala_genie_parser_get_access (ValaGenieParser* self, const char* s) {
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), 0);
	g_return_val_if_fail (s != NULL, 0);
	if (g_utf8_get_char (g_utf8_offset_to_pointer (s, 0)) == '_') {
		return VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	}
	return VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
}


static void vala_genie_parser_skip_identifier (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaGenieTokenType _tmp0;
	char* _tmp1;
	GError* _tmp2;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	inner_error = NULL;
	/* also accept keywords as identifiers where there is no conflict*/
	_tmp0 = vala_genie_parser_current (self);
	if (_tmp0 == VALA_GENIE_TOKEN_TYPE_ABSTRACT || _tmp0 == VALA_GENIE_TOKEN_TYPE_AS || _tmp0 == VALA_GENIE_TOKEN_TYPE_ASSERT || _tmp0 == VALA_GENIE_TOKEN_TYPE_BREAK || _tmp0 == VALA_GENIE_TOKEN_TYPE_CLASS || _tmp0 == VALA_GENIE_TOKEN_TYPE_CONST || _tmp0 == VALA_GENIE_TOKEN_TYPE_CONTINUE || _tmp0 == VALA_GENIE_TOKEN_TYPE_DEDENT || _tmp0 == VALA_GENIE_TOKEN_TYPE_DEF || _tmp0 == VALA_GENIE_TOKEN_TYPE_DEFAULT || _tmp0 == VALA_GENIE_TOKEN_TYPE_DELEGATE || _tmp0 == VALA_GENIE_TOKEN_TYPE_DELETE || _tmp0 == VALA_GENIE_TOKEN_TYPE_DO || _tmp0 == VALA_GENIE_TOKEN_TYPE_DOWNTO || _tmp0 == VALA_GENIE_TOKEN_TYPE_DYNAMIC || _tmp0 == VALA_GENIE_TOKEN_TYPE_ELSE || _tmp0 == VALA_GENIE_TOKEN_TYPE_EOL || _tmp0 == VALA_GENIE_TOKEN_TYPE_ENUM || _tmp0 == VALA_GENIE_TOKEN_TYPE_ENSURES || _tmp0 == VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN || _tmp0 == VALA_GENIE_TOKEN_TYPE_EVENT || _tmp0 == VALA_GENIE_TOKEN_TYPE_EXCEPT || _tmp0 == VALA_GENIE_TOKEN_TYPE_EXTERN || _tmp0 == VALA_GENIE_TOKEN_TYPE_FALSE || _tmp0 == VALA_GENIE_TOKEN_TYPE_FINAL || _tmp0 == VALA_GENIE_TOKEN_TYPE_FINALLY || _tmp0 == VALA_GENIE_TOKEN_TYPE_FOR || _tmp0 == VALA_GENIE_TOKEN_TYPE_GET || _tmp0 == VALA_GENIE_TOKEN_TYPE_IDENTIFIER || _tmp0 == VALA_GENIE_TOKEN_TYPE_IF || _tmp0 == VALA_GENIE_TOKEN_TYPE_IN || _tmp0 == VALA_GENIE_TOKEN_TYPE_INDENT || _tmp0 == VALA_GENIE_TOKEN_TYPE_INIT || _tmp0 == VALA_GENIE_TOKEN_TYPE_INLINE || _tmp0 == VALA_GENIE_TOKEN_TYPE_INTERFACE || _tmp0 == VALA_GENIE_TOKEN_TYPE_IS || _tmp0 == VALA_GENIE_TOKEN_TYPE_ISA || _tmp0 == VALA_GENIE_TOKEN_TYPE_LOCK || _tmp0 == VALA_GENIE_TOKEN_TYPE_NAMESPACE || _tmp0 == VALA_GENIE_TOKEN_TYPE_NEW || _tmp0 == VALA_GENIE_TOKEN_TYPE_NULL || _tmp0 == VALA_GENIE_TOKEN_TYPE_OF || _tmp0 == VALA_GENIE_TOKEN_TYPE_OUT || _tmp0 == VALA_GENIE_TOKEN_TYPE_OVERRIDE || _tmp0 == VALA_GENIE_TOKEN_TYPE_PASS || _tmp0 == VALA_GENIE_TOKEN_TYPE_PRINT || _tmp0 == VALA_GENIE_TOKEN_TYPE_PRIVATE || _tmp0 == VALA_GENIE_TOKEN_TYPE_PROP || _tmp0 == VALA_GENIE_TOKEN_TYPE_RAISE || _tmp0 == VALA_GENIE_TOKEN_TYPE_RAISES || _tmp0 == VALA_GENIE_TOKEN_TYPE_REF || _tmp0 == VALA_GENIE_TOKEN_TYPE_REQUIRES || _tmp0 == VALA_GENIE_TOKEN_TYPE_RETURN || _tmp0 == VALA_GENIE_TOKEN_TYPE_SET || _tmp0 == VALA_GENIE_TOKEN_TYPE_SIZEOF || _tmp0 == VALA_GENIE_TOKEN_TYPE_STATIC || _tmp0 == VALA_GENIE_TOKEN_TYPE_STRUCT || _tmp0 == VALA_GENIE_TOKEN_TYPE_SUPER || _tmp0 == VALA_GENIE_TOKEN_TYPE_THIS || _tmp0 == VALA_GENIE_TOKEN_TYPE_TO || _tmp0 == VALA_GENIE_TOKEN_TYPE_TRUE || _tmp0 == VALA_GENIE_TOKEN_TYPE_TRY || _tmp0 == VALA_GENIE_TOKEN_TYPE_TYPEOF || _tmp0 == VALA_GENIE_TOKEN_TYPE_USES || _tmp0 == VALA_GENIE_TOKEN_TYPE_VAR || _tmp0 == VALA_GENIE_TOKEN_TYPE_VIRTUAL || _tmp0 == VALA_GENIE_TOKEN_TYPE_VOID || _tmp0 == VALA_GENIE_TOKEN_TYPE_VOLATILE || _tmp0 == VALA_GENIE_TOKEN_TYPE_WEAK || _tmp0 == VALA_GENIE_TOKEN_TYPE_WHEN || _tmp0 == VALA_GENIE_TOKEN_TYPE_WHILE)
	do {
		vala_genie_parser_next (self);
		return;
	} while (0);
	_tmp1 = NULL;
	inner_error = (_tmp2 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp1 = vala_genie_parser_get_error (self, "expected identifier"))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
}


static char* vala_genie_parser_parse_identifier (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	vala_genie_parser_skip_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	return vala_genie_parser_get_last_string (self);
}


static ValaExpression* vala_genie_parser_parse_literal (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaGenieTokenType _tmp25;
	char* _tmp26;
	GError* _tmp27;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	_tmp25 = vala_genie_parser_current (self);
	if (_tmp25 == VALA_GENIE_TOKEN_TYPE_TRUE)
	do {
		ValaSourceReference* _tmp0;
		ValaExpression* _tmp1;
		vala_genie_parser_next (self);
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = VALA_EXPRESSION (vala_boolean_literal_new (TRUE, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	} while (0); else if (_tmp25 == VALA_GENIE_TOKEN_TYPE_FALSE)
	do {
		ValaSourceReference* _tmp3;
		ValaExpression* _tmp4;
		vala_genie_parser_next (self);
		_tmp3 = NULL;
		_tmp4 = NULL;
		return (_tmp4 = VALA_EXPRESSION (vala_boolean_literal_new (FALSE, (_tmp3 = vala_genie_parser_get_src (self, &begin)))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4);
	} while (0); else if (_tmp25 == VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL)
	do {
		ValaSourceReference* _tmp7;
		char* _tmp6;
		ValaExpression* _tmp8;
		vala_genie_parser_next (self);
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp8 = NULL;
		return (_tmp8 = VALA_EXPRESSION (vala_integer_literal_new ((_tmp6 = vala_genie_parser_get_last_string (self)), (_tmp7 = vala_genie_parser_get_src (self, &begin)))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp8);
	} while (0); else if (_tmp25 == VALA_GENIE_TOKEN_TYPE_REAL_LITERAL)
	do {
		ValaSourceReference* _tmp11;
		char* _tmp10;
		ValaExpression* _tmp12;
		vala_genie_parser_next (self);
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp12 = NULL;
		return (_tmp12 = VALA_EXPRESSION (vala_real_literal_new ((_tmp10 = vala_genie_parser_get_last_string (self)), (_tmp11 = vala_genie_parser_get_src (self, &begin)))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
	} while (0); else if (_tmp25 == VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL)
	do {
		ValaSourceReference* _tmp15;
		char* _tmp14;
		ValaExpression* _tmp16;
		vala_genie_parser_next (self);
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp16 = NULL;
		return (_tmp16 = VALA_EXPRESSION (vala_character_literal_new ((_tmp14 = vala_genie_parser_get_last_string (self)), (_tmp15 = vala_genie_parser_get_src (self, &begin)))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), (_tmp14 = (g_free (_tmp14), NULL)), _tmp16);
	} while (0); else if (_tmp25 == VALA_GENIE_TOKEN_TYPE_STRING_LITERAL)
	do {
		ValaSourceReference* _tmp19;
		char* _tmp18;
		ValaExpression* _tmp20;
		vala_genie_parser_next (self);
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp20 = NULL;
		return (_tmp20 = VALA_EXPRESSION (vala_string_literal_new ((_tmp18 = vala_genie_parser_get_last_string (self)), (_tmp19 = vala_genie_parser_get_src (self, &begin)))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), (_tmp18 = (g_free (_tmp18), NULL)), _tmp20);
	} while (0); else if (_tmp25 == VALA_GENIE_TOKEN_TYPE_NULL)
	do {
		ValaSourceReference* _tmp22;
		ValaExpression* _tmp23;
		vala_genie_parser_next (self);
		_tmp22 = NULL;
		_tmp23 = NULL;
		return (_tmp23 = VALA_EXPRESSION (vala_null_literal_new ((_tmp22 = vala_genie_parser_get_src (self, &begin)))), (_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL))), _tmp23);
	} while (0);
	_tmp26 = NULL;
	inner_error = (_tmp27 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp26 = vala_genie_parser_get_error (self, "expected literal"))), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
}


void vala_genie_parser_parse_file (ValaGenieParser* self, ValaSourceFile* source_file) {
	GError * inner_error;
	ValaGenieScanner* _tmp0;
	ValaGenieScanner* _tmp2;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	inner_error = NULL;
	_tmp0 = NULL;
	self->priv->scanner = (_tmp0 = vala_genie_scanner_new (source_file), (self->priv->scanner == NULL ? NULL : (self->priv->scanner = (g_object_unref (self->priv->scanner), NULL))), _tmp0);
	vala_genie_scanner_set_indent_spaces (self->priv->scanner, 0);
	self->priv->index = -1;
	self->priv->size = 0;
	vala_genie_parser_next (self);
	{
		ValaSourceLocation begin;
		begin = vala_genie_parser_get_location (self);
		/* see if there is an indent attribute */
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
			char* id;
			id = vala_genie_parser_parse_identifier (self, &inner_error);
			if (inner_error != NULL) {
				if (inner_error->domain == VALA_PARSE_ERROR) {
					goto __catch0_vala_parse_error;
				}
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
				g_clear_error (&inner_error);
			}
			if (_vala_strcmp0 (id, "indent") == 0) {
				char* _tmp1;
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSIGN, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch0_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch0_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				_tmp1 = NULL;
				vala_genie_scanner_set_indent_spaces (self->priv->scanner, atoi ((_tmp1 = vala_genie_parser_get_last_string (self))));
				_tmp1 = (g_free (_tmp1), NULL);
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch0_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch0_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
			} else {
				vala_genie_parser_rollback (self, &begin);
			}
			id = (g_free (id), NULL);
		}
		vala_genie_parser_parse_using_directives (self, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == VALA_PARSE_ERROR) {
				goto __catch0_vala_parse_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		vala_genie_parser_parse_declarations (self, VALA_SYMBOL (vala_code_context_get_root (self->priv->context)), TRUE, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == VALA_PARSE_ERROR) {
				goto __catch0_vala_parse_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
	}
	goto __finally0;
	__catch0_vala_parse_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
		}
	}
	__finally0:
	;
	/* already reported*/
	_tmp2 = NULL;
	self->priv->scanner = (_tmp2 = NULL, (self->priv->scanner == NULL ? NULL : (self->priv->scanner = (g_object_unref (self->priv->scanner), NULL))), _tmp2);
}


static void vala_genie_parser_skip_symbol_name (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	inner_error = NULL;
	do {
		vala_genie_parser_skip_identifier (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DOT));
}


static ValaUnresolvedSymbol* vala_genie_parser_parse_symbol_name (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaUnresolvedSymbol* sym;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	sym = NULL;
	do {
		char* name;
		ValaUnresolvedSymbol* _tmp1;
		ValaSourceReference* _tmp0;
		name = vala_genie_parser_parse_identifier (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		sym = (_tmp1 = vala_unresolved_symbol_new (sym, name, (_tmp0 = vala_genie_parser_get_src (self, &begin))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp1);
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		name = (g_free (name), NULL);
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DOT));
	return sym;
}


static void vala_genie_parser_skip_type (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	inner_error = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VOID)) {
		while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_STAR)) {
		}
		return;
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DYNAMIC);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WEAK);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ARRAY)) {
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF);
	}
	vala_genie_parser_skip_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	vala_genie_parser_skip_type_argument_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
		do {
			if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_COMMA && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET) {
				ValaExpression* _tmp0;
				_tmp0 = NULL;
				_tmp0 = vala_genie_parser_parse_expression (self, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return;
				}
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
			}
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OP_NEG);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_HASH);
}


static ValaDataType* vala_genie_parser_parse_type (ValaGenieParser* self, gboolean owned_by_default, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	gboolean is_dynamic;
	gboolean value_owned;
	gboolean is_array;
	ValaUnresolvedSymbol* sym;
	GeeList* type_arg_list;
	ValaSourceReference* _tmp2;
	ValaDataType* _tmp3;
	ValaDataType* type;
	ValaDataType* _tmp11;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VOID)) {
		ValaDataType* type;
		type = VALA_DATA_TYPE (vala_void_type_new ());
		while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_STAR)) {
			ValaDataType* _tmp0;
			_tmp0 = NULL;
			type = (_tmp0 = VALA_DATA_TYPE (vala_pointer_type_new (type, NULL)), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp0);
		}
		return type;
	}
	is_dynamic = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DYNAMIC);
	value_owned = owned_by_default;
	if (owned_by_default) {
		value_owned = !vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WEAK);
	}
	/* handle arrays */
	is_array = FALSE;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ARRAY)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		is_array = TRUE;
	}
	sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type_arg_list = vala_genie_parser_parse_type_argument_list (self, FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	type = (_tmp3 = VALA_DATA_TYPE (vala_unresolved_type_new_from_symbol (sym, (_tmp2 = vala_genie_parser_get_src (self, &begin)))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	if (type_arg_list != NULL) {
		{
			GeeList* type_arg_collection;
			int type_arg_it;
			type_arg_collection = type_arg_list;
			for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
				ValaDataType* type_arg;
				type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
				{
					vala_data_type_add_type_argument (type, type_arg);
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
		}
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_STAR)) {
		ValaDataType* _tmp5;
		ValaSourceReference* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		type = (_tmp5 = VALA_DATA_TYPE (vala_pointer_type_new (type, (_tmp4 = vala_genie_parser_get_src (self, &begin)))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp5);
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	}
	if (!(VALA_IS_POINTER_TYPE (type))) {
		vala_data_type_set_nullable (type, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR));
	}
	if (is_array) {
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
			ValaDataType* _tmp7;
			ValaSourceReference* _tmp6;
			vala_data_type_set_value_owned (type, TRUE);
			_tmp7 = NULL;
			_tmp6 = NULL;
			type = (_tmp7 = VALA_DATA_TYPE (vala_array_type_new (type, 1, (_tmp6 = vala_genie_parser_get_src (self, &begin)))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp7);
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
			vala_data_type_set_nullable (type, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR));
		} else {
			vala_genie_parser_prev (self);
			while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
				gint array_rank;
				ValaDataType* _tmp10;
				ValaSourceReference* _tmp9;
				array_rank = 0;
				do {
					array_rank++;
					/* support for stack-allocated arrays
					 also required for decision between expression and declaration statement*/
					if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_COMMA && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET) {
						ValaExpression* _tmp8;
						_tmp8 = NULL;
						_tmp8 = vala_genie_parser_parse_expression (self, &inner_error);
						if (inner_error != NULL) {
							g_propagate_error (error, inner_error);
							return NULL;
						}
						(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
					}
				} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
				vala_data_type_set_value_owned (type, TRUE);
				_tmp10 = NULL;
				_tmp9 = NULL;
				type = (_tmp10 = VALA_DATA_TYPE (vala_array_type_new (type, array_rank, (_tmp9 = vala_genie_parser_get_src (self, &begin)))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp10);
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				vala_data_type_set_nullable (type, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR));
			}
		}
	}
	if (!owned_by_default) {
		value_owned = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_HASH);
	}
	vala_data_type_set_is_dynamic (type, is_dynamic);
	vala_data_type_set_value_owned (type, value_owned);
	_tmp11 = NULL;
	return (_tmp11 = type, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), (type_arg_list == NULL ? NULL : (type_arg_list = (g_object_unref (type_arg_list), NULL))), _tmp11);
}


static GeeList* vala_genie_parser_parse_argument_list (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	GeeArrayList* list;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	list = gee_array_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaExpression* _tmp0;
			_tmp0 = NULL;
			gee_collection_add (GEE_COLLECTION (list), (_tmp0 = vala_genie_parser_parse_expression (self, &inner_error)));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	return GEE_LIST (list);
}


static ValaExpression* vala_genie_parser_parse_primary_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaGenieTokenType _tmp10;
	gboolean found;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	expr = NULL;
	_tmp10 = vala_genie_parser_current (self);
	if (_tmp10 == VALA_GENIE_TOKEN_TYPE_TRUE || _tmp10 == VALA_GENIE_TOKEN_TYPE_FALSE || _tmp10 == VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL || _tmp10 == VALA_GENIE_TOKEN_TYPE_REAL_LITERAL || _tmp10 == VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL || _tmp10 == VALA_GENIE_TOKEN_TYPE_STRING_LITERAL || _tmp10 == VALA_GENIE_TOKEN_TYPE_NULL)
	do {
		ValaExpression* _tmp0;
		_tmp0 = NULL;
		expr = (_tmp0 = vala_genie_parser_parse_literal (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		break;
	} while (0); else if (_tmp10 == VALA_GENIE_TOKEN_TYPE_ASSERT)
	do {
		ValaExpression* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = vala_genie_parser_parse_assert_expression (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp1);
	} while (0); else if (_tmp10 == VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)
	do {
		ValaExpression* _tmp2;
		_tmp2 = NULL;
		expr = (_tmp2 = vala_genie_parser_parse_tuple (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp2);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		break;
	} while (0); else if (_tmp10 == VALA_GENIE_TOKEN_TYPE_THIS)
	do {
		ValaExpression* _tmp3;
		_tmp3 = NULL;
		expr = (_tmp3 = vala_genie_parser_parse_this_access (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp3);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		break;
	} while (0); else if (_tmp10 == VALA_GENIE_TOKEN_TYPE_SUPER)
	do {
		ValaExpression* _tmp4;
		_tmp4 = NULL;
		expr = (_tmp4 = vala_genie_parser_parse_base_access (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp4);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		break;
	} while (0); else if (_tmp10 == VALA_GENIE_TOKEN_TYPE_NEW)
	do {
		ValaExpression* _tmp5;
		_tmp5 = NULL;
		expr = (_tmp5 = vala_genie_parser_parse_object_or_array_creation_expression (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp5);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		break;
	} while (0); else if (_tmp10 == VALA_GENIE_TOKEN_TYPE_PRINT)
	do {
		ValaExpression* _tmp6;
		_tmp6 = NULL;
		return (_tmp6 = vala_genie_parser_parse_print_expression (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp6);
	} while (0); else if (_tmp10 == VALA_GENIE_TOKEN_TYPE_SIZEOF)
	do {
		ValaExpression* _tmp7;
		_tmp7 = NULL;
		expr = (_tmp7 = vala_genie_parser_parse_sizeof_expression (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp7);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		break;
	} while (0); else if (_tmp10 == VALA_GENIE_TOKEN_TYPE_TYPEOF)
	do {
		ValaExpression* _tmp8;
		_tmp8 = NULL;
		expr = (_tmp8 = vala_genie_parser_parse_typeof_expression (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp8);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		break;
	} while (0); else
	do {
		ValaExpression* _tmp9;
		_tmp9 = NULL;
		expr = (_tmp9 = vala_genie_parser_parse_simple_name (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp9);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		break;
	} while (0);
	if (expr == NULL) {
		/* workaround for current limitation of exception handling*/
		inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in primary expression");
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	/* process primary expressions that start with an inner primary expression*/
	found = TRUE;
	while (found) {
		ValaGenieTokenType _tmp17;
		_tmp17 = vala_genie_parser_current (self);
		if (_tmp17 == VALA_GENIE_TOKEN_TYPE_DOT)
		do {
			ValaExpression* _tmp11;
			_tmp11 = NULL;
			expr = (_tmp11 = vala_genie_parser_parse_member_access (self, &begin, expr, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp11);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			break;
		} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_OP_PTR)
		do {
			ValaExpression* _tmp12;
			_tmp12 = NULL;
			expr = (_tmp12 = vala_genie_parser_parse_pointer_member_access (self, &begin, expr, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp12);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			break;
		} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)
		do {
			ValaExpression* _tmp13;
			_tmp13 = NULL;
			expr = (_tmp13 = vala_genie_parser_parse_invocation_expression (self, &begin, expr, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp13);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			break;
		} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)
		do {
			ValaExpression* _tmp14;
			_tmp14 = NULL;
			expr = (_tmp14 = vala_genie_parser_parse_element_access (self, &begin, expr, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp14);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			break;
		} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_OP_INC)
		do {
			ValaExpression* _tmp15;
			_tmp15 = NULL;
			expr = (_tmp15 = vala_genie_parser_parse_post_increment_expression (self, &begin, expr, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp15);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			break;
		} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_OP_DEC)
		do {
			ValaExpression* _tmp16;
			_tmp16 = NULL;
			expr = (_tmp16 = vala_genie_parser_parse_post_decrement_expression (self, &begin, expr, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp16);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			break;
		} while (0); else
		do {
			found = FALSE;
			break;
		} while (0);
		if (expr == NULL) {
			/* workaround for current limitation of exception handling*/
			inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in primary expression");
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
		}
	}
	return expr;
}


static ValaExpression* vala_genie_parser_parse_simple_name (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	char* id;
	GeeList* type_arg_list;
	ValaSourceReference* _tmp0;
	ValaMemberAccess* _tmp1;
	ValaMemberAccess* expr;
	ValaExpression* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type_arg_list = vala_genie_parser_parse_type_argument_list (self, TRUE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	expr = (_tmp1 = vala_member_access_new (NULL, id, (_tmp0 = vala_genie_parser_get_src (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (type_arg_list != NULL) {
		{
			GeeList* type_arg_collection;
			int type_arg_it;
			type_arg_collection = type_arg_list;
			for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
				ValaDataType* type_arg;
				type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
				{
					vala_member_access_add_type_argument (expr, type_arg);
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
		}
	}
	_tmp2 = NULL;
	return (_tmp2 = VALA_EXPRESSION (expr), (id = (g_free (id), NULL)), (type_arg_list == NULL ? NULL : (type_arg_list = (g_object_unref (type_arg_list), NULL))), _tmp2);
}


static ValaExpression* vala_genie_parser_parse_tuple (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	GeeArrayList* expr_list;
	ValaSourceReference* _tmp3;
	ValaExpression* _tmp2;
	ValaExpression* _tmp4;
	ValaExpression* _tmp5;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	expr_list = gee_array_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaExpression* _tmp0;
			_tmp0 = NULL;
			gee_collection_add (GEE_COLLECTION (expr_list), (_tmp0 = vala_genie_parser_parse_expression (self, &inner_error)));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (gee_collection_get_size (GEE_COLLECTION (expr_list)) != 1) {
		ValaTuple* tuple;
		ValaExpression* _tmp1;
		tuple = vala_tuple_new ();
		{
			GeeArrayList* expr_collection;
			int expr_it;
			expr_collection = expr_list;
			for (expr_it = 0; expr_it < gee_collection_get_size (GEE_COLLECTION (expr_collection)); expr_it = expr_it + 1) {
				ValaExpression* expr;
				expr = ((ValaExpression*) (gee_list_get (GEE_LIST (expr_collection), expr_it)));
				{
					vala_tuple_add_expression (tuple, expr);
					(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
				}
			}
		}
		_tmp1 = NULL;
		return (_tmp1 = VALA_EXPRESSION (tuple), (expr_list == NULL ? NULL : (expr_list = (g_object_unref (expr_list), NULL))), _tmp1);
	}
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp4 = NULL;
	_tmp5 = NULL;
	return (_tmp5 = (_tmp4 = VALA_EXPRESSION (vala_parenthesized_expression_new ((_tmp2 = ((ValaExpression*) (gee_list_get (GEE_LIST (expr_list), 0)))), (_tmp3 = vala_genie_parser_get_src (self, &begin)))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp4), (expr_list == NULL ? NULL : (expr_list = (g_object_unref (expr_list), NULL))), _tmp5);
}


static ValaExpression* vala_genie_parser_parse_member_access (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * inner_error;
	char* id;
	GeeList* type_arg_list;
	ValaSourceReference* _tmp0;
	ValaMemberAccess* _tmp1;
	ValaMemberAccess* expr;
	ValaExpression* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (inner), NULL);
	inner_error = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DOT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type_arg_list = vala_genie_parser_parse_type_argument_list (self, TRUE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	expr = (_tmp1 = vala_member_access_new (inner, id, (_tmp0 = vala_genie_parser_get_src (self, &(*begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (type_arg_list != NULL) {
		{
			GeeList* type_arg_collection;
			int type_arg_it;
			type_arg_collection = type_arg_list;
			for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
				ValaDataType* type_arg;
				type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
				{
					vala_member_access_add_type_argument (expr, type_arg);
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
		}
	}
	_tmp2 = NULL;
	return (_tmp2 = VALA_EXPRESSION (expr), (id = (g_free (id), NULL)), (type_arg_list == NULL ? NULL : (type_arg_list = (g_object_unref (type_arg_list), NULL))), _tmp2);
}


static ValaExpression* vala_genie_parser_parse_pointer_member_access (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * inner_error;
	char* id;
	GeeList* type_arg_list;
	ValaSourceReference* _tmp0;
	ValaMemberAccess* _tmp1;
	ValaMemberAccess* expr;
	ValaExpression* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (inner), NULL);
	inner_error = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OP_PTR, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type_arg_list = vala_genie_parser_parse_type_argument_list (self, TRUE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	expr = (_tmp1 = vala_member_access_new_pointer (inner, id, (_tmp0 = vala_genie_parser_get_src (self, &(*begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (type_arg_list != NULL) {
		{
			GeeList* type_arg_collection;
			int type_arg_it;
			type_arg_collection = type_arg_list;
			for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
				ValaDataType* type_arg;
				type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
				{
					vala_member_access_add_type_argument (expr, type_arg);
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
		}
	}
	_tmp2 = NULL;
	return (_tmp2 = VALA_EXPRESSION (expr), (id = (g_free (id), NULL)), (type_arg_list == NULL ? NULL : (type_arg_list = (g_object_unref (type_arg_list), NULL))), _tmp2);
}


static GeeList* vala_genie_parser_parse_print_argument_list (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	GeeArrayList* list;
	gint i;
	ValaSourceLocation begin;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	list = gee_array_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	i = 0;
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaExpression* p_expr;
			p_expr = vala_genie_parser_parse_expression (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			if (i == 0) {
				i++;
				if (p_expr != NULL) {
					char* s;
					s = g_strdup ("\\n\"");
					if (VALA_IS_STRING_LITERAL (p_expr)) {
						ValaStringLiteral* _tmp0;
						ValaStringLiteral* s_exp;
						glong len;
						_tmp0 = NULL;
						s_exp = (_tmp0 = VALA_STRING_LITERAL (p_expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
						len = strlen (vala_string_literal_get_value (s_exp));
						if (len > 2) {
							char* st;
							char* _tmp1;
							st = g_strndup (vala_string_literal_get_value (s_exp), ((gulong) (len - 1)));
							_tmp1 = NULL;
							st = (_tmp1 = g_strconcat (st, (s), NULL), (st = (g_free (st), NULL)), _tmp1);
							vala_string_literal_set_value (s_exp, st);
							st = (g_free (st), NULL);
						}
						(s_exp == NULL ? NULL : (s_exp = (g_object_unref (s_exp), NULL)));
					} else {
						char* s;
						ValaSourceReference* _tmp2;
						ValaStringLiteral* _tmp3;
						ValaStringLiteral* rhs;
						ValaExpression* _tmp5;
						ValaSourceReference* _tmp4;
						s = g_strdup ("\"\\n\"");
						_tmp2 = NULL;
						_tmp3 = NULL;
						rhs = (_tmp3 = vala_string_literal_new (s, (_tmp2 = vala_genie_parser_get_src (self, &begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
						_tmp5 = NULL;
						_tmp4 = NULL;
						p_expr = (_tmp5 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, p_expr, VALA_EXPRESSION (rhs), (_tmp4 = vala_genie_parser_get_src (self, &begin)))), (p_expr == NULL ? NULL : (p_expr = (g_object_unref (p_expr), NULL))), _tmp5);
						(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
						s = (g_free (s), NULL);
						(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
					}
					s = (g_free (s), NULL);
				}
			}
			gee_collection_add (GEE_COLLECTION (list), p_expr);
			(p_expr == NULL ? NULL : (p_expr = (g_object_unref (p_expr), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	return GEE_LIST (list);
}


static ValaExpression* vala_genie_parser_parse_print_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0;
	ValaMemberAccess* _tmp1;
	ValaMemberAccess* expr;
	GeeList* arg_list;
	ValaSourceReference* _tmp2;
	ValaInvocationExpression* _tmp3;
	ValaInvocationExpression* print_expr;
	ValaExpression* _tmp4;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_PRINT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS);
	_tmp0 = NULL;
	_tmp1 = NULL;
	expr = (_tmp1 = vala_member_access_new (NULL, "print", (_tmp0 = vala_genie_parser_get_src (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	arg_list = vala_genie_parser_parse_print_argument_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS);
	_tmp2 = NULL;
	_tmp3 = NULL;
	print_expr = (_tmp3 = vala_invocation_expression_new (VALA_EXPRESSION (expr), (_tmp2 = vala_genie_parser_get_src (self, &begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = arg_list;
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				vala_invocation_expression_add_argument (print_expr, arg);
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
	}
	_tmp4 = NULL;
	return (_tmp4 = VALA_EXPRESSION (print_expr), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), (arg_list == NULL ? NULL : (arg_list = (g_object_unref (arg_list), NULL))), _tmp4);
}


static ValaExpression* vala_genie_parser_parse_assert_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0;
	ValaMemberAccess* _tmp1;
	ValaMemberAccess* expr;
	GeeList* arg_list;
	ValaSourceReference* _tmp2;
	ValaInvocationExpression* _tmp3;
	ValaInvocationExpression* assert_expr;
	ValaExpression* _tmp4;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSERT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS);
	_tmp0 = NULL;
	_tmp1 = NULL;
	expr = (_tmp1 = vala_member_access_new (NULL, "assert", (_tmp0 = vala_genie_parser_get_src (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	arg_list = vala_genie_parser_parse_argument_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS);
	_tmp2 = NULL;
	_tmp3 = NULL;
	assert_expr = (_tmp3 = vala_invocation_expression_new (VALA_EXPRESSION (expr), (_tmp2 = vala_genie_parser_get_src (self, &begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = arg_list;
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				vala_invocation_expression_add_argument (assert_expr, arg);
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
	}
	_tmp4 = NULL;
	return (_tmp4 = VALA_EXPRESSION (assert_expr), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), (arg_list == NULL ? NULL : (arg_list = (g_object_unref (arg_list), NULL))), _tmp4);
}


static ValaExpression* vala_genie_parser_parse_invocation_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * inner_error;
	GeeList* arg_list;
	GeeList* init_list;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (inner), NULL);
	inner_error = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	arg_list = vala_genie_parser_parse_argument_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	init_list = vala_genie_parser_parse_object_initializer (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (gee_collection_get_size (GEE_COLLECTION (init_list)) > 0 && VALA_IS_MEMBER_ACCESS (inner)) {
		ValaMemberAccess* _tmp0;
		ValaMemberAccess* member;
		ValaSourceReference* _tmp1;
		ValaObjectCreationExpression* _tmp2;
		ValaObjectCreationExpression* expr;
		ValaExpression* _tmp3;
		/* struct creation expression*/
		_tmp0 = NULL;
		member = (_tmp0 = VALA_MEMBER_ACCESS (inner), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		vala_member_access_set_creation_member (member, TRUE);
		_tmp1 = NULL;
		_tmp2 = NULL;
		expr = (_tmp2 = vala_object_creation_expression_new (member, (_tmp1 = vala_genie_parser_get_src (self, &(*begin)))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
		vala_object_creation_expression_set_struct_creation (expr, TRUE);
		{
			GeeList* arg_collection;
			int arg_it;
			arg_collection = arg_list;
			for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
				ValaExpression* arg;
				arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
				{
					vala_object_creation_expression_add_argument (expr, arg);
					(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
				}
			}
		}
		{
			GeeList* initializer_collection;
			int initializer_it;
			initializer_collection = init_list;
			for (initializer_it = 0; initializer_it < gee_collection_get_size (GEE_COLLECTION (initializer_collection)); initializer_it = initializer_it + 1) {
				ValaMemberInitializer* initializer;
				initializer = ((ValaMemberInitializer*) (gee_list_get (GEE_LIST (initializer_collection), initializer_it)));
				{
					vala_object_creation_expression_add_member_initializer (expr, initializer);
					(initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL)));
				}
			}
		}
		_tmp3 = NULL;
		return (_tmp3 = VALA_EXPRESSION (expr), (member == NULL ? NULL : (member = (g_object_unref (member), NULL))), (arg_list == NULL ? NULL : (arg_list = (g_object_unref (arg_list), NULL))), (init_list == NULL ? NULL : (init_list = (g_object_unref (init_list), NULL))), _tmp3);
	} else {
		ValaSourceReference* _tmp4;
		ValaInvocationExpression* _tmp5;
		ValaInvocationExpression* expr;
		ValaExpression* _tmp6;
		_tmp4 = NULL;
		_tmp5 = NULL;
		expr = (_tmp5 = vala_invocation_expression_new (inner, (_tmp4 = vala_genie_parser_get_src (self, &(*begin)))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp5);
		{
			GeeList* arg_collection;
			int arg_it;
			arg_collection = arg_list;
			for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
				ValaExpression* arg;
				arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
				{
					vala_invocation_expression_add_argument (expr, arg);
					(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
				}
			}
		}
		_tmp6 = NULL;
		return (_tmp6 = VALA_EXPRESSION (expr), (arg_list == NULL ? NULL : (arg_list = (g_object_unref (arg_list), NULL))), (init_list == NULL ? NULL : (init_list = (g_object_unref (init_list), NULL))), _tmp6);
	}
	(arg_list == NULL ? NULL : (arg_list = (g_object_unref (arg_list), NULL)));
	(init_list == NULL ? NULL : (init_list = (g_object_unref (init_list), NULL)));
}


static ValaExpression* vala_genie_parser_parse_element_access (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * inner_error;
	GeeList* index_list;
	ValaSourceReference* _tmp0;
	ValaElementAccess* _tmp1;
	ValaElementAccess* expr;
	ValaExpression* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (inner), NULL);
	inner_error = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	index_list = vala_genie_parser_parse_expression_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	expr = (_tmp1 = vala_element_access_new (inner, (_tmp0 = vala_genie_parser_get_src (self, &(*begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	{
		GeeList* index_collection;
		int index_it;
		index_collection = index_list;
		for (index_it = 0; index_it < gee_collection_get_size (GEE_COLLECTION (index_collection)); index_it = index_it + 1) {
			ValaExpression* index;
			index = ((ValaExpression*) (gee_list_get (GEE_LIST (index_collection), index_it)));
			{
				vala_element_access_append_index (expr, index);
				(index == NULL ? NULL : (index = (g_object_unref (index), NULL)));
			}
		}
	}
	_tmp2 = NULL;
	return (_tmp2 = VALA_EXPRESSION (expr), (index_list == NULL ? NULL : (index_list = (g_object_unref (index_list), NULL))), _tmp2);
}


static GeeList* vala_genie_parser_parse_expression_list (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	GeeArrayList* list;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	list = gee_array_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	do {
		ValaExpression* _tmp0;
		_tmp0 = NULL;
		gee_collection_add (GEE_COLLECTION (list), (_tmp0 = vala_genie_parser_parse_expression (self, &inner_error)));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	return GEE_LIST (list);
}


static ValaExpression* vala_genie_parser_parse_this_access (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0;
	ValaExpression* _tmp1;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_THIS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = VALA_EXPRESSION (vala_member_access_new (NULL, "this", (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static ValaExpression* vala_genie_parser_parse_base_access (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0;
	ValaExpression* _tmp1;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_SUPER, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = VALA_EXPRESSION (vala_base_access_new ((_tmp0 = vala_genie_parser_get_src (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static ValaExpression* vala_genie_parser_parse_post_increment_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * inner_error;
	ValaSourceReference* _tmp0;
	ValaExpression* _tmp1;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (inner), NULL);
	inner_error = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OP_INC, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = VALA_EXPRESSION (vala_postfix_expression_new (inner, TRUE, (_tmp0 = vala_genie_parser_get_src (self, &(*begin))))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static ValaExpression* vala_genie_parser_parse_post_decrement_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * inner_error;
	ValaSourceReference* _tmp0;
	ValaExpression* _tmp1;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (inner), NULL);
	inner_error = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OP_DEC, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = VALA_EXPRESSION (vala_postfix_expression_new (inner, FALSE, (_tmp0 = vala_genie_parser_get_src (self, &(*begin))))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static ValaExpression* vala_genie_parser_parse_object_or_array_creation_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaMemberAccess* member;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_NEW, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ARRAY)) {
		ValaMemberAccess* m;
		ValaExpression* expr;
		ValaExpression* _tmp0;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		m = vala_genie_parser_parse_member_name (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		expr = vala_genie_parser_parse_array_creation_expression (self, &begin, m, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp0 = NULL;
		return (_tmp0 = expr, (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), _tmp0);
	}
	member = vala_genie_parser_parse_member_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		ValaExpression* expr;
		ValaExpression* _tmp1;
		expr = vala_genie_parser_parse_object_creation_expression (self, &begin, member, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		return (_tmp1 = expr, (member == NULL ? NULL : (member = (g_object_unref (member), NULL))), _tmp1);
	} else {
		char* _tmp2;
		GError* _tmp3;
		_tmp2 = NULL;
		inner_error = (_tmp3 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp2 = vala_genie_parser_get_error (self, "expected ( or ["))), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	(member == NULL ? NULL : (member = (g_object_unref (member), NULL)));
}


static ValaExpression* vala_genie_parser_parse_object_creation_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaMemberAccess* member, GError** error) {
	GError * inner_error;
	GeeList* arg_list;
	GeeList* init_list;
	ValaSourceReference* _tmp0;
	ValaObjectCreationExpression* _tmp1;
	ValaObjectCreationExpression* expr;
	ValaExpression* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (member), NULL);
	inner_error = NULL;
	vala_member_access_set_creation_member (member, TRUE);
	arg_list = vala_genie_parser_parse_argument_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	init_list = vala_genie_parser_parse_object_initializer (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	expr = (_tmp1 = vala_object_creation_expression_new (member, (_tmp0 = vala_genie_parser_get_src (self, &(*begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = arg_list;
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				vala_object_creation_expression_add_argument (expr, arg);
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
	}
	{
		GeeList* initializer_collection;
		int initializer_it;
		initializer_collection = init_list;
		for (initializer_it = 0; initializer_it < gee_collection_get_size (GEE_COLLECTION (initializer_collection)); initializer_it = initializer_it + 1) {
			ValaMemberInitializer* initializer;
			initializer = ((ValaMemberInitializer*) (gee_list_get (GEE_LIST (initializer_collection), initializer_it)));
			{
				vala_object_creation_expression_add_member_initializer (expr, initializer);
				(initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL)));
			}
		}
	}
	_tmp2 = NULL;
	return (_tmp2 = VALA_EXPRESSION (expr), (arg_list == NULL ? NULL : (arg_list = (g_object_unref (arg_list), NULL))), (init_list == NULL ? NULL : (init_list = (g_object_unref (init_list), NULL))), _tmp2);
}


static ValaExpression* vala_genie_parser_parse_array_creation_expression (ValaGenieParser* self, ValaSourceLocation* begin, ValaMemberAccess* member, GError** error) {
	GError * inner_error;
	gboolean size_specified;
	GeeList* size_specifier_list;
	gboolean first;
	ValaDataType* element_type;
	gboolean has_bracket;
	ValaInitializerList* initializer;
	ValaSourceReference* _tmp4;
	ValaArrayCreationExpression* _tmp5;
	ValaArrayCreationExpression* expr;
	ValaExpression* _tmp6;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (member), NULL);
	inner_error = NULL;
	size_specified = FALSE;
	size_specifier_list = NULL;
	first = TRUE;
	element_type = VALA_DATA_TYPE (vala_unresolved_type_new_from_expression (VALA_EXPRESSION (member)));
	has_bracket = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET);
	do {
		GeeList* _tmp1;
		if (!first) {
			ValaDataType* _tmp0;
			/* array of arrays: new T[][42]*/
			_tmp0 = NULL;
			element_type = (_tmp0 = VALA_DATA_TYPE (vala_array_type_new (element_type, gee_collection_get_size (GEE_COLLECTION (size_specifier_list)), vala_code_node_get_source_reference (VALA_CODE_NODE (element_type)))), (element_type == NULL ? NULL : (element_type = (g_object_unref (element_type), NULL))), _tmp0);
		} else {
			first = FALSE;
		}
		_tmp1 = NULL;
		size_specifier_list = (_tmp1 = GEE_LIST (gee_array_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal)), (size_specifier_list == NULL ? NULL : (size_specifier_list = (g_object_unref (size_specifier_list), NULL))), _tmp1);
		do {
			ValaExpression* size;
			size = NULL;
			if (has_bracket && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_COMMA) {
				ValaExpression* _tmp2;
				_tmp2 = NULL;
				size = (_tmp2 = vala_genie_parser_parse_expression (self, &inner_error), (size == NULL ? NULL : (size = (g_object_unref (size), NULL))), _tmp2);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
				size_specified = TRUE;
			}
			gee_collection_add (GEE_COLLECTION (size_specifier_list), size);
			(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		if (has_bracket) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
		}
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET));
	initializer = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaInitializerList* _tmp3;
		_tmp3 = NULL;
		initializer = (_tmp3 = vala_genie_parser_parse_initializer (self, &inner_error), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), _tmp3);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	_tmp4 = NULL;
	_tmp5 = NULL;
	expr = (_tmp5 = vala_array_creation_expression_new (element_type, gee_collection_get_size (GEE_COLLECTION (size_specifier_list)), initializer, (_tmp4 = vala_genie_parser_get_src (self, &(*begin)))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp5);
	if (size_specified) {
		{
			GeeList* size_collection;
			int size_it;
			size_collection = size_specifier_list;
			for (size_it = 0; size_it < gee_collection_get_size (GEE_COLLECTION (size_collection)); size_it = size_it + 1) {
				ValaExpression* size;
				size = ((ValaExpression*) (gee_list_get (GEE_LIST (size_collection), size_it)));
				{
					vala_array_creation_expression_append_size (expr, size);
					(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
				}
			}
		}
	}
	_tmp6 = NULL;
	return (_tmp6 = VALA_EXPRESSION (expr), (size_specifier_list == NULL ? NULL : (size_specifier_list = (g_object_unref (size_specifier_list), NULL))), (element_type == NULL ? NULL : (element_type = (g_object_unref (element_type), NULL))), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), _tmp6);
}


static GeeList* vala_genie_parser_parse_object_initializer (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	GeeArrayList* list;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	list = gee_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACE)) {
		do {
			ValaMemberInitializer* _tmp0;
			_tmp0 = NULL;
			gee_collection_add (GEE_COLLECTION (list), (_tmp0 = vala_genie_parser_parse_member_initializer (self, &inner_error)));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	return GEE_LIST (list);
}


static ValaMemberInitializer* vala_genie_parser_parse_member_initializer (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	char* id;
	ValaExpression* expr;
	ValaSourceReference* _tmp0;
	ValaMemberInitializer* _tmp1;
	ValaMemberInitializer* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSIGN, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	expr = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = vala_member_initializer_new (id, expr, (_tmp0 = vala_genie_parser_get_src (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (id = (g_free (id), NULL)), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp2);
}


static ValaExpression* vala_genie_parser_parse_sizeof_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaSourceReference* _tmp0;
	ValaExpression* _tmp1;
	ValaExpression* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_SIZEOF, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type = vala_genie_parser_parse_type (self, TRUE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = VALA_EXPRESSION (vala_sizeof_expression_new (type, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp2);
}


static ValaExpression* vala_genie_parser_parse_typeof_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaSourceReference* _tmp0;
	ValaExpression* _tmp1;
	ValaExpression* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_TYPEOF, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type = vala_genie_parser_parse_type (self, TRUE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = VALA_EXPRESSION (vala_typeof_expression_new (type, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp2);
}


static ValaUnaryOperator vala_genie_parser_get_unary_operator (ValaGenieParser* self, ValaGenieTokenType token_type) {
	ValaGenieTokenType _tmp9;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), 0);
	_tmp9 = token_type;
	if (_tmp9 == VALA_GENIE_TOKEN_TYPE_PLUS)
	do {
		return VALA_UNARY_OPERATOR_PLUS;
	} while (0); else if (_tmp9 == VALA_GENIE_TOKEN_TYPE_MINUS)
	do {
		return VALA_UNARY_OPERATOR_MINUS;
	} while (0); else if (_tmp9 == VALA_GENIE_TOKEN_TYPE_OP_NEG)
	do {
		return VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
	} while (0); else if (_tmp9 == VALA_GENIE_TOKEN_TYPE_TILDE)
	do {
		return VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT;
	} while (0); else if (_tmp9 == VALA_GENIE_TOKEN_TYPE_OP_INC)
	do {
		return VALA_UNARY_OPERATOR_INCREMENT;
	} while (0); else if (_tmp9 == VALA_GENIE_TOKEN_TYPE_OP_DEC)
	do {
		return VALA_UNARY_OPERATOR_DECREMENT;
	} while (0); else if (_tmp9 == VALA_GENIE_TOKEN_TYPE_REF)
	do {
		return VALA_UNARY_OPERATOR_REF;
	} while (0); else if (_tmp9 == VALA_GENIE_TOKEN_TYPE_OUT)
	do {
		return VALA_UNARY_OPERATOR_OUT;
	} while (0); else
	do {
		return VALA_UNARY_OPERATOR_NONE;
	} while (0);
}


static ValaExpression* vala_genie_parser_parse_unary_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaUnaryOperator operator;
	ValaGenieTokenType _tmp18;
	ValaExpression* expr;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	operator = vala_genie_parser_get_unary_operator (self, vala_genie_parser_current (self));
	if (operator != VALA_UNARY_OPERATOR_NONE) {
		ValaExpression* op;
		ValaSourceReference* _tmp0;
		ValaExpression* _tmp1;
		ValaExpression* _tmp2;
		vala_genie_parser_next (self);
		op = vala_genie_parser_parse_unary_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp0 = NULL;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = (_tmp1 = VALA_EXPRESSION (vala_unary_expression_new (operator, op, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (op == NULL ? NULL : (op = (g_object_unref (op), NULL))), _tmp2);
	}
	_tmp18 = vala_genie_parser_current (self);
	if (_tmp18 == VALA_GENIE_TOKEN_TYPE_HASH)
	do {
		ValaExpression* op;
		ValaSourceReference* _tmp3;
		ValaExpression* _tmp4;
		ValaExpression* _tmp5;
		vala_genie_parser_next (self);
		op = vala_genie_parser_parse_unary_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp3 = NULL;
		_tmp4 = NULL;
		_tmp5 = NULL;
		return (_tmp5 = (_tmp4 = VALA_EXPRESSION (vala_reference_transfer_expression_new (op, (_tmp3 = vala_genie_parser_get_src (self, &begin)))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4), (op == NULL ? NULL : (op = (g_object_unref (op), NULL))), _tmp5);
	} while (0); else if (_tmp18 == VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)
	do {
		ValaGenieTokenType _tmp11;
		vala_genie_parser_next (self);
		_tmp11 = vala_genie_parser_current (self);
		if (_tmp11 == VALA_GENIE_TOKEN_TYPE_VOID || _tmp11 == VALA_GENIE_TOKEN_TYPE_DYNAMIC || _tmp11 == VALA_GENIE_TOKEN_TYPE_WEAK || _tmp11 == VALA_GENIE_TOKEN_TYPE_IDENTIFIER)
		do {
			ValaDataType* type;
			type = vala_genie_parser_parse_type (self, TRUE, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)) {
				ValaGenieTokenType _tmp10;
				/* check follower to decide whether to create cast expression*/
				_tmp10 = vala_genie_parser_current (self);
				if (_tmp10 == VALA_GENIE_TOKEN_TYPE_OP_NEG || _tmp10 == VALA_GENIE_TOKEN_TYPE_TILDE || _tmp10 == VALA_GENIE_TOKEN_TYPE_OPEN_PARENS || _tmp10 == VALA_GENIE_TOKEN_TYPE_TRUE || _tmp10 == VALA_GENIE_TOKEN_TYPE_FALSE || _tmp10 == VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL || _tmp10 == VALA_GENIE_TOKEN_TYPE_REAL_LITERAL || _tmp10 == VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL || _tmp10 == VALA_GENIE_TOKEN_TYPE_STRING_LITERAL || _tmp10 == VALA_GENIE_TOKEN_TYPE_NULL || _tmp10 == VALA_GENIE_TOKEN_TYPE_THIS || _tmp10 == VALA_GENIE_TOKEN_TYPE_SUPER || _tmp10 == VALA_GENIE_TOKEN_TYPE_NEW || _tmp10 == VALA_GENIE_TOKEN_TYPE_SIZEOF || _tmp10 == VALA_GENIE_TOKEN_TYPE_TYPEOF || _tmp10 == VALA_GENIE_TOKEN_TYPE_IDENTIFIER)
				do {
					ValaExpression* inner;
					ValaSourceReference* _tmp7;
					ValaExpression* _tmp8;
					ValaExpression* _tmp9;
					if (!(VALA_IS_POINTER_TYPE (type)) && !vala_data_type_get_value_owned (type)) {
						ValaSourceReference* _tmp6;
						_tmp6 = NULL;
						vala_report_warning ((_tmp6 = vala_genie_parser_get_src (self, &begin)), "obsolete syntax, weak type modifier unused in cast expressions");
						(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
					}
					inner = vala_genie_parser_parse_unary_expression (self, &inner_error);
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						return NULL;
					}
					_tmp7 = NULL;
					_tmp8 = NULL;
					_tmp9 = NULL;
					return (_tmp9 = (_tmp8 = VALA_EXPRESSION (vala_cast_expression_new (inner, type, (_tmp7 = vala_genie_parser_get_src (self, &begin)), FALSE)), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8), (inner == NULL ? NULL : (inner = (g_object_unref (inner), NULL))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp9);
				} while (0);
			}
			(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
			break;
		} while (0);
		vala_genie_parser_rollback (self, &begin);
		break;
	} while (0); else if (_tmp18 == VALA_GENIE_TOKEN_TYPE_STAR)
	do {
		ValaExpression* op;
		ValaSourceReference* _tmp12;
		ValaExpression* _tmp13;
		ValaExpression* _tmp14;
		vala_genie_parser_next (self);
		op = vala_genie_parser_parse_unary_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp12 = NULL;
		_tmp13 = NULL;
		_tmp14 = NULL;
		return (_tmp14 = (_tmp13 = VALA_EXPRESSION (vala_pointer_indirection_new (op, (_tmp12 = vala_genie_parser_get_src (self, &begin)))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), _tmp13), (op == NULL ? NULL : (op = (g_object_unref (op), NULL))), _tmp14);
	} while (0); else if (_tmp18 == VALA_GENIE_TOKEN_TYPE_BITWISE_AND)
	do {
		ValaExpression* op;
		ValaSourceReference* _tmp15;
		ValaExpression* _tmp16;
		ValaExpression* _tmp17;
		vala_genie_parser_next (self);
		op = vala_genie_parser_parse_unary_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp15 = NULL;
		_tmp16 = NULL;
		_tmp17 = NULL;
		return (_tmp17 = (_tmp16 = VALA_EXPRESSION (vala_addressof_expression_new (op, (_tmp15 = vala_genie_parser_get_src (self, &begin)))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16), (op == NULL ? NULL : (op = (g_object_unref (op), NULL))), _tmp17);
	} while (0);
	expr = vala_genie_parser_parse_primary_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	return expr;
}


static ValaBinaryOperator vala_genie_parser_get_binary_operator (ValaGenieParser* self, ValaGenieTokenType token_type) {
	ValaGenieTokenType _tmp14;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), 0);
	_tmp14 = token_type;
	if (_tmp14 == VALA_GENIE_TOKEN_TYPE_STAR)
	do {
		return VALA_BINARY_OPERATOR_MUL;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_DIV)
	do {
		return VALA_BINARY_OPERATOR_DIV;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_PERCENT)
	do {
		return VALA_BINARY_OPERATOR_MOD;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_PLUS)
	do {
		return VALA_BINARY_OPERATOR_PLUS;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_MINUS)
	do {
		return VALA_BINARY_OPERATOR_MINUS;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_OP_LT)
	do {
		return VALA_BINARY_OPERATOR_LESS_THAN;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_OP_GT)
	do {
		return VALA_BINARY_OPERATOR_GREATER_THAN;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_OP_LE)
	do {
		return VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_OP_GE)
	do {
		return VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_OP_EQ)
	do {
		return VALA_BINARY_OPERATOR_EQUALITY;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_IS)
	do {
		vala_genie_parser_next (self);
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_NEG) {
			vala_genie_parser_prev (self);
			return VALA_BINARY_OPERATOR_INEQUALITY;
		}
		vala_genie_parser_prev (self);
		return VALA_BINARY_OPERATOR_EQUALITY;
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_OP_NE)
	do {
		return VALA_BINARY_OPERATOR_INEQUALITY;
	} while (0); else
	do {
		return VALA_BINARY_OPERATOR_NONE;
	} while (0);
}


static ValaExpression* vala_genie_parser_parse_multiplicative_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_unary_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	found = TRUE;
	while (found) {
		ValaBinaryOperator operator;
		ValaBinaryOperator _tmp2;
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		_tmp2 = operator;
		if (_tmp2 == VALA_BINARY_OPERATOR_MUL || _tmp2 == VALA_BINARY_OPERATOR_DIV || _tmp2 == VALA_BINARY_OPERATOR_MOD)
		do {
			ValaExpression* right;
			ValaExpression* _tmp1;
			ValaSourceReference* _tmp0;
			vala_genie_parser_next (self);
			right = vala_genie_parser_parse_unary_expression (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp1 = NULL;
			_tmp0 = NULL;
			left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (operator, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
			(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
			break;
		} while (0); else
		do {
			found = FALSE;
			break;
		} while (0);
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_additive_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_multiplicative_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	found = TRUE;
	while (found) {
		ValaBinaryOperator operator;
		ValaBinaryOperator _tmp2;
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		_tmp2 = operator;
		if (_tmp2 == VALA_BINARY_OPERATOR_PLUS || _tmp2 == VALA_BINARY_OPERATOR_MINUS)
		do {
			ValaExpression* right;
			ValaExpression* _tmp1;
			ValaSourceReference* _tmp0;
			vala_genie_parser_next (self);
			right = vala_genie_parser_parse_multiplicative_expression (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp1 = NULL;
			_tmp0 = NULL;
			left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (operator, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
			(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
			break;
		} while (0); else
		do {
			found = FALSE;
			break;
		} while (0);
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_shift_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_additive_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	found = TRUE;
	while (found) {
		ValaGenieTokenType _tmp4;
		_tmp4 = vala_genie_parser_current (self);
		if (_tmp4 == VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT)
		do {
			ValaExpression* right;
			ValaExpression* _tmp1;
			ValaSourceReference* _tmp0;
			vala_genie_parser_next (self);
			right = vala_genie_parser_parse_additive_expression (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp1 = NULL;
			_tmp0 = NULL;
			left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_SHIFT_LEFT, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
			(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
			break;
		} while (0); else if (_tmp4 == VALA_GENIE_TOKEN_TYPE_OP_GT)
		do {
			gchar* first_gt_pos;
			first_gt_pos = self->priv->tokens[self->priv->index].begin.pos;
			vala_genie_parser_next (self);
			if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_GT && self->priv->tokens[self->priv->index].begin.pos == first_gt_pos + 1) {
				ValaExpression* right;
				ValaExpression* _tmp3;
				ValaSourceReference* _tmp2;
				vala_genie_parser_next (self);
				right = vala_genie_parser_parse_additive_expression (self, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
				_tmp3 = NULL;
				_tmp2 = NULL;
				left = (_tmp3 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_SHIFT_RIGHT, left, right, (_tmp2 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp3);
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
			} else {
				vala_genie_parser_prev (self);
				found = FALSE;
			}
			break;
		} while (0); else
		do {
			found = FALSE;
			break;
		} while (0);
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_relational_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_shift_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	found = TRUE;
	while (found) {
		ValaBinaryOperator operator;
		ValaBinaryOperator _tmp9;
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		_tmp9 = operator;
		if (_tmp9 == VALA_BINARY_OPERATOR_LESS_THAN || _tmp9 == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL || _tmp9 == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL)
		do {
			ValaExpression* right;
			ValaExpression* _tmp1;
			ValaSourceReference* _tmp0;
			vala_genie_parser_next (self);
			right = vala_genie_parser_parse_shift_expression (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp1 = NULL;
			_tmp0 = NULL;
			left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (operator, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
			(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
			break;
		} while (0); else if (_tmp9 == VALA_BINARY_OPERATOR_GREATER_THAN)
		do {
			vala_genie_parser_next (self);
			if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_OP_GT && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_OP_GE) {
				ValaExpression* right;
				ValaExpression* _tmp3;
				ValaSourceReference* _tmp2;
				right = vala_genie_parser_parse_shift_expression (self, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
				_tmp3 = NULL;
				_tmp2 = NULL;
				left = (_tmp3 = VALA_EXPRESSION (vala_binary_expression_new (operator, left, right, (_tmp2 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp3);
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
			} else {
				vala_genie_parser_prev (self);
				found = FALSE;
			}
			break;
		} while (0); else
		do {
			ValaGenieTokenType _tmp8;
			_tmp8 = vala_genie_parser_current (self);
			if (_tmp8 == VALA_GENIE_TOKEN_TYPE_ISA)
			do {
				ValaDataType* type;
				ValaExpression* _tmp5;
				ValaSourceReference* _tmp4;
				vala_genie_parser_next (self);
				type = vala_genie_parser_parse_type (self, TRUE, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
				_tmp5 = NULL;
				_tmp4 = NULL;
				left = (_tmp5 = VALA_EXPRESSION (vala_typecheck_new (left, type, (_tmp4 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp5);
				(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
				(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
				break;
			} while (0); else if (_tmp8 == VALA_GENIE_TOKEN_TYPE_AS)
			do {
				ValaDataType* type;
				ValaExpression* _tmp7;
				ValaSourceReference* _tmp6;
				vala_genie_parser_next (self);
				type = vala_genie_parser_parse_type (self, TRUE, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
				_tmp7 = NULL;
				_tmp6 = NULL;
				left = (_tmp7 = VALA_EXPRESSION (vala_cast_expression_new (left, type, (_tmp6 = vala_genie_parser_get_src (self, &begin)), TRUE)), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp7);
				(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
				(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
				break;
			} while (0); else
			do {
				found = FALSE;
				break;
			} while (0);
			break;
		} while (0);
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_equality_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_relational_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	found = TRUE;
	while (found) {
		ValaBinaryOperator operator;
		ValaBinaryOperator _tmp2;
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		_tmp2 = operator;
		if (_tmp2 == VALA_BINARY_OPERATOR_INEQUALITY || _tmp2 == VALA_BINARY_OPERATOR_EQUALITY)
		do {
			ValaExpression* right;
			ValaExpression* _tmp1;
			ValaSourceReference* _tmp0;
			if ((operator == VALA_BINARY_OPERATOR_INEQUALITY) && (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_IS)) {
				vala_genie_parser_next (self);
			}
			vala_genie_parser_next (self);
			right = vala_genie_parser_parse_relational_expression (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp1 = NULL;
			_tmp0 = NULL;
			left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (operator, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
			(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
			break;
		} while (0); else
		do {
			found = FALSE;
			break;
		} while (0);
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_and_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_equality_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_BITWISE_AND)) {
		ValaExpression* right;
		ValaExpression* _tmp1;
		ValaSourceReference* _tmp0;
		right = vala_genie_parser_parse_equality_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_AND, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_exclusive_or_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_and_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CARRET)) {
		ValaExpression* right;
		ValaExpression* _tmp1;
		ValaSourceReference* _tmp0;
		right = vala_genie_parser_parse_and_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_XOR, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_inclusive_or_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_exclusive_or_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_BITWISE_OR)) {
		ValaExpression* right;
		ValaExpression* _tmp1;
		ValaSourceReference* _tmp0;
		right = vala_genie_parser_parse_exclusive_or_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_OR, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_in_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_inclusive_or_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_IN)) {
		ValaExpression* right;
		ValaExpression* _tmp1;
		ValaSourceReference* _tmp0;
		right = vala_genie_parser_parse_inclusive_or_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_IN, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_conditional_and_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_in_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OP_AND)) {
		ValaExpression* right;
		ValaExpression* _tmp1;
		ValaSourceReference* _tmp0;
		right = vala_genie_parser_parse_in_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_AND, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_conditional_or_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_conditional_and_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OP_OR)) {
		ValaExpression* right;
		ValaExpression* _tmp1;
		ValaSourceReference* _tmp0;
		right = vala_genie_parser_parse_conditional_and_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		left = (_tmp1 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_OR, left, right, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (left == NULL ? NULL : (left = (g_object_unref (left), NULL))), _tmp1);
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_conditional_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* condition;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	condition = vala_genie_parser_parse_conditional_or_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR)) {
		ValaExpression* true_expr;
		ValaExpression* false_expr;
		ValaSourceReference* _tmp0;
		ValaExpression* _tmp1;
		ValaExpression* _tmp2;
		true_expr = vala_genie_parser_parse_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		false_expr = vala_genie_parser_parse_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp0 = NULL;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = (_tmp1 = VALA_EXPRESSION (vala_conditional_expression_new (condition, true_expr, false_expr, (_tmp0 = vala_genie_parser_get_src (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (true_expr == NULL ? NULL : (true_expr = (g_object_unref (true_expr), NULL))), (false_expr == NULL ? NULL : (false_expr = (g_object_unref (false_expr), NULL))), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), _tmp2);
	} else {
		return condition;
	}
	(condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL)));
}


static ValaExpression* vala_genie_parser_parse_lambda_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	GeeList* params;
	ValaLambdaExpression* lambda;
	ValaExpression* _tmp6;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	params = GEE_LIST (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_direct_equal));
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEF, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
			do {
				char* _tmp0;
				_tmp0 = NULL;
				gee_collection_add (GEE_COLLECTION (params), (_tmp0 = vala_genie_parser_parse_identifier (self, &inner_error)));
				_tmp0 = (g_free (_tmp0), NULL);
			} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	} else {
		char* _tmp1;
		_tmp1 = NULL;
		gee_collection_add (GEE_COLLECTION (params), (_tmp1 = vala_genie_parser_parse_identifier (self, &inner_error)));
		_tmp1 = (g_free (_tmp1), NULL);
	}
	lambda = NULL;
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* block;
		ValaLambdaExpression* _tmp3;
		ValaSourceReference* _tmp2;
		block = vala_genie_parser_parse_block (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp3 = NULL;
		_tmp2 = NULL;
		lambda = (_tmp3 = vala_lambda_expression_new_with_statement_body (block, (_tmp2 = vala_genie_parser_get_src (self, &begin))), (lambda == NULL ? NULL : (lambda = (g_object_unref (lambda), NULL))), _tmp3);
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	} else {
		ValaExpression* expr;
		ValaLambdaExpression* _tmp5;
		ValaSourceReference* _tmp4;
		expr = vala_genie_parser_parse_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp5 = NULL;
		_tmp4 = NULL;
		lambda = (_tmp5 = vala_lambda_expression_new (expr, (_tmp4 = vala_genie_parser_get_src (self, &begin))), (lambda == NULL ? NULL : (lambda = (g_object_unref (lambda), NULL))), _tmp5);
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		vala_genie_parser_expect_terminator (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	}
	{
		GeeList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			char* param;
			param = ((char*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				vala_lambda_expression_add_parameter (lambda, param);
				param = (g_free (param), NULL);
			}
		}
	}
	_tmp6 = NULL;
	return (_tmp6 = VALA_EXPRESSION (lambda), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp6);
}


static ValaAssignmentOperator vala_genie_parser_get_assignment_operator (ValaGenieParser* self, ValaGenieTokenType token_type) {
	ValaGenieTokenType _tmp11;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), 0);
	_tmp11 = token_type;
	if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN)
	do {
		return VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} while (0); else if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD)
	do {
		return VALA_ASSIGNMENT_OPERATOR_ADD;
	} while (0); else if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB)
	do {
		return VALA_ASSIGNMENT_OPERATOR_SUB;
	} while (0); else if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR)
	do {
		return VALA_ASSIGNMENT_OPERATOR_BITWISE_OR;
	} while (0); else if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND)
	do {
		return VALA_ASSIGNMENT_OPERATOR_BITWISE_AND;
	} while (0); else if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR)
	do {
		return VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR;
	} while (0); else if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV)
	do {
		return VALA_ASSIGNMENT_OPERATOR_DIV;
	} while (0); else if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL)
	do {
		return VALA_ASSIGNMENT_OPERATOR_MUL;
	} while (0); else if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT)
	do {
		return VALA_ASSIGNMENT_OPERATOR_PERCENT;
	} while (0); else if (_tmp11 == VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT)
	do {
		return VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
	} while (0); else
	do {
		return VALA_ASSIGNMENT_OPERATOR_NONE;
	} while (0);
}


static ValaExpression* vala_genie_parser_parse_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* expr;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_DEF) {
		ValaExpression* lambda;
		lambda = vala_genie_parser_parse_lambda_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		self->priv->current_expr_is_lambda = TRUE;
		return lambda;
	}
	begin = vala_genie_parser_get_location (self);
	expr = vala_genie_parser_parse_conditional_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	while (TRUE) {
		ValaAssignmentOperator operator;
		operator = vala_genie_parser_get_assignment_operator (self, vala_genie_parser_current (self));
		if (operator != VALA_ASSIGNMENT_OPERATOR_NONE) {
			ValaExpression* rhs;
			ValaExpression* _tmp2;
			ValaSourceReference* _tmp1;
			vala_genie_parser_next (self);
			rhs = vala_genie_parser_parse_expression (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp2 = NULL;
			_tmp1 = NULL;
			expr = (_tmp2 = VALA_EXPRESSION (vala_assignment_new (expr, rhs, operator, (_tmp1 = vala_genie_parser_get_src (self, &begin)))), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp2);
			(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
			if (expr == NULL) {
				/* workaround for current limitation of exception handling*/
				inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in assignment");
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
			}
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		} else {
			if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_GT) {
				gchar* first_gt_pos;
				/* >>=*/
				first_gt_pos = self->priv->tokens[self->priv->index].begin.pos;
				vala_genie_parser_next (self);
				/* only accept >>= when there is no space between the two > signs*/
				if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_GE && self->priv->tokens[self->priv->index].begin.pos == first_gt_pos + 1) {
					ValaExpression* rhs;
					ValaExpression* _tmp4;
					ValaSourceReference* _tmp3;
					vala_genie_parser_next (self);
					rhs = vala_genie_parser_parse_expression (self, &inner_error);
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						return NULL;
					}
					_tmp4 = NULL;
					_tmp3 = NULL;
					expr = (_tmp4 = VALA_EXPRESSION (vala_assignment_new (expr, rhs, VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, (_tmp3 = vala_genie_parser_get_src (self, &begin)))), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp4);
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					if (expr == NULL) {
						/* workaround for current limitation of exception handling*/
						inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in assignment");
						if (inner_error != NULL) {
							g_propagate_error (error, inner_error);
							return NULL;
						}
					}
					(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
				} else {
					vala_genie_parser_prev (self);
					break;
				}
			} else {
				break;
			}
		}
	}
	return expr;
}


static ValaStatement* vala_genie_parser_get_for_statement_type (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	gboolean is_foreach;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	is_foreach = FALSE;
	while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DO) {
		vala_genie_parser_next (self);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_IN)) {
			is_foreach = TRUE;
			break;
		}
	}
	vala_genie_parser_rollback (self, &begin);
	if (is_foreach) {
		return vala_genie_parser_parse_foreach_statement (self, &inner_error);
	} else {
		return vala_genie_parser_parse_for_statement (self, &inner_error);
	}
}


static void vala_genie_parser_parse_statements (ValaGenieParser* self, ValaBlock* block, GError** error) {
	GError * inner_error;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_BLOCK (block));
	inner_error = NULL;
	while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_WHEN && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEFAULT) {
		{
			ValaStatement* stmt;
			gboolean is_decl;
			char* _tmp0;
			ValaGenieTokenType _tmp20;
			stmt = NULL;
			is_decl = FALSE;
			_tmp0 = NULL;
			self->priv->comment = (_tmp0 = vala_genie_scanner_pop_comment (self->priv->scanner), (self->priv->comment = (g_free (self->priv->comment), NULL)), _tmp0);
			_tmp20 = vala_genie_parser_current (self);
			if (_tmp20 == VALA_GENIE_TOKEN_TYPE_REQUIRES || _tmp20 == VALA_GENIE_TOKEN_TYPE_ENSURES)
			do {
				ValaSourceLocation begin;
				ValaStatement* _tmp2;
				ValaSourceReference* _tmp1;
				begin = vala_genie_parser_get_location (self);
				vala_genie_parser_next (self);
				if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL) && vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
					while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
						vala_genie_parser_next (self);
					}
					vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &inner_error);
					if (inner_error != NULL) {
						if (inner_error->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
						g_clear_error (&inner_error);
					}
				} else {
					while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL) {
						vala_genie_parser_next (self);
					}
					vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
					if (inner_error != NULL) {
						if (inner_error->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
						g_clear_error (&inner_error);
					}
				}
				_tmp2 = NULL;
				_tmp1 = NULL;
				stmt = (_tmp2 = VALA_STATEMENT (vala_empty_statement_new ((_tmp1 = vala_genie_parser_get_src_com (self, &begin)))), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp2);
				(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_INDENT)
			do {
				ValaStatement* _tmp3;
				_tmp3 = NULL;
				stmt = (_tmp3 = VALA_STATEMENT (vala_genie_parser_parse_block (self, &inner_error)), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp3);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_SEMICOLON || _tmp20 == VALA_GENIE_TOKEN_TYPE_PASS)
			do {
				ValaStatement* _tmp4;
				_tmp4 = NULL;
				stmt = (_tmp4 = vala_genie_parser_parse_empty_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp4);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_PRINT || _tmp20 == VALA_GENIE_TOKEN_TYPE_ASSERT)
			do {
				ValaStatement* _tmp5;
				_tmp5 = NULL;
				stmt = (_tmp5 = vala_genie_parser_parse_expression_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp5);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_IF)
			do {
				ValaStatement* _tmp6;
				_tmp6 = NULL;
				stmt = (_tmp6 = vala_genie_parser_parse_if_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp6);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_CASE)
			do {
				ValaStatement* _tmp7;
				_tmp7 = NULL;
				stmt = (_tmp7 = vala_genie_parser_parse_switch_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp7);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_WHILE)
			do {
				ValaStatement* _tmp8;
				_tmp8 = NULL;
				stmt = (_tmp8 = vala_genie_parser_parse_while_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp8);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_DO)
			do {
				ValaStatement* _tmp9;
				_tmp9 = NULL;
				stmt = (_tmp9 = vala_genie_parser_parse_do_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp9);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_FOR)
			do {
				ValaStatement* _tmp10;
				_tmp10 = NULL;
				stmt = (_tmp10 = vala_genie_parser_get_for_statement_type (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp10);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_BREAK)
			do {
				ValaStatement* _tmp11;
				_tmp11 = NULL;
				stmt = (_tmp11 = vala_genie_parser_parse_break_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp11);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_CONTINUE)
			do {
				ValaStatement* _tmp12;
				_tmp12 = NULL;
				stmt = (_tmp12 = vala_genie_parser_parse_continue_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp12);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_RETURN)
			do {
				ValaStatement* _tmp13;
				_tmp13 = NULL;
				stmt = (_tmp13 = vala_genie_parser_parse_return_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp13);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_RAISE)
			do {
				ValaStatement* _tmp14;
				_tmp14 = NULL;
				stmt = (_tmp14 = vala_genie_parser_parse_throw_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp14);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_TRY)
			do {
				ValaStatement* _tmp15;
				_tmp15 = NULL;
				stmt = (_tmp15 = vala_genie_parser_parse_try_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp15);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_LOCK)
			do {
				ValaStatement* _tmp16;
				_tmp16 = NULL;
				stmt = (_tmp16 = vala_genie_parser_parse_lock_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp16);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_DELETE)
			do {
				ValaStatement* _tmp17;
				_tmp17 = NULL;
				stmt = (_tmp17 = vala_genie_parser_parse_delete_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp17);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_VAR)
			do {
				is_decl = TRUE;
				vala_genie_parser_parse_local_variable_declarations (self, block, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else if (_tmp20 == VALA_GENIE_TOKEN_TYPE_OP_INC || _tmp20 == VALA_GENIE_TOKEN_TYPE_OP_DEC || _tmp20 == VALA_GENIE_TOKEN_TYPE_SUPER || _tmp20 == VALA_GENIE_TOKEN_TYPE_THIS || _tmp20 == VALA_GENIE_TOKEN_TYPE_OPEN_PARENS || _tmp20 == VALA_GENIE_TOKEN_TYPE_STAR || _tmp20 == VALA_GENIE_TOKEN_TYPE_NEW)
			do {
				ValaStatement* _tmp18;
				_tmp18 = NULL;
				stmt = (_tmp18 = vala_genie_parser_parse_expression_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp18);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				break;
			} while (0); else
			do {
				gboolean is_expr;
				is_expr = vala_genie_parser_is_expression (self, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch1_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				if (is_expr) {
					ValaStatement* _tmp19;
					_tmp19 = NULL;
					stmt = (_tmp19 = vala_genie_parser_parse_expression_statement (self, &inner_error), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp19);
					if (inner_error != NULL) {
						if (inner_error->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
						g_clear_error (&inner_error);
					}
				} else {
					is_decl = TRUE;
					vala_genie_parser_parse_local_variable_declarations (self, block, &inner_error);
					if (inner_error != NULL) {
						if (inner_error->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
						g_clear_error (&inner_error);
					}
				}
				break;
			} while (0);
			if (!is_decl) {
				if (stmt == NULL) {
					/* workaround for current limitation of exception handling*/
					inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in statement");
					if (inner_error != NULL) {
						if (inner_error->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
						g_clear_error (&inner_error);
					}
				}
				vala_block_add_statement (block, stmt);
			}
			(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
		}
		goto __finally1;
		__catch1_vala_parse_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				if (vala_genie_parser_recover (self) != VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN) {
					/* beginning of next declaration or end of file reached
					 return what we have so far*/
					break;
				}
			}
		}
		__finally1:
		;
	}
}


static gboolean vala_genie_parser_is_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaGenieTokenType _tmp1;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	/* decide between declaration and expression statement*/
	vala_genie_parser_skip_type (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return FALSE;
	}
	_tmp1 = vala_genie_parser_current (self);
	if (_tmp1 == VALA_GENIE_TOKEN_TYPE_OPEN_PARENS || _tmp1 == VALA_GENIE_TOKEN_TYPE_OP_INC || _tmp1 == VALA_GENIE_TOKEN_TYPE_OP_DEC || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT || _tmp1 == VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB || _tmp1 == VALA_GENIE_TOKEN_TYPE_OP_GT || _tmp1 == VALA_GENIE_TOKEN_TYPE_DOT || _tmp1 == VALA_GENIE_TOKEN_TYPE_OP_PTR)
	do {
		vala_genie_parser_rollback (self, &begin);
		return TRUE;
	} while (0);
	vala_genie_parser_rollback (self, &begin);
	return FALSE;
}


static ValaBlock* vala_genie_parser_parse_embedded_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	char* _tmp1;
	ValaBlock* block;
	ValaStatement* stmt;
	ValaBlock* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_INDENT) {
		ValaBlock* block;
		block = vala_genie_parser_parse_block (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		return block;
	}
	_tmp1 = NULL;
	self->priv->comment = (_tmp1 = vala_genie_scanner_pop_comment (self->priv->scanner), (self->priv->comment = (g_free (self->priv->comment), NULL)), _tmp1);
	block = vala_block_new (NULL);
	stmt = vala_genie_parser_parse_embedded_statement_without_block (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (stmt == NULL) {
		/* workaround for current limitation of exception handling*/
		inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in embedded statement");
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	vala_block_add_statement (block, stmt);
	_tmp2 = NULL;
	return (_tmp2 = block, (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp2);
}


static ValaStatement* vala_genie_parser_parse_embedded_statement_without_block (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaGenieTokenType _tmp14;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	_tmp14 = vala_genie_parser_current (self);
	if (_tmp14 == VALA_GENIE_TOKEN_TYPE_PASS || _tmp14 == VALA_GENIE_TOKEN_TYPE_SEMICOLON)
	do {
		return vala_genie_parser_parse_empty_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_IF)
	do {
		return vala_genie_parser_parse_if_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_CASE)
	do {
		return vala_genie_parser_parse_switch_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_WHILE)
	do {
		return vala_genie_parser_parse_while_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_DO)
	do {
		return vala_genie_parser_parse_do_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_FOR)
	do {
		return vala_genie_parser_get_for_statement_type (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_BREAK)
	do {
		return vala_genie_parser_parse_break_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_CONTINUE)
	do {
		return vala_genie_parser_parse_continue_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_RETURN)
	do {
		return vala_genie_parser_parse_return_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_RAISE)
	do {
		return vala_genie_parser_parse_throw_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_TRY)
	do {
		return vala_genie_parser_parse_try_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_LOCK)
	do {
		return vala_genie_parser_parse_lock_statement (self, &inner_error);
	} while (0); else if (_tmp14 == VALA_GENIE_TOKEN_TYPE_DELETE)
	do {
		return vala_genie_parser_parse_delete_statement (self, &inner_error);
	} while (0); else
	do {
		return vala_genie_parser_parse_expression_statement (self, &inner_error);
	} while (0);
}


static ValaBlock* vala_genie_parser_parse_block (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	GeeList* list;
	ValaSourceReference* _tmp0;
	ValaBlock* _tmp1;
	ValaBlock* block;
	ValaBlock* _tmp3;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	list = GEE_LIST (gee_array_list_new (VALA_TYPE_STATEMENT, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	block = (_tmp1 = vala_block_new ((_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_genie_parser_parse_statements (self, block, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DEDENT)) {
		/* only report error if it's not a secondary error*/
		if (vala_report_get_errors () == 0) {
			ValaSourceReference* _tmp2;
			_tmp2 = NULL;
			vala_report_error ((_tmp2 = vala_genie_parser_get_current_src (self)), "tab indentation is incorrect");
			(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		}
	}
	_tmp3 = NULL;
	return (_tmp3 = block, (list == NULL ? NULL : (list = (g_object_unref (list), NULL))), _tmp3);
}


static ValaStatement* vala_genie_parser_parse_empty_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0;
	ValaStatement* _tmp1;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_PASS);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_SEMICOLON);
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = VALA_STATEMENT (vala_empty_statement_new ((_tmp0 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static void vala_genie_parser_add_local_var_variable (ValaGenieParser* self, ValaBlock* block, const char* id, GError** error) {
	GError * inner_error;
	ValaDataType* type_copy;
	ValaLocalVariable* local;
	ValaDeclarationStatement* _tmp0;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_BLOCK (block));
	g_return_if_fail (id != NULL);
	inner_error = NULL;
	type_copy = NULL;
	local = vala_genie_parser_parse_local_variable (self, type_copy, id, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	_tmp0 = NULL;
	vala_block_add_statement (block, VALA_STATEMENT ((_tmp0 = vala_declaration_statement_new (VALA_SYMBOL (local), vala_code_node_get_source_reference (VALA_CODE_NODE (local))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	(type_copy == NULL ? NULL : (type_copy = (g_object_unref (type_copy), NULL)));
	(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
}


static void vala_genie_parser_parse_local_variable_declarations (ValaGenieParser* self, ValaBlock* block, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	GeeArrayList* id_list;
	ValaDataType* variable_type;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_BLOCK (block));
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VAR)) {
		/* support block vars */
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL) && vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
			while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
				char* s;
				s = vala_genie_parser_parse_identifier (self, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return;
				}
				vala_genie_parser_add_local_var_variable (self, block, s, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return;
				}
				vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
				vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_SEMICOLON);
				s = (g_free (s), NULL);
			}
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
		} else {
			char* s;
			s = vala_genie_parser_parse_identifier (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
			vala_genie_parser_add_local_var_variable (self, block, s, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
			vala_genie_parser_expect_terminator (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
			s = (g_free (s), NULL);
		}
		return;
	}
	id_list = gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_direct_equal);
	variable_type = NULL;
	do {
		char* _tmp0;
		_tmp0 = NULL;
		gee_collection_add (GEE_COLLECTION (id_list), (_tmp0 = vala_genie_parser_parse_identifier (self, &inner_error)));
		_tmp0 = (g_free (_tmp0), NULL);
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	_tmp1 = NULL;
	variable_type = (_tmp1 = vala_genie_parser_parse_type (self, TRUE, &inner_error), (variable_type == NULL ? NULL : (variable_type = (g_object_unref (variable_type), NULL))), _tmp1);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	{
		GeeArrayList* id_collection;
		int id_it;
		id_collection = id_list;
		for (id_it = 0; id_it < gee_collection_get_size (GEE_COLLECTION (id_collection)); id_it = id_it + 1) {
			char* id;
			id = ((char*) (gee_list_get (GEE_LIST (id_collection), id_it)));
			{
				ValaDataType* type_copy;
				ValaLocalVariable* local;
				ValaDeclarationStatement* _tmp3;
				type_copy = NULL;
				if (variable_type != NULL) {
					ValaDataType* _tmp2;
					_tmp2 = NULL;
					type_copy = (_tmp2 = vala_data_type_copy (variable_type), (type_copy == NULL ? NULL : (type_copy = (g_object_unref (type_copy), NULL))), _tmp2);
				}
				local = vala_genie_parser_parse_local_variable (self, type_copy, id, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return;
				}
				_tmp3 = NULL;
				vala_block_add_statement (block, VALA_STATEMENT ((_tmp3 = vala_declaration_statement_new (VALA_SYMBOL (local), vala_code_node_get_source_reference (VALA_CODE_NODE (local))))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				id = (g_free (id), NULL);
				(type_copy == NULL ? NULL : (type_copy = (g_object_unref (type_copy), NULL)));
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
			}
		}
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	(id_list == NULL ? NULL : (id_list = (g_object_unref (id_list), NULL)));
	(variable_type == NULL ? NULL : (variable_type = (g_object_unref (variable_type), NULL)));
}


static ValaLocalVariable* vala_genie_parser_parse_local_variable (ValaGenieParser* self, ValaDataType* variable_type, const char* id, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* initializer;
	ValaSourceReference* _tmp5;
	ValaLocalVariable* _tmp6;
	ValaLocalVariable* _tmp7;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (variable_type == NULL || VALA_IS_DATA_TYPE (variable_type), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	initializer = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp0;
		ValaArrayType* _tmp2;
		ValaDataType* _tmp1;
		ValaArrayType* array_type;
		_tmp0 = NULL;
		initializer = (_tmp0 = vala_genie_parser_parse_variable_initializer (self, &inner_error), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp2 = NULL;
		_tmp1 = NULL;
		array_type = (_tmp2 = (_tmp1 = variable_type, (VALA_IS_ARRAY_TYPE (_tmp1) ? ((ValaArrayType*) (_tmp1)) : NULL)), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
		if (array_type != NULL && VALA_IS_INITIALIZER_LIST (initializer)) {
			ValaExpression* _tmp4;
			ValaDataType* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			initializer = (_tmp4 = VALA_EXPRESSION (vala_array_creation_expression_new ((_tmp3 = vala_data_type_copy (vala_array_type_get_element_type (array_type))), vala_array_type_get_rank (array_type), VALA_INITIALIZER_LIST (initializer), vala_code_node_get_source_reference (VALA_CODE_NODE (initializer)))), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), _tmp4);
			(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	}
	_tmp5 = NULL;
	_tmp6 = NULL;
	_tmp7 = NULL;
	return (_tmp7 = (_tmp6 = vala_local_variable_new (variable_type, id, initializer, (_tmp5 = vala_genie_parser_get_src_com (self, &begin))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), _tmp7);
}


static ValaStatement* vala_genie_parser_parse_expression_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaSourceReference* _tmp0;
	ValaStatement* _tmp1;
	ValaStatement* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	expr = vala_genie_parser_parse_statement_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (self->priv->current_expr_is_lambda) {
		self->priv->current_expr_is_lambda = FALSE;
	} else {
		vala_genie_parser_expect_terminator (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = VALA_STATEMENT (vala_expression_statement_new (expr, (_tmp0 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp2);
}


static ValaExpression* vala_genie_parser_parse_statement_expression (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaExpression* expr;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	/* invocation expression, assignment,
	 or pre/post increment/decrement expression*/
	expr = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	return expr;
}


static ValaStatement* vala_genie_parser_parse_if_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* condition;
	ValaSourceReference* src;
	ValaBlock* true_stmt;
	ValaBlock* false_stmt;
	ValaStatement* _tmp1;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_IF, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	condition = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DO)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	} else {
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
	}
	src = vala_genie_parser_get_src_com (self, &begin);
	true_stmt = vala_genie_parser_parse_embedded_statement (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	false_stmt = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ELSE)) {
		ValaBlock* _tmp0;
		_tmp0 = NULL;
		false_stmt = (_tmp0 = vala_genie_parser_parse_embedded_statement (self, &inner_error), (false_stmt == NULL ? NULL : (false_stmt = (g_object_unref (false_stmt), NULL))), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	_tmp1 = NULL;
	return (_tmp1 = VALA_STATEMENT (vala_if_statement_new (condition, true_stmt, false_stmt, src)), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), (src == NULL ? NULL : (src = (g_object_unref (src), NULL))), (true_stmt == NULL ? NULL : (true_stmt = (g_object_unref (true_stmt), NULL))), (false_stmt == NULL ? NULL : (false_stmt = (g_object_unref (false_stmt), NULL))), _tmp1);
}


static ValaStatement* vala_genie_parser_parse_switch_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* condition;
	ValaSourceReference* _tmp0;
	ValaSwitchStatement* _tmp1;
	ValaSwitchStatement* stmt;
	ValaStatement* _tmp11;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CASE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	condition = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	stmt = (_tmp1 = vala_switch_statement_new (condition, (_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
		ValaSourceReference* _tmp2;
		ValaSwitchSection* _tmp3;
		ValaSwitchSection* section;
		ValaSourceReference* _tmp9;
		ValaBreakStatement* _tmp10;
		ValaBreakStatement* break_stmt;
		_tmp2 = NULL;
		_tmp3 = NULL;
		section = (_tmp3 = vala_switch_section_new ((_tmp2 = vala_genie_parser_get_src_com (self, &begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WHEN)) {
			do {
				ValaSwitchLabel* _tmp6;
				ValaSourceReference* _tmp5;
				ValaExpression* _tmp4;
				_tmp6 = NULL;
				_tmp5 = NULL;
				_tmp4 = NULL;
				vala_switch_section_add_label (section, (_tmp6 = vala_switch_label_new ((_tmp4 = vala_genie_parser_parse_expression (self, &inner_error)), (_tmp5 = vala_genie_parser_get_src_com (self, &begin)))));
				(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
				(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
				(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
			} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		} else {
			ValaSwitchLabel* _tmp8;
			ValaSourceReference* _tmp7;
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEFAULT, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp8 = NULL;
			_tmp7 = NULL;
			vala_switch_section_add_label (section, (_tmp8 = vala_switch_label_new_with_default ((_tmp7 = vala_genie_parser_get_src_com (self, &begin)))));
			(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
			(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		}
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
		}
		vala_genie_parser_parse_statements (self, VALA_BLOCK (section), &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		/* add break statement for each block */
		_tmp9 = NULL;
		_tmp10 = NULL;
		break_stmt = (_tmp10 = vala_break_statement_new ((_tmp9 = vala_genie_parser_get_src_com (self, &begin))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), _tmp10);
		vala_block_add_statement (VALA_BLOCK (section), VALA_STATEMENT (break_stmt));
		vala_switch_statement_add_section (stmt, section);
		(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
		(break_stmt == NULL ? NULL : (break_stmt = (g_object_unref (break_stmt), NULL)));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp11 = NULL;
	return (_tmp11 = VALA_STATEMENT (stmt), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), _tmp11);
}


static ValaStatement* vala_genie_parser_parse_while_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* condition;
	ValaBlock* body;
	ValaSourceReference* _tmp0;
	ValaStatement* _tmp1;
	ValaStatement* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_WHILE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	condition = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DO)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	} else {
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
	}
	body = vala_genie_parser_parse_embedded_statement (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = VALA_STATEMENT (vala_while_statement_new (condition, body, (_tmp0 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), (body == NULL ? NULL : (body = (g_object_unref (body), NULL))), _tmp2);
}


static ValaStatement* vala_genie_parser_parse_do_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaBlock* body;
	ValaExpression* condition;
	ValaSourceReference* _tmp0;
	ValaStatement* _tmp1;
	ValaStatement* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	body = vala_genie_parser_parse_embedded_statement (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_WHILE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	condition = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = VALA_STATEMENT (vala_do_statement_new (body, condition, (_tmp0 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (body == NULL ? NULL : (body = (g_object_unref (body), NULL))), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), _tmp2);
}


static ValaStatement* vala_genie_parser_parse_for_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaBlock* block;
	ValaExpression* initializer;
	ValaExpression* condition;
	ValaExpression* iterator;
	gboolean is_expr;
	char* id;
	ValaGenieTokenType _tmp0;
	ValaSourceReference* src;
	ValaBlock* body;
	ValaForStatement* stmt;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	block = NULL;
	initializer = NULL;
	condition = NULL;
	iterator = NULL;
	is_expr = FALSE;
	id = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FOR, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = vala_genie_parser_current (self);
	if (_tmp0 == VALA_GENIE_TOKEN_TYPE_VAR)
	do {
		is_expr = FALSE;
		break;
	} while (0); else
	do {
		gboolean local_is_expr;
		local_is_expr = vala_genie_parser_is_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		is_expr = local_is_expr;
		break;
	} while (0);
	if (is_expr) {
		ValaSourceLocation expr_begin;
		char* _tmp1;
		ValaExpression* _tmp2;
		expr_begin = vala_genie_parser_get_location (self);
		_tmp1 = NULL;
		id = (_tmp1 = vala_genie_parser_parse_identifier (self, &inner_error), (id = (g_free (id), NULL)), _tmp1);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		vala_genie_parser_rollback (self, &expr_begin);
		_tmp2 = NULL;
		initializer = (_tmp2 = vala_genie_parser_parse_statement_expression (self, &inner_error), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), _tmp2);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	} else {
		ValaBlock* _tmp4;
		ValaSourceReference* _tmp3;
		ValaDataType* variable_type;
		ValaDataType* type_copy;
		ValaLocalVariable* local;
		ValaDeclarationStatement* _tmp10;
		_tmp4 = NULL;
		_tmp3 = NULL;
		block = (_tmp4 = vala_block_new ((_tmp3 = vala_genie_parser_get_src (self, &begin))), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), _tmp4);
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		variable_type = NULL;
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VAR)) {
			ValaDataType* _tmp5;
			char* _tmp6;
			_tmp5 = NULL;
			variable_type = (_tmp5 = NULL, (variable_type == NULL ? NULL : (variable_type = (g_object_unref (variable_type), NULL))), _tmp5);
			_tmp6 = NULL;
			id = (_tmp6 = vala_genie_parser_parse_identifier (self, &inner_error), (id = (g_free (id), NULL)), _tmp6);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
		} else {
			char* _tmp7;
			ValaDataType* _tmp8;
			_tmp7 = NULL;
			id = (_tmp7 = vala_genie_parser_parse_identifier (self, &inner_error), (id = (g_free (id), NULL)), _tmp7);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp8 = NULL;
			variable_type = (_tmp8 = vala_genie_parser_parse_type (self, TRUE, &inner_error), (variable_type == NULL ? NULL : (variable_type = (g_object_unref (variable_type), NULL))), _tmp8);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
		}
		type_copy = NULL;
		if (variable_type != NULL) {
			ValaDataType* _tmp9;
			_tmp9 = NULL;
			type_copy = (_tmp9 = vala_data_type_copy (variable_type), (type_copy == NULL ? NULL : (type_copy = (g_object_unref (type_copy), NULL))), _tmp9);
		}
		local = vala_genie_parser_parse_local_variable (self, type_copy, id, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp10 = NULL;
		vala_block_add_statement (block, VALA_STATEMENT ((_tmp10 = vala_declaration_statement_new (VALA_SYMBOL (local), vala_code_node_get_source_reference (VALA_CODE_NODE (local))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		(variable_type == NULL ? NULL : (variable_type = (g_object_unref (variable_type), NULL)));
		(type_copy == NULL ? NULL : (type_copy = (g_object_unref (type_copy), NULL)));
		(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_TO)) {
		ValaSourceLocation to_begin;
		ValaSourceReference* to_src;
		ValaMemberAccess* left;
		ValaExpression* right;
		ValaExpression* _tmp11;
		ValaExpression* _tmp12;
		/* create expression for condition and incrementing iterator */
		to_begin = vala_genie_parser_get_location (self);
		to_src = vala_genie_parser_get_src (self, &to_begin);
		left = vala_member_access_new (NULL, id, to_src);
		right = vala_genie_parser_parse_primary_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp11 = NULL;
		condition = (_tmp11 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, VALA_EXPRESSION (left), right, to_src)), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), _tmp11);
		_tmp12 = NULL;
		iterator = (_tmp12 = VALA_EXPRESSION (vala_postfix_expression_new (VALA_EXPRESSION (left), TRUE, to_src)), (iterator == NULL ? NULL : (iterator = (g_object_unref (iterator), NULL))), _tmp12);
		(to_src == NULL ? NULL : (to_src = (g_object_unref (to_src), NULL)));
		(left == NULL ? NULL : (left = (g_object_unref (left), NULL)));
		(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
	} else {
		ValaSourceLocation downto_begin;
		ValaSourceReference* downto_src;
		ValaMemberAccess* left;
		ValaExpression* right;
		ValaExpression* _tmp13;
		ValaExpression* _tmp14;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DOWNTO, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		downto_begin = vala_genie_parser_get_location (self);
		downto_src = vala_genie_parser_get_src (self, &downto_begin);
		/* create expression for condition and decrementing iterator */
		left = vala_member_access_new (NULL, id, downto_src);
		right = vala_genie_parser_parse_primary_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp13 = NULL;
		condition = (_tmp13 = VALA_EXPRESSION (vala_binary_expression_new (VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, VALA_EXPRESSION (left), right, downto_src)), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), _tmp13);
		_tmp14 = NULL;
		iterator = (_tmp14 = VALA_EXPRESSION (vala_postfix_expression_new (VALA_EXPRESSION (left), FALSE, downto_src)), (iterator == NULL ? NULL : (iterator = (g_object_unref (iterator), NULL))), _tmp14);
		(downto_src == NULL ? NULL : (downto_src = (g_object_unref (downto_src), NULL)));
		(left == NULL ? NULL : (left = (g_object_unref (left), NULL)));
		(right == NULL ? NULL : (right = (g_object_unref (right), NULL)));
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	src = vala_genie_parser_get_src_com (self, &begin);
	body = vala_genie_parser_parse_embedded_statement (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	stmt = vala_for_statement_new (condition, body, src);
	if (initializer != NULL) {
		vala_for_statement_add_initializer (stmt, initializer);
	}
	vala_for_statement_add_iterator (stmt, iterator);
	if (block != NULL) {
		ValaStatement* _tmp15;
		vala_block_add_statement (block, VALA_STATEMENT (stmt));
		_tmp15 = NULL;
		return (_tmp15 = VALA_STATEMENT (block), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), (iterator == NULL ? NULL : (iterator = (g_object_unref (iterator), NULL))), (id = (g_free (id), NULL)), (src == NULL ? NULL : (src = (g_object_unref (src), NULL))), (body == NULL ? NULL : (body = (g_object_unref (body), NULL))), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp15);
	} else {
		ValaStatement* _tmp16;
		_tmp16 = NULL;
		return (_tmp16 = VALA_STATEMENT (stmt), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), (iterator == NULL ? NULL : (iterator = (g_object_unref (iterator), NULL))), (id = (g_free (id), NULL)), (src == NULL ? NULL : (src = (g_object_unref (src), NULL))), (body == NULL ? NULL : (body = (g_object_unref (body), NULL))), _tmp16);
	}
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL)));
	(condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL)));
	(iterator == NULL ? NULL : (iterator = (g_object_unref (iterator), NULL)));
	id = (g_free (id), NULL);
	(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
	(body == NULL ? NULL : (body = (g_object_unref (body), NULL)));
	(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
}


static ValaStatement* vala_genie_parser_parse_foreach_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaDataType* type;
	char* id;
	ValaExpression* collection;
	ValaSourceReference* src;
	ValaBlock* body;
	ValaStatement* _tmp3;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	type = NULL;
	id = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FOR, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VAR)) {
		char* _tmp0;
		_tmp0 = NULL;
		id = (_tmp0 = vala_genie_parser_parse_identifier (self, &inner_error), (id = (g_free (id), NULL)), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	} else {
		char* _tmp1;
		_tmp1 = NULL;
		id = (_tmp1 = vala_genie_parser_parse_identifier (self, &inner_error), (id = (g_free (id), NULL)), _tmp1);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
			ValaDataType* _tmp2;
			_tmp2 = NULL;
			type = (_tmp2 = vala_genie_parser_parse_type (self, TRUE, &inner_error), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp2);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_IN, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	collection = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	src = vala_genie_parser_get_src_com (self, &begin);
	body = vala_genie_parser_parse_embedded_statement (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp3 = NULL;
	return (_tmp3 = VALA_STATEMENT (vala_foreach_statement_new (type, id, collection, body, src)), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), (id = (g_free (id), NULL)), (collection == NULL ? NULL : (collection = (g_object_unref (collection), NULL))), (src == NULL ? NULL : (src = (g_object_unref (src), NULL))), (body == NULL ? NULL : (body = (g_object_unref (body), NULL))), _tmp3);
}


static ValaStatement* vala_genie_parser_parse_break_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0;
	ValaStatement* _tmp1;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_BREAK, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = VALA_STATEMENT (vala_break_statement_new ((_tmp0 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static ValaStatement* vala_genie_parser_parse_continue_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0;
	ValaStatement* _tmp1;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CONTINUE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = VALA_STATEMENT (vala_continue_statement_new ((_tmp0 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static ValaStatement* vala_genie_parser_parse_return_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaSourceReference* _tmp1;
	ValaStatement* _tmp2;
	ValaStatement* _tmp3;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_RETURN, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	expr = NULL;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_SEMICOLON && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL) {
		ValaExpression* _tmp0;
		_tmp0 = NULL;
		expr = (_tmp0 = vala_genie_parser_parse_expression (self, &inner_error), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	_tmp3 = NULL;
	return (_tmp3 = (_tmp2 = VALA_STATEMENT (vala_return_statement_new (expr, (_tmp1 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp3);
}


static ValaStatement* vala_genie_parser_parse_throw_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaSourceReference* _tmp0;
	ValaStatement* _tmp1;
	ValaStatement* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_RAISE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	expr = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = VALA_STATEMENT (vala_throw_statement_new (expr, (_tmp0 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp2);
}


static ValaStatement* vala_genie_parser_parse_try_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaBlock* try_block;
	ValaBlock* finally_clause;
	GeeArrayList* catch_clauses;
	ValaSourceReference* _tmp2;
	ValaTryStatement* _tmp3;
	ValaTryStatement* stmt;
	ValaStatement* _tmp4;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_TRY, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	try_block = vala_genie_parser_parse_block (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	finally_clause = NULL;
	catch_clauses = gee_array_list_new (VALA_TYPE_CATCH_CLAUSE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_EXCEPT) {
		vala_genie_parser_parse_catch_clauses (self, GEE_LIST (catch_clauses), &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_FINALLY) {
			ValaBlock* _tmp0;
			_tmp0 = NULL;
			finally_clause = (_tmp0 = vala_genie_parser_parse_finally_clause (self, &inner_error), (finally_clause == NULL ? NULL : (finally_clause = (g_object_unref (finally_clause), NULL))), _tmp0);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
		}
	} else {
		ValaBlock* _tmp1;
		_tmp1 = NULL;
		finally_clause = (_tmp1 = vala_genie_parser_parse_finally_clause (self, &inner_error), (finally_clause == NULL ? NULL : (finally_clause = (g_object_unref (finally_clause), NULL))), _tmp1);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	stmt = (_tmp3 = vala_try_statement_new (try_block, finally_clause, (_tmp2 = vala_genie_parser_get_src_com (self, &begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	{
		GeeArrayList* clause_collection;
		int clause_it;
		clause_collection = catch_clauses;
		for (clause_it = 0; clause_it < gee_collection_get_size (GEE_COLLECTION (clause_collection)); clause_it = clause_it + 1) {
			ValaCatchClause* clause;
			clause = ((ValaCatchClause*) (gee_list_get (GEE_LIST (clause_collection), clause_it)));
			{
				vala_try_statement_add_catch_clause (stmt, clause);
				(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
			}
		}
	}
	_tmp4 = NULL;
	return (_tmp4 = VALA_STATEMENT (stmt), (try_block == NULL ? NULL : (try_block = (g_object_unref (try_block), NULL))), (finally_clause == NULL ? NULL : (finally_clause = (g_object_unref (finally_clause), NULL))), (catch_clauses == NULL ? NULL : (catch_clauses = (g_object_unref (catch_clauses), NULL))), _tmp4);
}


static void vala_genie_parser_parse_catch_clauses (ValaGenieParser* self, GeeList* catch_clauses, GError** error) {
	GError * inner_error;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (GEE_IS_LIST (catch_clauses));
	inner_error = NULL;
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EXCEPT)) {
		ValaSourceLocation begin;
		ValaDataType* type;
		char* id;
		ValaBlock* block;
		ValaCatchClause* _tmp3;
		ValaSourceReference* _tmp2;
		begin = vala_genie_parser_get_location (self);
		type = NULL;
		id = NULL;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
			char* _tmp0;
			ValaDataType* _tmp1;
			_tmp0 = NULL;
			id = (_tmp0 = vala_genie_parser_parse_identifier (self, &inner_error), (id = (g_free (id), NULL)), _tmp0);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
			_tmp1 = NULL;
			type = (_tmp1 = vala_genie_parser_parse_type (self, TRUE, &inner_error), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp1);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
		}
		block = vala_genie_parser_parse_block (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
		_tmp3 = NULL;
		_tmp2 = NULL;
		gee_collection_add (GEE_COLLECTION (catch_clauses), (_tmp3 = vala_catch_clause_new (type, id, block, (_tmp2 = vala_genie_parser_get_src (self, &begin)))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
		id = (g_free (id), NULL);
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
}


static ValaBlock* vala_genie_parser_parse_finally_clause (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaBlock* block;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FINALLY, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_accept_block (self);
	block = vala_genie_parser_parse_block (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	return block;
}


static ValaStatement* vala_genie_parser_parse_lock_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaBlock* stmt;
	ValaSourceReference* _tmp0;
	ValaStatement* _tmp1;
	ValaStatement* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_LOCK, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	expr = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	stmt = vala_genie_parser_parse_embedded_statement (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = VALA_STATEMENT (vala_lock_statement_new (expr, stmt, (_tmp0 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), (stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL))), _tmp2);
}


static ValaStatement* vala_genie_parser_parse_delete_statement (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaSourceReference* _tmp0;
	ValaStatement* _tmp1;
	ValaStatement* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DELETE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	expr = vala_genie_parser_parse_expression (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = VALA_STATEMENT (vala_delete_statement_new (expr, (_tmp0 = vala_genie_parser_get_src_com (self, &begin)))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp2);
}


static GeeList* vala_genie_parser_parse_attributes (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	GeeArrayList* attrs;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET) {
		return NULL;
	}
	attrs = gee_array_list_new (VALA_TYPE_ATTRIBUTE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
		do {
			ValaSourceLocation begin;
			char* id;
			ValaSourceReference* _tmp1;
			ValaAttribute* _tmp2;
			ValaAttribute* attr;
			begin = vala_genie_parser_get_location (self);
			id = vala_genie_parser_parse_identifier (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp1 = NULL;
			_tmp2 = NULL;
			attr = (_tmp2 = vala_attribute_new (id, (_tmp1 = vala_genie_parser_get_src (self, &begin))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
				if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
					do {
						char* id;
						ValaExpression* expr;
						ValaNamedArgument* _tmp4;
						ValaSourceReference* _tmp3;
						begin = vala_genie_parser_get_location (self);
						id = vala_genie_parser_parse_identifier (self, &inner_error);
						if (inner_error != NULL) {
							g_propagate_error (error, inner_error);
							return NULL;
						}
						vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSIGN, &inner_error);
						if (inner_error != NULL) {
							g_propagate_error (error, inner_error);
							return NULL;
						}
						expr = vala_genie_parser_parse_expression (self, &inner_error);
						if (inner_error != NULL) {
							g_propagate_error (error, inner_error);
							return NULL;
						}
						_tmp4 = NULL;
						_tmp3 = NULL;
						vala_attribute_add_argument (attr, (_tmp4 = vala_named_argument_new (id, expr, (_tmp3 = vala_genie_parser_get_src (self, &begin)))));
						(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
						(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
						id = (g_free (id), NULL);
						(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
					} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
			}
			gee_collection_add (GEE_COLLECTION (attrs), attr);
			id = (g_free (id), NULL);
			(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	return GEE_LIST (attrs);
}


static void vala_genie_parser_set_attributes (ValaGenieParser* self, ValaCodeNode* node, GeeList* attributes) {
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_CODE_NODE (node));
	g_return_if_fail (attributes == NULL || GEE_IS_LIST (attributes));
	if (attributes != NULL) {
		{
			GeeList* attr_collection;
			int attr_it;
			attr_collection = GEE_LIST (attributes);
			for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
				ValaAttribute* attr;
				attr = ((ValaAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
				{
					ValaAttribute* _tmp0;
					_tmp0 = NULL;
					node->attributes = g_list_append (node->attributes, (_tmp0 = attr, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))));
					(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
				}
			}
		}
	}
}


static ValaSymbol* vala_genie_parser_parse_declaration (ValaGenieParser* self, gboolean is_root, GError** error) {
	GError * inner_error;
	char* _tmp0;
	GeeList* attrs;
	ValaGenieTokenType _tmp17;
	ValaGenieTokenType cur;
	ValaGenieTokenType pre;
	char* _tmp19;
	char* _tmp18;
	GError* _tmp20;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	self->priv->comment = (_tmp0 = vala_genie_scanner_pop_comment (self->priv->scanner), (self->priv->comment = (g_free (self->priv->comment), NULL)), _tmp0);
	attrs = vala_genie_parser_parse_attributes (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp17 = vala_genie_parser_current (self);
	if (_tmp17 == VALA_GENIE_TOKEN_TYPE_CONST)
	do {
		ValaSymbol* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = VALA_SYMBOL (vala_genie_parser_parse_constant_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp1);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_CONSTRUCT)
	do {
		ValaSymbol* _tmp2;
		_tmp2 = NULL;
		return (_tmp2 = VALA_SYMBOL (vala_genie_parser_parse_creation_method_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp2);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_CLASS)
	do {
		ValaSymbol* _tmp3;
		_tmp3 = NULL;
		return (_tmp3 = vala_genie_parser_parse_class_declaration (self, attrs, &inner_error), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp3);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_INIT)
	do {
		ValaSymbol* _tmp5;
		if (is_root) {
			ValaSymbol* _tmp4;
			_tmp4 = NULL;
			return (_tmp4 = VALA_SYMBOL (vala_genie_parser_parse_main_method_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp4);
		}
		_tmp5 = NULL;
		return (_tmp5 = VALA_SYMBOL (vala_genie_parser_parse_constructor_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp5);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_DELEGATE)
	do {
		ValaSymbol* _tmp6;
		_tmp6 = NULL;
		return (_tmp6 = vala_genie_parser_parse_delegate_declaration (self, attrs, &inner_error), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp6);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_DEF)
	do {
		ValaSymbol* _tmp7;
		_tmp7 = NULL;
		return (_tmp7 = VALA_SYMBOL (vala_genie_parser_parse_method_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp7);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_ENUM)
	do {
		ValaSymbol* _tmp8;
		_tmp8 = NULL;
		return (_tmp8 = vala_genie_parser_parse_enum_declaration (self, attrs, &inner_error), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp8);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN)
	do {
		ValaSymbol* _tmp9;
		_tmp9 = NULL;
		return (_tmp9 = vala_genie_parser_parse_errordomain_declaration (self, attrs, &inner_error), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp9);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_FINAL)
	do {
		ValaSymbol* _tmp10;
		_tmp10 = NULL;
		return (_tmp10 = VALA_SYMBOL (vala_genie_parser_parse_destructor_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp10);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_INTERFACE)
	do {
		ValaSymbol* _tmp11;
		_tmp11 = NULL;
		return (_tmp11 = vala_genie_parser_parse_interface_declaration (self, attrs, &inner_error), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp11);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_NAMESPACE)
	do {
		ValaSymbol* _tmp12;
		_tmp12 = NULL;
		return (_tmp12 = VALA_SYMBOL (vala_genie_parser_parse_namespace_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp12);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_PROP)
	do {
		ValaSymbol* _tmp13;
		_tmp13 = NULL;
		return (_tmp13 = VALA_SYMBOL (vala_genie_parser_parse_property_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp13);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_EVENT)
	do {
		ValaSymbol* _tmp14;
		_tmp14 = NULL;
		return (_tmp14 = VALA_SYMBOL (vala_genie_parser_parse_signal_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp14);
	} while (0); else if (_tmp17 == VALA_GENIE_TOKEN_TYPE_STRUCT)
	do {
		ValaSymbol* _tmp15;
		_tmp15 = NULL;
		return (_tmp15 = vala_genie_parser_parse_struct_declaration (self, attrs, &inner_error), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp15);
	} while (0); else
	do {
		ValaSourceLocation begin;
		begin = vala_genie_parser_get_location (self);
		while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_SEMICOLON && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF) {
			if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_COLON) {
				ValaSymbol* _tmp16;
				vala_genie_parser_rollback (self, &begin);
				_tmp16 = NULL;
				return (_tmp16 = VALA_SYMBOL (vala_genie_parser_parse_field_declaration (self, attrs, &inner_error)), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp16);
			} else {
				vala_genie_parser_next (self);
			}
		}
		vala_genie_parser_rollback (self, &begin);
		break;
	} while (0);
	cur = vala_genie_parser_current (self);
	pre = self->priv->tokens[self->priv->index - 1].type;
	_tmp19 = NULL;
	_tmp18 = NULL;
	inner_error = (_tmp20 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp19 = vala_genie_parser_get_error (self, (_tmp18 = g_strdup_printf ("expected declaration  but got %s with previous %s", vala_genie_token_type_to_string (cur), vala_genie_token_type_to_string (pre)))))), (_tmp19 = (g_free (_tmp19), NULL)), (_tmp18 = (g_free (_tmp18), NULL)), _tmp20);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	(attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL)));
}


static void vala_genie_parser_parse_declarations (ValaGenieParser* self, ValaSymbol* parent, gboolean root, GError** error) {
	GError * inner_error;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_SYMBOL (parent));
	inner_error = NULL;
	if (!root) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
	}
	while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF) {
		{
			if (VALA_IS_NAMESPACE (parent)) {
				vala_genie_parser_parse_namespace_member (self, VALA_NAMESPACE (parent), &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == VALA_PARSE_ERROR) {
						goto __catch2_vala_parse_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
			} else {
				if (VALA_IS_CLASS (parent)) {
					vala_genie_parser_parse_class_member (self, VALA_CLASS (parent), &inner_error);
					if (inner_error != NULL) {
						if (inner_error->domain == VALA_PARSE_ERROR) {
							goto __catch2_vala_parse_error;
						}
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
						g_clear_error (&inner_error);
					}
				} else {
					if (VALA_IS_STRUCT (parent)) {
						vala_genie_parser_parse_struct_member (self, VALA_STRUCT (parent), &inner_error);
						if (inner_error != NULL) {
							if (inner_error->domain == VALA_PARSE_ERROR) {
								goto __catch2_vala_parse_error;
							}
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
							g_clear_error (&inner_error);
						}
					} else {
						if (VALA_IS_INTERFACE (parent)) {
							vala_genie_parser_parse_interface_member (self, VALA_INTERFACE (parent), &inner_error);
							if (inner_error != NULL) {
								if (inner_error->domain == VALA_PARSE_ERROR) {
									goto __catch2_vala_parse_error;
								}
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
								g_clear_error (&inner_error);
							}
						}
					}
				}
			}
		}
		goto __finally2;
		__catch2_vala_parse_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				gint r;
				r = 0;
				while (TRUE) {
					r = ((gint) (vala_genie_parser_recover (self)));
					if (r == VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN) {
						vala_genie_parser_next (self);
					} else {
						break;
					}
				}
				if (r == VALA_GENIE_PARSER_RECOVERY_STATE_EOF) {
					return;
				}
			}
		}
		__finally2:
		;
	}
	if (!root) {
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DEDENT)) {
			/* only report error if it's not a secondary error*/
			if (vala_report_get_errors () == 0) {
				ValaSourceReference* _tmp0;
				_tmp0 = NULL;
				vala_report_error ((_tmp0 = vala_genie_parser_get_current_src (self)), "expected dedent");
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
			}
		}
	}
}


static ValaGenieParserRecoveryState vala_genie_parser_recover (ValaGenieParser* self) {
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), 0);
	while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF) {
		ValaGenieTokenType _tmp2;
		_tmp2 = vala_genie_parser_current (self);
		if (_tmp2 == VALA_GENIE_TOKEN_TYPE_CLASS || _tmp2 == VALA_GENIE_TOKEN_TYPE_CONST || _tmp2 == VALA_GENIE_TOKEN_TYPE_CONSTRUCT || _tmp2 == VALA_GENIE_TOKEN_TYPE_INIT || _tmp2 == VALA_GENIE_TOKEN_TYPE_DEF || _tmp2 == VALA_GENIE_TOKEN_TYPE_DELEGATE || _tmp2 == VALA_GENIE_TOKEN_TYPE_ENUM || _tmp2 == VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN || _tmp2 == VALA_GENIE_TOKEN_TYPE_FINAL || _tmp2 == VALA_GENIE_TOKEN_TYPE_INTERFACE || _tmp2 == VALA_GENIE_TOKEN_TYPE_NAMESPACE || _tmp2 == VALA_GENIE_TOKEN_TYPE_PROP || _tmp2 == VALA_GENIE_TOKEN_TYPE_EVENT || _tmp2 == VALA_GENIE_TOKEN_TYPE_STRUCT)
		do {
			return VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN;
		} while (0); else if (_tmp2 == VALA_GENIE_TOKEN_TYPE_BREAK || _tmp2 == VALA_GENIE_TOKEN_TYPE_CASE || _tmp2 == VALA_GENIE_TOKEN_TYPE_CONTINUE || _tmp2 == VALA_GENIE_TOKEN_TYPE_DELETE || _tmp2 == VALA_GENIE_TOKEN_TYPE_DO || _tmp2 == VALA_GENIE_TOKEN_TYPE_FOR || _tmp2 == VALA_GENIE_TOKEN_TYPE_IF || _tmp2 == VALA_GENIE_TOKEN_TYPE_LOCK || _tmp2 == VALA_GENIE_TOKEN_TYPE_RETURN || _tmp2 == VALA_GENIE_TOKEN_TYPE_RAISE || _tmp2 == VALA_GENIE_TOKEN_TYPE_TRY || _tmp2 == VALA_GENIE_TOKEN_TYPE_VAR || _tmp2 == VALA_GENIE_TOKEN_TYPE_WHILE)
		do {
			return VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN;
		} while (0); else
		do {
			vala_genie_parser_next (self);
			break;
		} while (0);
	}
	return VALA_GENIE_PARSER_RECOVERY_STATE_EOF;
}


static ValaNamespace* vala_genie_parser_parse_namespace_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaUnresolvedSymbol* sym;
	ValaSourceReference* _tmp0;
	ValaNamespace* _tmp1;
	ValaNamespace* ns;
	ValaNamespace* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_NAMESPACE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	ns = (_tmp1 = vala_namespace_new (vala_unresolved_symbol_get_name (sym), (_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (ns), attrs);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_parse_declarations (self, VALA_SYMBOL (ns), FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp2 = NULL;
	return (_tmp2 = ns, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp2);
}


static void vala_genie_parser_parse_namespace_member (ValaGenieParser* self, ValaNamespace* ns, GError** error) {
	GError * inner_error;
	ValaSymbol* sym;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_NAMESPACE (ns));
	inner_error = NULL;
	sym = vala_genie_parser_parse_declaration (self, (ns == vala_code_context_get_root (self->priv->context)), &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	if (VALA_IS_NAMESPACE (sym)) {
		vala_namespace_add_namespace (ns, VALA_NAMESPACE (sym));
	} else {
		if (VALA_IS_CLASS (sym)) {
			vala_namespace_add_class (ns, VALA_CLASS (sym));
		} else {
			if (VALA_IS_INTERFACE (sym)) {
				vala_namespace_add_interface (ns, VALA_INTERFACE (sym));
			} else {
				if (VALA_IS_STRUCT (sym)) {
					vala_namespace_add_struct (ns, VALA_STRUCT (sym));
				} else {
					if (VALA_IS_ENUM (sym)) {
						vala_namespace_add_enum (ns, VALA_ENUM (sym));
					} else {
						if (VALA_IS_ERROR_DOMAIN (sym)) {
							vala_namespace_add_error_domain (ns, VALA_ERROR_DOMAIN (sym));
						} else {
							if (VALA_IS_DELEGATE (sym)) {
								vala_namespace_add_delegate (ns, VALA_DELEGATE (sym));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaMethod* _tmp0;
									ValaMethod* method;
									_tmp0 = NULL;
									method = (_tmp0 = VALA_METHOD (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
									vala_method_set_binding (method, MEMBER_BINDING_STATIC);
									vala_namespace_add_method (ns, method);
									(method == NULL ? NULL : (method = (g_object_unref (method), NULL)));
								} else {
									if (VALA_IS_FIELD (sym)) {
										ValaField* _tmp1;
										ValaField* field;
										_tmp1 = NULL;
										field = (_tmp1 = VALA_FIELD (sym), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
										vala_field_set_binding (field, MEMBER_BINDING_STATIC);
										vala_namespace_add_field (ns, field);
										(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
									} else {
										if (VALA_IS_CONSTANT (sym)) {
											vala_namespace_add_constant (ns, VALA_CONSTANT (sym));
										} else {
											if (sym == NULL) {
												/* workaround for current limitation of exception handling*/
												inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in declaration");
												if (inner_error != NULL) {
													g_propagate_error (error, inner_error);
													return;
												}
											} else {
												vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (sym)), "unexpected declaration in namespace");
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), VALA_CODE_NODE (sym));
	(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
}


static gboolean vala_genie_parser_add_uses_clause (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaUnresolvedSymbol* sym;
	ValaSourceReference* _tmp0;
	ValaNamespaceReference* _tmp1;
	ValaNamespaceReference* ns_ref;
	gboolean _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return FALSE;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	ns_ref = (_tmp1 = vala_namespace_reference_new (vala_unresolved_symbol_get_name (sym), (_tmp0 = vala_genie_parser_get_src (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_source_file_add_using_directive (vala_genie_scanner_get_source_file (self->priv->scanner), ns_ref);
	return (_tmp2 = (_vala_strcmp0 (vala_unresolved_symbol_get_name (sym), "GLib") == 0), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), (ns_ref == NULL ? NULL : (ns_ref = (g_object_unref (ns_ref), NULL))), _tmp2);
}


static void vala_genie_parser_parse_using_directives (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	gboolean has_glib;
	ValaSourceLocation begin;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	inner_error = NULL;
	has_glib = FALSE;
	begin = vala_genie_parser_get_location (self);
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_USES)) {
		ValaSourceLocation begin;
		begin = vala_genie_parser_get_location (self);
		if (vala_genie_parser_accept_block (self)) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
			while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT && vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF) {
				if (vala_genie_parser_add_uses_clause (self, &inner_error)) {
					has_glib = TRUE;
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return;
				}
			}
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
		} else {
			do {
				vala_genie_parser_add_uses_clause (self, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return;
				}
			} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
			vala_genie_parser_expect_terminator (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
		}
	}
	if (!has_glib) {
		ValaSourceReference* _tmp0;
		ValaNamespaceReference* _tmp1;
		ValaNamespaceReference* ns_ref;
		_tmp0 = NULL;
		_tmp1 = NULL;
		ns_ref = (_tmp1 = vala_namespace_reference_new ("GLib", (_tmp0 = vala_genie_parser_get_src (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
		vala_source_file_add_using_directive (vala_genie_scanner_get_source_file (self->priv->scanner), ns_ref);
		(ns_ref == NULL ? NULL : (ns_ref = (g_object_unref (ns_ref), NULL)));
	}
}


static ValaSymbol* vala_genie_parser_parse_class_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	GeeList* type_param_list;
	GeeArrayList* base_types;
	ValaSourceReference* _tmp2;
	ValaClass* _tmp3;
	ValaClass* cl;
	char* _tmp6;
	const char* _tmp5;
	ValaSymbol* _tmp8;
	ValaSymbol* result;
	ValaSymbol* _tmp13;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLASS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type_param_list = vala_genie_parser_parse_type_parameter_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	base_types = gee_array_list_new (VALA_TYPE_DATA_TYPE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		gee_collection_add (GEE_COLLECTION (base_types), (_tmp0 = vala_genie_parser_parse_type (self, TRUE, &inner_error)));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_IMPLEMENTS)) {
			do {
				ValaDataType* _tmp1;
				_tmp1 = NULL;
				gee_collection_add (GEE_COLLECTION (base_types), (_tmp1 = vala_genie_parser_parse_type (self, TRUE, &inner_error)));
				(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
			} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		}
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
	_tmp2 = NULL;
	_tmp3 = NULL;
	cl = (_tmp3 = vala_class_new (vala_unresolved_symbol_get_name (sym), (_tmp2 = vala_genie_parser_get_src_com (self, &begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (cl), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		/* class must always be Public unless its name starts wtih underscore */
		if (g_utf8_get_char (g_utf8_offset_to_pointer (vala_unresolved_symbol_get_name (sym), 0)) == '_') {
			vala_symbol_set_access (VALA_SYMBOL (cl), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
		} else {
			vala_symbol_set_access (VALA_SYMBOL (cl), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		}
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT)) {
		vala_class_set_is_abstract (cl, TRUE);
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC)) {
		ValaSourceReference* _tmp4;
		vala_class_set_is_static (cl, TRUE);
		_tmp4 = NULL;
		vala_report_warning ((_tmp4 = vala_genie_parser_get_last_src (self)), "static classes are deprecated, use namespaces");
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (cl), attrs);
	{
		GeeList* type_param_collection;
		int type_param_it;
		type_param_collection = type_param_list;
		for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
			ValaTypeParameter* type_param;
			type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
			{
				vala_class_add_type_parameter (cl, type_param);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
			}
		}
	}
	{
		GeeArrayList* base_type_collection;
		int base_type_it;
		base_type_collection = base_types;
		for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
			ValaDataType* base_type;
			base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
			{
				vala_class_add_base_type (cl, base_type);
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			}
		}
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->priv->class_name = (_tmp6 = (_tmp5 = vala_symbol_get_name (VALA_SYMBOL (cl)), (_tmp5 == NULL ? NULL : g_strdup (_tmp5))), (self->priv->class_name = (g_free (self->priv->class_name), NULL)), _tmp6);
	vala_genie_parser_parse_declarations (self, VALA_SYMBOL (cl), FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	/* ensure there is always a default construction method*/
	if (!vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner)) && !vala_class_get_is_static (cl) && vala_class_get_default_construction_method (cl) == NULL) {
		ValaCreationMethod* m;
		ValaBlock* _tmp7;
		m = vala_creation_method_new (vala_symbol_get_name (VALA_SYMBOL (cl)), NULL, vala_code_node_get_source_reference (VALA_CODE_NODE (cl)));
		vala_method_set_binding (VALA_METHOD (m), MEMBER_BINDING_STATIC);
		vala_symbol_set_access (VALA_SYMBOL (m), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp7 = NULL;
		vala_method_set_body (VALA_METHOD (m), (_tmp7 = vala_block_new (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		vala_class_add_method (cl, VALA_METHOD (m));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	}
	_tmp8 = NULL;
	result = (_tmp8 = VALA_SYMBOL (cl), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp10;
		ValaUnresolvedSymbol* _tmp9;
		ValaNamespace* ns;
		ValaSymbol* _tmp12;
		ValaSymbol* _tmp11;
		_tmp10 = NULL;
		_tmp9 = NULL;
		sym = (_tmp10 = (_tmp9 = vala_unresolved_symbol_get_inner (sym), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp10);
		ns = vala_namespace_new (vala_unresolved_symbol_get_name (sym), vala_code_node_get_source_reference (VALA_CODE_NODE (cl)));
		if (VALA_IS_NAMESPACE (result)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (result));
		} else {
			vala_namespace_add_class (ns, VALA_CLASS (result));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), VALA_CODE_NODE (result));
		}
		_tmp12 = NULL;
		_tmp11 = NULL;
		result = (_tmp12 = (_tmp11 = VALA_SYMBOL (ns), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp12);
		(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
	}
	_tmp13 = NULL;
	return (_tmp13 = result, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), (type_param_list == NULL ? NULL : (type_param_list = (g_object_unref (type_param_list), NULL))), (base_types == NULL ? NULL : (base_types = (g_object_unref (base_types), NULL))), (cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL))), _tmp13);
}


static void vala_genie_parser_parse_class_member (ValaGenieParser* self, ValaClass* cl, GError** error) {
	GError * inner_error;
	ValaSymbol* sym;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	inner_error = NULL;
	sym = vala_genie_parser_parse_declaration (self, FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	if (VALA_IS_CLASS (sym)) {
		vala_class_add_class (cl, VALA_CLASS (sym));
	} else {
		if (VALA_IS_STRUCT (sym)) {
			vala_class_add_struct (cl, VALA_STRUCT (sym));
		} else {
			if (VALA_IS_ENUM (sym)) {
				vala_class_add_enum (cl, VALA_ENUM (sym));
			} else {
				if (VALA_IS_DELEGATE (sym)) {
					vala_class_add_delegate (cl, VALA_DELEGATE (sym));
				} else {
					if (VALA_IS_METHOD (sym)) {
						vala_class_add_method (cl, VALA_METHOD (sym));
					} else {
						if (VALA_IS_SIGNAL (sym)) {
							vala_class_add_signal (cl, VALA_SIGNAL (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_class_add_field (cl, VALA_FIELD (sym));
							} else {
								if (VALA_IS_CONSTANT (sym)) {
									vala_class_add_constant (cl, VALA_CONSTANT (sym));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										vala_class_add_property (cl, VALA_PROPERTY (sym));
									} else {
										if (VALA_IS_CONSTRUCTOR (sym)) {
											ValaConstructor* _tmp0;
											ValaConstructor* c;
											_tmp0 = NULL;
											c = (_tmp0 = VALA_CONSTRUCTOR (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
											if (vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE) {
												vala_class_set_constructor (cl, c);
											} else {
												if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS) {
													vala_class_set_class_constructor (cl, c);
												} else {
													vala_class_set_static_constructor (cl, c);
												}
											}
											(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
										} else {
											if (VALA_IS_DESTRUCTOR (sym)) {
												vala_class_set_destructor (cl, VALA_DESTRUCTOR (sym));
											} else {
												if (sym == NULL) {
													/* workaround for current limitation of exception handling*/
													inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in declaration");
													if (inner_error != NULL) {
														g_propagate_error (error, inner_error);
														return;
													}
												} else {
													vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (sym)), "unexpected declaration in class");
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
}


static ValaConstant* vala_genie_parser_parse_constant_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	char* id;
	ValaDataType* type;
	ValaExpression* initializer;
	ValaSourceReference* _tmp1;
	ValaConstant* _tmp2;
	ValaConstant* c;
	ValaConstant* _tmp3;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CONST, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_parse_member_declaration_modifiers (self);
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type = vala_genie_parser_parse_type (self, FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	initializer = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp0;
		_tmp0 = NULL;
		initializer = (_tmp0 = vala_genie_parser_parse_variable_initializer (self, &inner_error), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	c = (_tmp2 = vala_constant_new (id, type, initializer, (_tmp1 = vala_genie_parser_get_src_com (self, &begin))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	vala_symbol_set_access (VALA_SYMBOL (c), vala_genie_parser_get_access (self, id));
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (c), attrs);
	_tmp3 = NULL;
	return (_tmp3 = c, (id = (g_free (id), NULL)), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), (initializer == NULL ? NULL : (initializer = (g_object_unref (initializer), NULL))), _tmp3);
}


static ValaField* vala_genie_parser_parse_field_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	char* id;
	ValaGenieParserModifierFlags flags;
	ValaDataType* type;
	ValaSourceReference* _tmp0;
	ValaField* _tmp1;
	ValaField* f;
	ValaField* _tmp3;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	type = vala_genie_parser_parse_type (self, TRUE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	f = (_tmp1 = vala_field_new (id, type, NULL, (_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (f), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access (VALA_SYMBOL (f), vala_genie_parser_get_access (self, id));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (f), attrs);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp2;
		_tmp2 = NULL;
		vala_field_set_initializer (f, (_tmp2 = vala_genie_parser_parse_expression (self, &inner_error)));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC)) {
		vala_field_set_binding (f, MEMBER_BINDING_STATIC);
	} else {
		if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS)) {
			vala_field_set_binding (f, MEMBER_BINDING_CLASS);
		}
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp3 = NULL;
	return (_tmp3 = f, (id = (g_free (id), NULL)), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp3);
}


static ValaInitializerList* vala_genie_parser_parse_initializer (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0;
	ValaInitializerList* _tmp1;
	ValaInitializerList* initializer;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACE, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	initializer = (_tmp1 = vala_initializer_list_new ((_tmp0 = vala_genie_parser_get_src (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
		do {
			ValaExpression* _tmp2;
			_tmp2 = NULL;
			vala_initializer_list_append (initializer, (_tmp2 = vala_genie_parser_parse_variable_initializer (self, &inner_error)));
			(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	return initializer;
}


static gboolean vala_genie_parser_is_initializer (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	inner_error = NULL;
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OPEN_BRACE) {
		return TRUE;
	}
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OPEN_PARENS) {
		ValaSourceLocation begin;
		gboolean is_array;
		ValaExpression* expr;
		gboolean _tmp1;
		begin = vala_genie_parser_get_location (self);
		is_array = FALSE;
		vala_genie_parser_next (self);
		expr = vala_genie_parser_parse_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return FALSE;
		}
		is_array = (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		vala_genie_parser_rollback (self, &begin);
		return (_tmp1 = is_array, (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp1);
	}
	return FALSE;
}


static ValaExpression* vala_genie_parser_parse_variable_initializer (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	if (vala_genie_parser_is_initializer (self, &inner_error)) {
		ValaInitializerList* expr;
		expr = vala_genie_parser_parse_initializer (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		return VALA_EXPRESSION (expr);
	} else {
		ValaExpression* expr;
		expr = vala_genie_parser_parse_expression (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		return expr;
	}
}


static ValaMethod* vala_genie_parser_parse_main_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	char* id;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaSourceReference* _tmp0;
	ValaMethod* _tmp1;
	ValaMethod* method;
	ValaSourceReference* _tmp2;
	ValaUnresolvedSymbol* _tmp3;
	ValaUnresolvedSymbol* sym;
	ValaDataType* _tmp5;
	ValaSourceReference* _tmp4;
	ValaDataType* _tmp7;
	ValaSourceReference* _tmp6;
	ValaSourceReference* _tmp8;
	ValaFormalParameter* _tmp9;
	ValaFormalParameter* param;
	ValaMethod* _tmp11;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	id = g_strdup ("main");
	begin = vala_genie_parser_get_location (self);
	type = VALA_DATA_TYPE (vala_void_type_new ());
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INIT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	method = (_tmp1 = vala_method_new (id, type, (_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_symbol_set_access (VALA_SYMBOL (method), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (method), attrs);
	vala_method_set_binding (method, MEMBER_BINDING_STATIC);
	_tmp2 = NULL;
	_tmp3 = NULL;
	sym = (_tmp3 = vala_unresolved_symbol_new (NULL, "string", (_tmp2 = vala_genie_parser_get_src (self, &begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	type = (_tmp5 = VALA_DATA_TYPE (vala_unresolved_type_new_from_symbol (sym, (_tmp4 = vala_genie_parser_get_src (self, &begin)))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp5);
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	vala_data_type_set_value_owned (type, TRUE);
	_tmp7 = NULL;
	_tmp6 = NULL;
	type = (_tmp7 = VALA_DATA_TYPE (vala_array_type_new (type, 1, (_tmp6 = vala_genie_parser_get_src (self, &begin)))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp7);
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	vala_data_type_set_nullable (type, FALSE);
	_tmp8 = NULL;
	_tmp9 = NULL;
	param = (_tmp9 = vala_formal_parameter_new ("args", type, (_tmp8 = vala_genie_parser_get_src (self, &begin))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	vala_method_add_parameter (method, param);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* _tmp10;
		_tmp10 = NULL;
		vala_method_set_body (method, (_tmp10 = vala_genie_parser_parse_block (self, &inner_error)));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	}
	_tmp11 = NULL;
	return (_tmp11 = method, (id = (g_free (id), NULL)), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp11);
}


static ValaMethod* vala_genie_parser_parse_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaGenieParserModifierFlags flags;
	char* id;
	GeeArrayList* params;
	ValaSourceReference* _tmp2;
	ValaMethod* _tmp3;
	ValaMethod* method;
	ValaSourceLocation body_location;
	ValaMethod* _tmp10;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	type = VALA_DATA_TYPE (vala_void_type_new ());
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEF, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	params = gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaFormalParameter* param;
			param = vala_genie_parser_parse_parameter (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			gee_collection_add (GEE_COLLECTION (params), param);
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	/* deal with return value */
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp0;
		GeeList* _tmp1;
		_tmp0 = NULL;
		type = (_tmp0 = vala_genie_parser_parse_type (self, TRUE, &inner_error), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		_tmp1 = vala_genie_parser_parse_type_parameter_list (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	method = (_tmp3 = vala_method_new (id, type, (_tmp2 = vala_genie_parser_get_src_com (self, &begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (method), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access (VALA_SYMBOL (method), vala_genie_parser_get_access (self, id));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (method), attrs);
	{
		GeeArrayList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				vala_method_add_parameter (method, param);
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_RAISES)) {
		do {
			ValaDataType* _tmp4;
			_tmp4 = NULL;
			vala_code_node_add_error_type (VALA_CODE_NODE (method), (_tmp4 = vala_genie_parser_parse_type (self, TRUE, &inner_error)));
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) || _vala_strcmp0 (id, "main") == 0) {
		vala_method_set_binding (method, MEMBER_BINDING_STATIC);
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT)) {
		vala_method_set_is_abstract (method, TRUE);
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL)) {
		vala_method_set_is_virtual (method, TRUE);
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE)) {
		vala_method_set_overrides (method, TRUE);
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE)) {
		vala_method_set_is_inline (method, TRUE);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	body_location = vala_genie_parser_get_location (self);
	/* "requires" and "ensures" if present will be at  start of the method body */
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_REQUIRES)) {
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL) && vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
				while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
					ValaExpression* _tmp5;
					_tmp5 = NULL;
					vala_method_add_precondition (method, (_tmp5 = vala_genie_parser_parse_expression (self, &inner_error)));
					(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
					vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						return NULL;
					}
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
				vala_genie_parser_accept_terminator (self);
			} else {
				ValaExpression* _tmp6;
				_tmp6 = NULL;
				vala_method_add_precondition (method, (_tmp6 = vala_genie_parser_parse_expression (self, &inner_error)));
				(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
				vala_genie_parser_expect_terminator (self, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
			}
		}
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ENSURES)) {
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL) && vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
				while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
					ValaExpression* _tmp7;
					_tmp7 = NULL;
					vala_method_add_postcondition (method, (_tmp7 = vala_genie_parser_parse_expression (self, &inner_error)));
					(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
					vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						return NULL;
					}
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
				vala_genie_parser_accept_terminator (self);
			} else {
				ValaExpression* _tmp8;
				_tmp8 = NULL;
				vala_method_add_postcondition (method, (_tmp8 = vala_genie_parser_parse_expression (self, &inner_error)));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				vala_genie_parser_expect_terminator (self, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
			}
		}
	}
	vala_genie_parser_rollback (self, &body_location);
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* _tmp9;
		_tmp9 = NULL;
		vala_method_set_body (method, (_tmp9 = vala_genie_parser_parse_block (self, &inner_error)));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	}
	_tmp10 = NULL;
	return (_tmp10 = method, (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), (id = (g_free (id), NULL)), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp10);
}


static ValaProperty* vala_genie_parser_parse_property_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	gboolean readonly;
	ValaGenieParserModifierFlags flags;
	char* id;
	gboolean is_weak;
	ValaDataType* type;
	ValaSourceReference* _tmp0;
	ValaProperty* _tmp1;
	ValaProperty* prop;
	ValaProperty* _tmp24;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	readonly = FALSE;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_PROP, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	readonly = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_READONLY);
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	is_weak = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WEAK);
	type = vala_genie_parser_parse_type (self, FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	prop = (_tmp1 = vala_property_new (id, type, NULL, NULL, (_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (prop), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access (VALA_SYMBOL (prop), vala_genie_parser_get_access (self, id));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (prop), attrs);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT)) {
		vala_property_set_is_abstract (prop, TRUE);
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL)) {
		vala_property_set_is_virtual (prop, TRUE);
	}
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE)) {
		vala_property_set_overrides (prop, TRUE);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp2;
		_tmp2 = NULL;
		vala_property_set_default_expression (prop, (_tmp2 = vala_genie_parser_parse_expression (self, &inner_error)));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	}
	if (vala_genie_parser_accept_block (self)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
			ValaSourceLocation accessor_begin;
			GeeList* _tmp3;
			ValaSymbolAccessibility accessor_access;
			accessor_begin = vala_genie_parser_get_location (self);
			_tmp3 = NULL;
			_tmp3 = vala_genie_parser_parse_attributes (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
			accessor_access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_GET)) {
				ValaBlock* block;
				ValaPropertyAccessor* _tmp8;
				ValaSourceReference* _tmp7;
				if (vala_property_get_get_accessor (prop) != NULL) {
					char* _tmp4;
					GError* _tmp5;
					_tmp4 = NULL;
					inner_error = (_tmp5 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp4 = vala_genie_parser_get_error (self, "property get accessor already defined"))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						return NULL;
					}
				}
				block = NULL;
				if (vala_genie_parser_accept_block (self)) {
					ValaBlock* _tmp6;
					_tmp6 = NULL;
					block = (_tmp6 = vala_genie_parser_parse_block (self, &inner_error), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), _tmp6);
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						return NULL;
					}
				}
				_tmp8 = NULL;
				_tmp7 = NULL;
				vala_property_set_get_accessor (prop, (_tmp8 = vala_property_accessor_new (TRUE, FALSE, FALSE, block, (_tmp7 = vala_genie_parser_get_src (self, &accessor_begin)))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
				vala_property_accessor_set_access (vala_property_get_get_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
			} else {
				gboolean _construct;
				ValaBlock* block;
				ValaPropertyAccessor* _tmp17;
				ValaSourceReference* _tmp16;
				_construct = FALSE;
				if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_SET)) {
					if (readonly) {
						char* _tmp9;
						GError* _tmp10;
						_tmp9 = NULL;
						inner_error = (_tmp10 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp9 = vala_genie_parser_get_error (self, "set block not allowed for a read only property"))), (_tmp9 = (g_free (_tmp9), NULL)), _tmp10);
						if (inner_error != NULL) {
							g_propagate_error (error, inner_error);
							return NULL;
						}
					}
					_construct = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CONSTRUCT);
				} else {
					if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CONSTRUCT)) {
						_construct = TRUE;
					} else {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
							char* _tmp11;
							GError* _tmp12;
							_tmp11 = NULL;
							inner_error = (_tmp12 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp11 = vala_genie_parser_get_error (self, "expected get, set, or construct"))), (_tmp11 = (g_free (_tmp11), NULL)), _tmp12);
							if (inner_error != NULL) {
								g_propagate_error (error, inner_error);
								return NULL;
							}
						}
					}
				}
				if (vala_property_get_set_accessor (prop) != NULL) {
					char* _tmp13;
					GError* _tmp14;
					_tmp13 = NULL;
					inner_error = (_tmp14 = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, (_tmp13 = vala_genie_parser_get_error (self, "property set accessor already defined"))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14);
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						return NULL;
					}
				}
				block = NULL;
				if (vala_genie_parser_accept_block (self)) {
					ValaBlock* _tmp15;
					_tmp15 = NULL;
					block = (_tmp15 = vala_genie_parser_parse_block (self, &inner_error), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), _tmp15);
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						return NULL;
					}
				}
				_tmp17 = NULL;
				_tmp16 = NULL;
				vala_property_set_set_accessor (prop, (_tmp17 = vala_property_accessor_new (FALSE, !readonly, _construct, block, (_tmp16 = vala_genie_parser_get_src (self, &accessor_begin)))));
				(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
				(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
				vala_property_accessor_set_access (vala_property_get_set_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
			}
		}
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	} else {
		ValaPropertyAccessor* _tmp19;
		ValaSourceReference* _tmp18;
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_property_set_get_accessor (prop, (_tmp19 = vala_property_accessor_new (TRUE, FALSE, FALSE, NULL, (_tmp18 = vala_genie_parser_get_src (self, &begin)))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
		vala_property_accessor_set_access (vala_property_get_get_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		if (!readonly) {
			ValaPropertyAccessor* _tmp21;
			ValaSourceReference* _tmp20;
			_tmp21 = NULL;
			_tmp20 = NULL;
			vala_property_set_set_accessor (prop, (_tmp21 = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, (_tmp20 = vala_genie_parser_get_src (self, &begin)))));
			(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
			vala_property_accessor_set_access (vala_property_get_set_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		}
		vala_genie_parser_expect_terminator (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	if (!vala_property_get_is_abstract (prop) && !vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner))) {
		gboolean needs_var;
		needs_var = (readonly && (vala_property_get_get_accessor (prop) != NULL && vala_property_accessor_get_body (vala_property_get_get_accessor (prop)) == NULL));
		if (!needs_var) {
			needs_var = (vala_property_get_get_accessor (prop) != NULL && vala_property_accessor_get_body (vala_property_get_get_accessor (prop)) == NULL) || (vala_property_get_set_accessor (prop) != NULL && vala_property_accessor_get_body (vala_property_get_set_accessor (prop)) == NULL);
		}
		if (needs_var) {
			ValaDataType* field_type;
			ValaField* _tmp23;
			char* _tmp22;
			/* automatic property accessor body generation */
			field_type = vala_data_type_copy (vala_property_get_property_type (prop));
			vala_data_type_set_value_owned (field_type, !is_weak);
			_tmp23 = NULL;
			_tmp22 = NULL;
			vala_property_set_field (prop, (_tmp23 = vala_field_new ((_tmp22 = g_strdup_printf ("_%s", vala_symbol_get_name (VALA_SYMBOL (prop)))), field_type, vala_property_get_default_expression (prop), vala_code_node_get_source_reference (VALA_CODE_NODE (prop)))));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
			_tmp22 = (g_free (_tmp22), NULL);
			vala_symbol_set_access (VALA_SYMBOL (vala_property_get_field (prop)), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
			(field_type == NULL ? NULL : (field_type = (g_object_unref (field_type), NULL)));
		}
	}
	_tmp24 = NULL;
	return (_tmp24 = prop, (id = (g_free (id), NULL)), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp24);
}


static ValaSignal* vala_genie_parser_parse_signal_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaGenieParserModifierFlags flags;
	char* id;
	GeeArrayList* params;
	ValaSourceReference* _tmp2;
	ValaSignal* _tmp3;
	ValaSignal* sig;
	ValaSignal* _tmp4;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	type = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EVENT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	params = gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaFormalParameter* param;
			param = vala_genie_parser_parse_parameter (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			gee_collection_add (GEE_COLLECTION (params), param);
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		type = (_tmp0 = vala_genie_parser_parse_type (self, TRUE, &inner_error), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	} else {
		ValaDataType* _tmp1;
		_tmp1 = NULL;
		type = (_tmp1 = VALA_DATA_TYPE (vala_void_type_new ()), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp1);
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	sig = (_tmp3 = vala_signal_new (id, type, (_tmp2 = vala_genie_parser_get_src_com (self, &begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (sig), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access (VALA_SYMBOL (sig), vala_genie_parser_get_access (self, id));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (sig), attrs);
	{
		GeeArrayList* formal_param_collection;
		int formal_param_it;
		formal_param_collection = params;
		for (formal_param_it = 0; formal_param_it < gee_collection_get_size (GEE_COLLECTION (formal_param_collection)); formal_param_it = formal_param_it + 1) {
			ValaFormalParameter* formal_param;
			formal_param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (formal_param_collection), formal_param_it)));
			{
				vala_signal_add_parameter (sig, formal_param);
				(formal_param == NULL ? NULL : (formal_param = (g_object_unref (formal_param), NULL)));
			}
		}
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp4 = NULL;
	return (_tmp4 = sig, (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), (id = (g_free (id), NULL)), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp4);
}


static ValaConstructor* vala_genie_parser_parse_constructor_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaSourceReference* _tmp0;
	ValaConstructor* _tmp1;
	ValaConstructor* c;
	ValaBlock* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INIT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	_tmp0 = NULL;
	_tmp1 = NULL;
	c = (_tmp1 = vala_constructor_new ((_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC)) {
		vala_constructor_set_binding (c, MEMBER_BINDING_STATIC);
	} else {
		if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS)) {
			vala_constructor_set_binding (c, MEMBER_BINDING_CLASS);
		}
	}
	vala_genie_parser_accept_block (self);
	_tmp2 = NULL;
	vala_constructor_set_body (c, (_tmp2 = vala_genie_parser_parse_block (self, &inner_error)));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	return c;
}


static ValaDestructor* vala_genie_parser_parse_destructor_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0;
	ValaDestructor* _tmp1;
	ValaDestructor* d;
	ValaBlock* _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FINAL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	d = (_tmp1 = vala_destructor_new ((_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_genie_parser_accept_block (self);
	_tmp2 = NULL;
	vala_destructor_set_body (d, (_tmp2 = vala_genie_parser_parse_block (self, &inner_error)));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	return d;
}


static ValaSymbol* vala_genie_parser_parse_struct_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	GeeList* type_param_list;
	GeeArrayList* base_types;
	ValaSourceReference* _tmp1;
	ValaStruct* _tmp2;
	ValaStruct* st;
	ValaSymbol* _tmp3;
	ValaSymbol* result;
	ValaSymbol* _tmp8;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_STRUCT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type_param_list = vala_genie_parser_parse_type_parameter_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	base_types = gee_array_list_new (VALA_TYPE_DATA_TYPE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		do {
			ValaDataType* _tmp0;
			_tmp0 = NULL;
			gee_collection_add (GEE_COLLECTION (base_types), (_tmp0 = vala_genie_parser_parse_type (self, TRUE, &inner_error)));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	st = (_tmp2 = vala_struct_new (vala_unresolved_symbol_get_name (sym), (_tmp1 = vala_genie_parser_get_src_com (self, &begin))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (st), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access (VALA_SYMBOL (st), vala_genie_parser_get_access (self, vala_unresolved_symbol_get_name (sym)));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (st), attrs);
	{
		GeeList* type_param_collection;
		int type_param_it;
		type_param_collection = type_param_list;
		for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
			ValaTypeParameter* type_param;
			type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
			{
				vala_struct_add_type_parameter (st, type_param);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
			}
		}
	}
	{
		GeeArrayList* base_type_collection;
		int base_type_it;
		base_type_collection = base_types;
		for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
			ValaDataType* base_type;
			base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
			{
				vala_struct_add_base_type (st, base_type);
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			}
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_parse_declarations (self, VALA_SYMBOL (st), FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp3 = NULL;
	result = (_tmp3 = VALA_SYMBOL (st), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp5;
		ValaUnresolvedSymbol* _tmp4;
		ValaNamespace* ns;
		ValaSymbol* _tmp7;
		ValaSymbol* _tmp6;
		_tmp5 = NULL;
		_tmp4 = NULL;
		sym = (_tmp5 = (_tmp4 = vala_unresolved_symbol_get_inner (sym), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp5);
		ns = vala_namespace_new (vala_unresolved_symbol_get_name (sym), vala_code_node_get_source_reference (VALA_CODE_NODE (st)));
		if (VALA_IS_NAMESPACE (result)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (result));
		} else {
			vala_namespace_add_struct (ns, VALA_STRUCT (result));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), VALA_CODE_NODE (result));
		}
		_tmp7 = NULL;
		_tmp6 = NULL;
		result = (_tmp7 = (_tmp6 = VALA_SYMBOL (ns), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp7);
		(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
	}
	_tmp8 = NULL;
	return (_tmp8 = result, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), (type_param_list == NULL ? NULL : (type_param_list = (g_object_unref (type_param_list), NULL))), (base_types == NULL ? NULL : (base_types = (g_object_unref (base_types), NULL))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp8);
}


static void vala_genie_parser_parse_struct_member (ValaGenieParser* self, ValaStruct* st, GError** error) {
	GError * inner_error;
	ValaSymbol* sym;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_STRUCT (st));
	inner_error = NULL;
	sym = vala_genie_parser_parse_declaration (self, FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	if (VALA_IS_METHOD (sym)) {
		vala_struct_add_method (st, VALA_METHOD (sym));
	} else {
		if (VALA_IS_FIELD (sym)) {
			vala_struct_add_field (st, VALA_FIELD (sym));
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				vala_struct_add_constant (st, VALA_CONSTANT (sym));
			} else {
				if (sym == NULL) {
					/* workaround for current limitation of exception handling*/
					inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in declaration");
					if (inner_error != NULL) {
						g_propagate_error (error, inner_error);
						return;
					}
				} else {
					vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (sym)), "unexpected declaration in struct");
				}
			}
		}
	}
	(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
}


static ValaSymbol* vala_genie_parser_parse_interface_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	GeeList* type_param_list;
	GeeArrayList* base_types;
	ValaSourceReference* _tmp1;
	ValaInterface* _tmp2;
	ValaInterface* iface;
	ValaSymbol* _tmp3;
	ValaSymbol* result;
	ValaSymbol* _tmp8;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INTERFACE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type_param_list = vala_genie_parser_parse_type_parameter_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	base_types = gee_array_list_new (VALA_TYPE_DATA_TYPE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		do {
			ValaDataType* _tmp0;
			_tmp0 = NULL;
			gee_collection_add (GEE_COLLECTION (base_types), (_tmp0 = vala_genie_parser_parse_type (self, TRUE, &inner_error)));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	iface = (_tmp2 = vala_interface_new (vala_unresolved_symbol_get_name (sym), (_tmp1 = vala_genie_parser_get_src_com (self, &begin))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (iface), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access (VALA_SYMBOL (iface), vala_genie_parser_get_access (self, vala_unresolved_symbol_get_name (sym)));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (iface), attrs);
	{
		GeeList* type_param_collection;
		int type_param_it;
		type_param_collection = type_param_list;
		for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
			ValaTypeParameter* type_param;
			type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
			{
				vala_interface_add_type_parameter (iface, type_param);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
			}
		}
	}
	{
		GeeArrayList* base_type_collection;
		int base_type_it;
		base_type_collection = base_types;
		for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
			ValaDataType* base_type;
			base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
			{
				vala_interface_add_prerequisite (iface, base_type);
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			}
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_parse_declarations (self, VALA_SYMBOL (iface), FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp3 = NULL;
	result = (_tmp3 = VALA_SYMBOL (iface), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp5;
		ValaUnresolvedSymbol* _tmp4;
		ValaNamespace* ns;
		ValaSymbol* _tmp7;
		ValaSymbol* _tmp6;
		_tmp5 = NULL;
		_tmp4 = NULL;
		sym = (_tmp5 = (_tmp4 = vala_unresolved_symbol_get_inner (sym), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp5);
		ns = vala_namespace_new (vala_unresolved_symbol_get_name (sym), vala_code_node_get_source_reference (VALA_CODE_NODE (iface)));
		if (VALA_IS_NAMESPACE (result)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (result));
		} else {
			vala_namespace_add_interface (ns, VALA_INTERFACE (result));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), VALA_CODE_NODE (result));
		}
		_tmp7 = NULL;
		_tmp6 = NULL;
		result = (_tmp7 = (_tmp6 = VALA_SYMBOL (ns), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp7);
		(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
	}
	_tmp8 = NULL;
	return (_tmp8 = result, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), (type_param_list == NULL ? NULL : (type_param_list = (g_object_unref (type_param_list), NULL))), (base_types == NULL ? NULL : (base_types = (g_object_unref (base_types), NULL))), (iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL))), _tmp8);
}


static void vala_genie_parser_parse_interface_member (ValaGenieParser* self, ValaInterface* iface, GError** error) {
	GError * inner_error;
	ValaSymbol* sym;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	inner_error = NULL;
	sym = vala_genie_parser_parse_declaration (self, FALSE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	if (VALA_IS_CLASS (sym)) {
		vala_interface_add_class (iface, VALA_CLASS (sym));
	} else {
		if (VALA_IS_STRUCT (sym)) {
			vala_interface_add_struct (iface, VALA_STRUCT (sym));
		} else {
			if (VALA_IS_ENUM (sym)) {
				vala_interface_add_enum (iface, VALA_ENUM (sym));
			} else {
				if (VALA_IS_DELEGATE (sym)) {
					vala_interface_add_delegate (iface, VALA_DELEGATE (sym));
				} else {
					if (VALA_IS_METHOD (sym)) {
						vala_interface_add_method (iface, VALA_METHOD (sym));
					} else {
						if (VALA_IS_SIGNAL (sym)) {
							vala_interface_add_signal (iface, VALA_SIGNAL (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_interface_add_field (iface, VALA_FIELD (sym));
							} else {
								if (VALA_IS_PROPERTY (sym)) {
									vala_interface_add_property (iface, VALA_PROPERTY (sym));
								} else {
									if (sym == NULL) {
										/* workaround for current limitation of exception handling*/
										inner_error = g_error_new (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, "syntax error in declaration");
										if (inner_error != NULL) {
											g_propagate_error (error, inner_error);
											return;
										}
									} else {
										vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (sym)), "unexpected declaration in interface");
									}
								}
							}
						}
					}
				}
			}
		}
	}
	(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
}


static ValaSymbol* vala_genie_parser_parse_enum_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	ValaSourceReference* _tmp0;
	ValaEnum* _tmp1;
	ValaEnum* en;
	ValaSymbol* _tmp5;
	ValaSymbol* result;
	ValaSymbol* _tmp10;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ENUM, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	en = (_tmp1 = vala_enum_new (vala_unresolved_symbol_get_name (sym), (_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (en), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access (VALA_SYMBOL (en), vala_genie_parser_get_access (self, vala_unresolved_symbol_get_name (sym)));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (en), attrs);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	do {
		GeeList* value_attrs;
		ValaSourceLocation value_begin;
		char* id;
		ValaSourceReference* _tmp2;
		ValaEnumValue* _tmp3;
		ValaEnumValue* ev;
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_DEDENT) {
			/* allow trailing comma*/
			break;
		}
		value_attrs = vala_genie_parser_parse_attributes (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		value_begin = vala_genie_parser_get_location (self);
		id = vala_genie_parser_parse_identifier (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp2 = NULL;
		_tmp3 = NULL;
		ev = (_tmp3 = vala_enum_value_new (id, (_tmp2 = vala_genie_parser_get_src (self, &value_begin))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
		vala_genie_parser_set_attributes (self, VALA_CODE_NODE (ev), value_attrs);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
			ValaExpression* _tmp4;
			_tmp4 = NULL;
			vala_enum_value_set_value (ev, (_tmp4 = vala_genie_parser_parse_expression (self, &inner_error)));
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		}
		vala_enum_add_value (en, ev);
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(value_attrs == NULL ? NULL : (value_attrs = (g_object_unref (value_attrs), NULL)));
		id = (g_free (id), NULL);
		(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
	} while (TRUE);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp5 = NULL;
	result = (_tmp5 = VALA_SYMBOL (en), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp7;
		ValaUnresolvedSymbol* _tmp6;
		ValaNamespace* ns;
		ValaSymbol* _tmp9;
		ValaSymbol* _tmp8;
		_tmp7 = NULL;
		_tmp6 = NULL;
		sym = (_tmp7 = (_tmp6 = vala_unresolved_symbol_get_inner (sym), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp7);
		ns = vala_namespace_new (vala_unresolved_symbol_get_name (sym), vala_code_node_get_source_reference (VALA_CODE_NODE (en)));
		if (VALA_IS_NAMESPACE (result)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (result));
		} else {
			vala_namespace_add_enum (ns, VALA_ENUM (result));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), VALA_CODE_NODE (result));
		}
		_tmp9 = NULL;
		_tmp8 = NULL;
		result = (_tmp9 = (_tmp8 = VALA_SYMBOL (ns), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp9);
		(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
	}
	_tmp10 = NULL;
	return (_tmp10 = result, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), (en == NULL ? NULL : (en = (g_object_unref (en), NULL))), _tmp10);
}


static ValaSymbol* vala_genie_parser_parse_errordomain_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	ValaSourceReference* _tmp0;
	ValaErrorDomain* _tmp1;
	ValaErrorDomain* ed;
	ValaSymbol* _tmp3;
	ValaSymbol* result;
	ValaSymbol* _tmp8;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp0 = NULL;
	_tmp1 = NULL;
	ed = (_tmp1 = vala_error_domain_new (vala_unresolved_symbol_get_name (sym), (_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (ed), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access (VALA_SYMBOL (ed), vala_genie_parser_get_access (self, vala_unresolved_symbol_get_name (sym)));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (ed), attrs);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	do {
		GeeList* code_attrs;
		char* id;
		ValaErrorCode* ec;
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_DEDENT) {
			/* allow trailing comma*/
			break;
		}
		code_attrs = vala_genie_parser_parse_attributes (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		id = vala_genie_parser_parse_identifier (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		ec = vala_error_code_new (id);
		vala_genie_parser_set_attributes (self, VALA_CODE_NODE (ec), code_attrs);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
			ValaExpression* _tmp2;
			_tmp2 = NULL;
			vala_error_code_set_value (ec, (_tmp2 = vala_genie_parser_parse_expression (self, &inner_error)));
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		}
		vala_error_domain_add_code (ed, ec);
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
		(code_attrs == NULL ? NULL : (code_attrs = (g_object_unref (code_attrs), NULL)));
		id = (g_free (id), NULL);
		(ec == NULL ? NULL : (ec = (g_object_unref (ec), NULL)));
	} while (TRUE);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp3 = NULL;
	result = (_tmp3 = VALA_SYMBOL (ed), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp5;
		ValaUnresolvedSymbol* _tmp4;
		ValaNamespace* ns;
		ValaSymbol* _tmp7;
		ValaSymbol* _tmp6;
		_tmp5 = NULL;
		_tmp4 = NULL;
		sym = (_tmp5 = (_tmp4 = vala_unresolved_symbol_get_inner (sym), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp5);
		ns = vala_namespace_new (vala_unresolved_symbol_get_name (sym), vala_code_node_get_source_reference (VALA_CODE_NODE (ed)));
		if (VALA_IS_NAMESPACE (result)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (result));
		} else {
			vala_namespace_add_error_domain (ns, VALA_ERROR_DOMAIN (result));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), VALA_CODE_NODE (result));
		}
		_tmp7 = NULL;
		_tmp6 = NULL;
		result = (_tmp7 = (_tmp6 = VALA_SYMBOL (ns), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp7);
		(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
	}
	_tmp8 = NULL;
	return (_tmp8 = result, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), (ed == NULL ? NULL : (ed = (g_object_unref (ed), NULL))), _tmp8);
}


static ValaGenieParserModifierFlags vala_genie_parser_parse_type_declaration_modifiers (ValaGenieParser* self) {
	ValaGenieParserModifierFlags flags;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), 0);
	flags = 0;
	while (TRUE) {
		ValaGenieTokenType _tmp1;
		_tmp1 = vala_genie_parser_current (self);
		if (_tmp1 == VALA_GENIE_TOKEN_TYPE_ABSTRACT)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_EXTERN)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_STATIC)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_PRIVATE)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE);
			break;
		} while (0); else
		do {
			return flags;
		} while (0);
	}
	return flags;
}


static ValaGenieParserModifierFlags vala_genie_parser_parse_member_declaration_modifiers (ValaGenieParser* self) {
	ValaGenieParserModifierFlags flags;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), 0);
	flags = 0;
	while (TRUE) {
		ValaGenieTokenType _tmp1;
		_tmp1 = vala_genie_parser_current (self);
		if (_tmp1 == VALA_GENIE_TOKEN_TYPE_ABSTRACT)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_CLASS)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_EXTERN)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_INLINE)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_OVERRIDE)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_STATIC)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_VIRTUAL)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL);
			break;
		} while (0); else if (_tmp1 == VALA_GENIE_TOKEN_TYPE_PRIVATE)
		do {
			vala_genie_parser_next (self);
			flags = flags | (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE);
			break;
		} while (0); else
		do {
			return flags;
		} while (0);
	}
	return flags;
}


static ValaFormalParameter* vala_genie_parser_parse_parameter (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	GeeList* attrs;
	ValaSourceLocation begin;
	ValaParameterDirection direction;
	char* id;
	ValaDataType* type;
	ValaSourceReference* _tmp5;
	ValaFormalParameter* _tmp6;
	ValaFormalParameter* param;
	ValaFormalParameter* _tmp8;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	attrs = vala_genie_parser_parse_attributes (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ELLIPSIS)) {
		ValaSourceReference* _tmp0;
		ValaFormalParameter* _tmp1;
		ValaFormalParameter* _tmp2;
		/* varargs*/
		_tmp0 = NULL;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = (_tmp1 = vala_formal_parameter_new_with_ellipsis ((_tmp0 = vala_genie_parser_get_src (self, &begin))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1), (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), _tmp2);
	}
	direction = VALA_PARAMETER_DIRECTION_IN;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OUT)) {
		direction = VALA_PARAMETER_DIRECTION_OUT;
	} else {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_REF)) {
			direction = VALA_PARAMETER_DIRECTION_REF;
		}
	}
	id = vala_genie_parser_parse_identifier (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type = NULL;
	if (direction == VALA_PARAMETER_DIRECTION_IN) {
		ValaDataType* _tmp3;
		_tmp3 = NULL;
		type = (_tmp3 = vala_genie_parser_parse_type (self, FALSE, &inner_error), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp3);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	} else {
		ValaDataType* _tmp4;
		_tmp4 = NULL;
		type = (_tmp4 = vala_genie_parser_parse_type (self, TRUE, &inner_error), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp4);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	}
	_tmp5 = NULL;
	_tmp6 = NULL;
	param = (_tmp6 = vala_formal_parameter_new (id, type, (_tmp5 = vala_genie_parser_get_src (self, &begin))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6);
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (param), attrs);
	vala_formal_parameter_set_direction (param, direction);
	vala_formal_parameter_set_construct_parameter (param, FALSE);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp7;
		_tmp7 = NULL;
		vala_formal_parameter_set_default_expression (param, (_tmp7 = vala_genie_parser_parse_expression (self, &inner_error)));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	}
	_tmp8 = NULL;
	return (_tmp8 = param, (attrs == NULL ? NULL : (attrs = (g_object_unref (attrs), NULL))), (id = (g_free (id), NULL)), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp8);
}


static ValaCreationMethod* vala_genie_parser_parse_creation_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaCreationMethod* method;
	ValaGenieParserModifierFlags flags;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	method = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CONSTRUCT, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		ValaCreationMethod* _tmp1;
		ValaSourceReference* _tmp0;
		/* create default name using class name */
		_tmp1 = NULL;
		_tmp0 = NULL;
		method = (_tmp1 = vala_creation_method_new (self->priv->class_name, NULL, (_tmp0 = vala_genie_parser_get_src_com (self, &begin))), (method == NULL ? NULL : (method = (g_object_unref (method), NULL))), _tmp1);
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaUnresolvedSymbol* sym;
		sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		if (vala_unresolved_symbol_get_inner (sym) == NULL) {
			if (_vala_strcmp0 (vala_unresolved_symbol_get_name (sym), self->priv->class_name) != 0) {
				ValaCreationMethod* _tmp3;
				ValaSourceReference* _tmp2;
				_tmp3 = NULL;
				_tmp2 = NULL;
				method = (_tmp3 = vala_creation_method_new (self->priv->class_name, vala_unresolved_symbol_get_name (sym), (_tmp2 = vala_genie_parser_get_src_com (self, &begin))), (method == NULL ? NULL : (method = (g_object_unref (method), NULL))), _tmp3);
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
			} else {
				ValaCreationMethod* _tmp5;
				ValaSourceReference* _tmp4;
				_tmp5 = NULL;
				_tmp4 = NULL;
				method = (_tmp5 = vala_creation_method_new (vala_unresolved_symbol_get_name (sym), NULL, (_tmp4 = vala_genie_parser_get_src_com (self, &begin))), (method == NULL ? NULL : (method = (g_object_unref (method), NULL))), _tmp5);
				(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
			}
		} else {
			ValaCreationMethod* _tmp7;
			ValaSourceReference* _tmp6;
			_tmp7 = NULL;
			_tmp6 = NULL;
			method = (_tmp7 = vala_creation_method_new (vala_unresolved_symbol_get_name (vala_unresolved_symbol_get_inner (sym)), vala_unresolved_symbol_get_name (sym), (_tmp6 = vala_genie_parser_get_src_com (self, &begin))), (method == NULL ? NULL : (method = (g_object_unref (method), NULL))), _tmp7);
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaFormalParameter* param;
			param = vala_genie_parser_parse_parameter (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			vala_method_add_parameter (VALA_METHOD (method), param);
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_RAISES)) {
		do {
			ValaDataType* _tmp8;
			_tmp8 = NULL;
			vala_code_node_add_error_type (VALA_CODE_NODE (method), (_tmp8 = vala_genie_parser_parse_type (self, TRUE, &inner_error)));
			(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_symbol_set_access (VALA_SYMBOL (method), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (method), attrs);
	vala_method_set_binding (VALA_METHOD (method), MEMBER_BINDING_STATIC);
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* _tmp9;
		_tmp9 = NULL;
		vala_method_set_body (VALA_METHOD (method), (_tmp9 = vala_genie_parser_parse_block (self, &inner_error)));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	}
	return method;
}


static ValaSymbol* vala_genie_parser_parse_delegate_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	GeeList* type_param_list;
	GeeArrayList* params;
	ValaSourceReference* _tmp3;
	ValaDelegate* _tmp4;
	ValaDelegate* d;
	ValaSymbol* _tmp5;
	ValaSymbol* result;
	ValaSymbol* _tmp10;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	g_return_val_if_fail (attrs == NULL || GEE_IS_LIST (attrs), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	type = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DELEGATE, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	type_param_list = vala_genie_parser_parse_type_parameter_list (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	params = gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaFormalParameter* param;
			param = vala_genie_parser_parse_parameter (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			gee_collection_add (GEE_COLLECTION (params), param);
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		type = (_tmp0 = vala_genie_parser_parse_type (self, TRUE, &inner_error), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
	} else {
		ValaDataType* _tmp1;
		_tmp1 = NULL;
		type = (_tmp1 = VALA_DATA_TYPE (vala_void_type_new ()), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp1);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_RAISES)) {
		do {
			ValaDataType* _tmp2;
			_tmp2 = NULL;
			_tmp2 = vala_genie_parser_parse_type (self, TRUE, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect_terminator (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	_tmp3 = NULL;
	_tmp4 = NULL;
	d = (_tmp4 = vala_delegate_new (vala_unresolved_symbol_get_name (sym), type, (_tmp3 = vala_genie_parser_get_src_com (self, &begin))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4);
	if (((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE)) {
		vala_symbol_set_access (VALA_SYMBOL (d), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access (VALA_SYMBOL (d), vala_genie_parser_get_access (self, vala_unresolved_symbol_get_name (sym)));
	}
	vala_genie_parser_set_attributes (self, VALA_CODE_NODE (d), attrs);
	{
		GeeList* type_param_collection;
		int type_param_it;
		type_param_collection = type_param_list;
		for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
			ValaTypeParameter* type_param;
			type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
			{
				vala_delegate_add_type_parameter (d, type_param);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
			}
		}
	}
	{
		GeeArrayList* formal_param_collection;
		int formal_param_it;
		formal_param_collection = params;
		for (formal_param_it = 0; formal_param_it < gee_collection_get_size (GEE_COLLECTION (formal_param_collection)); formal_param_it = formal_param_it + 1) {
			ValaFormalParameter* formal_param;
			formal_param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (formal_param_collection), formal_param_it)));
			{
				vala_delegate_add_parameter (d, formal_param);
				(formal_param == NULL ? NULL : (formal_param = (g_object_unref (formal_param), NULL)));
			}
		}
	}
	if (!(((flags) & (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC)) == (VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC))) {
		vala_delegate_set_has_target (d, TRUE);
	}
	_tmp5 = NULL;
	result = (_tmp5 = VALA_SYMBOL (d), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp7;
		ValaUnresolvedSymbol* _tmp6;
		ValaNamespace* ns;
		ValaSymbol* _tmp9;
		ValaSymbol* _tmp8;
		_tmp7 = NULL;
		_tmp6 = NULL;
		sym = (_tmp7 = (_tmp6 = vala_unresolved_symbol_get_inner (sym), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp7);
		ns = vala_namespace_new (vala_unresolved_symbol_get_name (sym), vala_code_node_get_source_reference (VALA_CODE_NODE (d)));
		if (VALA_IS_NAMESPACE (result)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (result));
		} else {
			vala_namespace_add_delegate (ns, VALA_DELEGATE (result));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), VALA_CODE_NODE (result));
		}
		_tmp9 = NULL;
		_tmp8 = NULL;
		result = (_tmp9 = (_tmp8 = VALA_SYMBOL (ns), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp9);
		(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
	}
	_tmp10 = NULL;
	return (_tmp10 = result, (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), (type_param_list == NULL ? NULL : (type_param_list = (g_object_unref (type_param_list), NULL))), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (d == NULL ? NULL : (d = (g_object_unref (d), NULL))), _tmp10);
}


static GeeList* vala_genie_parser_parse_type_parameter_list (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	GeeArrayList* list;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	list = gee_array_list_new (VALA_TYPE_TYPEPARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF)) {
		do {
			ValaSourceLocation begin;
			char* id;
			ValaTypeParameter* _tmp1;
			ValaSourceReference* _tmp0;
			begin = vala_genie_parser_get_location (self);
			id = vala_genie_parser_parse_identifier (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return NULL;
			}
			_tmp1 = NULL;
			_tmp0 = NULL;
			gee_collection_add (GEE_COLLECTION (list), (_tmp1 = vala_typeparameter_new (id, (_tmp0 = vala_genie_parser_get_src (self, &begin)))));
			(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
			id = (g_free (id), NULL);
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	return GEE_LIST (list);
}


static void vala_genie_parser_skip_type_argument_list (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	g_return_if_fail (VALA_GENIE_IS_PARSER (self));
	inner_error = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF)) {
		do {
			vala_genie_parser_skip_type (self, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return;
			}
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
}


/* try to parse type argument list*/
static GeeList* vala_genie_parser_parse_type_argument_list (ValaGenieParser* self, gboolean maybe_expression, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF)) {
		GeeArrayList* list;
		list = gee_array_list_new (VALA_TYPE_DATA_TYPE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
		do {
			ValaGenieTokenType _tmp1;
			_tmp1 = vala_genie_parser_current (self);
			if (_tmp1 == VALA_GENIE_TOKEN_TYPE_VOID || _tmp1 == VALA_GENIE_TOKEN_TYPE_DYNAMIC || _tmp1 == VALA_GENIE_TOKEN_TYPE_WEAK || _tmp1 == VALA_GENIE_TOKEN_TYPE_IDENTIFIER)
			do {
				ValaDataType* type;
				type = vala_genie_parser_parse_type (self, TRUE, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					return NULL;
				}
				gee_collection_add (GEE_COLLECTION (list), type);
				(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
				break;
			} while (0); else
			do {
				GeeList* _tmp0;
				vala_genie_parser_rollback (self, &begin);
				_tmp0 = NULL;
				return (_tmp0 = NULL, (list == NULL ? NULL : (list = (g_object_unref (list), NULL))), _tmp0);
			} while (0);
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		return GEE_LIST (list);
	}
	return NULL;
}


static ValaMemberAccess* vala_genie_parser_parse_member_name (ValaGenieParser* self, GError** error) {
	GError * inner_error;
	ValaSourceLocation begin;
	ValaMemberAccess* expr;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), NULL);
	inner_error = NULL;
	begin = vala_genie_parser_get_location (self);
	expr = NULL;
	do {
		char* id;
		GeeList* type_arg_list;
		ValaMemberAccess* _tmp1;
		ValaSourceReference* _tmp0;
		id = vala_genie_parser_parse_identifier (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		type_arg_list = vala_genie_parser_parse_type_argument_list (self, FALSE, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return NULL;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		expr = (_tmp1 = vala_member_access_new (VALA_EXPRESSION (expr), id, (_tmp0 = vala_genie_parser_get_src (self, &begin))), (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), _tmp1);
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		if (type_arg_list != NULL) {
			{
				GeeList* type_arg_collection;
				int type_arg_it;
				type_arg_collection = type_arg_list;
				for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
					ValaDataType* type_arg;
					type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
					{
						vala_member_access_add_type_argument (expr, type_arg);
						(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
					}
				}
			}
		}
		id = (g_free (id), NULL);
		(type_arg_list == NULL ? NULL : (type_arg_list = (g_object_unref (type_arg_list), NULL)));
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DOT));
	return expr;
}


static gboolean vala_genie_parser_is_declaration_keyword (ValaGenieParser* self, ValaGenieTokenType type) {
	ValaGenieTokenType _tmp2;
	g_return_val_if_fail (VALA_GENIE_IS_PARSER (self), FALSE);
	_tmp2 = type;
	if (_tmp2 == VALA_GENIE_TOKEN_TYPE_CLASS || _tmp2 == VALA_GENIE_TOKEN_TYPE_CONST || _tmp2 == VALA_GENIE_TOKEN_TYPE_DEF || _tmp2 == VALA_GENIE_TOKEN_TYPE_DELEGATE || _tmp2 == VALA_GENIE_TOKEN_TYPE_ENUM || _tmp2 == VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN || _tmp2 == VALA_GENIE_TOKEN_TYPE_EVENT || _tmp2 == VALA_GENIE_TOKEN_TYPE_FINAL || _tmp2 == VALA_GENIE_TOKEN_TYPE_INIT || _tmp2 == VALA_GENIE_TOKEN_TYPE_INTERFACE || _tmp2 == VALA_GENIE_TOKEN_TYPE_NAMESPACE || _tmp2 == VALA_GENIE_TOKEN_TYPE_OVERRIDE || _tmp2 == VALA_GENIE_TOKEN_TYPE_PROP || _tmp2 == VALA_GENIE_TOKEN_TYPE_STRUCT)
	do {
		return TRUE;
	} while (0); else
	do {
		return FALSE;
	} while (0);
}


/**
 * Code visitor parsing all Genie source files.
 */
ValaGenieParser* vala_genie_parser_new (void) {
	ValaGenieParser * self;
	self = g_object_newv (VALA_GENIE_TYPE_PARSER, 0, NULL);
	return self;
}


static GObject * vala_genie_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ValaGenieParserClass * klass;
	GObjectClass * parent_class;
	ValaGenieParser * self;
	klass = VALA_GENIE_PARSER_CLASS (g_type_class_peek (VALA_GENIE_TYPE_PARSER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_GENIE_PARSER (obj);
	{
		ValaGenieParserTokenInfo* _tmp0;
		char* _tmp1;
		_tmp0 = NULL;
		self->priv->tokens = (_tmp0 = g_new0 (ValaGenieParserTokenInfo, VALA_GENIE_PARSER_BUFFER_SIZE), (self->priv->tokens = (g_free (self->priv->tokens), NULL)), self->priv->tokens_length1 = VALA_GENIE_PARSER_BUFFER_SIZE, _tmp0);
		_tmp1 = NULL;
		self->priv->class_name = (_tmp1 = NULL, (self->priv->class_name = (g_free (self->priv->class_name), NULL)), _tmp1);
		self->priv->current_expr_is_lambda = FALSE;
	}
	return obj;
}


static void vala_genie_parser_class_init (ValaGenieParserClass * klass) {
	vala_genie_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaGenieParserPrivate));
	G_OBJECT_CLASS (klass)->constructor = vala_genie_parser_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_genie_parser_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_genie_parser_real_visit_source_file;
}


static void vala_genie_parser_instance_init (ValaGenieParser * self) {
	self->priv = VALA_GENIE_PARSER_GET_PRIVATE (self);
}


static void vala_genie_parser_dispose (GObject * obj) {
	ValaGenieParser * self;
	self = VALA_GENIE_PARSER (obj);
	(self->priv->scanner == NULL ? NULL : (self->priv->scanner = (g_object_unref (self->priv->scanner), NULL)));
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	self->priv->comment = (g_free (self->priv->comment), NULL);
	self->priv->class_name = (g_free (self->priv->class_name), NULL);
	G_OBJECT_CLASS (vala_genie_parser_parent_class)->dispose (obj);
}


GType vala_genie_parser_get_type (void) {
	static GType vala_genie_parser_type_id = 0;
	if (G_UNLIKELY (vala_genie_parser_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenieParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_genie_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenieParser), 0, (GInstanceInitFunc) vala_genie_parser_instance_init };
		vala_genie_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGenieParser", &g_define_type_info, 0);
	}
	return vala_genie_parser_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




