/* valavoidtype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valavoidtype.h>




enum  {
	VALA_VOID_TYPE_DUMMY_PROPERTY
};
static gboolean vala_void_type_real_stricter (ValaDataType* base, ValaDataType* type2);
static char* vala_void_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
static char* vala_void_type_real_get_cname (ValaDataType* base);
static ValaDataType* vala_void_type_real_copy (ValaDataType* base);
static gpointer vala_void_type_parent_class = NULL;



ValaVoidType* vala_void_type_new (void) {
	ValaVoidType * self;
	self = g_object_newv (VALA_TYPE_VOID_TYPE, 0, NULL);
	return self;
}


static gboolean vala_void_type_real_stricter (ValaDataType* base, ValaDataType* type2) {
	ValaVoidType * self;
	self = VALA_VOID_TYPE (base);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type2), FALSE);
	return (VALA_IS_VOID_TYPE (type2));
}


static char* vala_void_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaVoidType * self;
	self = VALA_VOID_TYPE (base);
	g_return_val_if_fail (scope == NULL || VALA_IS_SCOPE (scope), NULL);
	return g_strdup ("void");
}


static char* vala_void_type_real_get_cname (ValaDataType* base) {
	ValaVoidType * self;
	self = VALA_VOID_TYPE (base);
	return g_strdup ("void");
}


static ValaDataType* vala_void_type_real_copy (ValaDataType* base) {
	ValaVoidType * self;
	self = VALA_VOID_TYPE (base);
	return VALA_DATA_TYPE (vala_void_type_new ());
}


static void vala_void_type_class_init (ValaVoidTypeClass * klass) {
	vala_void_type_parent_class = g_type_class_peek_parent (klass);
	VALA_DATA_TYPE_CLASS (klass)->stricter = vala_void_type_real_stricter;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_void_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_void_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_void_type_real_copy;
}


static void vala_void_type_instance_init (ValaVoidType * self) {
}


GType vala_void_type_get_type (void) {
	static GType vala_void_type_type_id = 0;
	if (vala_void_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVoidTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_void_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVoidType), 0, (GInstanceInitFunc) vala_void_type_instance_init };
		vala_void_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaVoidType", &g_define_type_info, 0);
	}
	return vala_void_type_type_id;
}




