/* valaccodemacroreplacement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeMacroReplacementPrivate {
	char* _name;
	char* _replacement;
	ValaCCodeExpression* _replacement_expression;
};

#define VALA_CCODE_MACRO_REPLACEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_MACRO_REPLACEMENT, ValaCCodeMacroReplacementPrivate))
enum  {
	VALA_CCODE_MACRO_REPLACEMENT_DUMMY_PROPERTY
};
static void vala_ccode_macro_replacement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_macro_replacement_parent_class = NULL;
static void vala_ccode_macro_replacement_finalize (ValaCCodeNode* obj);



ValaCCodeMacroReplacement* vala_ccode_macro_replacement_construct (GType object_type, const char* name, const char* replacement) {
	ValaCCodeMacroReplacement* self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	self = ((ValaCCodeMacroReplacement*) (g_type_create_instance (object_type)));
	vala_ccode_macro_replacement_set_replacement (self, replacement);
	vala_ccode_macro_replacement_set_name (self, name);
	return self;
}


ValaCCodeMacroReplacement* vala_ccode_macro_replacement_new (const char* name, const char* replacement) {
	return vala_ccode_macro_replacement_construct (VALA_TYPE_CCODE_MACRO_REPLACEMENT, name, replacement);
}


ValaCCodeMacroReplacement* vala_ccode_macro_replacement_construct_with_expression (GType object_type, const char* name, ValaCCodeExpression* replacement_expression) {
	ValaCCodeMacroReplacement* self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (replacement_expression), NULL);
	self = ((ValaCCodeMacroReplacement*) (g_type_create_instance (object_type)));
	vala_ccode_macro_replacement_set_name (self, name);
	vala_ccode_macro_replacement_set_replacement_expression (self, replacement_expression);
	return self;
}


ValaCCodeMacroReplacement* vala_ccode_macro_replacement_new_with_expression (const char* name, ValaCCodeExpression* replacement_expression) {
	return vala_ccode_macro_replacement_construct_with_expression (VALA_TYPE_CCODE_MACRO_REPLACEMENT, name, replacement_expression);
}


static void vala_ccode_macro_replacement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeMacroReplacement * self;
	self = VALA_CCODE_MACRO_REPLACEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, NULL);
	vala_ccode_writer_write_string (writer, "#define ");
	vala_ccode_writer_write_string (writer, self->priv->_name);
	vala_ccode_writer_write_string (writer, " ");
	if (self->priv->_replacement != NULL) {
		vala_ccode_writer_write_string (writer, self->priv->_replacement);
	} else {
		vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_replacement_expression), writer);
	}
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_macro_replacement_get_name (ValaCCodeMacroReplacement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self), NULL);
	return self->priv->_name;
}


void vala_ccode_macro_replacement_set_name (ValaCCodeMacroReplacement* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


const char* vala_ccode_macro_replacement_get_replacement (ValaCCodeMacroReplacement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self), NULL);
	return self->priv->_replacement;
}


void vala_ccode_macro_replacement_set_replacement (ValaCCodeMacroReplacement* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_replacement = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_replacement = (g_free (self->priv->_replacement), NULL)), _tmp2);
}


ValaCCodeExpression* vala_ccode_macro_replacement_get_replacement_expression (ValaCCodeMacroReplacement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self), NULL);
	return self->priv->_replacement_expression;
}


void vala_ccode_macro_replacement_set_replacement_expression (ValaCCodeMacroReplacement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_replacement_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_replacement_expression == NULL ? NULL : (self->priv->_replacement_expression = (vala_ccode_node_unref (self->priv->_replacement_expression), NULL))), _tmp2);
}


static void vala_ccode_macro_replacement_class_init (ValaCCodeMacroReplacementClass * klass) {
	vala_ccode_macro_replacement_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_macro_replacement_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeMacroReplacementPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_macro_replacement_real_write;
}


static void vala_ccode_macro_replacement_instance_init (ValaCCodeMacroReplacement * self) {
	self->priv = VALA_CCODE_MACRO_REPLACEMENT_GET_PRIVATE (self);
}


static void vala_ccode_macro_replacement_finalize (ValaCCodeNode* obj) {
	ValaCCodeMacroReplacement * self;
	self = VALA_CCODE_MACRO_REPLACEMENT (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	self->priv->_replacement = (g_free (self->priv->_replacement), NULL);
	(self->priv->_replacement_expression == NULL ? NULL : (self->priv->_replacement_expression = (vala_ccode_node_unref (self->priv->_replacement_expression), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_macro_replacement_parent_class)->finalize (obj);
}


GType vala_ccode_macro_replacement_get_type (void) {
	static GType vala_ccode_macro_replacement_type_id = 0;
	if (vala_ccode_macro_replacement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMacroReplacementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_macro_replacement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMacroReplacement), 0, (GInstanceInitFunc) vala_ccode_macro_replacement_instance_init, NULL };
		vala_ccode_macro_replacement_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeMacroReplacement", &g_define_type_info, 0);
	}
	return vala_ccode_macro_replacement_type_id;
}




