/* valaccodedynamicmethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodedynamicmethodbinding.h>
#include <ccode/valaccodefunction.h>
#include <vala/valamethod.h>
#include <vala/valadatatype.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeblock.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <vala/valainvocationexpression.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <vala/valaunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodeunaryexpression.h>
#include <gee/collection.h>
#include <vala/valaformalparameter.h>
#include <vala/valaarraytype.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valavoidtype.h>
#include <vala/valamethodtype.h>
#include <vala/valadelegatetype.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valastruct.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodecastexpression.h>
#include <gobject/valaccodegenerator.h>




enum  {
	VALA_CCODE_DYNAMIC_METHOD_BINDING_DUMMY_PROPERTY
};
static void vala_ccode_dynamic_method_binding_generate_dbus_method_wrapper (ValaCCodeDynamicMethodBinding* self, ValaCCodeBlock* block);
static ValaCCodeExpression* vala_ccode_dynamic_method_binding_get_dbus_g_type (ValaCCodeDynamicMethodBinding* self, ValaDataType* data_type);
static gpointer vala_ccode_dynamic_method_binding_parent_class = NULL;



ValaCCodeDynamicMethodBinding* vala_ccode_dynamic_method_binding_construct (GType object_type, ValaCCodeGenerator* codegen, ValaDynamicMethod* method) {
	ValaCCodeDynamicMethodBinding* self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_DYNAMIC_METHOD (method), NULL);
	self = ((ValaCCodeDynamicMethodBinding*) (g_type_create_instance (object_type)));
	vala_ccode_method_binding_set_method (VALA_CCODE_METHOD_BINDING (self), VALA_METHOD (method));
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


ValaCCodeDynamicMethodBinding* vala_ccode_dynamic_method_binding_new (ValaCCodeGenerator* codegen, ValaDynamicMethod* method) {
	return vala_ccode_dynamic_method_binding_construct (VALA_TYPE_CCODE_DYNAMIC_METHOD_BINDING, codegen, method);
}


void vala_ccode_dynamic_method_binding_generate_wrapper (ValaCCodeDynamicMethodBinding* self) {
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* func;
	GeeHashMap* cparam_map;
	char* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* instance_param;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp8;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_METHOD_BINDING (self));
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	func = (_tmp3 = vala_ccode_function_new ((_tmp1 = vala_method_get_cname (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))), (_tmp2 = vala_data_type_get_cname (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), _tmp3);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp4 = NULL;
	_tmp5 = NULL;
	instance_param = (_tmp5 = vala_ccode_formal_parameter_new ("obj", (_tmp4 = vala_data_type_get_cname (vala_dynamic_method_get_dynamic_type (dynamic_method)))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
	gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), FALSE)), instance_param);
	vala_ccode_method_binding_generate_cparameters (VALA_CCODE_METHOD_BINDING (self), vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)), vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), FALSE, GEE_MAP (cparam_map), func, NULL, NULL, NULL);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_method_get_dynamic_type (dynamic_method)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_object_type) {
		vala_ccode_dynamic_method_binding_generate_dbus_method_wrapper (self, block);
	} else {
		char* _tmp7;
		char* _tmp6;
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))), (_tmp7 = g_strdup_printf ("dynamic methods are not supported for `%s'", (_tmp6 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_method_get_dynamic_type (dynamic_method)))))));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp6 = (g_free (_tmp6), NULL);
	}
	/* append to C source file*/
	_tmp8 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp8 = vala_ccode_function_copy (func))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
	(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
	(func == NULL ? NULL : (func = (vala_ccode_node_unref (func), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)));
	(block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL)));
}


static void vala_ccode_dynamic_method_binding_generate_dbus_method_wrapper (ValaCCodeDynamicMethodBinding* self, ValaCCodeBlock* block) {
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	ValaInvocationExpression* _tmp1;
	ValaInvocationExpression* expr;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp4;
	gboolean found_out;
	ValaExpression* callback;
	gint callback_index;
	gint arg_index;
	ValaCCodeConstant* _tmp9;
	char* _tmp8;
	char* _tmp7;
	ValaCCodeIdentifier* _tmp150;
	ValaCCodeFragment* out_marshalling_fragment;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	expr = (_tmp1 = vala_dynamic_method_get_invocation (dynamic_method), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp2 = NULL;
	_tmp3 = NULL;
	ccall = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("dbus_g_proxy_begin_call")))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("obj"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	found_out = FALSE;
	callback = NULL;
	callback_index = -1;
	arg_index = 1;
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
					ValaExpression* _tmp6;
					ValaExpression* _tmp5;
					/* callback*/
					if (callback != NULL) {
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "only one reply callback may be specified in invocation of DBus method");
						vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
						(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
						(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
						(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
						(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
						(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
						(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
						return;
					} else {
						if (found_out) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "out argument and reply callback conflict in invocation of DBus method");
							vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
							(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
							return;
						}
					}
					_tmp6 = NULL;
					_tmp5 = NULL;
					callback = (_tmp6 = (_tmp5 = arg, (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5))), (callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL))), _tmp6);
					callback_index = arg_index;
				} else {
					if (VALA_IS_UNARY_EXPRESSION (arg) && vala_unary_expression_get_operator ((VALA_UNARY_EXPRESSION (arg))) == VALA_UNARY_OPERATOR_OUT) {
						/* out arg*/
						if (callback != NULL) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "out argument and reply callback conflict in invocation of DBus method");
							vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
							(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
							return;
						}
						found_out = TRUE;
					} else {
						/* in arg*/
						if (callback != NULL || found_out) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "in argument must not follow out argument or reply callback in invocation of DBus method");
							vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
							(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
							(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
							(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
							(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
							(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
							return;
						}
					}
				}
				arg_index++;
				(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
	}
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ((_tmp8 = g_strdup_printf ("\"%s\"", (_tmp7 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (VALA_SYMBOL (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))))))))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	_tmp8 = (g_free (_tmp8), NULL);
	_tmp7 = (g_free (_tmp7), NULL);
	if (callback != NULL) {
		ValaMethod* _tmp10;
		ValaMethod* reply_method;
		char* _tmp12;
		char* _tmp11;
		ValaCCodeFunction* _tmp13;
		ValaCCodeFunction* cb_fun;
		ValaCCodeFormalParameter* _tmp14;
		ValaCCodeFormalParameter* _tmp15;
		ValaCCodeFormalParameter* _tmp16;
		ValaCCodeBlock* _tmp17;
		ValaCCodeDeclaration* cerrdecl;
		ValaCCodeVariableDeclarator* _tmp19;
		ValaCCodeConstant* _tmp18;
		ValaCCodeIdentifier* _tmp20;
		ValaCCodeFunctionCall* _tmp21;
		ValaCCodeFunctionCall* cend_call;
		ValaCCodeIdentifier* _tmp22;
		ValaCCodeIdentifier* _tmp23;
		ValaCCodeUnaryExpression* _tmp25;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeFunctionCall* creply_call;
		ValaCCodeIdentifier* _tmp26;
		GeeList* _tmp27;
		gint _tmp28;
		gint param_count;
		gint i;
		ValaCCodeIdentifier* _tmp52;
		ValaCCodeExpressionStatement* _tmp53;
		ValaCCodeIdentifier* _tmp54;
		ValaCCodeExpressionStatement* _tmp55;
		ValaCCodeIdentifier* _tmp56;
		ValaCCodeConstant* _tmp58;
		char* _tmp57;
		ValaCCodeConstant* _tmp59;
		_tmp10 = NULL;
		reply_method = (_tmp10 = VALA_METHOD (vala_expression_get_symbol_reference (callback)), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp13 = NULL;
		cb_fun = (_tmp13 = vala_ccode_function_new ((_tmp12 = g_strdup_printf ("_%s_cb", (_tmp11 = vala_method_get_cname (reply_method)))), "void"), (_tmp12 = (g_free (_tmp12), NULL)), (_tmp11 = (g_free (_tmp11), NULL)), _tmp13);
		vala_ccode_function_set_modifiers (cb_fun, VALA_CCODE_MODIFIERS_STATIC);
		_tmp14 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp14 = vala_ccode_formal_parameter_new ("proxy", "DBusGProxy*")));
		(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
		_tmp15 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp15 = vala_ccode_formal_parameter_new ("call", "DBusGProxyCall*")));
		(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
		_tmp16 = NULL;
		vala_ccode_function_add_parameter (cb_fun, (_tmp16 = vala_ccode_formal_parameter_new ("user_data", "void*")));
		(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
		_tmp17 = NULL;
		vala_ccode_function_set_block (cb_fun, (_tmp17 = vala_ccode_block_new ()));
		(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
		cerrdecl = vala_ccode_declaration_new ("GError*");
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_ccode_declaration_add_declarator (cerrdecl, VALA_CCODE_DECLARATOR ((_tmp19 = vala_ccode_variable_declarator_new_with_initializer ("error", VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("NULL")))))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
		(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cerrdecl));
		_tmp20 = NULL;
		_tmp21 = NULL;
		cend_call = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("dbus_g_proxy_end_call")))), (_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL))), _tmp21);
		_tmp22 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("proxy"))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
		_tmp23 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("call"))));
		(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
		_tmp25 = NULL;
		_tmp24 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("error")))))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
		(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
		creply_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (callback))));
		_tmp26 = NULL;
		vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("user_data"))));
		(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
		_tmp27 = NULL;
		param_count = (_tmp28 = gee_collection_get_size (GEE_COLLECTION ((_tmp27 = vala_method_get_parameters (reply_method)))), (_tmp27 == NULL ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL))), _tmp28);
		i = 0;
		{
			GeeList* param_collection;
			int param_it;
			param_collection = vala_method_get_parameters (reply_method);
			for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
				{
					if (((i = i + 1)) == param_count) {
						/* error parameter*/
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						break;
					}
					if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
						ValaArrayType* _tmp29;
						ValaArrayType* array_type;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp32;
						ValaCCodeExpression* _tmp33;
						ValaCCodeUnaryExpression* _tmp35;
						ValaCCodeIdentifier* _tmp34;
						ValaCCodeMemberAccess* _tmp37;
						ValaCCodeIdentifier* _tmp36;
						ValaCCodeMemberAccess* _tmp39;
						ValaCCodeIdentifier* _tmp38;
						_tmp29 = NULL;
						array_type = (_tmp29 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp29 == NULL ? NULL : vala_code_node_ref (_tmp29)));
						cdecl_ = NULL;
						if (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type)) {
							ValaCCodeDeclaration* _tmp30;
							_tmp30 = NULL;
							cdecl_ = (_tmp30 = vala_ccode_declaration_new ("GPtrArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp30);
						} else {
							ValaCCodeDeclaration* _tmp31;
							_tmp31 = NULL;
							cdecl_ = (_tmp31 = vala_ccode_declaration_new ("GArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp31);
						}
						_tmp32 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp32 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
						vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
						_tmp33 = NULL;
						vala_ccode_function_call_add_argument (cend_call, (_tmp33 = vala_ccode_dynamic_method_binding_get_dbus_g_type (self, VALA_DATA_TYPE (array_type))));
						(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
						_tmp35 = NULL;
						_tmp34 = NULL;
						vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
						(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
						(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
						_tmp37 = NULL;
						_tmp36 = NULL;
						vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type) ? "pdata" : "data")))));
						(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
						(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
						_tmp39 = NULL;
						_tmp38 = NULL;
						vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), "len"))));
						(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
						(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
						(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					} else {
						char* _tmp40;
						ValaCCodeDeclaration* _tmp41;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp42;
						ValaCCodeUnaryExpression* _tmp47;
						ValaCCodeIdentifier* _tmp46;
						ValaCCodeIdentifier* _tmp48;
						_tmp40 = NULL;
						_tmp41 = NULL;
						cdecl_ = (_tmp41 = vala_ccode_declaration_new ((_tmp40 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)))), (_tmp40 = (g_free (_tmp40), NULL)), _tmp41);
						_tmp42 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp42 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
						vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
						if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
							ValaCCodeIdentifier* _tmp43;
							/* special case string array*/
							_tmp43 = NULL;
							vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("G_TYPE_STRV"))));
							(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
						} else {
							ValaCCodeIdentifier* _tmp45;
							char* _tmp44;
							_tmp45 = NULL;
							_tmp44 = NULL;
							vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ((_tmp44 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))))));
							(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
							_tmp44 = (g_free (_tmp44), NULL);
						}
						_tmp47 = NULL;
						_tmp46 = NULL;
						vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
						(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
						(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
						_tmp48 = NULL;
						vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
						if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
							ValaCCodeIdentifier* _tmp49;
							ValaCCodeFunctionCall* _tmp50;
							ValaCCodeFunctionCall* cstrvlen;
							ValaCCodeIdentifier* _tmp51;
							_tmp49 = NULL;
							_tmp50 = NULL;
							cstrvlen = (_tmp50 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL))), _tmp50);
							_tmp51 = NULL;
							vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
							(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
							vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION (cstrvlen));
							(cstrvlen == NULL ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL)));
						}
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					}
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
		}
		_tmp52 = NULL;
		vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
		_tmp53 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp53 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cend_call)))));
		(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
		_tmp54 = NULL;
		vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_identifier_new ("error"))));
		(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
		_tmp55 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp55 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (creply_call)))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)));
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (cb_fun));
		_tmp56 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new (vala_ccode_function_get_name (cb_fun)))));
		(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
		_tmp58 = NULL;
		_tmp57 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_constant_new ((_tmp57 = g_strdup_printf ("param%d_target", callback_index))))));
		(_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)));
		_tmp57 = (g_free (_tmp57), NULL);
		_tmp59 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_constant_new ("NULL"))));
		(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
		(reply_method == NULL ? NULL : (reply_method = (vala_code_node_unref (reply_method), NULL)));
		(cb_fun == NULL ? NULL : (cb_fun = (vala_ccode_node_unref (cb_fun), NULL)));
		(cerrdecl == NULL ? NULL : (cerrdecl = (vala_ccode_node_unref (cerrdecl), NULL)));
		(cend_call == NULL ? NULL : (cend_call = (vala_ccode_node_unref (cend_call), NULL)));
		(creply_call == NULL ? NULL : (creply_call = (vala_ccode_node_unref (creply_call), NULL)));
	} else {
		if (found_out || !(VALA_IS_VOID_TYPE (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))) {
			ValaCCodeIdentifier* _tmp60;
			ValaCCodeIdentifier* _tmp61;
			_tmp60 = NULL;
			vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_identifier_new ("dbus_g_proxy_call"))));
			(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
			_tmp61 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_identifier_new ("error"))));
			(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
		} else {
			ValaCCodeIdentifier* _tmp62;
			_tmp62 = NULL;
			vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ("dbus_g_proxy_call_no_reply"))));
			(_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)));
		}
	}
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)));
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				ValaArrayType* _tmp64;
				ValaDataType* _tmp63;
				ValaArrayType* array_type;
				if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param)) || VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					/* callback parameter*/
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					continue;
				}
				_tmp64 = NULL;
				_tmp63 = NULL;
				array_type = (_tmp64 = (_tmp63 = vala_formal_parameter_get_parameter_type (param), (VALA_IS_ARRAY_TYPE (_tmp63) ? ((ValaArrayType*) (_tmp63)) : NULL)), (_tmp64 == NULL ? NULL : vala_code_node_ref (_tmp64)));
				if (array_type != NULL) {
					/* array parameter*/
					if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
						ValaCCodeExpression* _tmp65;
						ValaCCodeIdentifier* _tmp66;
						ValaCCodeFunctionCall* _tmp67;
						ValaCCodeFunctionCall* sizeof_call;
						ValaCCodeIdentifier* _tmp69;
						char* _tmp68;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeFunctionCall* array_construct;
						ValaCCodeVariableDeclarator* _tmp81;
						char* _tmp80;
						ValaCCodeIdentifier* _tmp108;
						char* _tmp107;
						/* non-string arrays (use GArray)*/
						_tmp65 = NULL;
						vala_ccode_function_call_add_argument (ccall, (_tmp65 = vala_ccode_dynamic_method_binding_get_dbus_g_type (self, VALA_DATA_TYPE (array_type))));
						(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
						_tmp66 = NULL;
						_tmp67 = NULL;
						sizeof_call = (_tmp67 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ("sizeof")))), (_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL))), _tmp67);
						_tmp69 = NULL;
						_tmp68 = NULL;
						vala_ccode_function_call_add_argument (sizeof_call, VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new ((_tmp68 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
						(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
						_tmp68 = (g_free (_tmp68), NULL);
						cdecl_ = NULL;
						array_construct = NULL;
						if (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type)) {
							ValaCCodeDeclaration* _tmp70;
							ValaCCodeFunctionCall* _tmp72;
							ValaCCodeIdentifier* _tmp71;
							ValaCCodeIdentifier* _tmp74;
							char* _tmp73;
							_tmp70 = NULL;
							cdecl_ = (_tmp70 = vala_ccode_declaration_new ("GPtrArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp70);
							_tmp72 = NULL;
							_tmp71 = NULL;
							array_construct = (_tmp72 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new ("g_ptr_array_sized_new")))), (array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL))), _tmp72);
							(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
							_tmp74 = NULL;
							_tmp73 = NULL;
							vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new ((_tmp73 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), 1))))));
							(_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)));
							_tmp73 = (g_free (_tmp73), NULL);
						} else {
							ValaCCodeDeclaration* _tmp75;
							ValaCCodeFunctionCall* _tmp77;
							ValaCCodeIdentifier* _tmp76;
							ValaCCodeConstant* _tmp78;
							ValaCCodeConstant* _tmp79;
							_tmp75 = NULL;
							cdecl_ = (_tmp75 = vala_ccode_declaration_new ("GArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp75);
							_tmp77 = NULL;
							_tmp76 = NULL;
							array_construct = (_tmp77 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new ("g_array_new")))), (array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL))), _tmp77);
							(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
							_tmp78 = NULL;
							vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_constant_new ("TRUE"))));
							(_tmp78 == NULL ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)));
							_tmp79 = NULL;
							vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_constant_new ("TRUE"))));
							(_tmp79 == NULL ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL)));
							vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION (sizeof_call));
						}
						_tmp81 = NULL;
						_tmp80 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp81 = vala_ccode_variable_declarator_new_with_initializer ((_tmp80 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))), VALA_CCODE_EXPRESSION (array_construct)))));
						(_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)));
						_tmp80 = (g_free (_tmp80), NULL);
						vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
						if (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type)) {
							ValaCCodeIdentifier* _tmp82;
							ValaCCodeFunctionCall* _tmp83;
							ValaCCodeFunctionCall* memcpy_call;
							ValaCCodeMemberAccess* _tmp86;
							ValaCCodeIdentifier* _tmp85;
							char* _tmp84;
							ValaCCodeIdentifier* _tmp87;
							ValaCCodeBinaryExpression* _tmp90;
							ValaCCodeIdentifier* _tmp89;
							char* _tmp88;
							ValaCCodeExpressionStatement* _tmp91;
							ValaCCodeIdentifier* _tmp96;
							char* _tmp95;
							ValaCCodeMemberAccess* _tmp94;
							ValaCCodeIdentifier* _tmp93;
							char* _tmp92;
							ValaCCodeAssignment* _tmp97;
							ValaCCodeAssignment* len_assignment;
							ValaCCodeExpressionStatement* _tmp98;
							_tmp82 = NULL;
							_tmp83 = NULL;
							memcpy_call = (_tmp83 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_identifier_new ("memcpy")))), (_tmp82 == NULL ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL))), _tmp83);
							_tmp86 = NULL;
							_tmp85 = NULL;
							_tmp84 = NULL;
							vala_ccode_function_call_add_argument (memcpy_call, VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_identifier_new ((_tmp84 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "pdata"))));
							(_tmp86 == NULL ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL)));
							(_tmp85 == NULL ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL)));
							_tmp84 = (g_free (_tmp84), NULL);
							_tmp87 = NULL;
							vala_ccode_function_call_add_argument (memcpy_call, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
							(_tmp87 == NULL ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL)));
							_tmp90 = NULL;
							_tmp89 = NULL;
							_tmp88 = NULL;
							vala_ccode_function_call_add_argument (memcpy_call, VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ((_tmp88 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), 1))))), VALA_CCODE_EXPRESSION (sizeof_call)))));
							(_tmp90 == NULL ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL)));
							(_tmp89 == NULL ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL)));
							_tmp88 = (g_free (_tmp88), NULL);
							_tmp91 = NULL;
							vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp91 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (memcpy_call)))));
							(_tmp91 == NULL ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL)));
							_tmp96 = NULL;
							_tmp95 = NULL;
							_tmp94 = NULL;
							_tmp93 = NULL;
							_tmp92 = NULL;
							_tmp97 = NULL;
							len_assignment = (_tmp97 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp94 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_identifier_new ((_tmp92 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "len"))), VALA_CCODE_EXPRESSION ((_tmp96 = vala_ccode_identifier_new ((_tmp95 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), 1))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL))), (_tmp95 = (g_free (_tmp95), NULL)), (_tmp94 == NULL ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL))), (_tmp93 == NULL ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL))), (_tmp92 = (g_free (_tmp92), NULL)), _tmp97);
							_tmp98 = NULL;
							vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp98 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (len_assignment)))));
							(_tmp98 == NULL ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL)));
							(memcpy_call == NULL ? NULL : (memcpy_call = (vala_ccode_node_unref (memcpy_call), NULL)));
							(len_assignment == NULL ? NULL : (len_assignment = (vala_ccode_node_unref (len_assignment), NULL)));
						} else {
							ValaCCodeIdentifier* _tmp99;
							ValaCCodeFunctionCall* _tmp100;
							ValaCCodeFunctionCall* cappend_call;
							ValaCCodeIdentifier* _tmp102;
							char* _tmp101;
							ValaCCodeIdentifier* _tmp103;
							ValaCCodeIdentifier* _tmp105;
							char* _tmp104;
							ValaCCodeExpressionStatement* _tmp106;
							_tmp99 = NULL;
							_tmp100 = NULL;
							cappend_call = (_tmp100 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp99 = vala_ccode_identifier_new ("g_array_append_vals")))), (_tmp99 == NULL ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL))), _tmp100);
							_tmp102 = NULL;
							_tmp101 = NULL;
							vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_identifier_new ((_tmp101 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))));
							(_tmp102 == NULL ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)));
							_tmp101 = (g_free (_tmp101), NULL);
							_tmp103 = NULL;
							vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION ((_tmp103 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
							(_tmp103 == NULL ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)));
							_tmp105 = NULL;
							_tmp104 = NULL;
							vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_identifier_new ((_tmp104 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), 1))))));
							(_tmp105 == NULL ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)));
							_tmp104 = (g_free (_tmp104), NULL);
							_tmp106 = NULL;
							vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp106 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cappend_call)))));
							(_tmp106 == NULL ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL)));
							(cappend_call == NULL ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL)));
						}
						_tmp108 = NULL;
						_tmp107 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp108 = vala_ccode_identifier_new ((_tmp107 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))));
						(_tmp108 == NULL ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL)));
						_tmp107 = (g_free (_tmp107), NULL);
						(sizeof_call == NULL ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
						(array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp109;
						ValaCCodeIdentifier* _tmp110;
						/* string arrays*/
						_tmp109 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_identifier_new ("G_TYPE_STRV"))));
						(_tmp109 == NULL ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL)));
						_tmp110 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp110 == NULL ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)));
					}
				} else {
					char* _tmp111;
					gboolean _tmp112;
					_tmp111 = NULL;
					if ((_tmp112 = g_str_has_prefix ((_tmp111 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp111 = (g_free (_tmp111), NULL)), _tmp112)) {
						ValaStruct* _tmp113;
						ValaStruct* st;
						ValaCCodeIdentifier* _tmp114;
						ValaCCodeFunctionCall* _tmp115;
						ValaCCodeFunctionCall* array_construct;
						ValaCCodeConstant* _tmp116;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp118;
						char* _tmp117;
						ValaCCodeIdentifier* _tmp119;
						ValaCCodeFunctionCall* _tmp120;
						ValaCCodeFunctionCall* type_call;
						ValaCCodeConstant* _tmp121;
						ValaCCodeConstant* _tmp144;
						ValaCCodeIdentifier* _tmp146;
						char* _tmp145;
						/* struct parameter*/
						_tmp113 = NULL;
						st = (_tmp113 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp113 == NULL ? NULL : vala_code_node_ref (_tmp113)));
						_tmp114 = NULL;
						_tmp115 = NULL;
						array_construct = (_tmp115 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp114 = vala_ccode_identifier_new ("g_value_array_new")))), (_tmp114 == NULL ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL))), _tmp115);
						_tmp116 = NULL;
						vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp116 = vala_ccode_constant_new ("0"))));
						(_tmp116 == NULL ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL)));
						cdecl_ = vala_ccode_declaration_new ("GValueArray*");
						_tmp118 = NULL;
						_tmp117 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp118 = vala_ccode_variable_declarator_new_with_initializer ((_tmp117 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))), VALA_CCODE_EXPRESSION (array_construct)))));
						(_tmp118 == NULL ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL)));
						_tmp117 = (g_free (_tmp117), NULL);
						vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
						_tmp119 = NULL;
						_tmp120 = NULL;
						type_call = (_tmp120 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp119 = vala_ccode_identifier_new ("dbus_g_type_get_struct")))), (_tmp119 == NULL ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL))), _tmp120);
						_tmp121 = NULL;
						vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp121 = vala_ccode_constant_new ("\"GValueArray\""))));
						(_tmp121 == NULL ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL)));
						{
							GeeList* f_collection;
							int f_it;
							f_collection = vala_struct_get_fields (st);
							for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
								ValaField* f;
								f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
								{
									char* val_name;
									ValaCCodeInitializerList* cvalinit;
									ValaCCodeConstant* _tmp122;
									ValaCCodeDeclaration* cval_decl;
									ValaCCodeVariableDeclarator* _tmp123;
									ValaCCodeIdentifier* _tmp124;
									ValaCCodeUnaryExpression* _tmp125;
									ValaCCodeUnaryExpression* val_ptr;
									ValaCCodeIdentifier* _tmp126;
									ValaCCodeFunctionCall* _tmp127;
									ValaCCodeFunctionCall* cinit_call;
									ValaCCodeIdentifier* _tmp129;
									char* _tmp128;
									ValaCCodeExpressionStatement* _tmp130;
									ValaCCodeIdentifier* _tmp132;
									char* _tmp131;
									ValaCCodeFunctionCall* _tmp133;
									ValaCCodeFunctionCall* cset_call;
									ValaCCodeMemberAccess* _tmp135;
									ValaCCodeIdentifier* _tmp134;
									ValaCCodeExpressionStatement* _tmp136;
									ValaCCodeIdentifier* _tmp137;
									ValaCCodeFunctionCall* _tmp138;
									ValaCCodeFunctionCall* cappend_call;
									ValaCCodeIdentifier* _tmp140;
									char* _tmp139;
									ValaCCodeExpressionStatement* _tmp141;
									ValaCCodeIdentifier* _tmp143;
									char* _tmp142;
									if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
										(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
										continue;
									}
									val_name = g_strdup_printf ("val_%s_%s", vala_symbol_get_name (VALA_SYMBOL (param)), vala_symbol_get_name (VALA_SYMBOL (f)));
									/* 0-initialize struct with struct initializer { 0 }*/
									cvalinit = vala_ccode_initializer_list_new ();
									_tmp122 = NULL;
									vala_ccode_initializer_list_append (cvalinit, VALA_CCODE_EXPRESSION ((_tmp122 = vala_ccode_constant_new ("0"))));
									(_tmp122 == NULL ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL)));
									cval_decl = vala_ccode_declaration_new ("GValue");
									_tmp123 = NULL;
									vala_ccode_declaration_add_declarator (cval_decl, VALA_CCODE_DECLARATOR ((_tmp123 = vala_ccode_variable_declarator_new_with_initializer (val_name, VALA_CCODE_EXPRESSION (cvalinit)))));
									(_tmp123 == NULL ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)));
									vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cval_decl));
									_tmp124 = NULL;
									_tmp125 = NULL;
									val_ptr = (_tmp125 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_identifier_new (val_name)))), (_tmp124 == NULL ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL))), _tmp125);
									_tmp126 = NULL;
									_tmp127 = NULL;
									cinit_call = (_tmp127 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_identifier_new ("g_value_init")))), (_tmp126 == NULL ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL))), _tmp127);
									vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION (val_ptr));
									_tmp129 = NULL;
									_tmp128 = NULL;
									vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_identifier_new ((_tmp128 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
									(_tmp129 == NULL ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL)));
									_tmp128 = (g_free (_tmp128), NULL);
									_tmp130 = NULL;
									vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp130 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit_call)))));
									(_tmp130 == NULL ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL)));
									_tmp132 = NULL;
									_tmp131 = NULL;
									_tmp133 = NULL;
									cset_call = (_tmp133 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp132 = vala_ccode_identifier_new ((_tmp131 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))), (_tmp132 == NULL ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL))), (_tmp131 = (g_free (_tmp131), NULL)), _tmp133);
									vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION (val_ptr));
									_tmp135 = NULL;
									_tmp134 = NULL;
									vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION ((_tmp135 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp134 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), vala_symbol_get_name (VALA_SYMBOL (f))))));
									(_tmp135 == NULL ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL)));
									(_tmp134 == NULL ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL)));
									_tmp136 = NULL;
									vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp136 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cset_call)))));
									(_tmp136 == NULL ? NULL : (_tmp136 = (vala_ccode_node_unref (_tmp136), NULL)));
									_tmp137 = NULL;
									_tmp138 = NULL;
									cappend_call = (_tmp138 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp137 = vala_ccode_identifier_new ("g_value_array_append")))), (_tmp137 == NULL ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL))), _tmp138);
									_tmp140 = NULL;
									_tmp139 = NULL;
									vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION ((_tmp140 = vala_ccode_identifier_new ((_tmp139 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))));
									(_tmp140 == NULL ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL)));
									_tmp139 = (g_free (_tmp139), NULL);
									vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION (val_ptr));
									_tmp141 = NULL;
									vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp141 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cappend_call)))));
									(_tmp141 == NULL ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL)));
									_tmp143 = NULL;
									_tmp142 = NULL;
									vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp143 = vala_ccode_identifier_new ((_tmp142 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
									(_tmp143 == NULL ? NULL : (_tmp143 = (vala_ccode_node_unref (_tmp143), NULL)));
									_tmp142 = (g_free (_tmp142), NULL);
									(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
									val_name = (g_free (val_name), NULL);
									(cvalinit == NULL ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL)));
									(cval_decl == NULL ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL)));
									(val_ptr == NULL ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL)));
									(cinit_call == NULL ? NULL : (cinit_call = (vala_ccode_node_unref (cinit_call), NULL)));
									(cset_call == NULL ? NULL : (cset_call = (vala_ccode_node_unref (cset_call), NULL)));
									(cappend_call == NULL ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL)));
								}
							}
							(f_collection == NULL ? NULL : (f_collection = (gee_collection_object_unref (f_collection), NULL)));
						}
						_tmp144 = NULL;
						vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp144 = vala_ccode_constant_new ("G_TYPE_INVALID"))));
						(_tmp144 == NULL ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL)));
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (type_call));
						_tmp146 = NULL;
						_tmp145 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp146 = vala_ccode_identifier_new ((_tmp145 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))));
						(_tmp146 == NULL ? NULL : (_tmp146 = (vala_ccode_node_unref (_tmp146), NULL)));
						_tmp145 = (g_free (_tmp145), NULL);
						(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
						(array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
						(type_call == NULL ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp148;
						char* _tmp147;
						ValaCCodeIdentifier* _tmp149;
						_tmp148 = NULL;
						_tmp147 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp148 = vala_ccode_identifier_new ((_tmp147 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))))));
						(_tmp148 == NULL ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL)));
						_tmp147 = (g_free (_tmp147), NULL);
						_tmp149 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp149 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp149 == NULL ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL)));
					}
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	_tmp150 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp150 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp150 == NULL ? NULL : (_tmp150 = (vala_ccode_node_unref (_tmp150), NULL)));
	out_marshalling_fragment = vala_ccode_fragment_new ();
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)));
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp151;
				gboolean _tmp152;
				if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					/* callback parameter*/
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					continue;
				}
				_tmp151 = NULL;
				if ((_tmp152 = g_str_has_prefix ((_tmp151 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp151 = (g_free (_tmp151), NULL)), _tmp152)) {
					ValaStruct* _tmp153;
					ValaStruct* st;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp155;
					char* _tmp154;
					ValaCCodeIdentifier* _tmp156;
					ValaCCodeFunctionCall* _tmp157;
					ValaCCodeFunctionCall* type_call;
					ValaCCodeConstant* _tmp158;
					gint i;
					ValaCCodeConstant* _tmp175;
					ValaCCodeUnaryExpression* _tmp178;
					ValaCCodeIdentifier* _tmp177;
					char* _tmp176;
					/* struct output parameter*/
					_tmp153 = NULL;
					st = (_tmp153 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp153 == NULL ? NULL : vala_code_node_ref (_tmp153)));
					cdecl_ = vala_ccode_declaration_new ("GValueArray*");
					_tmp155 = NULL;
					_tmp154 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp155 = vala_ccode_variable_declarator_new ((_tmp154 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))));
					(_tmp155 == NULL ? NULL : (_tmp155 = (vala_ccode_node_unref (_tmp155), NULL)));
					_tmp154 = (g_free (_tmp154), NULL);
					vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
					_tmp156 = NULL;
					_tmp157 = NULL;
					type_call = (_tmp157 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp156 = vala_ccode_identifier_new ("dbus_g_type_get_struct")))), (_tmp156 == NULL ? NULL : (_tmp156 = (vala_ccode_node_unref (_tmp156), NULL))), _tmp157);
					_tmp158 = NULL;
					vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_constant_new ("\"GValueArray\""))));
					(_tmp158 == NULL ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL)));
					i = 0;
					{
						GeeList* f_collection;
						int f_it;
						f_collection = vala_struct_get_fields (st);
						for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
							ValaField* f;
							f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
							{
								ValaCCodeIdentifier* _tmp160;
								char* _tmp159;
								ValaCCodeFunctionCall* _tmp161;
								ValaCCodeFunctionCall* cget_call;
								ValaCCodeUnaryExpression* _tmp168;
								ValaCCodeElementAccess* _tmp167;
								ValaCCodeConstant* _tmp166;
								char* _tmp165;
								ValaCCodeMemberAccess* _tmp164;
								ValaCCodeIdentifier* _tmp163;
								char* _tmp162;
								ValaCCodeMemberAccess* _tmp170;
								ValaCCodeIdentifier* _tmp169;
								ValaCCodeAssignment* _tmp171;
								ValaCCodeAssignment* assign;
								ValaCCodeExpressionStatement* _tmp172;
								ValaCCodeIdentifier* _tmp174;
								char* _tmp173;
								if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
									(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
									continue;
								}
								_tmp160 = NULL;
								_tmp159 = NULL;
								_tmp161 = NULL;
								cget_call = (_tmp161 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_identifier_new ((_tmp159 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))), (_tmp160 == NULL ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL))), (_tmp159 = (g_free (_tmp159), NULL)), _tmp161);
								_tmp168 = NULL;
								_tmp167 = NULL;
								_tmp166 = NULL;
								_tmp165 = NULL;
								_tmp164 = NULL;
								_tmp163 = NULL;
								_tmp162 = NULL;
								vala_ccode_function_call_add_argument (cget_call, VALA_CCODE_EXPRESSION ((_tmp168 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp167 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp164 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp163 = vala_ccode_identifier_new ((_tmp162 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "values"))), VALA_CCODE_EXPRESSION ((_tmp166 = vala_ccode_constant_new ((_tmp165 = g_strdup_printf ("%i", i))))))))))));
								(_tmp168 == NULL ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL)));
								(_tmp167 == NULL ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL)));
								(_tmp166 == NULL ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL)));
								_tmp165 = (g_free (_tmp165), NULL);
								(_tmp164 == NULL ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL)));
								(_tmp163 == NULL ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL)));
								_tmp162 = (g_free (_tmp162), NULL);
								_tmp170 = NULL;
								_tmp169 = NULL;
								_tmp171 = NULL;
								assign = (_tmp171 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp170 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp169 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), vala_symbol_get_name (VALA_SYMBOL (f))))), VALA_CCODE_EXPRESSION (cget_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp170 == NULL ? NULL : (_tmp170 = (vala_ccode_node_unref (_tmp170), NULL))), (_tmp169 == NULL ? NULL : (_tmp169 = (vala_ccode_node_unref (_tmp169), NULL))), _tmp171);
								_tmp172 = NULL;
								vala_ccode_fragment_append (out_marshalling_fragment, VALA_CCODE_NODE ((_tmp172 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
								(_tmp172 == NULL ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL)));
								_tmp174 = NULL;
								_tmp173 = NULL;
								vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp174 = vala_ccode_identifier_new ((_tmp173 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
								(_tmp174 == NULL ? NULL : (_tmp174 = (vala_ccode_node_unref (_tmp174), NULL)));
								_tmp173 = (g_free (_tmp173), NULL);
								i++;
								(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
								(cget_call == NULL ? NULL : (cget_call = (vala_ccode_node_unref (cget_call), NULL)));
								(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
							}
						}
						(f_collection == NULL ? NULL : (f_collection = (gee_collection_object_unref (f_collection), NULL)));
					}
					_tmp175 = NULL;
					vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp175 = vala_ccode_constant_new ("G_TYPE_INVALID"))));
					(_tmp175 == NULL ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL)));
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (type_call));
					_tmp178 = NULL;
					_tmp177 = NULL;
					_tmp176 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp178 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp177 = vala_ccode_identifier_new ((_tmp176 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))))))))));
					(_tmp178 == NULL ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL)));
					(_tmp177 == NULL ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL)));
					_tmp176 = (g_free (_tmp176), NULL);
					(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					(type_call == NULL ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp180;
					char* _tmp179;
					ValaCCodeUnaryExpression* _tmp182;
					ValaCCodeIdentifier* _tmp181;
					_tmp180 = NULL;
					_tmp179 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp180 = vala_ccode_identifier_new ((_tmp179 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))))));
					(_tmp180 == NULL ? NULL : (_tmp180 = (vala_ccode_node_unref (_tmp180), NULL)));
					_tmp179 = (g_free (_tmp179), NULL);
					_tmp182 = NULL;
					_tmp181 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp182 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp181 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
					(_tmp182 == NULL ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL)));
					(_tmp181 == NULL ? NULL : (_tmp181 = (vala_ccode_node_unref (_tmp181), NULL)));
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))) {
		ValaArrayType* _tmp184;
		ValaDataType* _tmp183;
		ValaArrayType* array_type;
		/* synchronous D-Bus method call with reply*/
		_tmp184 = NULL;
		_tmp183 = NULL;
		array_type = (_tmp184 = (_tmp183 = vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), (VALA_IS_ARRAY_TYPE (_tmp183) ? ((ValaArrayType*) (_tmp183)) : NULL)), (_tmp184 == NULL ? NULL : vala_code_node_ref (_tmp184)));
		if (array_type != NULL && vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
			ValaCCodeExpression* _tmp185;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp188;
			ValaCCodeUnaryExpression* _tmp190;
			ValaCCodeIdentifier* _tmp189;
			ValaCCodeIdentifier* _tmp191;
			ValaCCodeExpressionStatement* _tmp192;
			ValaCCodeBlock* creturnblock;
			ValaCCodeReturnStatement* _tmp194;
			ValaCCodeExpression* _tmp193;
			ValaCCodeUnaryExpression* _tmp196;
			ValaCCodeIdentifier* _tmp195;
			ValaCCodeIfStatement* _tmp197;
			ValaCCodeIfStatement* cerrorif;
			ValaCCodeIdentifier* _tmp198;
			ValaCCodeMemberAccess* _tmp199;
			ValaCCodeMemberAccess* garray_length;
			ValaCCodeIdentifier* _tmp200;
			ValaCCodeUnaryExpression* _tmp201;
			ValaCCodeUnaryExpression* result_length;
			ValaCCodeAssignment* assign;
			ValaCCodeExpressionStatement* _tmp202;
			ValaCCodeReturnStatement* _tmp207;
			ValaCCodeCastExpression* _tmp206;
			char* _tmp205;
			ValaCCodeMemberAccess* _tmp204;
			ValaCCodeIdentifier* _tmp203;
			/* non-string arrays (use GArray)*/
			_tmp185 = NULL;
			vala_ccode_function_call_add_argument (ccall, (_tmp185 = vala_ccode_dynamic_method_binding_get_dbus_g_type (self, VALA_DATA_TYPE (array_type))));
			(_tmp185 == NULL ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL)));
			cdecl_ = NULL;
			if (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type)) {
				ValaCCodeDeclaration* _tmp186;
				_tmp186 = NULL;
				cdecl_ = (_tmp186 = vala_ccode_declaration_new ("GPtrArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp186);
			} else {
				ValaCCodeDeclaration* _tmp187;
				_tmp187 = NULL;
				cdecl_ = (_tmp187 = vala_ccode_declaration_new ("GArray*"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp187);
			}
			_tmp188 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp188 = vala_ccode_variable_declarator_new ("result"))));
			(_tmp188 == NULL ? NULL : (_tmp188 = (vala_ccode_node_unref (_tmp188), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
			_tmp190 = NULL;
			_tmp189 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp190 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp189 = vala_ccode_identifier_new ("result")))))));
			(_tmp190 == NULL ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL)));
			(_tmp189 == NULL ? NULL : (_tmp189 = (vala_ccode_node_unref (_tmp189), NULL)));
			_tmp191 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp191 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
			(_tmp191 == NULL ? NULL : (_tmp191 = (vala_ccode_node_unref (_tmp191), NULL)));
			_tmp192 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp192 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp192 == NULL ? NULL : (_tmp192 = (vala_ccode_node_unref (_tmp192), NULL)));
			/* don't access result when error occured*/
			creturnblock = vala_ccode_block_new ();
			_tmp194 = NULL;
			_tmp193 = NULL;
			vala_ccode_block_add_statement (creturnblock, VALA_CCODE_NODE ((_tmp194 = vala_ccode_return_statement_new ((_tmp193 = vala_ccode_generator_default_value_for_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), FALSE))))));
			(_tmp194 == NULL ? NULL : (_tmp194 = (vala_ccode_node_unref (_tmp194), NULL)));
			(_tmp193 == NULL ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL)));
			_tmp196 = NULL;
			_tmp195 = NULL;
			_tmp197 = NULL;
			cerrorif = (_tmp197 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp196 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp195 = vala_ccode_identifier_new ("error")))))), VALA_CCODE_STATEMENT (creturnblock), NULL), (_tmp196 == NULL ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL))), (_tmp195 == NULL ? NULL : (_tmp195 = (vala_ccode_node_unref (_tmp195), NULL))), _tmp197);
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cerrorif));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (out_marshalling_fragment));
			/* *result_length1 = result->len;*/
			_tmp198 = NULL;
			_tmp199 = NULL;
			garray_length = (_tmp199 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp198 = vala_ccode_identifier_new ("result"))), "len"), (_tmp198 == NULL ? NULL : (_tmp198 = (vala_ccode_node_unref (_tmp198), NULL))), _tmp199);
			_tmp200 = NULL;
			_tmp201 = NULL;
			result_length = (_tmp201 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp200 = vala_ccode_identifier_new ("result_length1")))), (_tmp200 == NULL ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL))), _tmp201);
			assign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (result_length), VALA_CCODE_EXPRESSION (garray_length), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_tmp202 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp202 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
			(_tmp202 == NULL ? NULL : (_tmp202 = (vala_ccode_node_unref (_tmp202), NULL)));
			/* return result->data;*/
			_tmp207 = NULL;
			_tmp206 = NULL;
			_tmp205 = NULL;
			_tmp204 = NULL;
			_tmp203 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp207 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp206 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp204 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp203 = vala_ccode_identifier_new ("result"))), (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type) ? "pdata" : "data")))), (_tmp205 = vala_data_type_get_cname (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))))))))));
			(_tmp207 == NULL ? NULL : (_tmp207 = (vala_ccode_node_unref (_tmp207), NULL)));
			(_tmp206 == NULL ? NULL : (_tmp206 = (vala_ccode_node_unref (_tmp206), NULL)));
			_tmp205 = (g_free (_tmp205), NULL);
			(_tmp204 == NULL ? NULL : (_tmp204 = (vala_ccode_node_unref (_tmp204), NULL)));
			(_tmp203 == NULL ? NULL : (_tmp203 = (vala_ccode_node_unref (_tmp203), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			(creturnblock == NULL ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL)));
			(cerrorif == NULL ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL)));
			(garray_length == NULL ? NULL : (garray_length = (vala_ccode_node_unref (garray_length), NULL)));
			(result_length == NULL ? NULL : (result_length = (vala_ccode_node_unref (result_length), NULL)));
			(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
		} else {
			char* _tmp211;
			ValaCCodeDeclaration* _tmp212;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp213;
			ValaCCodeUnaryExpression* _tmp215;
			ValaCCodeIdentifier* _tmp214;
			ValaCCodeIdentifier* _tmp216;
			ValaCCodeExpressionStatement* _tmp217;
			ValaCCodeBlock* creturnblock;
			ValaCCodeReturnStatement* _tmp219;
			ValaCCodeExpression* _tmp218;
			ValaCCodeUnaryExpression* _tmp221;
			ValaCCodeIdentifier* _tmp220;
			ValaCCodeIfStatement* _tmp222;
			ValaCCodeIfStatement* cerrorif;
			ValaCCodeReturnStatement* _tmp230;
			ValaCCodeIdentifier* _tmp229;
			/* string arrays or other datatypes*/
			if (VALA_IS_ARRAY_TYPE (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))) {
				ValaCCodeIdentifier* _tmp208;
				/* string arrays*/
				_tmp208 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp208 = vala_ccode_identifier_new ("G_TYPE_STRV"))));
				(_tmp208 == NULL ? NULL : (_tmp208 = (vala_ccode_node_unref (_tmp208), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp210;
				char* _tmp209;
				/* other types*/
				_tmp210 = NULL;
				_tmp209 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp210 = vala_ccode_identifier_new ((_tmp209 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))))))))));
				(_tmp210 == NULL ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL)));
				_tmp209 = (g_free (_tmp209), NULL);
			}
			_tmp211 = NULL;
			_tmp212 = NULL;
			cdecl_ = (_tmp212 = vala_ccode_declaration_new ((_tmp211 = vala_data_type_get_cname (vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self)))))), (_tmp211 = (g_free (_tmp211), NULL)), _tmp212);
			_tmp213 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp213 = vala_ccode_variable_declarator_new ("result"))));
			(_tmp213 == NULL ? NULL : (_tmp213 = (vala_ccode_node_unref (_tmp213), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
			_tmp215 = NULL;
			_tmp214 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp215 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp214 = vala_ccode_identifier_new ("result")))))));
			(_tmp215 == NULL ? NULL : (_tmp215 = (vala_ccode_node_unref (_tmp215), NULL)));
			(_tmp214 == NULL ? NULL : (_tmp214 = (vala_ccode_node_unref (_tmp214), NULL)));
			_tmp216 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp216 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
			(_tmp216 == NULL ? NULL : (_tmp216 = (vala_ccode_node_unref (_tmp216), NULL)));
			_tmp217 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp217 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp217 == NULL ? NULL : (_tmp217 = (vala_ccode_node_unref (_tmp217), NULL)));
			/* don't access result when error occured*/
			creturnblock = vala_ccode_block_new ();
			_tmp219 = NULL;
			_tmp218 = NULL;
			vala_ccode_block_add_statement (creturnblock, VALA_CCODE_NODE ((_tmp219 = vala_ccode_return_statement_new ((_tmp218 = vala_ccode_generator_default_value_for_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_return_type (vala_ccode_method_binding_get_method (VALA_CCODE_METHOD_BINDING (self))), FALSE))))));
			(_tmp219 == NULL ? NULL : (_tmp219 = (vala_ccode_node_unref (_tmp219), NULL)));
			(_tmp218 == NULL ? NULL : (_tmp218 = (vala_ccode_node_unref (_tmp218), NULL)));
			_tmp221 = NULL;
			_tmp220 = NULL;
			_tmp222 = NULL;
			cerrorif = (_tmp222 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp221 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp220 = vala_ccode_identifier_new ("error")))))), VALA_CCODE_STATEMENT (creturnblock), NULL), (_tmp221 == NULL ? NULL : (_tmp221 = (vala_ccode_node_unref (_tmp221), NULL))), (_tmp220 == NULL ? NULL : (_tmp220 = (vala_ccode_node_unref (_tmp220), NULL))), _tmp222);
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cerrorif));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (out_marshalling_fragment));
			if (array_type != NULL) {
				ValaCCodeIdentifier* _tmp223;
				ValaCCodeFunctionCall* _tmp224;
				ValaCCodeFunctionCall* cstrvlen;
				ValaCCodeIdentifier* _tmp225;
				ValaCCodeIdentifier* _tmp226;
				ValaCCodeUnaryExpression* _tmp227;
				ValaCCodeUnaryExpression* result_length;
				ValaCCodeAssignment* assign;
				ValaCCodeExpressionStatement* _tmp228;
				/* special case string array
				 *result_length1 = g_strv_length (result);*/
				_tmp223 = NULL;
				_tmp224 = NULL;
				cstrvlen = (_tmp224 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp223 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp223 == NULL ? NULL : (_tmp223 = (vala_ccode_node_unref (_tmp223), NULL))), _tmp224);
				_tmp225 = NULL;
				vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp225 = vala_ccode_identifier_new ("result"))));
				(_tmp225 == NULL ? NULL : (_tmp225 = (vala_ccode_node_unref (_tmp225), NULL)));
				_tmp226 = NULL;
				_tmp227 = NULL;
				result_length = (_tmp227 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp226 = vala_ccode_identifier_new ("result_length1")))), (_tmp226 == NULL ? NULL : (_tmp226 = (vala_ccode_node_unref (_tmp226), NULL))), _tmp227);
				assign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (result_length), VALA_CCODE_EXPRESSION (cstrvlen), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
				_tmp228 = NULL;
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp228 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
				(_tmp228 == NULL ? NULL : (_tmp228 = (vala_ccode_node_unref (_tmp228), NULL)));
				(cstrvlen == NULL ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL)));
				(result_length == NULL ? NULL : (result_length = (vala_ccode_node_unref (result_length), NULL)));
				(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
			}
			_tmp230 = NULL;
			_tmp229 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp230 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp229 = vala_ccode_identifier_new ("result")))))));
			(_tmp230 == NULL ? NULL : (_tmp230 = (vala_ccode_node_unref (_tmp230), NULL)));
			(_tmp229 == NULL ? NULL : (_tmp229 = (vala_ccode_node_unref (_tmp229), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			(creturnblock == NULL ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL)));
			(cerrorif == NULL ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp231;
		ValaCCodeBlock* creturnblock;
		ValaCCodeReturnStatement* _tmp232;
		ValaCCodeUnaryExpression* _tmp234;
		ValaCCodeIdentifier* _tmp233;
		ValaCCodeIfStatement* _tmp235;
		ValaCCodeIfStatement* cerrorif;
		_tmp231 = NULL;
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp231 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp231 == NULL ? NULL : (_tmp231 = (vala_ccode_node_unref (_tmp231), NULL)));
		/* don't access result when error occured*/
		creturnblock = vala_ccode_block_new ();
		_tmp232 = NULL;
		vala_ccode_block_add_statement (creturnblock, VALA_CCODE_NODE ((_tmp232 = vala_ccode_return_statement_new (NULL))));
		(_tmp232 == NULL ? NULL : (_tmp232 = (vala_ccode_node_unref (_tmp232), NULL)));
		_tmp234 = NULL;
		_tmp233 = NULL;
		_tmp235 = NULL;
		cerrorif = (_tmp235 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp234 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp233 = vala_ccode_identifier_new ("error")))))), VALA_CCODE_STATEMENT (creturnblock), NULL), (_tmp234 == NULL ? NULL : (_tmp234 = (vala_ccode_node_unref (_tmp234), NULL))), (_tmp233 == NULL ? NULL : (_tmp233 = (vala_ccode_node_unref (_tmp233), NULL))), _tmp235);
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cerrorif));
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE (out_marshalling_fragment));
		(creturnblock == NULL ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL)));
		(cerrorif == NULL ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL)));
	}
	(dynamic_method == NULL ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL)));
	(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(callback == NULL ? NULL : (callback = (vala_code_node_unref (callback), NULL)));
	(out_marshalling_fragment == NULL ? NULL : (out_marshalling_fragment = (vala_ccode_node_unref (out_marshalling_fragment), NULL)));
}


static ValaCCodeExpression* vala_ccode_dynamic_method_binding_get_dbus_g_type (ValaCCodeDynamicMethodBinding* self, ValaDataType* data_type) {
	ValaArrayType* _tmp1;
	ValaDataType* _tmp0;
	ValaArrayType* array_type;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (data_type), NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	array_type = (_tmp1 = (_tmp0 = data_type, (VALA_IS_ARRAY_TYPE (_tmp0) ? ((ValaArrayType*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (array_type != NULL) {
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeFunctionCall* carray_type;
		ValaCCodeExpression* _tmp7;
		ValaCCodeExpression* _tmp8;
		if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
			ValaCCodeExpression* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_TYPE_STRV")), (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp2);
		}
		_tmp3 = NULL;
		_tmp4 = NULL;
		carray_type = (_tmp4 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("dbus_g_type_get_collection")))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL))), _tmp4);
		if (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type)) {
			ValaCCodeConstant* _tmp5;
			_tmp5 = NULL;
			vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("\"GPtrArray\""))));
			(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		} else {
			ValaCCodeConstant* _tmp6;
			_tmp6 = NULL;
			vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("\"GArray\""))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		}
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (carray_type, (_tmp7 = vala_ccode_dynamic_method_binding_get_dbus_g_type (self, vala_array_type_get_element_type (array_type))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
		_tmp8 = NULL;
		return (_tmp8 = VALA_CCODE_EXPRESSION (carray_type), (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp8);
	} else {
		char* _tmp9;
		ValaCCodeExpression* _tmp10;
		ValaCCodeExpression* _tmp11;
		_tmp9 = NULL;
		_tmp10 = NULL;
		_tmp11 = NULL;
		return (_tmp11 = (_tmp10 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp9 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (data_type))))), (_tmp9 = (g_free (_tmp9), NULL)), _tmp10), (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp11);
	}
	(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
}


static void vala_ccode_dynamic_method_binding_class_init (ValaCCodeDynamicMethodBindingClass * klass) {
	vala_ccode_dynamic_method_binding_parent_class = g_type_class_peek_parent (klass);
}


static void vala_ccode_dynamic_method_binding_instance_init (ValaCCodeDynamicMethodBinding * self) {
}


GType vala_ccode_dynamic_method_binding_get_type (void) {
	static GType vala_ccode_dynamic_method_binding_type_id = 0;
	if (vala_ccode_dynamic_method_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDynamicMethodBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_dynamic_method_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDynamicMethodBinding), 0, (GInstanceInitFunc) vala_ccode_dynamic_method_binding_instance_init, NULL };
		vala_ccode_dynamic_method_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_BINDING, "ValaCCodeDynamicMethodBinding", &g_define_type_info, 0);
	}
	return vala_ccode_dynamic_method_binding_type_id;
}




