/* valagtypemodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valagtypemodule.h>
#include <vala/valatypesymbol.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemacroreplacement.h>
#include <vala/valasourcefile.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodecomment.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaobjecttypesymbol.h>
#include <gee/list.h>
#include <vala/valaproperty.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valasignal.h>
#include <vala/valamethod.h>
#include <ccode/valaccodememberaccess.h>
#include <gobject/valaccodebasemodule.h>
#include <gobject/valainterfaceregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>




enum  {
	VALA_GTYPE_MODULE_DUMMY_PROPERTY
};
static void vala_gtype_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface);
static void vala_gtype_module_add_interface_base_init_function (ValaGTypeModule* self, ValaInterface* iface);
static gpointer vala_gtype_module_parent_class = NULL;



ValaGTypeModule* vala_gtype_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGTypeModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaGTypeModule*) (g_type_create_instance (object_type)));
	self = ((ValaGTypeModule*) (vala_gerror_module_construct (object_type, codegen, next)));
	return self;
}


ValaGTypeModule* vala_gtype_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gtype_module_construct (VALA_TYPE_GTYPE_MODULE, codegen, next);
}


static void vala_gtype_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface) {
	ValaGTypeModule * self;
	ValaSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaTypeSymbol* _tmp3;
	ValaTypeSymbol* _tmp2;
	char* _tmp4;
	gboolean _tmp5;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaCCodeStruct* _tmp18;
	char* _tmp17;
	char* _tmp16;
	ValaCCodeNewline* _tmp19;
	char* _tmp20;
	char* _tmp21;
	char* macro;
	ValaCCodeMacroReplacement* _tmp23;
	char* _tmp22;
	char* _tmp26;
	char* _tmp25;
	char* _tmp24;
	ValaCCodeMacroReplacement* _tmp29;
	char* _tmp28;
	char* _tmp27;
	char* _tmp31;
	char* _tmp30;
	ValaCCodeMacroReplacement* _tmp34;
	char* _tmp33;
	char* _tmp32;
	char* _tmp37;
	char* _tmp36;
	char* _tmp35;
	ValaCCodeMacroReplacement* _tmp40;
	char* _tmp39;
	char* _tmp38;
	ValaCCodeNewline* _tmp41;
	ValaInterfaceRegisterFunction* type_fun;
	ValaCCodeFragment* _tmp54;
	ValaTypeSymbol* _tmp55;
	self = ((ValaGTypeModule*) (base));
	g_return_if_fail (iface != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	((ValaCCodeBaseModule*) (self))->current_symbol = (_tmp1 = (_tmp0 = ((ValaSymbol*) (iface)), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0))), (((ValaCCodeBaseModule*) (self))->current_symbol == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) (self))->current_symbol), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	((ValaCCodeBaseModule*) (self))->current_type_symbol = (_tmp3 = (_tmp2 = ((ValaTypeSymbol*) (iface)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (((ValaCCodeBaseModule*) (self))->current_type_symbol == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) (self))->current_type_symbol), NULL))), _tmp3);
	_tmp4 = NULL;
	if ((_tmp5 = g_utf8_strlen ((_tmp4 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (iface)), FALSE)), -1) < 3, (_tmp4 = (g_free (_tmp4), NULL)), _tmp5)) {
		char* _tmp7;
		char* _tmp6;
		vala_code_node_set_error (((ValaCodeNode*) (iface)), TRUE);
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (iface))), (_tmp7 = g_strdup_printf ("Interface name `%s' is too short", (_tmp6 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (iface)), FALSE)))));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp6 = (g_free (_tmp6), NULL);
		return;
	}
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (((ValaSymbol*) (iface))) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp8;
		ValaCCodeFragment* _tmp11;
		ValaCCodeFragment* _tmp10;
		_tmp9 = NULL;
		_tmp8 = NULL;
		decl_frag = (_tmp9 = (_tmp8 = ((ValaCCodeBaseModule*) (self))->header_type_declaration, (_tmp8 == NULL ? NULL : vala_ccode_node_ref (_tmp8))), (decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL))), _tmp9);
		_tmp11 = NULL;
		_tmp10 = NULL;
		def_frag = (_tmp11 = (_tmp10 = ((ValaCCodeBaseModule*) (self))->header_type_definition, (_tmp10 == NULL ? NULL : vala_ccode_node_ref (_tmp10))), (def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL))), _tmp11);
	} else {
		ValaCCodeFragment* _tmp13;
		ValaCCodeFragment* _tmp12;
		ValaCCodeFragment* _tmp15;
		ValaCCodeFragment* _tmp14;
		_tmp13 = NULL;
		_tmp12 = NULL;
		decl_frag = (_tmp13 = (_tmp12 = ((ValaCCodeBaseModule*) (self))->source_type_declaration, (_tmp12 == NULL ? NULL : vala_ccode_node_ref (_tmp12))), (decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL))), _tmp13);
		_tmp15 = NULL;
		_tmp14 = NULL;
		def_frag = (_tmp15 = (_tmp14 = ((ValaCCodeBaseModule*) (self))->source_type_definition, (_tmp14 == NULL ? NULL : vala_ccode_node_ref (_tmp14))), (def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL))), _tmp15);
	}
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	((ValaCCodeBaseModule*) (self))->type_struct = (_tmp18 = vala_ccode_struct_new ((_tmp17 = g_strdup_printf ("_%s", (_tmp16 = vala_interface_get_type_cname (iface))))), (((ValaCCodeBaseModule*) (self))->type_struct == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->type_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) (self))->type_struct), NULL))), _tmp18);
	_tmp17 = (g_free (_tmp17), NULL);
	_tmp16 = (g_free (_tmp16), NULL);
	_tmp19 = NULL;
	vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp19 = vala_ccode_newline_new ()))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	_tmp20 = NULL;
	_tmp21 = NULL;
	macro = (_tmp21 = g_strdup_printf ("(%s_get_type ())", (_tmp20 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (iface)), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), _tmp21);
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp23 = vala_ccode_macro_replacement_new ((_tmp22 = vala_typesymbol_get_type_id (((ValaTypeSymbol*) (iface)))), macro)))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	_tmp22 = (g_free (_tmp22), NULL);
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	macro = (_tmp26 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (_tmp24 = vala_typesymbol_get_type_id (((ValaTypeSymbol*) (iface)))), (_tmp25 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (iface)), FALSE))), (macro = (g_free (macro), NULL)), _tmp26);
	_tmp25 = (g_free (_tmp25), NULL);
	_tmp24 = (g_free (_tmp24), NULL);
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp29 = vala_ccode_macro_replacement_new ((_tmp28 = g_strdup_printf ("%s(obj)", (_tmp27 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (iface)), NULL)))), macro)))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
	_tmp28 = (g_free (_tmp28), NULL);
	_tmp27 = (g_free (_tmp27), NULL);
	_tmp31 = NULL;
	_tmp30 = NULL;
	macro = (_tmp31 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (_tmp30 = vala_typesymbol_get_type_id (((ValaTypeSymbol*) (iface))))), (macro = (g_free (macro), NULL)), _tmp31);
	_tmp30 = (g_free (_tmp30), NULL);
	_tmp34 = NULL;
	_tmp33 = NULL;
	_tmp32 = NULL;
	vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp34 = vala_ccode_macro_replacement_new ((_tmp33 = g_strdup_printf ("%s(obj)", (_tmp32 = vala_ccode_base_module_get_type_check_function (((ValaCCodeBaseModule*) (self)), ((ValaTypeSymbol*) (iface)))))), macro)))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
	_tmp33 = (g_free (_tmp33), NULL);
	_tmp32 = (g_free (_tmp32), NULL);
	_tmp37 = NULL;
	_tmp36 = NULL;
	_tmp35 = NULL;
	macro = (_tmp37 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", (_tmp35 = vala_typesymbol_get_type_id (((ValaTypeSymbol*) (iface)))), (_tmp36 = vala_interface_get_type_cname (iface))), (macro = (g_free (macro), NULL)), _tmp37);
	_tmp36 = (g_free (_tmp36), NULL);
	_tmp35 = (g_free (_tmp35), NULL);
	_tmp40 = NULL;
	_tmp39 = NULL;
	_tmp38 = NULL;
	vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp40 = vala_ccode_macro_replacement_new ((_tmp39 = g_strdup_printf ("%s_GET_INTERFACE(obj)", (_tmp38 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (iface)), NULL)))), macro)))));
	(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
	_tmp39 = (g_free (_tmp39), NULL);
	_tmp38 = (g_free (_tmp38), NULL);
	_tmp41 = NULL;
	vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp41 = vala_ccode_newline_new ()))));
	(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) (iface))))) == NULL) {
		ValaCCodeTypeDefinition* _tmp46;
		ValaCCodeVariableDeclarator* _tmp45;
		char* _tmp44;
		char* _tmp43;
		char* _tmp42;
		ValaCCodeTypeDefinition* _tmp50;
		ValaCCodeVariableDeclarator* _tmp49;
		char* _tmp48;
		char* _tmp47;
		_tmp46 = NULL;
		_tmp45 = NULL;
		_tmp44 = NULL;
		_tmp43 = NULL;
		_tmp42 = NULL;
		vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp46 = vala_ccode_type_definition_new ((_tmp43 = g_strdup_printf ("struct _%s", (_tmp42 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (iface)), FALSE)))), ((ValaCCodeDeclarator*) ((_tmp45 = vala_ccode_variable_declarator_new ((_tmp44 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (iface)), FALSE)))))))))));
		(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
		(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
		_tmp44 = (g_free (_tmp44), NULL);
		_tmp43 = (g_free (_tmp43), NULL);
		_tmp42 = (g_free (_tmp42), NULL);
		_tmp50 = NULL;
		_tmp49 = NULL;
		_tmp48 = NULL;
		_tmp47 = NULL;
		vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp50 = vala_ccode_type_definition_new ((_tmp47 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (((ValaCCodeBaseModule*) (self))->type_struct))), ((ValaCCodeDeclarator*) ((_tmp49 = vala_ccode_variable_declarator_new ((_tmp48 = vala_interface_get_type_cname (iface)))))))))));
		(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
		(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
		_tmp48 = (g_free (_tmp48), NULL);
		_tmp47 = (g_free (_tmp47), NULL);
	}
	vala_ccode_struct_add_field (((ValaCCodeBaseModule*) (self))->type_struct, "GTypeInterface", "parent_iface");
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (iface)))) != NULL) {
		ValaCCodeComment* _tmp51;
		_tmp51 = NULL;
		vala_ccode_fragment_append (def_frag, ((ValaCCodeNode*) ((_tmp51 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (iface)))))))));
		(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
	}
	vala_ccode_fragment_append (def_frag, ((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->type_struct)));
	vala_code_node_accept_children (((ValaCodeNode*) (iface)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	vala_gtype_module_add_interface_base_init_function (self, iface);
	type_fun = vala_interface_register_function_new (iface, vala_ccode_base_module_get_context (((ValaCCodeBaseModule*) (self))));
	vala_typeregister_function_init_from_type (((ValaTypeRegisterFunction*) (type_fun)), FALSE);
	if (vala_symbol_get_access (((ValaSymbol*) (iface))) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp52;
		_tmp52 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->header_type_member_declaration, ((ValaCCodeNode*) ((_tmp52 = vala_typeregister_function_get_declaration (((ValaTypeRegisterFunction*) (type_fun)))))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
	} else {
		ValaCCodeFragment* _tmp53;
		_tmp53 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp53 = vala_typeregister_function_get_declaration (((ValaTypeRegisterFunction*) (type_fun)))))));
		(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
	}
	_tmp54 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) ((_tmp54 = vala_typeregister_function_get_definition (((ValaTypeRegisterFunction*) (type_fun)))))));
	(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
	_tmp55 = NULL;
	((ValaCCodeBaseModule*) (self))->current_type_symbol = (_tmp55 = NULL, (((ValaCCodeBaseModule*) (self))->current_type_symbol == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) (self))->current_type_symbol), NULL))), _tmp55);
	(decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)));
	macro = (g_free (macro), NULL);
	(type_fun == NULL ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL)));
}


static void vala_gtype_module_add_interface_base_init_function (ValaGTypeModule* self, ValaInterface* iface) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeBlock* _tmp6;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeConstant* _tmp9;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeIfStatement* _tmp13;
	ValaCCodeIfStatement* cif;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFragment* _tmp29;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	base_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_base_init", (_tmp0 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (iface)), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (base_init, (_tmp5 = vala_ccode_formal_parameter_new ("iface", (_tmp4 = g_strdup_printf ("%sIface *", (_tmp3 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (iface)), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	/* make sure not to run the initialization code twice */
	_tmp6 = NULL;
	vala_ccode_function_set_block (base_init, (_tmp6 = vala_ccode_block_new ()));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	_tmp8 = NULL;
	decl = (_tmp8 = vala_ccode_declaration_new ((_tmp7 = vala_data_type_get_cname (((ValaCCodeBaseModule*) (self))->bool_type))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
	vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | (VALA_CCODE_MODIFIERS_STATIC));
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (decl, ((ValaCCodeDeclarator*) ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer ("initialized", ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_constant_new ("FALSE")))))))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), ((ValaCCodeNode*) (decl)));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	cif = (_tmp13 = vala_ccode_if_statement_new (((ValaCCodeExpression*) ((_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_identifier_new ("initialized")))))))), ((ValaCCodeStatement*) (init_block)), NULL), (_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL))), _tmp13);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), ((ValaCCodeNode*) (cif)));
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_block_add_statement (init_block, ((ValaCCodeNode*) ((_tmp17 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp16 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp14 = vala_ccode_identifier_new ("initialized")))), ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_constant_new ("TRUE")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
	if (vala_typesymbol_is_subtype_of (((ValaTypeSymbol*) (iface)), ((ValaCCodeBaseModule*) (self))->gobject_type)) {
		GeeList* props;
		/* create properties */
		props = vala_object_type_symbol_get_properties (((ValaObjectTypeSymbol*) (iface)));
		{
			GeeList* prop_collection;
			int prop_it;
			prop_collection = props;
			for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
				ValaProperty* prop;
				prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
				{
					if (vala_property_get_is_abstract (prop)) {
						ValaCCodeIdentifier* _tmp18;
						ValaCCodeFunctionCall* _tmp19;
						ValaCCodeFunctionCall* cinst;
						ValaCCodeIdentifier* _tmp20;
						ValaCCodeFunctionCall* _tmp21;
						ValaCCodeExpressionStatement* _tmp22;
						_tmp18 = NULL;
						_tmp19 = NULL;
						cinst = (_tmp19 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp18 = vala_ccode_identifier_new ("g_object_interface_install_property"))))), (_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL))), _tmp19);
						_tmp20 = NULL;
						vala_ccode_function_call_add_argument (cinst, ((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new ("iface")))));
						(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (cinst, ((ValaCCodeExpression*) ((_tmp21 = vala_ccode_module_get_param_spec (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), prop)))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
						_tmp22 = NULL;
						vala_ccode_block_add_statement (init_block, ((ValaCCodeNode*) ((_tmp22 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cinst)))))));
						(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
						(cinst == NULL ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)));
					}
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				}
			}
		}
		(props == NULL ? NULL : (props = (gee_collection_object_unref (props), NULL)));
	}
	/* create signals */
	{
		GeeList* sig_collection;
		int sig_it;
		sig_collection = vala_object_type_symbol_get_signals (((ValaObjectTypeSymbol*) (iface)));
		for (sig_it = 0; sig_it < gee_collection_get_size (GEE_COLLECTION (sig_collection)); sig_it = sig_it + 1) {
			ValaSignal* sig;
			sig = ((ValaSignal*) (gee_list_get (GEE_LIST (sig_collection), sig_it)));
			{
				ValaCCodeExpressionStatement* _tmp24;
				ValaCCodeFunctionCall* _tmp23;
				_tmp24 = NULL;
				_tmp23 = NULL;
				vala_ccode_block_add_statement (init_block, ((ValaCCodeNode*) ((_tmp24 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp23 = vala_ccode_module_get_signal_creation (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), sig, ((ValaTypeSymbol*) (iface)))))))))));
				(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
				(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
				(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
			}
		}
		(sig_collection == NULL ? NULL : (sig_collection = (gee_collection_object_unref (sig_collection), NULL)));
	}
	/* connect default implementations*/
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_object_type_symbol_get_methods (((ValaObjectTypeSymbol*) (iface)));
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				if (vala_method_get_is_virtual (m)) {
					ValaCCodeIdentifier* ciface;
					char* cname;
					ValaCCodeExpressionStatement* _tmp28;
					ValaCCodeAssignment* _tmp27;
					ValaCCodeIdentifier* _tmp26;
					ValaCCodeMemberAccess* _tmp25;
					ciface = vala_ccode_identifier_new ("iface");
					cname = vala_method_get_real_cname (m);
					_tmp28 = NULL;
					_tmp27 = NULL;
					_tmp26 = NULL;
					_tmp25 = NULL;
					vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), ((ValaCCodeNode*) ((_tmp28 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp27 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp25 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (ciface)), vala_method_get_vfunc_name (m))))), ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_identifier_new (cname)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
					(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
					(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
					(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
					(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
					(ciface == NULL ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL)));
					cname = (g_free (cname), NULL);
				}
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (gee_collection_object_unref (m_collection), NULL)));
	}
	_tmp29 = NULL;
	vala_ccode_block_add_statement (init_block, ((ValaCCodeNode*) ((_tmp29 = vala_ccode_module_register_dbus_info (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), ((ValaObjectTypeSymbol*) (iface)))))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (base_init)));
	(base_init == NULL ? NULL : (base_init = (vala_ccode_node_unref (base_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(decl == NULL ? NULL : (decl = (vala_ccode_node_unref (decl), NULL)));
	(cif == NULL ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)));
}


static void vala_gtype_module_class_init (ValaGTypeModuleClass * klass) {
	vala_gtype_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_interface = vala_gtype_module_real_visit_interface;
}


static void vala_gtype_module_instance_init (ValaGTypeModule * self) {
}


GType vala_gtype_module_get_type (void) {
	static GType vala_gtype_module_type_id = 0;
	if (vala_gtype_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGTypeModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gtype_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGTypeModule), 0, (GInstanceInitFunc) vala_gtype_module_instance_init, NULL };
		vala_gtype_module_type_id = g_type_register_static (VALA_TYPE_GERROR_MODULE, "ValaGTypeModule", &g_define_type_info, 0);
	}
	return vala_gtype_module_type_id;
}




