/* valaintegertype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaintegertype.h>
#include <vala/valastruct.h>
#include <vala/valacodenode.h>
#include <vala/valaattribute.h>
#include <vala/valaenum.h>




struct _ValaIntegerTypePrivate {
	char* literal_value;
	char* literal_type_name;
};

#define VALA_INTEGER_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypePrivate))
enum  {
	VALA_INTEGER_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_integer_type_real_copy (ValaDataType* base);
static gboolean vala_integer_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static gpointer vala_integer_type_parent_class = NULL;
static void vala_integer_type_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaIntegerType* vala_integer_type_construct (GType object_type, ValaTypeSymbol* type_symbol, const char* literal_value, const char* literal_type_name) {
	ValaIntegerType* self;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp3;
	const char* _tmp2;
	g_return_val_if_fail (type_symbol != NULL, NULL);
	g_return_val_if_fail (literal_value != NULL, NULL);
	g_return_val_if_fail (literal_type_name != NULL, NULL);
	self = ((ValaIntegerType*) (g_type_create_instance (object_type)));
	vala_value_type_set_type_symbol (((ValaValueType*) (self)), type_symbol);
	vala_data_type_set_data_type (((ValaDataType*) (self)), type_symbol);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->literal_value = (_tmp1 = (_tmp0 = literal_value, (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (self->priv->literal_value = (g_free (self->priv->literal_value), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->literal_type_name = (_tmp3 = (_tmp2 = literal_type_name, (_tmp2 == NULL ? NULL : g_strdup (_tmp2))), (self->priv->literal_type_name = (g_free (self->priv->literal_type_name), NULL)), _tmp3);
	return self;
}


ValaIntegerType* vala_integer_type_new (ValaTypeSymbol* type_symbol, const char* literal_value, const char* literal_type_name) {
	return vala_integer_type_construct (VALA_TYPE_INTEGER_TYPE, type_symbol, literal_value, literal_type_name);
}


static ValaDataType* vala_integer_type_real_copy (ValaDataType* base) {
	ValaIntegerType * self;
	ValaIntegerType* type;
	self = ((ValaIntegerType*) (base));
	type = vala_integer_type_new (vala_value_type_get_type_symbol (((ValaValueType*) (self))), self->priv->literal_value, self->priv->literal_type_name);
	vala_data_type_set_is_type_argument (((ValaDataType*) (type)), vala_data_type_get_is_type_argument (((ValaDataType*) (self))));
	return ((ValaDataType*) (type));
}


static gboolean vala_integer_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaIntegerType * self;
	self = ((ValaIntegerType*) (base));
	g_return_val_if_fail (target_type != NULL, FALSE);
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (target_type)) && _vala_strcmp0 (self->priv->literal_type_name, "int") == 0) {
		ValaStruct* _tmp0;
		ValaStruct* target_st;
		/* int literals are implicitly convertible to integer types
		 of a lower rank if the value of the literal is within
		 the range of the target type*/
		_tmp0 = NULL;
		target_st = (_tmp0 = VALA_STRUCT (vala_data_type_get_data_type (target_type)), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		if (vala_struct_is_integer_type (target_st)) {
			ValaAttribute* int_attr;
			int_attr = vala_code_node_get_attribute (((ValaCodeNode*) (target_st)), "IntegerType");
			if (int_attr != NULL && vala_attribute_has_argument (int_attr, "min") && vala_attribute_has_argument (int_attr, "max")) {
				gint val;
				gboolean _tmp1;
				val = atoi (self->priv->literal_value);
				return (_tmp1 = (val >= vala_attribute_get_integer (int_attr, "min") && val <= vala_attribute_get_integer (int_attr, "max")), (int_attr == NULL ? NULL : (int_attr = (vala_code_node_unref (int_attr), NULL))), (target_st == NULL ? NULL : (target_st = (vala_code_node_unref (target_st), NULL))), _tmp1);
			} else {
				gboolean _tmp2;
				/* assume to be compatible if the target type doesn't specify limits*/
				return (_tmp2 = TRUE, (int_attr == NULL ? NULL : (int_attr = (vala_code_node_unref (int_attr), NULL))), (target_st == NULL ? NULL : (target_st = (vala_code_node_unref (target_st), NULL))), _tmp2);
			}
			(int_attr == NULL ? NULL : (int_attr = (vala_code_node_unref (int_attr), NULL)));
		}
		(target_st == NULL ? NULL : (target_st = (vala_code_node_unref (target_st), NULL)));
	} else {
		if (VALA_IS_ENUM (vala_data_type_get_data_type (target_type)) && _vala_strcmp0 (self->priv->literal_type_name, "int") == 0) {
			/* allow implicit conversion from 0 to enum and flags types*/
			if (atoi (self->priv->literal_value) == 0) {
				return TRUE;
			}
		}
	}
	return VALA_DATA_TYPE_CLASS (vala_integer_type_parent_class)->compatible (((ValaDataType*) (VALA_VALUE_TYPE (self))), target_type);
}


static void vala_integer_type_class_init (ValaIntegerTypeClass * klass) {
	vala_integer_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_integer_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaIntegerTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_integer_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_integer_type_real_compatible;
}


static void vala_integer_type_instance_init (ValaIntegerType * self) {
	self->priv = VALA_INTEGER_TYPE_GET_PRIVATE (self);
}


static void vala_integer_type_finalize (ValaCodeNode* obj) {
	ValaIntegerType * self;
	self = VALA_INTEGER_TYPE (obj);
	self->priv->literal_value = (g_free (self->priv->literal_value), NULL);
	self->priv->literal_type_name = (g_free (self->priv->literal_type_name), NULL);
	VALA_CODE_NODE_CLASS (vala_integer_type_parent_class)->finalize (obj);
}


GType vala_integer_type_get_type (void) {
	static GType vala_integer_type_type_id = 0;
	if (vala_integer_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaIntegerTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_integer_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaIntegerType), 0, (GInstanceInitFunc) vala_integer_type_instance_init, NULL };
		vala_integer_type_type_id = g_type_register_static (VALA_TYPE_VALUE_TYPE, "ValaIntegerType", &g_define_type_info, 0);
	}
	return vala_integer_type_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




