/* valathrowstatement.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valathrowstatement.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valaerrortype.h>
#include <vala/valaerrordomain.h>
#include <vala/valaerrorcode.h>
#include <vala/valadatatype.h>
#include <vala/valareport.h>




struct _ValaThrowStatementPrivate {
	ValaExpression* _error_expression;
};

#define VALA_THROW_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementPrivate))
enum  {
	VALA_THROW_STATEMENT_DUMMY_PROPERTY
};
static void vala_throw_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_throw_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_throw_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_throw_statement_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static void vala_throw_statement_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection);
static void vala_throw_statement_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection);
static gpointer vala_throw_statement_parent_class = NULL;
static ValaStatementIface* vala_throw_statement_vala_statement_parent_iface = NULL;
static void vala_throw_statement_finalize (ValaCodeNode* obj);



/**
 * Creates a new throw statement.
 *
 * @param error_expression the error expression
 * @param source_reference reference to source code
 * @return                 newly created throw statement
 */
ValaThrowStatement* vala_throw_statement_construct (GType object_type, ValaExpression* error_expression, ValaSourceReference* source_reference) {
	ValaThrowStatement* self;
	g_return_val_if_fail (error_expression != NULL, NULL);
	self = (ValaThrowStatement*) g_type_create_instance (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_throw_statement_set_error_expression (self, error_expression);
	return self;
}


ValaThrowStatement* vala_throw_statement_new (ValaExpression* error_expression, ValaSourceReference* source_reference) {
	return vala_throw_statement_construct (VALA_TYPE_THROW_STATEMENT, error_expression, source_reference);
}


static void vala_throw_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaThrowStatement * self;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_throw_statement (visitor, self);
}


static void vala_throw_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaThrowStatement * self;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_throw_statement_get_error_expression (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_throw_statement_get_error_expression (self), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, vala_throw_statement_get_error_expression (self));
	}
}


static void vala_throw_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaThrowStatement * self;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_throw_statement_get_error_expression (self) == old_node) {
		vala_throw_statement_set_error_expression (self, new_node);
	}
}


static gboolean vala_throw_statement_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaThrowStatement * self;
	ValaErrorType* _tmp1;
	ValaDataType* error_type;
	gboolean _tmp5;
	self = (ValaThrowStatement*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp1 = NULL;
	vala_expression_set_target_type (vala_throw_statement_get_error_expression (self), (ValaDataType*) (_tmp1 = vala_error_type_new (NULL, NULL, vala_code_node_get_source_reference ((ValaCodeNode*) self))));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL));
	vala_data_type_set_value_owned (vala_expression_get_target_type (vala_throw_statement_get_error_expression (self)), TRUE);
	if (vala_throw_statement_get_error_expression (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_throw_statement_get_error_expression (self), analyzer);
		if (!(VALA_IS_ERROR_TYPE (vala_expression_get_value_type (vala_throw_statement_get_error_expression (self))))) {
			char* _tmp3;
			char* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_throw_statement_get_error_expression (self)), _tmp3 = g_strdup_printf ("`%s' is not an error type", _tmp2 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (vala_throw_statement_get_error_expression (self)))));
			_tmp3 = (g_free (_tmp3), NULL);
			_tmp2 = (g_free (_tmp2), NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			return FALSE;
		}
	}
	error_type = vala_data_type_copy (vala_expression_get_value_type (vala_throw_statement_get_error_expression (self)));
	vala_code_node_set_source_reference ((ValaCodeNode*) error_type, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	vala_code_node_add_error_type ((ValaCodeNode*) self, error_type);
	return (_tmp5 = !vala_code_node_get_error ((ValaCodeNode*) self), (error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL)), _tmp5);
}


static void vala_throw_statement_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaThrowStatement * self;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (collection != NULL);
	vala_code_node_get_defined_variables ((ValaCodeNode*) vala_throw_statement_get_error_expression (self), collection);
}


static void vala_throw_statement_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaThrowStatement * self;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (collection != NULL);
	vala_code_node_get_used_variables ((ValaCodeNode*) vala_throw_statement_get_error_expression (self), collection);
}


ValaExpression* vala_throw_statement_get_error_expression (ValaThrowStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_error_expression;
}


void vala_throw_statement_set_error_expression (ValaThrowStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_error_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_error_expression == NULL) ? NULL : (self->priv->_error_expression = (vala_code_node_unref (self->priv->_error_expression), NULL)), _tmp2);
	if (self->priv->_error_expression != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_error_expression, (ValaCodeNode*) self);
	}
}


static void vala_throw_statement_class_init (ValaThrowStatementClass * klass) {
	vala_throw_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_throw_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaThrowStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_throw_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_throw_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_throw_statement_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->check = vala_throw_statement_real_check;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_throw_statement_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_throw_statement_real_get_used_variables;
}


static void vala_throw_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_throw_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_throw_statement_instance_init (ValaThrowStatement * self) {
	self->priv = VALA_THROW_STATEMENT_GET_PRIVATE (self);
}


static void vala_throw_statement_finalize (ValaCodeNode* obj) {
	ValaThrowStatement * self;
	self = VALA_THROW_STATEMENT (obj);
	(self->priv->_error_expression == NULL) ? NULL : (self->priv->_error_expression = (vala_code_node_unref (self->priv->_error_expression), NULL));
	VALA_CODE_NODE_CLASS (vala_throw_statement_parent_class)->finalize (obj);
}


GType vala_throw_statement_get_type (void) {
	static GType vala_throw_statement_type_id = 0;
	if (vala_throw_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaThrowStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_throw_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaThrowStatement), 0, (GInstanceInitFunc) vala_throw_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_throw_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_throw_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaThrowStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_throw_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_throw_statement_type_id;
}




