/* valastructregisterfunction.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALASTRUCTREGISTERFUNCTION_H__
#define __GOBJECT_VALASTRUCTREGISTERFUNCTION_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valastruct.h>
#include <vala/valacodecontext.h>
#include <vala/valatypesymbol.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodefragment.h>
#include <gobject/valatyperegisterfunction.h>

G_BEGIN_DECLS


#define VALA_TYPE_STRUCT_REGISTER_FUNCTION (vala_struct_register_function_get_type ())
#define VALA_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunction))
#define VALA_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))
#define VALA_IS_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_IS_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_STRUCT_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))

typedef struct _ValaStructRegisterFunction ValaStructRegisterFunction;
typedef struct _ValaStructRegisterFunctionClass ValaStructRegisterFunctionClass;
typedef struct _ValaStructRegisterFunctionPrivate ValaStructRegisterFunctionPrivate;

/**
 * C function to register a class at runtime.
 */
struct _ValaStructRegisterFunction {
	ValaTypeRegisterFunction parent_instance;
	ValaStructRegisterFunctionPrivate * priv;
};

struct _ValaStructRegisterFunctionClass {
	ValaTypeRegisterFunctionClass parent_class;
};


ValaStructRegisterFunction* vala_struct_register_function_construct (GType object_type, ValaStruct* st, ValaCodeContext* context);
ValaStructRegisterFunction* vala_struct_register_function_new (ValaStruct* st, ValaCodeContext* context);
ValaStruct* vala_struct_register_function_get_struct_reference (ValaStructRegisterFunction* self);
void vala_struct_register_function_set_struct_reference (ValaStructRegisterFunction* self, ValaStruct* value);
GType vala_struct_register_function_get_type (void);


G_END_DECLS

#endif
